#ifndef _ENEMY_MANAGER_
#define _ENEMY_MANAGER_

#include <HPLE3DLapper.h>
namespace MotionTest {

static char TEXTURE_PATH_LIST[][MAX_PATH] = {
	"Media\\Cyclops\\",
	"Media\\worm\\",
	"Media\\worm\\",
	"Media\\zombie\\",
	"Media\\js2\\",
	"Media\\js2\\",
	"Media\\zombie_B\\",
	"Media\\trol\\",
	"Media\\Enemy\\Hover\\",
	"Media\\zombie\\",
	"Media\\Enemy\\Roper\\",
	"Media\\Enemy\\phoboko\\",
	"Media\\Enemy\\ANl\\",
	"Media\\Enemy\\Wall\\",
	"Media\\Enemy\\Switch\\",
};

namespace EnemyConsts {
	const int MAX_LENGTH = 256;
	static char ENEMY_NAME_LIST[][MAX_LENGTH] = {
		"Cyclops",
		"BigWorm",
		"SmallWorm",
		"ZombieA",
		"MosukoA",
		"MosukoB",
		"ZombieB",
		"Trol",
		"Hover",
		"ZombieA",
		"Roper",
		"Phoboko",
		"Arachne",
		"Wall",
		"Arachne",

	};
};

/** GǗ}l[W
  *
  */
class EnemyManager: public HPL::E3D::AbstractObjectManager<HPL::E3D::E3DObject> {
private:
	// gȂ
	//! ̃tF[YɍEɉ]ǂL^B
	//! ŏɕL^Ă
	//! ړAxNg̊O
	//int nRotateY;

	//! ̃Xe[WőΏۂƂȂG
	std::map<int, BOOL> m_mapEnableMap;
public:
	EnemyManager();
	virtual ~EnemyManager();
public:

	///////////////////
	// I[o[Ch
	BOOL is_Skip( HPL::E3D::E3DObject* obj );
	int checkInView( HPL::E3D::E3DObject* obj );
	int move( HPL::E3D::E3DObject* obj );
	int checkHitToGround( HPL::E3D::E3DObject* obj );
	int checkHitToBillBoard( HPL::E3D::E3DObject* obj ){return 1;}
	int checkHitToPlayer( HPL::E3D::E3DObject* obj );
	int checkHitToEnemy( HPL::E3D::E3DObject* obj );
	
	int render( HPL::E3D::E3DObject* obj );

	int createObjects( int nType, int nNum );
	

	/** S}X^[̃ZbgAbvs܂
	  *
	  */
	int setupAllMaster( );


	HPL::E3D::E3DObject* add_Object( int nType, int nSigID );

	/** ҋ@ĂIuWFNgĂяo܂B
	  * @retval NULL	ɑSĖ܂Ăđ݂Ȃꍇ
	  */
	HPL::E3D::E3DObject* search( int nType);

	/** ^[Qbg̕
	  *
	  */
	void rotate_AgainstTarget( HPL::E3D::E3DObject* obj, int nTargetSigID );

	/** f/[V̔{
	  */
	float get_Zoom( int nType );

	/** L[œG𑀍
	*/
	int key_Move( HPL::E3D::E3DObject* obj );

	/** vC[̈ʒuŒ肷
	  */
	void hold_Player( HPL::E3D::E3DObject* obj );

	/** L/̐؂ւ
	  * bIsEnable
	  */
	void set_Enable(int nType, BOOL bIsEnable) ;

	bool isFly( int nType , int nEventNumber );

	void die( HPL::E3D::E3DObject* obj );

	void changeMosukoFace( HPL::E3D::E3DObject* obj, int nMaterial ) ;

	/**
	  * @param[in]	obj
	  * @param[in]	vTargetPosition			Ώۂ̈ʒu
	  * @param[in]	vPosition				obj̈ʒu
	  * @param[in]	fBasicDegree			̊{
	  * @param[in]	fErrorDegree			̂ől(degree)
	  * @param[in]	fGoalRadius				Ώۂ̈ʒuǂꂭ炢ꂽꏊS[ɐݒ肷邩
	  */
	void setBehindGoal( HPL::E3D::E3DObject* obj, D3DXVECTOR3& vTargetPosition, D3DXVECTOR3& vPosition ,
								 float fBasicDegree, float fErrorDegree, float fGoalRadius );

	/**
	  * @param[in]	obj
	  * @param[in]	vPosition
	  * @param[in]	fGoalThreshold
	  */
	bool gotoGoal( HPL::E3D::E3DObject* obj, D3DXVECTOR3& vPosition, float fGoalThreshold);

	/** GɃ_[W^
	  * @param[in]	obj	_[W^鑤̃IuWFNg
	  * @param[in]	enemy	_[W󂯂鑤̓G
	  * @param[in]	fBlowRate	є{
	  * @param[in]	fDamageRate	_[W{
	  */
	void damage( HPL::E3D::E3DObject* obj, HPL::E3D::E3DObject* enemy,
		float fBlowRate, float fDamageRate );

	/** ʂȑΏۂāAׂăNA
	  *
	  */
	void destroyAllExceptSpecial();
};

}

#endif