#include "GameSetting.h"

#include "StaticData.h"

#include <fstream>
#include <vector>
#include <string>

using namespace HPL;
using namespace E3D;
using namespace General;
using namespace MotionTest;
using namespace MotionTestConsts;
using namespace GameSettingConsts;

using namespace std;

static const int MAX_LENGTH = 1024;

#ifndef UNICODE
#define wsprintf sprintf
#endif

GameSetting::GameSetting() {
	// ftHgɂ
	this->setAsDefault();
}
GameSetting::~GameSetting() {
}

// 

// ǂݍ
void GameSetting::load() {
	vector<string> vList ;
	if( TextTool::load_StringLinesFromFile( STAGE_SETTING_FILE_PATH, &vList ) != ErrorType::ERR_NONE ) {
		// s
		TCHAR tstr[MAX_LENGTH];
		wsprintf( tstr, _T("ݒt@C[%ls]̓ǂݍ݂Ɏs"), STAGE_SETTING_FILE_PATH );

		MessageBox( staticData->get_WindowHandle(), tstr, _T("Error"), MB_OK );

		// ftHgݒ
		this->setAsDefault();

		// Z[u
		//this->save();

		return;
	}

	for( int i = 0; i < static_cast<int>( vList.size() ); i ++ ) {
		if( TextTool::is_SkipLine( vList[i] ) ) {
			continue;
		}

		vector<string> vEqualsSet = TextTool::split( vList[i], "=");

		if( static_cast<int>( vEqualsSet.size() ) < 2 ) {
			continue;
		}

		vector<string> vItems = TextTool::split( vEqualsSet[1], ",") ;

		if( vEqualsSet[0].compare( TAG_CLEAR_REVEAL_STAGE ) == 0 ) {
			// Xe[WJڏ
			for( int i = 0;
				i < static_cast<int>( vItems.size()) && i < MissionType::MAX_NUM; i ++ ) 
			{
				try { 
					this->m_aryRevealMissions[i] = atoi( vItems[i].c_str() );
				} catch ( ... ) {
					// do nothing
				}
			}

		}
	}
}

// 񏑂
/*void GameSetting::save() {
	ofstream ofs( STAGE_SETTING_FILE_PATH );

	if( ofs.is_open() == false ) {
		// s

		TCHAR tstr[MAX_LENGTH];
		wsprintf( tstr, _T("ݒt@C[%ls]̕ۑɎs"), STAGE_SETTING_FILE_PATH );

		MessageBox( staticData->get_WindowHandle(), tstr, _T("Error") );


		return;
	}

	// ݒۑ

	ofs << TAG_CLEAR_REVEAL_STAGE <<
	ofs.close();
}*/

// ftHgݒ
void GameSetting::setAsDefault() {
	for( int i = 0; i < MissionType::MAX_NUM; i ++ ) {
		// -1=ǂJȂ
		this->m_aryRevealMissions[i] = -1;
	}
}
