#include "KaisouScene.h"
#include "StaticData.h"

namespace MotionTest {
using namespace HPL;
using namespace E3D;

using namespace General;
using namespace MotionTestConsts;

KaisouScene::KaisouScene() : AbstractScene(){

}
KaisouScene::~KaisouScene(){
}
void KaisouScene::init() {
	// }EX͎RɓȂ
	staticData->set_Grab( TRUE );

	// ʂ͕ςȂ


	// BGM
	staticData->set_BGMIndex( Sound::EVIL_STAR );

}

void KaisouScene::process() {
	int ret = 0;

	// LN^[̈ړ
	ret = this->frameMove();
	if( ret ){
		_ASSERT( 0 );
		return ;
	}

	// `擙
	ret = this->render();
	if( ret ){
		_ASSERT( 0 );
		return ;
	}
}
void KaisouScene::quit() {
}

//! `
int KaisouScene::drawText() {
	int ret = 0;
	float zoom = 1;

	int INTERVAL_Y = 20;

	RECT rClientRect;
	staticData->get_ClientRect( &rClientRect );

	ret = E3DTool::drawText(
		rClientRect.right - 200, rClientRect.bottom - 30,			//pos XY
		255, 0, 0, 255,	//col RGBA
		zoom,				// zoom
		"Game Clear!");
	ret = E3DTool::drawText(
		10, INTERVAL_Y,			//pos XY
		255, 255, 255, 255,	//col RGBA
		zoom,				// zoom
		"Left Click to go back to select mission...");
	if( ret ) {
		_ASSERT( 0 );
		return ret;
	}
	return 0;
}

//! _O
int KaisouScene::render() {
	int ret = 0;

	// nʂ̃`FbNC
	ret = staticData->checkInGround();
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}

	/////////////////////////////////////////
	// vC[֘A
	// vC[f`FbNC
	int status;
	if( E3DChkInView( staticData->get_SwapChainID(), staticData->get_Player()->m_nSigID, &status ) ){
		_ASSERT( 0 );
		return 1;
	}

	// nʂƂ̐ڐG
	ret = staticData->checkPlayerOnGround();
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}

	/////////////////////////////////////////
	// et`
	staticData->renderWithShadow( TRUE, TRUE, FALSE, FALSE );

	/////////////////////////////////////////
	// V[`Jn
	ret = E3DBeginScene( staticData->get_SwapChainID(), 1 );//skipflag 
	if( ret ) { 
		_ASSERT( 0 );
		return 1;
	}

		if( staticData->m_nSelectedWallType >= 0 ) {
			// ǂƓV`
			// sig id擾
			int hsid = staticData->m_mapWallSigMap[staticData->m_nSelectedWallType];

			// ʏ`
			if( E3DRender( staticData->get_SwapChainID(), hsid, 0, 1, 0, 0 ) ){
				_ASSERT( 0 );
				return 1;
			}

			// uh`
			if( E3DRender( staticData->get_SwapChainID(), hsid, 1, 1, 0, 0 ) ){
				_ASSERT( 0 );
				return 1;
			}
		}

		//////////////
		// G̈ړƕ`
		ret = staticData->m_EnemyManager.process();

		///////////////
		// Sr{[h`
		ret = E3DRenderBillboard( staticData->get_SwapChainID(), 0 );
		if( ret ) {
			_ASSERT( 0 );
			return ret;
		}

		//////////
		// XvCg\
		ret = E3DBeginSprite();
		ret = E3DEndSprite();

		// `
		this->drawText();

		staticData->afterRenderCommon();
	if( E3DEndScene() ) {
		_ASSERT( 0 );
		return 1;
	}
	return 0;
}
//! t[Ƃ̈ړ
int KaisouScene::frameMove() {
	int ret = 0;


	if( staticData->is_Pause() == FALSE ) {
		// [Vݒ
		if( staticData->isEvigenizePlayer() ) {
			staticData->get_Player()->m_nEventNumber = Motion::Evigen::JOJO01;
		}
		// [Vω
		ret = staticData->updatePlayerMotion();
		staticData->move_BillBoard();

	}

	DIMOUSESTATE2* mouse = staticData->get_DIMouse()->get_CurrentState();
	DIMOUSESTATE2* mousePrevious = staticData->get_DIMouse()->get_PreviousState();

/*	if( staticData->get_CurrentKeyBuffer('R') &&
		staticData->get_PreviousKeyBuffer('R') == FALSE ) 
	{
		// ^Cg
		staticData->m_SceneManager.set_Scene( SceneType::TITLE );
		return 0;
	}*/

	if( mouse->rgbButtons[0] && 
		mousePrevious->rgbButtons[0] == FALSE )
	{

		// ~bVI
		staticData->m_SceneManager.set_Scene( SceneType::SELECT_MISSION );
	}
	///////////////////////////////
	// Jړ
	ret = staticData->moveCamera();
	if( ret ) {
		_ASSERT( 0 );
		return ret;
	}

	return 0;
}

}
