#include "StaticData.h"

#include <fstream>
#include <vector>
#include <string>

#include "GameScene.h"
#include "TitleScene.h"
#include "SelectMissionScene.h"
#include "BriefingScene.h"
#include "EnemyModeScene.h"
#include "GameOverScene.h"

using namespace HPL;
using namespace E3D;
using namespace General;
using namespace std;

#include "resource.h"

namespace MotionTest {
using namespace MotionTestConsts;
using namespace BasicStaticDataConsts;

bool isBackPack() {
	return staticData->isEvigenizePlayer() &&
			staticData->get_Player()->m_nEventNumber == Motion::Evigen::BACKPACK_IDLE;
}

StaticData::StaticData(HINSTANCE hInstance): BasicStaticData(hInstance) {
/*	int ret = 0;
	ret = SetMediaDir();
	if( ret ){
		_ASSERT( 0 );
		//return FALSE;
	}*/

	// AˊԊuJE^
	this->m_cntShotAutomaticCounter = new HPLCounter(
		6,	// [v1
		1 );

	this->m_lpPlayerSigBuffer = NULL;

	this->m_nSelectedGroundType = 0;

	this->m_bNearByConsole = FALSE;

	//this->m_Console = NULL;

	int ret = 0;
	// ViIACeǂݍ
	ret = m_ScenarioManager.load_ScenariosFromOneText( "Media\\Scenario\\Game.txt");

	// [Vɑ΂ݒ
//	m_mapSpecialMotionData[ Motion::Evigen::SEIJOU_Z ].bIsRemovePants = true;
//	m_mapSpecialMotionData[ Motion::Evigen::SEIJOU_Z ].nNextFaceMaterial = Material::DAMAGE;

}
StaticData::~StaticData() {
	delete this->m_cntShotAutomaticCounter;
	if(this->m_lpPlayerSigBuffer != NULL ) {
		delete this->m_lpPlayerSigBuffer;
	}
//	delete this->m_Building;

	for(std::list<EnemyLifeBar*>::iterator it = this->m_lstEnemyLifeBarList.begin();
		it != this->m_lstEnemyLifeBarList.end();
		it ++ ) 
	{
		delete *it;
	}
	this->m_lstEnemyLifeBarList.clear();

	this->m_mapGroundMap.clear();
	this->m_mapWallMap.clear();
}

/** 1024x1024̃eNX`쐬s
  * @param[in]	nFormat			DirectXݒ肵ĂtH[}bg
  * @param[out]	lpszSize		쐬łTCYB쐬Ɏsꍇg͕ύXȂ
  * @retval		0				
  * @retval		1				s
  */
int StaticData::tryToCreateTexture( int nFormat, SIZE* lpszSize ) {
	int ret = 0;

	ret = E3DTool::createRenderTexture( nFormat,
		*lpszSize,
		&this->m_nShadowSwapChainID,
		&this->m_nShadowTextureID );
	if( ret ) {
		lpszSize->cx = 512;
		lpszSize->cy = 512;
		ret = E3DTool::createRenderTexture( nFormat,
			*lpszSize,
			&this->m_nShadowSwapChainID,
			&this->m_nShadowTextureID );
		if( ret ) {
			lpszSize->cx = 256;
			lpszSize->cy = 256;
			ret = E3DTool::createRenderTexture( nFormat,
				*lpszSize,
				&this->m_nShadowSwapChainID,
				&this->m_nShadowTextureID );
			if(ret ) {

				return 1;
			}
		}
	}

	return ret;
}

int set_Toon(int n ) {
	int ret = 0;
	E3DCOLOR4UC redcol = { 255, 255, 255, 0 };
	ret = E3DSetToonEdge0Color( n, -1, "dummy", redcol );
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}
	ret = E3DSetToonEdge0Width( n, -1, "dummy", 10.0f );
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}

	RDBColor3f amb = {1.f,1.f,1.f};
	ret = E3DSetToon1Ambient( n, -1, "dummy", amb );

	return 0;
}


int StaticData::checkObjectOnGround( E3DObject* obj, BOOL bIsPlayer) {

	D3DXVECTOR3 vPlayerPosition;
	E3DGetPos( obj->m_nSigID, &vPlayerPosition );


	int nMode =1;	//n𔇂
	bool bHover = obj->m_Game.m_nObjectType == ObjectType::ENEMY &&
		( obj->m_Game.m_nType == EnemyType::HOVER ||
		obj->m_Game.m_nType == EnemyType::WALL );
		//obj->m_Game.m_nType == EnemyType::SWITCH );
	if( bHover)
	{
		// Ԓ
		nMode = 0;
		obj->m_Move.set_Trigger( TriggerType::ON_THE_GROUND ,
			FALSE);

		// ㉺ړ͂
		const float RATE = 0.2f;
		obj->m_Move.m_vPosition.x += obj->m_Move.m_vVelocity.x;
		obj->m_Move.m_vPosition.y += obj->m_Move.m_vVelocity.y * RATE;
		obj->m_Move.m_vPosition.z += obj->m_Move.m_vVelocity.z;

		E3DSetPos( obj->m_nSigID, obj->m_Move.m_vPosition );
		return 0;
	}


	bool bBackPack = obj->m_Game.m_nObjectType == ObjectType::PLAYER &&
		this->isEvigenizePlayer() &&
		this->get_Player()->m_nEventNumber == Motion::Evigen::BACKPACK_IDLE;

	if( bBackPack ) {
		nMode = 0;
	}
	int ret = 0;

	// 
	int nResult = 0;

	BOOL bIsFlyingBefore = obj->m_Move.get_Trigger( TriggerType::ON_THE_GROUND ) == FALSE;

	D3DXVECTOR3 vAdjust;
	D3DXVECTOR3 n;
	float fDiffMaxY = 2000.f;

	// 蔻p
	int nHitCheckSigID = obj->m_nSigID;
	if( bIsPlayer ) {
		nHitCheckSigID = this->m_nAtariSigID;
		D3DXVECTOR3 vPos;
		E3DGetPos( obj->m_nSigID, &vPos );
		ret = E3DSetPos( this->m_nAtariSigID, vPos );
	}
	{
		ret = E3DChkConfGround( nHitCheckSigID, this->get_GroundSigID(), nMode, 
			fDiffMaxY, MAP_MIN, &nResult, &vAdjust, &n );
		if(ret ) {
			_ASSERT(0);
			return 1;
		}
	}

	// ǂnʂɐڐGǂ̔
	// vC[pB
	BOOL bIsHitGroundOrWall = FALSE;

	if( vPlayerPosition.y > vAdjust.y )
	{
		{
			// 󒆂ɋ
			if( nMode != 0 ) {
				// 
				obj->m_Move.m_vVelocity.y += GRAVITY;
			}
			obj->m_Move.set_Trigger( TriggerType::ON_THE_GROUND ,
				FALSE);
			obj->m_Move.m_vPosition += obj->m_Move.m_vVelocity;

			E3DSetPos( obj->m_nSigID, obj->m_Move.m_vPosition );
		}
	} else {

		if( nResult != 0 ) {
			// ڒn
			//if( bIsPlayer ) {
				vPlayerPosition.z = vAdjust.z;
				vPlayerPosition.x = vAdjust.x;
			//}
			vPlayerPosition.y = vAdjust.y;

			obj->m_Move.m_vPosition = vPlayerPosition;
			obj->m_Move.m_vVelocity.y = 0;

			if(obj->m_Move.get_Trigger( TriggerType::ON_THE_GROUND ) == FALSE ) {
				// ړ0
				obj->m_Move.m_vVelocity.x = 0;
				obj->m_Move.m_vVelocity.z = 0;
			}
			obj->m_Move.set_Trigger( TriggerType::ON_THE_GROUND, TRUE ) ;
			obj->m_Move.m_bJumpAccelable = TRUE ;


			if( bIsPlayer == TRUE ) {
				// vC[ł

				bIsHitGroundOrWall = TRUE;
			}
		}
	}
	E3DSetPos( obj->m_nSigID, obj->m_Move.m_vPosition );
	if( bIsPlayer ) {
		nHitCheckSigID = this->m_nAtariSigID;
		D3DXVECTOR3 vPos;
		E3DGetPos( obj->m_nSigID, &vPos );
		ret = E3DSetPos( this->m_nAtariSigID, vPos );
	}
	if( this->m_nSelectedWallType >= 0 ) {
		float fSpeed = D3DXVec3Length( &obj->m_Move.m_vVelocity );
		const float DISTANCE_FROM_WALL = 400.f+ fSpeed;
		ret = E3DChkConfWall( nHitCheckSigID, this->get_WallSigID(), DISTANCE_FROM_WALL, 
			&nResult, &vAdjust, &n );
		if( nResult ) {
			obj->m_Move.m_vPosition = vAdjust;
			E3DSetPos( obj->m_nSigID, vAdjust );

			bIsHitGroundOrWall = TRUE;
		}
	} else {}

	if( bIsHitGroundOrWall ) {
		if( this->isEvigenizePlayer() ) {

			if( this->get_Player()->m_nEventNumber == Motion::Evigen::DAMAGE_CRASH_UP ) {

				// т璅n
				// BOUNDɂȂ
				this->get_Player()->m_nEventNumber = Motion::Evigen::DAMAGE_BOUND ;

			} else if( this->get_Player()->m_nEventNumber == Motion::Evigen::DOWN &&
				bIsFlyingBefore == TRUE ) 
			{
				// 󒆂DOWNɂȂĂ
				// Œn
				// oEh
				this->get_Player()->m_nEventNumber = Motion::Evigen::DAMAGE_BOUND ;

			} else if( this->get_Player()->m_nEventNumber == Motion::Evigen::DAMAGE_A ||
				this->get_Player()->m_nEventNumber == Motion::Evigen::DAMAGE_B )
			{
				// _[W

				if( this->get_Player()->m_Game.m_fHP <= 0 ) {
					// 
					this->get_Player()->m_nEventNumber = Motion::Evigen::DEATH;
				} else if( this->get_Player()->m_Game.m_nHolderSigID >= 0 ) {
					// X^[ɕ߂܂Ă
					// ̂܂܌p

				} else {
					// [VƂɖ߂
					this->get_Player()->m_nEventNumber = Motion::Evigen::WALK;

					// A
					this->restorePlayer();
				}
			}
		} else if( this->get_Player()->m_Game.m_nType == PlayerType::TANYA ) {
		} else {
			_ASSERT(0);
		}
	}


	return 0;
}

bool StaticData::isWeaponUsable( int nNewWeaponType, int nPlayerType ) {
	for( int i = 0; i < static_cast<int>( this->m_mapWeaponEnableMap[nPlayerType].size() ); i ++ ) {

		if( nNewWeaponType == this->m_mapWeaponEnableMap[nPlayerType][i] ) {
			return true;
		}
	}
	return false;
}

void StaticData::set_NextWeapon( bool bForce) {
	if( this->isPlayerControllable() == false)  {
		return;
	}
	
	int nNewWeaponIndex = this->m_nWeaponIndex + 1;
	while( true ) {
		if( nNewWeaponIndex >= WeaponType::MAX_NUM ) {
			nNewWeaponIndex = 0;
		}

		if( nNewWeaponIndex == this->m_nWeaponIndex ) {
			// T
			return ;
		}
		if( this->m_aryWeaponList[ nNewWeaponIndex ].is_Valid()== TRUE ) {
			if( this->isWeaponUsable( nNewWeaponIndex, this->get_Player()->m_Game.m_nType ) ) {
				this->set_WeaponIndex( nNewWeaponIndex , bForce);
				return ;
			}
		}
		nNewWeaponIndex ++;
	}

}
void StaticData::set_PreviousWeapon(bool bForce) {
	if( this->isPlayerControllable() == false ) {
		return;
	}
	int nNewWeaponIndex = this->m_nWeaponIndex - 1;
	while( true ) {
		if( nNewWeaponIndex < 0 ) {
			nNewWeaponIndex = WeaponType::MAX_NUM - 1;
		}

		if( nNewWeaponIndex == this->m_nWeaponIndex ) {
			// T
			return ;
		}
		if( this->m_aryWeaponList[ nNewWeaponIndex ].is_Valid() == TRUE ) {
			if( this->isWeaponUsable( nNewWeaponIndex, this->get_Player()->m_Game.m_nType ) ) {
				this->set_WeaponIndex( nNewWeaponIndex , bForce );
				return ;
			}
		}
		nNewWeaponIndex --;
	}

}
/*int StaticData::get_WeaponIndex() {
	return this->m_nWeaponIndex;
}*/
Weapon* StaticData::get_Weapon() {
	return &this->m_aryWeaponList[this->m_nWeaponIndex];
}
void StaticData::set_WeaponIndex( int nNewWeaponIndex, bool bForce ) {
	if( (this->isPlayerControllable() == false || this->m_SceneManager.get_CurrentSceneID() == SceneType::TITLE )
		&& bForce == false)
	{
		return;
	}
	this->m_nWeaponIndex = nNewWeaponIndex;

	// EFCg^CύX
	this->m_cntShotAutomaticCounter->set_FrameCounterMax( this->get_Weapon()->m_nShotAutomaticInterval );
	this->m_cntShotAutomaticCounter->reset();

	int ret = 0;
	if( this->get_Player()->m_Game.m_nType == PlayerType::EVIGEN &&
		(nNewWeaponIndex == WeaponType::MINI_GUN || 
		nNewWeaponIndex == WeaponType::HAND_GUN ||
		nNewWeaponIndex == WeaponType::MOPPU ) )
	{
		// o
		this->set_WeaponEnable( TRUE );
	} else {
		// ʏ탂[Vɖ߂
		this->get_Player()->m_nEventNumber = 0;

		// ~jKB
		this->set_WeaponEnable( FALSE );
	}
}

void StaticData::get_ShotDirection( D3DXVECTOR3* vDirection, D3DXVECTOR3& vShotFrom) {

	float fErrorDegree = 0;
	if( this->get_CameraMode() == CameraMode::AT_TARGET_MODE )  {
		// vC[̌Ă@+ERROR
		E3DGetCharaDir( this->get_Player()->m_nSigID, 0,0, vDirection);
		// ERROR
		fErrorDegree = this->get_Weapon()->get_Error() * SHOT_AT_TARGET_MODE_ERROR_RATE;

	} else if( this->get_CameraMode() == CameraMode::SHOT_BEHIND_MODE ) {
		// TeCgiƏj
		D3DXVECTOR3 vSatellitePosition;
		this->get_Camera()->get_SatellitePosition(
			vShotFrom,
			&vSatellitePosition );

		//
		*vDirection = vSatellitePosition - vShotFrom;
		fErrorDegree = this->get_Weapon()->get_Error();

	} else if( this->get_CameraMode() == CameraMode::SNIPER_MODE ) {
		// ڂ̍猩Ă܂
		D3DXVECTOR3 vSatellitePosition;
		this->get_Camera()->get_SatellitePosition( 
			vShotFrom,
			&vSatellitePosition );
		*vDirection = vSatellitePosition - vShotFrom;

		// G[0
		fErrorDegree = 0;

	}

	// K
	D3DXVec3Normalize( vDirection, vDirection );


	// G[]
	VectorTool::rotateHorizontal( vDirection, vDirection, MathTool::nextRandom<float>(-fErrorDegree, fErrorDegree) );

	// cG[]
	VectorTool::rotateVertical( vDirection, vDirection, MathTool::nextRandom<float>(-fErrorDegree, fErrorDegree) );
}

/**
  *
  */
BOOL StaticData::is_Runnable() {
	
	if( this->m_nWeaponIndex == WeaponType::MINI_GUN ||
		this->m_nWeaponIndex == WeaponType::MISSILE_LAUNCHER ||
		(this->m_nWeaponIndex != WeaponType::MACHINE_GUN && this->get_CameraMode() == CameraMode::SHOT_BEHIND_MODE ) ||
		this->get_CameraMode() == CameraMode::SNIPER_MODE/* ||
		this->get_DIMouse()->get_CurrentState()->rgbButtons[0]*/)
	{
		return FALSE;
	}

	return TRUE;
}
/** nʂ̃`FbNC
  *
  */
int StaticData::checkInGround() {
	int ret = 0;
	int status;
	ret = E3DChkInView( this->get_SwapChainID(), this->get_GroundSigID() , &status);
	if(ret ) {
		_ASSERT(0);
		return ret;
	}

	if( this->m_nSelectedWallType >= 0 ) {
		ret = E3DChkInView( this->get_SwapChainID(), this->m_mapWallSigMap[this->m_nSelectedWallType] , &status);
		if(ret ) {
			_ASSERT(0);
			return ret;
		}
		ret = E3DChkInView( this->get_SwapChainID(), this->get_WallSigID() , &status);
		if(ret ) {
			_ASSERT(0);
			return ret;
		}
	}
	return 0;
}

/** vC[ƒnʂ̐ڐG
  *
  */
int StaticData::checkPlayerOnGround( ) {
	int ret = 0;
	if( this->get_Player()->m_Game.m_nHolderSigID < 0 ) {
		// vC[ƃ}bṽ`FbNC
		ret = this->checkObjectOnGround( this->get_Player(), TRUE);
		if( ret ) {
			_ASSERT(0);
			return ret;
		}
	}
	return 0;
}
int StaticData::renderWithShadow( BOOL bIsGround, BOOL bIsPlayer, BOOL bIsMissile, BOOL bIsEnemy ) {
	int ret = 0;

	// vC[؂ւeXg
	
	if( this->get_CurrentKeyBuffer('T') && this->get_PreviousKeyBuffer('T') == FALSE ) {
		// ؂ւ}bv
		int CHANGE_PAIR_LIST[][2] = {
			{PlayerType::EVIGEN, PlayerType::TANYA },
			{PlayerType::TANYA, PlayerType::TIGHTS },
			{PlayerType::TIGHTS, PlayerType::KANRITAN },
			{PlayerType::KANRITAN, PlayerType::TOZICA },
			{PlayerType::TOZICA, PlayerType::EVIGEN },
		};
		int nMax = sizeof(CHANGE_PAIR_LIST)/sizeof(CHANGE_PAIR_LIST[0]);
		int i = 0;
		for( i = 0; i < nMax; i ++ ){
			if( this->get_Player()->m_Game.m_nType == CHANGE_PAIR_LIST[i][0] ) {
				this->change_PlayerType( CHANGE_PAIR_LIST[i][1] );
				break;
			}
		}
		if( i == nMax ) {
			_ASSERT(0);
		}

	}

	if( this->get_Player()->m_Game.m_nType == PlayerType::TANYA ) {
		for(int i = 0; i < TanyaParts::MAX_NUM; i ++ ) {
			char nVirKey = '1' + i;
			if( this->get_CurrentKeyBuffer( nVirKey ) && this->get_PreviousKeyBuffer( nVirKey ) == 0 ) {
				// ؂ւ
				this->m_aryTanyaPartsValidList[i] = !this->m_aryTanyaPartsValidList[i];
				ret = E3DSetValidFlag( this->get_Player()->m_nSigID, this->m_aryTanyaPartsIndexList[i], this->m_aryTanyaPartsValidList[i] );
				if(ret){
					_ASSERT(0);
				}
			}
		}

		if( this->get_CurrentKeyBuffer( 'Y' ) && this->get_PreviousKeyBuffer( 'Y' ) == FALSE ) {
			this->m_nTanyaBodyMaterialIndex ++;
			if( this->m_nTanyaBodyMaterialIndex >= Material::TANYA_BODY_NAKED2 - Material::TANYA_BODY_2P + 1 ) {
				this->m_nTanyaBodyMaterialIndex = 0;
			}

			int nMaterial = Material::TANYA_BODY_2P + this->m_nTanyaBodyMaterialIndex;
			if( this->m_nTanyaBodyMaterialIndex == 0 &&
				this->m_nTanya2PColor == 0 )
			{
				nMaterial = Material::TANYA_BODY_NORMAL;
			}
			// eNX`ύX
			this->set_Texture( this->get_Player()->m_nSigID, "karada",
				nMaterial, FALSE);
			this->set_Texture( this->get_Player()->m_nSigID, "karada_under",
				nMaterial, FALSE);
		}
		if( this->get_CurrentKeyBuffer( 'I' ) && this->get_PreviousKeyBuffer( 'I' ) ==  FALSE ) {
			this->m_nTanya2PColor = (this->m_nTanya2PColor + 1) % 2;

			this->set_Tanya2PColor();
				
		}
	} else if( this->get_Player()->m_Game.m_nType == PlayerType::EVIGEN ) {
		//////
		// ؂ւ
		for(int i = 0; i < Parts::MAX_NUM; i ++ ) {
			char nVirKey = '0' + i + 1;
			if( this->get_CurrentKeyBuffer( nVirKey ) && this->get_PreviousKeyBuffer( nVirKey ) == 0 ) {
				// ؂ւ
				this->m_aryPartsValidList[i] = !this->m_aryPartsValidList[i];
				ret = E3DSetValidFlag( this->get_Player()->m_nSigID, this->m_aryPartsIndexList[i], this->m_aryPartsValidList[i] );
				if(ret){
					_ASSERT(0);
				}
			}
		}

		//////
		// 
		float fStep = 0;
		if( this->get_CurrentKeyBuffer( 'P' ) && this->get_PreviousKeyBuffer( 'P' ) == 0 ) {
			fStep = CLOTH_ALPHA_STEP;
		}
		if( this->get_CurrentKeyBuffer( 'O' ) && this->get_PreviousKeyBuffer( 'O' ) == 0 ) {
			fStep = -CLOTH_ALPHA_STEP;
		}
		if( fStep != 0 ){
			this->set_MaterialAlpha( this->get_Player()->m_nSigID, "huku", &this->m_fClothAlpha, fStep );
		}
		fStep = 0;
		if( this->get_CurrentKeyBuffer( 'J' ) && this->get_PreviousKeyBuffer( 'J' ) == 0 ) {
			fStep = CLOTH_ALPHA_STEP;
		}
		if( this->get_CurrentKeyBuffer( 'H' ) && this->get_PreviousKeyBuffer( 'H' ) == 0 ) {
			fStep = -CLOTH_ALPHA_STEP;
		}
		if( fStep != 0 ){
			this->set_MaterialAlpha( this->get_Player()->m_nSigID, "huku_under", &this->m_fClothUnderAlpha, fStep );
		}
		fStep = 0;
		if( this->get_CurrentKeyBuffer( 'L' ) && this->get_PreviousKeyBuffer( 'L' ) == 0 ) {
			fStep = CLOTH_ALPHA_STEP;
		}
		if( this->get_CurrentKeyBuffer( 'K' ) && this->get_PreviousKeyBuffer( 'K' ) == 0 ) {
			fStep = -CLOTH_ALPHA_STEP;
		}
		if( fStep != 0 ){
			this->set_MaterialAlpha( this->get_Player()->m_nSigID, "apron", &this->m_fApronAlpha, fStep );
		}
		fStep = 0;
		if( this->get_CurrentKeyBuffer( 'N' ) && this->get_PreviousKeyBuffer( 'N' ) == 0 ) {
			fStep = CLOTH_ALPHA_STEP;
		}
		if( this->get_CurrentKeyBuffer( 'B' ) && this->get_PreviousKeyBuffer( 'B' ) == 0 ) {
			fStep = -CLOTH_ALPHA_STEP;
		}
		if( fStep != 0 ){
			this->set_MaterialAlpha( this->get_Player()->m_nSigID, "apron_under", &this->m_fApronUnderAlpha, fStep );
		}
		fStep = 0;
		if( this->get_CurrentKeyBuffer( VK_OEM_COMMA ) && this->get_PreviousKeyBuffer( VK_OEM_COMMA ) == 0 ) {
			fStep = CLOTH_ALPHA_STEP;
		}
		if( this->get_CurrentKeyBuffer( 'M' ) && this->get_PreviousKeyBuffer( 'M' ) == 0 ) {
			fStep = -CLOTH_ALPHA_STEP;
		}
		if( fStep != 0 ){
			this->set_MaterialAlpha( this->get_Player()->m_nSigID, "shitagi", &this->m_fUnderAlpha, fStep );
		//	this->set_MaterialAlpha( this->get_Player()->m_nSigID, "shitagi_under", &this->m_fUnderAlpha, fStep );
		}
		fStep = 0;
		if( this->get_CurrentKeyBuffer( 'U' ) && this->get_PreviousKeyBuffer( 'U' ) == 0 ) {
			fStep = CLOTH_ALPHA_STEP;
		}
		if( this->get_CurrentKeyBuffer( 'Y' ) && this->get_PreviousKeyBuffer( 'Y' ) == 0 ) {
			fStep = -CLOTH_ALPHA_STEP;
		}
		if( fStep != 0 ){
			this->set_MaterialAlpha( this->get_Player()->m_nSigID, "katyu", &this->m_fKatyuAlpha, fStep );
		}

		// j
		if( this->get_CurrentKeyBuffer( 'I' ) && this->get_PreviousKeyBuffer( 'I' ) == 0 ) {
			this->m_nClothBreak = (this->m_nClothBreak + 1) % 3;

			this->set_Texture( this->get_Player()->m_nSigID, "huku", Material::CLOTH_NORMAL + this->m_nClothBreak, FALSE );
			this->set_Texture( this->get_Player()->m_nSigID, "huku_under", Material::CLOTH_NORMAL + this->m_nClothBreak, FALSE );
		}

		// ̐FύX
	/*	if( this->get_CurrentKeyBuffer( 'T' ) && this->get_PreviousKeyBuffer( 'T' ) == 0 ) {
			int nColor = 0;
			if( this->m_nUnderColor == 0 ) {
				nColor = 1;
			} else {
				nColor = 0;
			}
			this->setup_Under(nColor );
		}*/
	} else if( this->get_Player()->m_Game.m_nType == PlayerType::TIGHTS ||
		this->get_Player()->m_Game.m_nType == PlayerType::KANRITAN ||
		this->get_Player()->m_Game.m_nType == PlayerType::TOZICA
		)
	{
		/*	CLOTH,
			APRON,
			BRA,
			PANTS,
			GARTER,*/
		static char PARTS_NAME_LIST[][20] = {
			"cloth",
			"apron",
			"bra",
			"pants",
			"garter",
		};
		//////
		// ؂ւ
		for(int i = 0; i < sizeof(PARTS_NAME_LIST)/sizeof(PARTS_NAME_LIST[0]); i ++ ) {
			char nVirKey = '0' + i + 1;
			if( this->get_CurrentKeyBuffer( nVirKey ) && this->get_PreviousKeyBuffer( nVirKey ) == 0 ) {
				// ؂ւ
				this->m_aryPartsValidList[i] = !this->m_aryPartsValidList[i];

				// p[cID
				int nPartNo = 0;

				ret = E3DGetPartNoByName( this->get_Player()->m_nSigID, PARTS_NAME_LIST[i], &nPartNo );
				if(ret){
					_ASSERT(0);
				}
				ret = E3DSetValidFlag( this->get_Player()->m_nSigID, nPartNo, this->m_aryPartsValidList[i] );
				if(ret){
					_ASSERT(0);
				}
			}
		}

	}

	/////////////////////////////////////////
	// et`Ώ
	int naryShadowSigIDList[ 100 ];// + OBJECT_MAX ];

	int cnt = 0;

	if( bIsPlayer ) {
		if( this->get_CameraMode() == CameraMode::SNIPER_MODE ) {
			// XiCp[[h͕\Ȃ
		} else {
			// XiCp[ȊOȂvC[\B
			naryShadowSigIDList[cnt] = this->get_Player()->m_nSigID;
			cnt ++;
		}
	}

	if( bIsGround ) {
		// n
		naryShadowSigIDList[ cnt] = this->get_GroundSigID();
		cnt ++;
	}

	if( cnt == 0 ) {
		return 0;
	}
	
	
	// et`
	ret = E3DRenderWithShadow( this->get_SwapChainID(), 
		this->m_nShadowSwapChainID,
		this->m_nShadowTextureID,
		naryShadowSigIDList,
		cnt,
		0);	// skipflag

	if( ret ) {
		_ASSERT( 0 );
		return ret;
	}

	{
		// ʒuvC[ɍ킹
		D3DXVECTOR3 vPlayerPosition;
		E3DGetPos( this->get_Player()->m_nSigID, &vPlayerPosition );

		// vC[ɍ킹
		D3DXVECTOR3 vPlayerDirection;
		E3DGetCharaDir( this->get_Player()->m_nSigID, 180, 0, &vPlayerDirection );

		// `
		if( this->get_Weapon()->m_nSigID >= 0 ) //&& this->get_Weapon()->is_Valid())
		{
			int stat = 0;
			E3DSetPos( this->get_Weapon()->m_nSigID, vPlayerPosition );
			this->face( vPlayerDirection, 1, this->get_Weapon()->m_nSigID, this->get_Weapon()->m_Move.m_nQuoatanion );
			ret = E3DChkInView( this->get_SwapChainID(), this->get_Weapon()->m_nSigID, &stat );

			ret = E3DBeginScene( this->get_SwapChainID(), 1 );


				// 炷
				// TODO
				if( this->m_nWeaponIndex == WeaponType::HAND_GUN ) {
					E3DRotateY( this->get_Weapon()->m_nSigID, 30);
				}

				// ʏ`
				if( E3DRender( this->get_SwapChainID(), this->get_Weapon()->m_nSigID, 0, 1, 0, 0 ) ){
					_ASSERT( 0 );
					return 1;
				}

				// uh`
				if( E3DRender( this->get_SwapChainID(), this->get_Weapon()->m_nSigID, 1, 1, 0, 0 ) ){
					_ASSERT( 0 );
					return 1;
				}
				//int ret = E3DSetBeforePos( this->get_Weapon()->m_nSigID) ;
			ret = E3DEndScene( );
		}

		if( isBackPack() ) {
			int stat = 0;
			// vC[̈ʒuɍ킹
			E3DSetPos( this->m_BackPack.m_nSigID, vPlayerPosition );

			// vC[Ɠ
			this->face( vPlayerDirection, 1, this->m_BackPack.m_nSigID, this->m_BackPack.m_Move.m_nQuoatanion );

			ret = E3DChkInView( this->get_SwapChainID(), this->m_BackPack.m_nSigID, &stat );
			ret = E3DBeginScene( this->get_SwapChainID(), 1 );
				// ʏ`
				if( E3DRender( this->get_SwapChainID(), this->m_BackPack.m_nSigID, 0, 1, 0, 0 ) ){
					_ASSERT( 0 );
					return 1;
				}

				// uh`
				if( E3DRender( this->get_SwapChainID(), this->m_BackPack.m_nSigID, 1, 1, 0, 0 ) ){
					_ASSERT( 0 );
					return 1;
				}
			ret = E3DEndScene( );
		}
	}
	return 0;
}

int StaticData::get_WallSigID() {
	return m_mapWallMap[ this->m_nSelectedWallType ];
}
int StaticData::set_WallType( int nWallType ) {
	this->m_nSelectedWallType = nWallType;
	return 0;
}

int StaticData::get_GroundSigID() {
	// TODO Xe[WɂĒn`ω
	return m_mapGroundMap[ m_nSelectedGroundType ];
}

/**
  *
  */
int StaticData::updatePlayerMotion() {
	int ret = 0;

	// ݂̃t[No擾
	int motid;
	int frameno;
	ret = E3DGetMotionFrameNoML( this->get_Player()->m_nSigID, this->get_Player()->m_nUpperBoneNumber, &motid, &frameno );

	//! Aj[V~߂
	BOOL bIsSkip = FALSE;

	//! Aj[V܂Ă
	BOOL bContinue = motid != 0 && this->get_Player()->m_nOldEventNumber == this->get_Player()->m_nEventNumber;

	if( motid != 0 && bContinue /* &&
		this->get_Player()->m_nOldEventNumber == this->get_Player()->m_nEventNumber*/)
	{
		// Aj[Voߒ

		BOOL bIsFlying = this->get_Player()->m_Move.get_Trigger( TriggerType::ON_THE_GROUND ) == FALSE;

		if( this->isEvigenizePlayer()) {
			if( frameno > 28 && this->get_Player()->m_nEventNumber == Motion::Evigen::MINI_GUN_UP ) {
				// ɏグ铮삪I

				// SԂɂ
				this->get_Player()->m_nEventNumber = Motion::Evigen::MINI_GUN_CARRY;

			} else if( frameno > 43 && this->get_Player()->m_nEventNumber == Motion::Evigen::HAND_GUN_RELOAD ) {
				// [hI

				// IDLEԂɖ߂
				this->get_Player()->m_nEventNumber = Motion::Evigen::HAND_GUN_IDLE;

			} else if( frameno > 8 && this->get_Player()->m_nEventNumber == Motion::Evigen::HAND_GUN_UP ) {
				// グ铮
				this->get_Player()->m_nEventNumber = Motion::Evigen::HAND_GUN_IDLE;

			} else if( this->get_Player()->m_nEventNumber == Motion::Evigen::DAMAGE_A ||
				this->get_Player()->m_nEventNumber == Motion::Evigen::DAMAGE_B )
			{
				// _[W

				if( this->get_Player()->m_Game.m_nHolderSigID >= 0) {
					// ߂܂Ă
					// ̂܂܌p
					if( frameno == 18) {
						
						// o
						if( MathTool::nextRandom<float>(0,100 ) < 50 ) {
							int nVoiceID = Sound::VOICE_HIT_1 + MathTool::nextRandom<int>(0,7 );
							ret = E3DPlaySound( this->m_arySoundList[ nVoiceID ], 0, 0, 0 );
						}

						// o
						this->create_PlayerBlood();

						//float fOldHP = this->get_Player()->m_Game.m_fHP;

						const float ZOMBIE_HOLD_DAMAGE = 3;
						// _[W
						this->get_Player()->m_Game.set_HP( this->get_Player()->m_Game.m_fHP - ZOMBIE_HOLD_DAMAGE );

					}
				} else {
					
					if( bContinue && frameno > 10) {
						// ܂Ă
						// 10t[̓Xgbv
						bIsSkip = TRUE;
					}
				}
			} else if( this->get_Player()->m_nEventNumber == Motion::Evigen::DAMAGE_CRASH_UP &&
				bContinue && bIsFlying && frameno > 10) 
			{
				// & 

				/*if( this->get_CurrentKeyBuffer(VK_SPACE) ){
					// g
					this->get_Player()->m_nEventNumber = Motion::Evigen::DAMAGE_B;
				}else {*/

					//ωȂ
			//		if( bContinue ) {
						bIsSkip = TRUE;
			//		}

				//}
			} else if( this->get_Player()->m_nEventNumber == Motion::Evigen::DAMAGE_BOUND ) {

				if( frameno > 48 && bContinue) {
					// DOWNցB
					this->get_Player()->m_nEventNumber = Motion::Evigen::DOWN;

					// \ύX
					ret = staticData->setFace( staticData->get_Player()->m_nSigID, Material::DOWN, TRUE );
				}

			} else if( frameno > 65 && this->get_Player()->m_nEventNumber == Motion::Evigen::RETURN ) {

				// [VƂɖ߂
				this->get_Player()->m_nEventNumber = Motion::Evigen::IDLE;

				// A
				this->restorePlayer();

			} else if( frameno > 109 && this->get_Player()->m_nEventNumber == Motion::Evigen::DEATH ) {
				bIsSkip = TRUE;
			} else if( frameno == 370 && this->get_Player()->m_nEventNumber == Motion::Evigen::SWALLOW ) {
				// n
				for(int i = 0; i < Parts::MAX_NUM; i ++ ) {
					
					if( this->m_aryPartsValidList[i] == TRUE ) {
						// ܂Ă
						// 
						this->m_aryPartsValidList[i] = FALSE;
						ret = E3DSetValidFlag( this->get_Player()->m_nSigID, this->m_aryPartsIndexList[i], this->m_aryPartsValidList[i] );
					}

				}
			} else if( frameno > 438 && this->get_Player()->m_nEventNumber == Motion::Evigen::SWALLOW ) {
				bIsSkip = TRUE;
			}
		
		}else if( this->get_Player()->m_Game.m_nType == PlayerType::TANYA ) {
			if( frameno > 18 && bContinue && this->get_Player()->m_nEventNumber == Motion::Tanya::JUMP_UP ) {
				bIsSkip = TRUE;
			}
		} else {
			_ASSERT(0);
		}
	}

	if( this->get_Player()->m_Game.m_nType == PlayerType::EVIGEN ) {
		if( this->get_Player()->m_nEventNumber >= Motion::Evigen::DAMAGE_A &&
			this->get_Player()->m_nEventNumber <= Motion::Evigen::RETURN ||
			this->get_Player()->m_nEventNumber == Motion::Evigen::SWALLOW ||

			// test motion
			this->get_Player()->m_nEventNumber == Motion::Evigen::ORZ ||
			this->get_Player()->m_nEventNumber == Motion::Evigen::ATOZUSARI ||
			this->get_Player()->m_nEventNumber == Motion::Evigen::SEIJOU ||
			this->get_Player()->m_nEventNumber == Motion::Evigen::SEIJOU_Z ||
			this->get_Player()->m_nEventNumber == Motion::Evigen::OSHIKOMI ||

			this->get_Player()->m_nEventNumber == Motion::Evigen::ROLLING ||
			this->get_Player()->m_nEventNumber == Motion::Evigen::BACKPACK_IDLE

			)
		{
			// _[W
				
			// B
			this->set_WeaponEnable( FALSE );

		} else if( 
			this->isWeaponMotion( this->get_Player()->m_Game.m_nType, this->get_Player()->m_nEventNumber ) 
			)
		{
			// 폊[V
			// ~jK/nho
			this->set_WeaponEnable( TRUE );

			if( this->m_nWeaponIndex == WeaponType::MINI_GUN) {
				// ~jK
				// Ȃ
				if( this->get_Player()->m_nUnderEventNumber == Motion::Evigen::RUN ) {
					this->get_Player()->m_nUnderEventNumber = Motion::Evigen::WALK;
				}
			}
		}
	}
	if( this->isEvigenizePlayer() )
	{

		if( TEST_MOTION_LIST[staticData->m_nTestMotionIndex ] >= 0 ) {
			this->get_Player()->m_nUnderEventNumber = -1;
			this->get_Player()->m_nEventNumber = TEST_MOTION_LIST[staticData->m_nTestMotionIndex ];
		}

		if( this->get_CurrentKeyBuffer( '7' ) && this->get_PreviousKeyBuffer( '7' ) == FALSE ) {

			// ̃eXg[Vֈڍs
			int nMax = sizeof(TEST_MOTION_LIST ) / sizeof(int);
			if( nMax >= 2 ) {
				this->setTestMotion( ( this->m_nTestMotionIndex + 1 ) % nMax );

			}


		}


		if( motid != 0 ) {
			int nNextFaceMaterial = -1;	//-1ȂύXȂ

			if( TEST_MOTION_LIST[this->m_nTestMotionIndex] == Motion::Evigen::SEIJOU_Z ) {
				if( frameno == 70 ) {
					ret = E3DPlaySound( staticData->m_arySoundList[ Sound::VOICE_HIT_1 + MathTool::nextRandom<int>(0,7 ) ], 0, 0, 0 );
				} else if( frameno == 80 ) {
					// ʏ
					nNextFaceMaterial = Material::NORMAL;
				} else if( frameno == 161 ) {
					nNextFaceMaterial = Material::DAMAGE;
				} else if( frameno == 615 ) {
					nNextFaceMaterial = Material::DAMAGE_CRASH;
				} else if( frameno == 620  ) {
					ret = E3DPlaySound( staticData->m_arySoundList[ Sound::VOICE_EXTACY ], 0, 0, 0 );
				} else if( frameno == 800  ) {
					ret = E3DPlaySound( staticData->m_arySoundList[ Sound::VOICE_LONG ], 0, 0, 0 );
				} else if( frameno == 900 ) {
					ret = E3DPlaySound( staticData->m_arySoundList[ Sound::VOICE_HIT_1 + MathTool::nextRandom<int>(0,7 ) ], 0, 0, 0 );
				}

			} else if( TEST_MOTION_LIST[this->m_nTestMotionIndex] == Motion::Evigen::SEIJOU ) {
				if( frameno == 75 ) {
					ret = E3DPlaySound( staticData->m_arySoundList[ Sound::VOICE_HIT_1 + MathTool::nextRandom<int>(0,7 ) ], 0, 0, 0 );
				}
			} else if( TEST_MOTION_LIST[this->m_nTestMotionIndex] == Motion::Evigen::YJI ) {
				if( frameno == 10 ) {
					ret = E3DPlaySound( staticData->m_arySoundList[ Sound::VOICE_HIT_1 + MathTool::nextRandom<int>(0,7 ) ], 0, 0, 0 );
				}
			} else if( TEST_MOTION_LIST[this->m_nTestMotionIndex] == Motion::Evigen::KOUHAII ) {
				if( frameno == 20 ) {
					ret = E3DPlaySound( staticData->m_arySoundList[ Sound::VOICE_EXTACY ], 0, 0, 0 );
				} else if( frameno == 110 ) {
					ret = E3DPlaySound( staticData->m_arySoundList[ Sound::VOICE_HIT_1 + MathTool::nextRandom<int>(0,7 ) ], 0, 0, 0 );
				}
			} else if( TEST_MOTION_LIST[this->m_nTestMotionIndex] == Motion::Evigen::HAIMENZAI ) {
				if( frameno == 50 ) {
					ret = E3DPlaySound( staticData->m_arySoundList[ Sound::VOICE_EXTACY ], 0, 0, 0 );
				} else if( frameno == 195 ) {
					ret = E3DPlaySound( staticData->m_arySoundList[ Sound::VOICE_HIT_1 + MathTool::nextRandom<int>(0,7 ) ], 0, 0, 0 );
				}
			} else if( TEST_MOTION_LIST[this->m_nTestMotionIndex] == Motion::Evigen::HAIMEN_MOTIAGE ) {
				if( frameno == 30 ) {
					ret = E3DPlaySound( staticData->m_arySoundList[ Sound::VOICE_HIT_1 + MathTool::nextRandom<int>(0,7 ) ], 0, 0, 0 );
				}

			} else if( TEST_MOTION_LIST[this->m_nTestMotionIndex] == Motion::Evigen::TAIMEN ) {
				if( frameno == 20 ) {
					ret = E3DPlaySound( staticData->m_arySoundList[ Sound::VOICE_HIT_1 + MathTool::nextRandom<int>(0,7 ) ], 0, 0, 0 );
				}
			} else if( TEST_MOTION_LIST[this->m_nTestMotionIndex] == Motion::Evigen::KOUHAII_2 ) {
				if( frameno == 20 || frameno == 90 ) {
					ret = E3DPlaySound( staticData->m_arySoundList[ Sound::VOICE_HIT_1 + MathTool::nextRandom<int>(0,7 ) ], 0, 0, 0 );
				}
			} else if( TEST_MOTION_LIST[this->m_nTestMotionIndex] == Motion::Evigen::OSHIKOMI ) {
				if( frameno == 20 ) {
					ret = E3DPlaySound( staticData->m_arySoundList[ Sound::VOICE_HIT_1 + MathTool::nextRandom<int>(0,7 ) ], 0, 0, 0 );
				}

			} else if( TEST_MOTION_LIST[this->m_nTestMotionIndex] == Motion::Evigen::ROPER_1_1_1_NUPPU_BASE ) {
				if( frameno >= 65 ) {
					// ߂܂I
					nNextFaceMaterial = Material::DAMAGE;
				}

				if( frameno >= 120 ) {
					// oops

					nNextFaceMaterial = Material::DAMAGE_CRASH;
				}
			} else if( TEST_MOTION_LIST[this->m_nTestMotionIndex] == Motion::Evigen::ROPER_1_1_2_SAKASA_NUPPU ) {
				if( frameno >= 244 ) {
					// oops

					nNextFaceMaterial = Material::DAMAGE_CRASH;
				}
			} else if( TEST_MOTION_LIST[this->m_nTestMotionIndex] == Motion::Evigen::ROPER_2_1_1_HAIMEN_NUPPU ) {
				if( frameno == 95 ) {
					// sound
					ret = E3DPlaySound( staticData->m_arySoundList[ Sound::VOICE_HIT_1 + MathTool::nextRandom<int>(0,7 ) ], 0, 0, 0 );
				}
			} else if( TEST_MOTION_LIST[this->m_nTestMotionIndex] == Motion::Evigen::HIZA_KOUHAII ) {
				if( frameno == 40 ) {
					// sound
					ret = E3DPlaySound( staticData->m_arySoundList[ Sound::VOICE_HIT_1 + MathTool::nextRandom<int>(0,7 ) ], 0, 0, 0 );
				}
			}

			if( nNextFaceMaterial >= 0 ) {
				// \ύX
				ret = staticData->setFace( staticData->get_Player()->m_nSigID, nNextFaceMaterial, TRUE );
			}
		}
	} else if( this->get_Player()->m_Game.m_nType == PlayerType::TANYA ) {
		if( TEST_TANYA_MOTION_LIST[staticData->m_nTestTanyaMotionIndex ] >= 0 ) {
			this->get_Player()->m_nUnderEventNumber = -1;
			this->get_Player()->m_nEventNumber = TEST_TANYA_MOTION_LIST[staticData->m_nTestTanyaMotionIndex ];
		}
		if( this->get_CurrentKeyBuffer( '7' ) && this->get_PreviousKeyBuffer( '7' ) == FALSE ) {

			// 
			int nMax = sizeof(TEST_TANYA_MOTION_LIST ) / sizeof(int);
			if( nMax >= 2 ) {
				this->m_nTestTanyaMotionIndex = ( this->m_nTestTanyaMotionIndex + 1 ) % nMax;

			}
			if( TEST_TANYA_MOTION_LIST[staticData->m_nTestTanyaMotionIndex ] < 0 ) {
				//  ʏ탂[V
				this->get_Player()->m_nUnderEventNumber = -1;
				this->get_Player()->m_nEventNumber = 0;
			}

			// o[\ (ʏ펞̖\)
			bool bIsShowCrowbar = TEST_TANYA_MOTION_LIST[this->m_nTestTanyaMotionIndex] < 0;

			this->showPart( this->get_Player()->m_nSigID, "bar-hand[R]_X-", bIsShowCrowbar );
		}
	}

	// vC[̃[VύX
	if( bIsSkip == FALSE ) {
		if( this->get_Player()->m_nUnderEventNumber >= 0 ) {
			//	this->get_Player()->m_nUpperBoneNumber,
			//	this->get_Player()->m_nUnderBoneNumber,
			// ㉺ŕĂ
			// 㔼g
			int upperList[5];
			int upperNoList[5];
			int underList[5];
			int underNoList[5];
//#define UPPER_BASE 1
#ifdef UPPER_BASE
			//㔼g
			upperList[0] = -1;
			upperList[1] = 0;
			upperNoList[0] = 0;

			// g
			underList[0] = this->get_Player()->m_nUnderBoneNumber;
			underList[1] = 0;
			underNoList[0] = 0;

			ret = E3DSetMOAEventNoML( this->get_Player()->m_nSigID, this->get_Player()->m_nEventNumber,
				upperList, upperNoList );
			ret = E3DSetMOAEventNoML( this->get_Player()->m_nSigID, this->get_Player()->m_nUnderEventNumber,
				underList, underNoList );
#else
			//㔼g
			upperList[0] = -1;//this->get_Player()->m_nUpperBoneNumber;
			upperList[1] = 0;//this->get_Player()->m_nWeaponBoneNumber;
			upperList[2] = 0;//this->get_Player()->m_nWeaponBoneNumber2;
			upperList[3] = 0;

			upperNoList[0] = 0;//this->get_Player()->m_nUnderBoneNumber;
			upperNoList[1] = 0;

			// g
			underList[0] = this->get_Player()->m_nBaseBoneNumber;
			underList[1] = 0;
			underNoList[0] = this->get_Player()->m_nUpperBoneNumber;
			underNoList[1] = 0;

			ret = E3DSetMOAEventNoML( this->get_Player()->m_nSigID, this->get_Player()->m_nEventNumber,
				upperList, upperNoList );
			ret = E3DSetMOAEventNoML( this->get_Player()->m_nSigID, this->get_Player()->m_nUnderEventNumber,
				underList, underNoList );
#endif

			/*if( ret ){
				_ASSERT( 0 );
				return 1;
			}*/
			/*if( ret ){
				_ASSERT( 0 );
				return 1;
			}*/

			/*int weapList[] = {
				this->get_Player()->m_nWeaponBoneNumber,
				0
			};
			int weapNoList[] = {
				0
			};
			ret = E3DSetMOAEventNoML( this->get_Player()->m_nSigID, this->get_Player()->m_nEventNumber,
				weapList, weapNoList );*/

			ret = E3DSetNewPoseML( this->get_Player()->m_nSigID );
			/*if( ret ){
				_ASSERT( 0 );
				return 1;
			}*/
		} else
		{
		/*	int upperList[] = {
				this->get_Player()->m_nUpperBoneNumber,
				0
			};
			int upperNoList[] = {
				0
			};
			// g
			int underList[] = {
				this->get_Player()->m_nUnderBoneNumber,
				0
			};
			int underNoList[] = {
				0
			};
			ret = E3DSetMOAEventNoML( this->get_Player()->m_nSigID, this->get_Player()->m_nEventNumber,
				underList, underNoList );
			ret = E3DSetMOAEventNoML( this->get_Player()->m_nSigID, this->get_Player()->m_nEventNumber,
				upperList, upperNoList );

			E3DSetNewPoseML( this->get_Player()->m_nSigID );*/
			int baseList[] = {
				-1,
				0
			};
			int baseNoList[] = {
				0
			};
			int eventno = this->get_Player()->m_nEventNumber;
			ret = E3DSetMOAEventNoML( this->get_Player()->m_nSigID, eventno,
				baseList, baseNoList );
			if( ret ){
				_ASSERT( 0 );
				return 1;
			}
			ret = E3DSetNewPoseML( this->get_Player()->m_nSigID );
			if( ret ){
				_ASSERT( 0 );
				return 1;
			}
			//ret = E3DSetNewPoseByMOA(this->get_Player()->m_nSigID, this->get_Player()->m_nEventNumber );
		}

		// ̃[V
		int nWeaponEventNumber = this->get_Player()->m_nEventNumber;
		if( this->isWeaponMotion( this->get_Player()->m_Game.m_nType, this->get_Player()->m_nEventNumber ) == false){
			nWeaponEventNumber = 0;
		}
		ret = E3DSetNewPoseByMOA( this->get_Weapon()->m_nSigID, nWeaponEventNumber );

		if( isBackPack() ) 
		{
			ret = E3DSetNewPoseByMOA( this->m_BackPack.m_nSigID, this->get_Player()->m_nEventNumber );
		}
	}

	// XV
	this->get_Player()->m_nOldEventNumber = this->get_Player()->m_nEventNumber;
	return 0;
}

StaticData* staticData = NULL;

/**
  * J[hAT_TARGETɂB
  * JʒuvC[̖ڂ̑Oɂ
  * @param[in]	nSigID			ڂ̑OɈړΏۂSIGID
  * @param[in]	fHeightDelta	YDelta
  */
int StaticData::set_CameraInFrontOfObject( int nSigID, float fHeightDelta ) {
	// AT_TARGET[h
	this->set_CameraMode( CameraMode::AT_TARGET_MODE, nSigID ) ;

	// vC[̕
	D3DXVECTOR3 vDirection;
	int ret = 0;
	ret = E3DGetCharaDir( nSigID, 0,0, &vDirection);
	// ɏ炷
	vDirection.y = fHeightDelta;//-200.f;
	D3DXVec3Normalize( &vDirection, &vDirection );


	// JiTeCgj̏AT_TARGETJvC[̕ɂ
	this->get_Camera()->set_NormalizedQuatanionDirection( vDirection );
	return 0;
}

/** ̕\/\؂ւ
  * @param[in]	bEnable	TRUE	\
  * @param[in]	bEnable	FALSE	\
  *
  */
int StaticData::set_WeaponEnable( BOOL bEnable ) {
	int w = this->m_nWeaponIndex;

	int ret = 0;
	int partno = 0;
	if( this->get_Player()->m_Game.m_nType == PlayerType::EVIGEN ) {

		BOOL bMiniGunEnable = FALSE;
		BOOL bHandGunEnable = FALSE;
		BOOL bMoppuEnable = FALSE;

		if( w == WeaponType::MINI_GUN ) {
			bMiniGunEnable = bEnable;
		} else if( w == WeaponType::HAND_GUN ) {
			bHandGunEnable = bEnable;
		} else if( w == WeaponType::MOPPU ) {
			bMoppuEnable = bEnable;
		}
		showMinigun( bMiniGunEnable == TRUE );
		showHandgun( bHandGunEnable == TRUE );
		showWeapon( WeaponType::MOPPU, bMoppuEnable == TRUE );

	}

	return 0;
}
void StaticData::showWeapon( int nWeaponType, bool bIsShow ) {
	BOOL nIsShow = bIsShow ? TRUE : FALSE;

	//this->m_aryWeaponList[ nWeaponType ].set_Valid( nIsShow );
	E3DSetValidFlag( this->m_aryWeaponList[ nWeaponType ].m_nSigID, -1, nIsShow );
}

void StaticData::showMinigun( bool bIsShow ) {
	this->showWeapon( WeaponType::MINI_GUN, bIsShow );

	/*char LABELS[][100] = {
		"barrel",
		"trunk",
	};
	for(int i = 0; i < 2; i ++ ) {
		this->showPart( this->get_Player()->m_nSigID, LABELS[i], bIsShow );
	}*/
}

void StaticData::showHandgun( bool bIsShow ) {
	this->showWeapon( WeaponType::HAND_GUN, bIsShow );
	/*char LABELS[][100] = {
		"barrel_handgun",
		"trunk_handgun",
		"cartridge_handgun",
	};
	for(int i = 0; i < 3; i ++ ) {
		this->showPart( this->get_Player()->m_nSigID, LABELS[i], bIsShow );
	}*/
}


void StaticData::showPart( int nSigID, const char* lpczPartName, bool bIsShow ) {
	int ret = 0;
	int partno;

	ret = E3DGetPartNoByName( nSigID, lpczPartName, &partno );
	if( ret ) {
		_ASSERT( 0 );
	}
	ret = E3DSetValidFlag( nSigID, partno, bIsShow ? TRUE: FALSE );
	if( ret ) {
		_ASSERT( 0 );
	}
}

// A
int StaticData::restorePlayer() {
	int ret = 0;

	if( this->isEvigenizePlayer() ) {
		// \ɖ߂
		ret = staticData->setFace( staticData->get_Player()->m_nSigID, Material::NORMAL, TRUE );
	}

	return 0;
}

BOOL StaticData::is_MultiLayerMotion() {
	return this->m_nWeaponIndex == WeaponType::MINI_GUN ||
			this->m_nWeaponIndex == WeaponType::HAND_GUN ||
			this->m_nWeaponIndex == WeaponType::MOPPU;
}

/** {^NbNȂǁAUIIȓsV[ł̋ʏ
  * ΏہF^Cg/ViII/Q[I[o[
  *
  */
int StaticData::initUISceneCommon() {
	// }EX͎Rɓ
	this->set_Grab( FALSE );

	return 0;
}

int StaticData::set_GroundType( int nGroundType ) {
	this->m_nSelectedGroundType = nGroundType;

	if( nGroundType == GroundType::PRACTICE_ROOM ) {
		this->set_WallType( WallType::PRACTICE_ROOM ) ;
	} else if( nGroundType == GroundType::ZOMBIE ) {
		this->set_WallType( WallType::ZOMBIE ) ;
	} else if( nGroundType == GroundType::WORM ) {
		this->set_WallType( WallType::WORM ) ;
	} else if( nGroundType == GroundType::SKY ) {
		this->set_WallType( WallType::SKY ) ;
	} else if( nGroundType == GroundType::SNAKE ) {
		this->set_WallType( WallType::SNAKE ) ;
	} else if( nGroundType == GroundType::STARSHIP_TROOPER ) {
		this->set_WallType( WallType::STARSHIP_TROOPER );
	} else {
		this->set_WallType( -1 ) ;
	}
	return 0;
}

BOOL StaticData::set_MouseOverSpriteColor(int nSpriteID, int nPointX, int nPointY, int nRectX, int nRectY, int nRectWidth, int nRectHeight,
	int nOverColR, int nOverColG, int nOverColB, int nOverColA,
	int nNormalColR, int nNormalColG, int nNormalColB, int nNormalColA ) 
{
	int ret = 0;
	if( nPointX >= nRectX && nPointX <= nRectX + nRectWidth &&
		nPointY >= nRectY && nPointY <= nRectY + nRectHeight )
	{
		// J[\ɓ
		E3DCOLOR4UC uc = {nOverColA, nOverColR, nOverColG, nOverColB };
		// Ԃ
		ret = E3DSetSpriteARGB( nSpriteID, uc );

		return TRUE;
	} else {
		E3DCOLOR4UC uc = {nNormalColA,nNormalColR,nNormalColG,nNormalColB };
		ret = E3DSetSpriteARGB( nSpriteID, uc );

		return FALSE;
	}
	
}

void StaticData::reset_Weapons() {
	for( int i = 0; i < WeaponType::MAX_NUM; i ++ ) {
		m_aryWeaponList[i].resetFirst();
	}
}
void StaticData::set_BGMIndex( int nBGMIndex ) {
	int ret = 0;
	int nIsPlay;
	ret = E3DIsSoundPlaying( this->m_arySoundList[this->m_nBGMIndex] , &nIsPlay );
	if( nIsPlay ) {
		ret = E3DStopSound( this->m_arySoundList[this->m_nBGMIndex] );
	}
	this->m_nBGMIndex = nBGMIndex;
	ret = E3DPlaySound( this->m_arySoundList[this->m_nBGMIndex], 0, 0, 255 );
}
E3DBillBoard* StaticData::create_Blood( D3DXVECTOR3& vPosition,
									   D3DXVECTOR3& vDirection) {
	E3DBillBoard* billBoard = this->m_BloodBillBoardManager.search();
	if( billBoard != NULL ) {
		// 

		// ʒuݒ
		E3DSetBillboardPos( billBoard->get_BillBoardID(), vPosition );

		// _ɂ
		D3DXVECTOR3 v = vDirection;

		// AɃ_ɗh炷
		VectorTool::rotateHorizontal( &v, &v, MathTool::nextRandom<float>(-BLOOD_ERROR_DEGREE,BLOOD_ERROR_DEGREE) );
		VectorTool::rotateVertical( &v, &v, MathTool::nextRandom<float>(-BLOOD_ERROR_DEGREE,BLOOD_ERROR_DEGREE) );

		// x
		D3DXVec3Scale( &v, &v, BLOOD_SPEED );

		// ړAxo^
		billBoard->set_Velocity( v );

		// JE^ݒ
		billBoard->set_LifeCounterMax( BLOOD_LIFE_COUNT );
		billBoard->reset();

	}
	return billBoard;

}


void StaticData::create_PlayerBlood() {
	////////////
	// vC[̈ʒu{vC[̕~苗猌o
	// ڂ̍
	D3DXVECTOR3 vEyeHeight( 0, PLAYER_EYE_HEIGHT_FROM_CENTER , 0 );
	D3DXVECTOR3 vBloodPosition = this->get_Player()->m_Move.m_vPosition;

	// ڂ̍ɂ
	vBloodPosition += vEyeHeight;

	// vC[̕
	D3DXVECTOR3 vDirection;
	E3DGetCharaDir( this->get_Player()->m_nSigID, 0,0, &vDirection );
	vDirection *= -1;
	vDirection.y = 0;
	// normalize
	D3DXVec3Normalize( &vDirection, &vDirection );

	D3DXVECTOR3 vBloodDistance = vDirection;
	//scale
	D3DXVec3Scale( &vBloodDistance, &vBloodDistance, SHOT_FROM_DISTANCE );

	vBloodPosition += vBloodDistance;

	// 萔o
	for(int i = 0; i < PLAYER_DAMAGE_BLOOD_NUM; i ++ ) {
		this->create_Blood( vBloodPosition, vDirection );
	}
}

void StaticData::remove_Head() {
	if( this->get_Player()->m_Game.m_nType != PlayerType::EVIGEN ) {
		return ;
	}

	int ret = 0;

	// 
	char MATS[][100] = {
		"atama",
		"kami",
		"katyu",
	};
	for(int i = 0; i < 3; i ++ ) {
		int mat = 0;
		ret = E3DGetMaterialNoByName( this->get_Player()->m_nSigID, MATS[i], &mat );
		if( ret ) {
			_ASSERT(0);
		}
		ret = E3DSetMaterialAlpha( this->get_Player()->m_nSigID, mat, 0.f );
		if( ret ) {
			_ASSERT(0);
		}
	}
	// ̒fʂ\
	int mat = 0;
	ret = E3DGetMaterialNoByName( this->get_Player()->m_nSigID, "danmen", &mat );
	if( ret ) {
		_ASSERT( 0 );
		return ;
	}
	ret = E3DSetMaterialAlpha( this->get_Player()->m_nSigID, mat, 1.f );
	if( ret ) {
		_ASSERT( 0 );
		return ;
	}

	/////
	// 񐶐
	E3DObject* head = this->m_NeutralManager.search( NeutralType::HEAD );
	if( head != NULL ) {
		// ڂ̍
		D3DXVECTOR3 vEyeHeightVector(0,PLAYER_EYE_HEIGHT_FROM_CENTER,0);

		// vC[̈ʒu
		D3DXVECTOR3 vPlayerPosition;
		E3DGetPos( this->get_Player()->m_nSigID, &vPlayerPosition );
		E3DSetPos( head->m_nSigID, 
			vPlayerPosition + vEyeHeightVector);

		D3DXVECTOR3 vError(MathTool::nextRandom<float>(-HEAD_ERROR, HEAD_ERROR),
			0,MathTool::nextRandom<float>(-HEAD_ERROR, HEAD_ERROR ) );

		// _
		this->face( vError, 1, head->m_nSigID, head->m_Move.m_nQuoatanion );

		head->m_Move.m_vVelocity = vError;
		head->m_Move.m_vVelocity.y = HEAD_SPEED + MathTool::nextRandom<float>(-HEAD_ERROR, HEAD_ERROR );

	}

}
void StaticData::set_DirectionToVelocity( HPL::E3D::E3DObject* obj, float fSpeedRate ) {
	int ret = 0;

	//D3DXVECTOR3 vPosition;
	//ret = E3DGetPos( obj->m_nSigID, &vPosition );
	// vC[ւ̕擾
	//D3DXVECTOR3 vDiff = vPlayerPosition - vPosition;

	D3DXVECTOR3 vDirection;
	ret = E3DGetCharaDir( obj->m_nSigID, 0, 0, &vDirection );
	//vDirection *= -1;


	
	// Y͕ςȂiWvƂ̂ŕύXȂƁj
	vDirection.y = 0;
	D3DXVec3Normalize( &vDirection, &vDirection );
	D3DXVec3Scale( &vDirection, &vDirection, obj->m_Move.m_fSpeed * fSpeedRate);

	// ړʂݒiĂɂj
	obj->m_Move.m_vVelocity.x = vDirection.x;
	obj->m_Move.m_vVelocity.z = vDirection.z;
}

void StaticData::setup_Under( int nColor ) {

	E3DObject* player = &(m_aryPlayerList[PlayerType::EVIGEN]);

	//if( this->get_Player()->m_Game.m_nType == PlayerType::EVIGEN ) {
	this->m_nUnderColor = nColor;
	this->set_Texture( player->m_nSigID, "shitagi", Material::UNDER + this->m_nUnderColor, FALSE );

	// ̂ύX

	int nTex = m_nUnderColor == 0 ? Material::KARADA_NORMAL : Material::KARADA_BLACK;
	this->set_Texture( player->m_nSigID, "karada", nTex, FALSE );

	int ret = 0;

	ret = this->set_Texture( player->m_nSigID, "karada_under", nTex, FALSE );
	//}
}


void StaticData::blow_Out( E3DObject* oBlower, E3DObject* oTarget , float fRate ) {
	D3DXVECTOR3 vPlayerPosition;
	E3DGetPos( oTarget->m_nSigID, 
		&vPlayerPosition );
	D3DXVECTOR3 vObjectPosition;
	E3DGetPos( oBlower->m_nSigID, 
		&vObjectPosition );

	D3DXVECTOR3 vDiff = vObjectPosition - vPlayerPosition;

	
	D3DXVECTOR3 vVel = -vDiff;
	D3DXVec3Normalize( &vVel, &vVel );
	if( fabs(vVel.x) <= PLAYER_DAMAGE_MIN_DISTANCE && fabs(vVel.z) <= PLAYER_DAMAGE_MIN_DISTANCE ) {
		vVel.x = MathTool::nextRandom<float>(-1.f,1.f);
		vVel.z = MathTool::nextRandom<float>(-1.f,1.f);
		D3DXVec3Normalize( &vVel, &vVel );
	}
	if( oTarget->m_Game.m_nObjectType == ObjectType::ENEMY ) {
		if( oTarget->m_Game.m_nType == EnemyType::MOSUKO ||
			oTarget->m_Game.m_nType == EnemyType::MOSUKO_LONG ) 
		{
			// ̂ق
			this->face( vVel, 1, oTarget->m_nSigID, 
				oTarget->m_Move.m_nQuoatanion );
		}
	}

	vVel *= PLAYER_RUN_SPEED * PLAYER_BLOWEN_SPEED_RATE * fRate;

	vVel.y = PLAYER_JUMP_SPEED_Y;
	oTarget->m_Move.set_Trigger( TriggerType::ON_THE_GROUND, FALSE );

	//oTarget->m_Move.m_vPosition = vPlayerPosition;
	oTarget->m_Move.m_vVelocity = vVel;
	oTarget->m_Move.m_vPosition += oTarget->m_Move.m_vVelocity;
	E3DSetPos( oTarget->m_nSigID, oTarget->m_Move.m_vPosition );

}

void StaticData::afterRenderCommon() {
	int ret = 0;
	// beforepos
	ret = E3DSetBeforePos( this->get_Player()->m_nSigID) ;

	D3DXVECTOR3 vPos;
	ret = E3DGetPos( this->get_Player()->m_nSigID, &vPos );
	ret = E3DSetPos( this->m_nAtariSigID, vPos );
	ret = E3DSetBeforePos( this->m_nAtariSigID) ;

	//ret = E3DSetBeforeBlur( this->get_Player()->m_nSigID );
}

void StaticData::change_PlayerType( int nType ) {
	int ret = 0;

	// ݂̃vC[ʒuL^
	D3DXVECTOR3 vOriginalPosition;
	ret = E3DGetPos( this->get_Player()->m_nShadowSigID, &vOriginalPosition ) ;

	if( nType != this->get_Player()->m_Game.m_nType ) {
		// Õf
		ret = E3DSetValidFlag( this->get_Player()->m_nSigID, -1, FALSE );
		if( ret ){
			_ASSERT(0);
		}

		//this->get_Player()->m_Game.m_nType = nType;
		this->m_nPlayerType = nType;

		// ݂̃fo
		ret = E3DSetValidFlag( this->get_Player()->m_nSigID, -1, TRUE );
		if( ret ){
			_ASSERT(0);
		}

		// ݂̈ʒu܂ňړ
		/*ret = E3DSetPos( this->get_Player()->m_nSigID, vOriginalPosition );

		this->get_Player()->m_Move.m_vPosition = vOriginalPosition;

		// ǂɈȂ悤ɂ
		ret = E3DSetBeforePos( this->get_Player()->m_nSigID );*/

		if( nType == PlayerType::EVIGEN ) {

			this->reset_EvigenMaterial();

		} else if( nType == PlayerType::TANYA ) {
			// 
			for(int i = 0; i < TanyaParts::MAX_NUM; i ++ ) {
				this->m_aryTanyaPartsValidList[i] = TRUE;
				ret = E3DSetValidFlag( this->get_Player()->m_nSigID,
					this->m_aryTanyaPartsIndexList[i], this->m_aryTanyaPartsValidList[i] );
				if(ret ) {
					_ASSERT(0);
				}
			}
		} else if( nType == PlayerType::TIGHTS ) {
			int n = this->get_Player()->m_nSigID;
			this->showPart( n , "cloth", false );
			this->showPart( n, "garter", false );
			this->showPart( n, "bra", false );
			this->showPart( n, "pants", false );
			this->showPart( n, "katyu-head", false );
			this->showPart( n, "apron", false );
		} else if( nType == PlayerType::KANRITAN ) {
			int n = this->get_Player()->m_nSigID;
			this->showPart( n, "garter", false );
			this->showPart( n, "katyu-head", false );
			this->showPart( n, "apron", false );

		} else if( nType == PlayerType::TOZICA ) {
			int n = this->get_Player()->m_nSigID;
			this->showPart( n, "garter", false );
			this->showPart( n, "katyu-head", false );
			this->showPart( n, "apron", false );

			// m[u
			this->showPart( n, "bra", this->m_aryOptionList[TitleSceneConsts::CheckType::TOZICA_NO_BRA] ?
				false : true);

		}
			// ύX
		//this->get_Player()->m_nSigID = this->m_aryPlayerSigIDList[nType];
		// J̒S
		this->m_nCameraTargetSigID = this->get_Player()->m_nSigID;

		// 평
		this->reset_Weapons();

		// ύX

		int nWeaponType = WeaponType::FIST;
		if( nType == PlayerType::EVIGEN ) {
		} else if( nType == PlayerType::TANYA ) {
			nWeaponType = WeaponType::CROWBAR;
		} else {
			nWeaponType = WeaponType::FIST;
		}

		// IɕύX
		bool bForce = true;
		this->set_WeaponIndex( nWeaponType, bForce);
	}
}

void StaticData::reset_EvigenMaterial() {
	int ret = 0;

	E3DObject* player = &(this->m_aryPlayerList[PlayerType::EVIGEN]);

	// 
	for(int i = 0; i < Parts::MAX_NUM; i ++ ) {
		this->m_aryPartsValidList[i] = TRUE;
		ret = E3DSetValidFlag( player->m_nSigID,
			this->m_aryPartsIndexList[i], this->m_aryPartsValidList[i] );
		if(ret ) {
			_ASSERT(0);
		}
	}
	// }eA
	char MATS[][100] = {
		"atama",
		"kami",
		"karada",
		"huku",
		"apron",
		"katyu",
		"shitagi",
		"huku_under",
		//"shitagi_under",
		"apron_under",
	};
	for(int i = 0; i < 9; i ++ ) {
		int mat = 0;
		ret = E3DGetMaterialNoByName( player->m_nSigID, MATS[i], &mat );
		if( ret ) {
			_ASSERT( 0 );
			return ;
		}
		ret = E3DSetMaterialAlpha( player->m_nSigID, mat, 1 );
		if( ret ) {
			_ASSERT( 0 );
			return ;
		}
	}
	// fʂ͏Ă
	char MATS_FALSE[][100] = {
		"danmen",
		"danmen_body",
	};
	for(int i = 0; i < 2; i ++ ) {
		int mat = 0;
		ret = E3DGetMaterialNoByName( player->m_nSigID, MATS_FALSE[i], &mat );
		if( ret ) {
			_ASSERT( 0 );
			return ;
		}
		ret = E3DSetMaterialAlpha( player->m_nSigID, mat, 0.f );
		if( ret ) {
			_ASSERT( 0 );
			return ;
		}
	}
	ret = staticData->setFace( staticData->get_Player()->m_nSigID, Material::NORMAL, TRUE );

	if( ret ) {
		_ASSERT( 0 );
		return ;
	}
	int nTex = staticData->m_nUnderColor == 0 ? Material::KARADA_NORMAL : Material::KARADA_BLACK;
	ret = staticData->set_Texture( player->m_nSigID, "karada", nTex, FALSE );
	if( ret ) {
		_ASSERT( 0 );
		return ;
	}
	ret = staticData->set_Texture( player->m_nSigID, "karada_under", nTex, FALSE );
	if( ret ) {
		_ASSERT( 0 );
		return ;
	}
}

E3DObject* StaticData::get_Player() {
	return &this->m_aryPlayerList[this->m_nPlayerType];
}

void StaticData::set_Tanya2PColor(){
	int MAT_INDEX[] = {
		Material::TANYA_CROWBAR_NORMAL,
		Material::TANYA_HAKUI_NORMAL,
		Material::TANYA_HAIR_NORMAL,
		Material::TANYA_FACE_NORMAL,
		Material::TANYA_CLOTH_NORMAL,
		Material::TANYA_BODY_NORMAL,
		Material::TANYA_BODY_NORMAL,
	};
	char MAT_LIST[][100] = {
		"bar",
		"white",
		"kami",
		"atama",
		"huku",
		"karada",
		"karada_under",
	};
	for(int i = 0; i < sizeof(MAT_INDEX)/sizeof(int); i ++ ) {

		this->set_Texture( this->m_aryPlayerList[PlayerType::TANYA].m_nSigID,
			MAT_LIST[i], MAT_INDEX[i] + this->m_nTanya2PColor * TANYA_2P_DELTA,
			FALSE);
	}
}

/** vC[\mF
  * 
  */
bool StaticData::isPlayerControllable() {
	if( this->get_Player()->m_Game.m_fHP == 0 ) {
		return false;
	}

	int nEventNumber = this->get_Player()->m_nEventNumber;

	if( this->isEvigenizePlayer() ) {
		if( nEventNumber == Motion::Evigen::DAMAGE_A ||
			nEventNumber == Motion::Evigen::DAMAGE_B ||
			nEventNumber == Motion::Evigen::DAMAGE_CRASH_UP ||
			nEventNumber == Motion::Evigen::SWALLOW ||
			nEventNumber == Motion::Evigen::DAMAGE_BOUND ||
			nEventNumber == Motion::Evigen::DEATH ||
			nEventNumber == Motion::Evigen::RETURN ||
			nEventNumber == Motion::Evigen::DOWN
			)
		{
			return false;
		}

		for(int i = 0; i < sizeof(TEST_MOTION_LIST)/ sizeof(int); i ++ ){
			if( nEventNumber == TEST_MOTION_LIST[i] ) {
				return false;
			}
		}
	}

	if( this->get_Player()->m_Game.m_nType == PlayerType::TANYA) {
		for(int i = 0; i < sizeof(TEST_TANYA_MOTION_LIST )/ sizeof(int); i ++ ){
			if( nEventNumber == TEST_TANYA_MOTION_LIST[i] ) {
				return false;
			}
		}
	}
	
	return true;
}
bool StaticData::isWeaponMotion( int nPlayerType, int nEventNumber ) {
	if( nPlayerType == PlayerType::EVIGEN ) {
		if( nEventNumber >= Motion::Evigen::MINI_GUN_SETTLE &&
			nEventNumber <= Motion::Evigen::MINI_GUN_DOWN ) 
		{
			return true;
		} else if( nEventNumber >= Motion::Evigen::HAND_GUN_IDLE &&
			nEventNumber <= Motion::Evigen::HAND_GUN_RELOAD )
		{
			return true;
		} else if( nEventNumber >= Motion::Evigen::MOPPU_IDLE &&
			nEventNumber <= Motion::Evigen::MOPPU_SWING )
		{
			return true;
		}
	} else if( nPlayerType == PlayerType::TANYA ) {
		if( nEventNumber >= Motion::Tanya::BAR_SET &&
			nEventNumber <= Motion::Tanya::BAR_ATTACK ) 
		{
			return true;
		}
	} else if( nPlayerType == PlayerType::TIGHTS ) {
		// do nothig
	} else if( nPlayerType == PlayerType::KANRITAN ) {
		// do nothing
	} else if( nPlayerType == PlayerType::TOZICA ) {
		// do nothing
	} else {
		_ASSERT(0);
		return false;
	}
	return false;
}

int StaticData::setFace( int nSigID, int nMaterial, BOOL bIsPlayerMaterial ) {
	int ret = 0;
	ret = staticData->set_Texture( staticData->get_Player()->m_nSigID, "atama", nMaterial, bIsPlayerMaterial );
	ret = staticData->set_Texture( staticData->get_Player()->m_nSigID, "eye", nMaterial, FALSE );
	ret = staticData->set_Texture( staticData->get_Player()->m_nSigID, "mouth", nMaterial, FALSE );

	return 0;
}


/** тƓ{[gpĂ郂f
  *
  */
bool StaticData::isEvigenizePlayer() {
	return this->get_Player()->m_Game.m_nType == PlayerType::EVIGEN ||
		this->get_Player()->m_Game.m_nType == PlayerType::TIGHTS ||
		this->get_Player()->m_Game.m_nType == PlayerType::KANRITAN || 
		this->get_Player()->m_Game.m_nType == PlayerType::TOZICA;

}

/** Melee^CviesvBߐڐpj
*/
bool StaticData::isMeleeWeapon() {
	return this->isMeleeWeapon( this->get_Weapon()->m_Game.m_nType );
}
bool StaticData::isMeleeWeapon( int nWeaponType ) {
	return nWeaponType == WeaponType::CROWBAR ||
		nWeaponType == WeaponType::FIST ||
		nWeaponType == WeaponType::MOPPU;
}

/** Melee[hōUǂ
  */
bool StaticData::isMeleeAttackMotion() {
	int nWeaponType = this->get_Weapon()->m_Game.m_nType;
	int nEventNumber = this->get_Player()->m_nEventNumber;

	if( this->isEvigenizePlayer() ) {
		if( nWeaponType == WeaponType::MOPPU ) {
			if( nEventNumber == Motion::Evigen::MOPPU_SWING ) {
				return true;
			}
		} else if( nWeaponType == WeaponType::FIST ) {
			// do nothing
			// TODO attack motion
		}

	} else if( this->get_Player()->m_Game.m_nType == PlayerType::TANYA ) {
		if( nWeaponType == WeaponType::CROWBAR ) {
			if( nEventNumber == Motion::Tanya::BAR_ATTACK ) {
				return true;
			}
		}
	}
	return false;
}

}// namespace MotionTest end



