#include "stdafx.h"
#include "ItemInfo.h"
#include "HPLNetLibConsts.h"

using namespace Enum;
using namespace System;
using namespace System::Collections;
using namespace System::Collections::Generic;

ItemInfo^ ItemInfo::LoadItemInfo(String^ strPath ) {
	List<String^>^ aryResult = gcnew List<String^>();

	HPLNetLibTool::loadLinesFromFile( aryResult,
		strPath,
		gcnew String(HPLNetLibConsts::ENCODING_SHIFT_JIS), true );

	ItemInfo^ info = gcnew ItemInfo();

	
	for each ( String^ str in aryResult ) {
		// 
		cli::array<String^>^ ary = str->Split(_T('='));
		if( ary[0]->Equals(_T("SPRITE_ID")) ) {
			info->m_nSpriteID = Convert::ToInt32(ary[1]);
		} else if( ary[0]->Equals(_T("IMAGE_TYPE")) ) {
			if( ary[1]->Equals(_T("ANIME")) ){
				info->m_nImageType = ButtonImageType::SEQUENCES;
			} else {
				info->m_nImageType = ButtonImageType::FRAMES;
			}
		} else if( ary[0]->Equals(_T("NAME")) ) {
			info->m_strName = ary[1]->Trim();
		} else if( ary[0]->Equals(_T("SEQUENCE_ID")) ) {
			info->m_nSequenceID = Convert::ToInt32(ary[1]);
		} else if( ary[0]->Equals(_T("RELEASE_INDEX")) ) {
			info->m_nReleaseIndex = Convert::ToInt32(ary[1]);
		} else if( ary[0]->Equals(_T("ENTER_INDEX")) ) {
			info->m_nEnterIndex = Convert::ToInt32(ary[1]);
		} else if( ary[0]->Equals(_T("PRESS_INDEX")) ) {
			info->m_nPressIndex = Convert::ToInt32(ary[1]);
		} else if( ary[0]->Equals(_T("CURSOR"))){
			info->m_Cursor = gcnew Windows::Forms::Cursor( _T("data/image/Common/Palette/") + ary[1]);
		} else {
		}
	}
	return info;
}
