#ifndef _BASIC_STATIC_DATA_
#define _BASIC_STATIC_DATA_

//! Windows wb_[ t@C:
#include <windows.h>

//! C ^C wb_[ t@C
#include <cstdlib>
//#include <malloc.h>
#include <memory.h>
#include <tchar.h>


#ifdef _DEBUG
//! fobOo͗p
#include <crtdbg.h>

#endif


//! easy3d
#include <easy3d.h>

#include "E3DSigManager.h"
#include "E3DLightManager.h"

// }EX
#include "DIMouse.h"

// J
#include "DCameraManager.h"

#include "E3DObject.h"

#include <list>

#include "HPLSceneManager.h"

namespace HPL {

namespace E3D {
namespace BasicStaticDataConsts {
	static const int MAX_TITLE_AND_CLASSNAME_STRING_LENGTH = 1024;
	static const TCHAR* INI_FILE_PATH = _T("data/General.ini");
	static const int MAX_KEY_BUFFER = 256;

	//! EDFˌ[hŁAƏ܂ł̋
	static const float CAMERA_SHOT_BEHIND_MODE_TARGET_DISTANCE = 5000.f;
	//! EDFˌ[hŁAvC[班̃J̋
	static const float CAMERA_SHOT_BEHIND_MODE_CAMERA_DISTANCE = 1300.f;
	static const float CAMERA_SHOT_BEHIND_DELTA_HEIGHT = 700.f;

	static const float MOUSE_LOOK_AT_TARGET_MODE_DEGREE_HORIZONTAL = 0.2f;		//! JύXpx
	static const float MOUSE_LOOK_AT_TARGET_MODE_DEGREE_VERTICAL = 0.2f;		//! cJύXpx
	static const float MOUSE_LOOK_SHOT_BEHIND_MODE_DEGREE_HORIZONTAL = 0.1f;		//! JύXpx
	static const float MOUSE_LOOK_SHOT_BEHIND_MODE_DEGREE_VERTICAL = 0.1f;		//! cJύXpx
	static const float MOUSE_LOOK_SNIPER_MODE_DEGREE_HORIZONTAL = 0.2f;		//! JύXpx
	static const float MOUSE_LOOK_SNIPER_MODE_DEGREE_VERTICAL = 0.2f;		//! cJύXpx

	static const float PLAYER_EYE_HEIGHT_FROM_CENTER = 1000;		//! vC[̒SWڂ̍܂ł̑΍x
	static const float PLAYER_SHOT_HEIGHT_FROM_CENTER = 800.f;		//! vC[̒SWe̔ˈʒu܂ł̑΍x
	static const float PLAYER_EYE_HEIGHT_FROM_CENTER_LOW = 100.f;
	static const float PLAYER_EYE_HEIGHT_FROM_CENTER_HIGH = 2000.f;

	static const int CAMERA_ROTATE_DIV = 1;
	static const float GRAVITY = -3.f;
	static const int FONT_SIZE = 16;


	/** }EXJ[h
	  * J؂ւĂB
	  */
	namespace CameraMode {
		enum {
			/** ^[Qbg𒆐SɃJʏ𓮂
			  * ʒu	FǂłBwƂB
			  * pxω	F}EXɍ킹ăJ㉺Eɋʏړ
			  * Disable	F]
			  */
			AT_TARGET_MODE,

			/** EDF/GTAˌ[hBvC[̌̌납^[Qbg銴
			  * ʒu	FvC[̔w
			  * pxω	FvC[]iz̓vC[̏㔼ĝ݁j
			  * Disable	F]
			  */
			SHOT_BEHIND_MODE,

			/** vC[̖ڂ̈ʒu𒆐Sɕ`悷iEyeFromCamera == FALSEj
			  * ꉞNH[^jIȂƂȂ
			  * ʒu	FvC[ĂA苗ꂽƂ
			  * pxω	Fʏ̃JƂ͋tɉ]
			  * Disable	F]ȂBEnableɖ񏉊B
			  *				@tEnable̓vC[\Ȃ悤ɂ邱
			  */
			SNIPER_MODE,

			MAX_NUM,
		} ;

	}

	/** J̏tO
	  *
	  */
	namespace CameraUpFlag {
		enum {
			ALWAYS_Y_AXIS			= 0x000000,	//! Yɂ
			ALWAYS_NEGATIVE_Y_AXIS	= 0x000001,	//! Yɂ
			SEQUENCE				= 0x000002,	//! A
			FREE					= 0x000003,	//! 䖳
		};
	}

	namespace FontType {
		enum {
			MINCHO,
			GOTHIC,
			MAX_NUM
		};
	}
}

class BasicStaticData {
public:
	//! IuWFNg}l[W
	//std::list<E3DObject*> m_lstObjectList;

	//! }EXɂJ؂ւȂ
	//! ʓrJ[h؂ւ鎖
	//BOOL m_bIsNoCameraChange;


private:
	int m_nFontType;
	int m_aryFontIDList[BasicStaticDataConsts::FontType::MAX_NUM];

	//! AvP[ṼCX^X
	HINSTANCE m_hInstance;

	//! CEBhẼnh
	HWND m_hWindowHandle;

	TCHAR m_szTitle[BasicStaticDataConsts::MAX_TITLE_AND_CLASSNAME_STRING_LENGTH];
	TCHAR m_szWindowClass[BasicStaticDataConsts::MAX_TITLE_AND_CLASSNAME_STRING_LENGTH];

	/** Xbv`FCIDFǂ̕ɕ`sw肷ۂɎgp
	  *  E3DChkInView, E3DRender, E3DBeginScene, E3DPresentŎgp
	  */
	int m_nSwapChainID;

	//! baseFPS
	int m_nBaseFPS;

	//! J̍
	//float m_fCameraHeight;

	//! J̋
	//float m_fCameraDistance;

	//! J̈ʒu
	//D3DXVECTOR3 m_vCameraPosition;

	//! L[
	int m_lpCurrentKeyBuffer[BasicStaticDataConsts::MAX_KEY_BUFFER];
	int m_lpPreviousKeyBuffer[BasicStaticDataConsts::MAX_KEY_BUFFER];

	DirectX::DIMouse* m_diMouse;

	//! EBhE͍ANeBuH
	BOOL m_bActive;

	//! J[h
	int m_nCameraMode;

	//! GTAs[hJAO
	//! ܂AΏۂ𒆐SɈܓxAoxɃJړ
	DirectX::DCameraManager* m_cameraAtTarget;

	//! GTAˌ[hJAO
	//! ܂AvC[̌班납^[QbgĂ
	//! ܂ŃJvC[̍WƂāAۂ̃JAO
	//! JvC[Ăɏ͂Ȃꂽʒu
	DirectX::DCameraManager* m_cameraShotBehind;
	//! ⏕q// LN^[ƏL̃J́Ảq݂̕悤ɂ
	//DirectX::DCameraManager* m_cameraShotBehindSub;

	//! XiCp[J
	//! vC[𒆐SƂ
	DirectX::DCameraManager* m_cameraSniper;

	//! }EXJ[\߂܂邩ǂ
	BOOL m_bGrab;

	//! |[Y
	BOOL m_bPause;
public:
	//! XN[̉z̉B
	//! ۂ̃EBhẼTCYƂ͊֌WȂ
	int m_nScreenWidth;
	int m_nScreenHeight;
public:
	//! FPS
	int m_nFPS;

	//! Sig/Quat@CǗ
	E3DSigManager m_SigManager;

	//! Ǘ
	E3DLightManager m_LightManager;

	//! V[Ǘ
	General::HPLSceneManager m_SceneManager;
	
public:
	/** RXgN^
	  *
	  */
	BasicStaticData(HINSTANCE hInstance);

	/** fXgN^ 
	  *
	  */
	~BasicStaticData();

public:	// Getter/Setter
	/** 
	  * @retval {AvP[ṼCX^X
	  */
	HINSTANCE get_Instance();

	/**
	  * @retval {AvP[ṼCEChẼnh
	  */
	HWND get_WindowHandle();

	/** fBAfBNgpX擾
	  *
	  */
	const char* get_MediaDirectory();

	/** Xbv`FCID擾
	  * @retval Xbv`FCID
	  */
	int get_SwapChainID();

	/**
	  * @retval FPS
	  */
	int get_FPS();
	/**
	  * @retval BaseFPS
	  */
	int get_BaseFPS();
	DirectX::DIMouse* get_DIMouse();
	BOOL get_Active();
	VOID set_Active(BOOL bActive);

	/** 
	  * @param[in]	nCameraMode			J[h
	  * @param[in]	nPlayerSigID		vC[f̉]𐧌䂷\邽߁Aw肷
	  *									܂AXiCp[̕擾̂ɂKv
	  */
	VOID set_CameraMode( int nCameraMode, int nPlayerSigID);
	int get_CameraMode();

	DirectX::DCameraManager* get_Camera();

	BOOL get_Grab();
	VOID set_Grab(BOOL bGrab);

	void set_Pause( BOOL bPause );
	BOOL is_Pause();

	int get_FontType();
	int set_FontType( int nFontType );
	int get_FontID();

private:// ֐
	/** CX^X
	  * @param nCmdShow
	  */
	BOOL initInstance( int nCmdShow);

protected:
public: // ʃIy[V


	/** WinMainōŏɍs
	  * @param[in] nAppTitleResourceID	^Cg̃\[XID
	  * @param[in] nClassNameResourceID	AvP[VNX̖̃̕\[XID
	  */
	BOOL commonMainStart(
		int nAppTitleResourceID,
		int nClassNameResourceID,
		int nCmdShow,
		int nIconResourceID, int nSmallIconResourceID,
									HCURSOR hCursor);

	/** WinMainŏIɍs
	  *
	  */
	void commonMainEnd();

	/** EBhENXo^
	  * @param[in] hCursor			ACRnh
	  */
	ATOM registerClass( int nIconResourceID, int nSmallIconResourceID, HCURSOR hCursor);

	/** 3D_O
	  * @retval 0ȊO Ɏsꍇ
	  */
	int render3DEnvironment();
	/**
	  *
	  */
	int updateKeyBuffer();
	int get_CurrentKeyBuffer( int nVirtualKey );
	int get_PreviousKeyBuffer( int nVirtualKey );

	/** JʒuAݒ
	  * @param[in]	vPlayerPosition			vC[̈ʒu
	  * @param[in]	vPlayerDirection		vC[̌Ă
	  */
	int updateCameraPosition( int nPlayerSigID, D3DXVECTOR3& vPlayerPosition, float fHeight);

	/**
	  *
	  * @param[in]	lQuatanionHorizontal	NH[^jII]
	  * @param[in]	fQuatanionVertical	NH[^jIIc]
	  */
	int moveCameraPosition(
		long lQuatanionHorizontal,
		long lQuatanionVertical,
		float *fRateHorizontal,
		float *fRateVertical );

	/** J^[QbgݒiE3D̂܂Ŏ{j
	  * @param[in]	
	  * @return		0	I
	  */
	int set_CameraLookAt(
		int nPlayerSigID , int nPlayerQuatanionID, float fHeight);

	void get_ClientRect(RECT* rClientRect);
	void get_ClientCenter( POINT* pClientCenter );

	/** NH[^jIvDirectionփZbg
	  * @param[in] vDirection	
	  * @param[in] nDivision	
	  * @param[in] nSigID		]Ώۃf
	  */
	void face( D3DXVECTOR3 vDirection , int nDivision, int nSigID,
		int nQuoatanion);

	/** 
	  * @param[in] vDirection			ړ
	  * @param[in] fSpeed				ړ
	  * @param[in] vCurrentPosition		݈ʒu
	  * @param[out] vNewPosition		Vʒu
	  * @retval D3DXVECTOR3				ړxNgi=vDirection * fSpeedj
	  */
	D3DXVECTOR3 move( 
			D3DXVECTOR3 vDirection,
			float fSpeed,
			D3DXVECTOR3 vCurrentPosition,
			D3DXVECTOR3* vNewPosition );
public: // z֐ vI[o[Ch

	/** 񂾂{V[
	  * @retval 0
	  */
	virtual int oneTimeSceneInit() = 0;


};


}// namespace E3D
}// namespace HPL
LRESULT CALLBACK WindowProcedure(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
#endif
