#include "HPLException.h"
#include <stdarg.h>
#include <cstdlib>
#include <cstdio>
#include <tchar.h>


namespace HPL{
namespace General {
/**
  *
  */
HPLException::HPLException( int dwErrorCode, const char* format, ... ) {
	this->m_dwErrorCode = dwErrorCode;
	char message[HPLExceptionConsts::BUFFER_MAX];

	va_list maker;
	va_start( maker, format );
	vsprintf_s( message, HPLExceptionConsts::BUFFER_MAX, format, maker );
	this->m_strErrorMessage = std::string(message );
}
/**
  *
  */
HPLException::~HPLException( ) {
}

/**
  * @retval G[bZ[W
  */
const std::string& HPLException::get_ErrorMessage() {
	return this->m_strErrorMessage;
}

/**
  * @retval G[R[h
  */
DWORD HPLException::get_ErrorCode() {
	return this->m_dwErrorCode;
}


}// namespace General
}// namespace HPL

