#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include <math.h>
#include <Commdlg.h>

#include "../RDBPlugin.h"
#include "../coef_r.h"

#include <shlwapi.h>	// <-- PathFilen֐p

#include <crtdbg.h>// <--- _ASSERT}N

#include <vector>
#include <string>
#include <map>
using namespace std;

static char* TAB_SPACE = "    ";
static int XS_ANIMATION_CONTAINER_TAB_NUM = 3;

static HINSTANCE hInstance;
static HANDLE s_hfile = INVALID_HANDLE_VALUE;
static char* s_jointname = 0;
static int* s_jointinfo = 0;

//////
// mFpO
static HANDLE s_hLogFile = INVALID_HANDLE_VALUE;


class ObjectInfo {
public:
	string m_strName;
	bool m_bIsValid;	//! L(DOI_NOTUSE1DOI_NOTUSẼIuWFNgL\)
//	bool m_bIsInvisible;	//! unused
	ObjectInfo() {
		m_bIsValid = true;
//		m_bIsInvisible = false;
	}
};

class ObjectManager {
public:
	vector<ObjectInfo*> m_vecObjects;
	~ObjectManager() {
		for( vector<ObjectInfo*>::iterator it = this->m_vecObjects.begin();
			it != this->m_vecObjects.end(); it ++ ) 
		{
			delete *it;
		}
		this->m_vecObjects.clear();
	}
};

static int Write2File( char* lpFormat, ... );
static int WriteEachMotion( int hsid, int motid, int jointnum, ObjectManager& objManager );
static void SafeFreeAndClose();

static int putTab( int nNum ) {
	for( int i = 0; i < nNum; i ++ ) {
		Write2File( TAB_SPACE );
	}
	return 0;
}

//---------------------------------------------------------------------------
//  DllMain
//---------------------------------------------------------------------------
BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
	//_CAO{bNX̕\ɕKvȂ̂ŁACX^XۑĂ
	hInstance = (HINSTANCE)hModule;

	setlocale(LC_ALL, "");
	//vOCƂĂ͓ɕKvȏ͂Ȃ̂ŁATRUEԂ
    return TRUE;
}


//---------------------------------------------------------------------------
//  RDBGetPlugInID
//    vOCIDԂB
//    ̊֐͋NɌĂяoB
//---------------------------------------------------------------------------
RDBPLUGIN_EXPORT int RDBGetPlugInID(DWORD *Product, DWORD *ID)
{
	// v_Ng(Җ)IDAS64bit̒lƂĕԂ
	// l͑ƏdȂ悤ȃ_Ȃ̂ŗǂ

	char* cproduct;
	cproduct = (char*)Product;
	*cproduct = 'h';
	*( cproduct + 1 ) = 'o';
	*( cproduct + 2 ) = 'g';
	*( cproduct + 3 ) = 'e';
	*( cproduct + 4 ) = 'p';
	*( cproduct + 5 ) = 'i';
	*( cproduct + 6 ) = 'y';
	*( cproduct + 7 ) = 'o';

	*ID      = 0xDCBA00AB;

	return 0;
}


//---------------------------------------------------------------------------
//  RDBGetPlugInName
//    vOCԂB
//    RokDeBone2̃vOCj[ɁA̖O\B
//---------------------------------------------------------------------------
RDBPLUGIN_EXPORT const char* RDBGetPlugInName(void)
{
	// vOC
	return "MQXExporter";
}

//---------------------------------------------------------------------------
//  RDBOnClose
//    RokDeBone2I钼ORokDeBone2Ă΂B
//---------------------------------------------------------------------------
RDBPLUGIN_EXPORT int RDBOnClose(void)
{
	return 0;
}

//---------------------------------------------------------------------------
//  RDBOnPose
//    RokDeBone2Ń[U[{[̎pҏWA}EX𗣂ƂRokDeBone2Ă΂B
//    [V|Cg͕ύXĂ邪FillUp͂ĂȂԂŌĂ΂B
//---------------------------------------------------------------------------
RDBPLUGIN_EXPORT int RDBOnPose( int motid )
{
	return 0;
}


//----------------------------------------------------------------------------
//  RDBOnSelectPlugin
//  RokDeBone2̃vOCj[ŁARDBGetPlugInName̕IƂɁA
//  ̊֐AAĂ΂܂B
//----------------------------------------------------------------------------

RDBPLUGIN_EXPORT int RDBOnSelectPlugin()
{

	OPENFILENAME ofn;
	char buf[_MAX_PATH];
	buf[0] = 0;
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = NULL;
	ofn.hInstance = 0;
	ofn.lpstrFilter = (LPCTSTR)"mqx FILE (*.mqx)\0*.mqx\0All Files (*.*)\0*.*\0";
	ofn.lpstrCustomFilter = NULL;
	ofn.nMaxCustFilter = 0;
	ofn.nFilterIndex = 1;
	ofn.lpstrFile = (LPTSTR)buf;
	ofn.nMaxFile =sizeof(buf);
	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 0;
	ofn.lpstrInitialDir = NULL;
	ofn.lpstrTitle = NULL;
	ofn.Flags = OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
	ofn.nFileOffset = 0;
	ofn.nFileExtension = 0;
	ofn.lpstrDefExt ="mqx";
	ofn.lCustData = NULL;
	ofn.lpfnHook = NULL;
	ofn.lpTemplateName = NULL;
	if( GetSaveFileName(&ofn) == 0 )
		return 0;

	s_hfile = CreateFile( buf, GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_ALWAYS,
		FILE_FLAG_SEQUENTIAL_SCAN, NULL );
	if( s_hfile == INVALID_HANDLE_VALUE ){
		RDBDbgOut( "motionexporter : file open error %s !!!\n", buf );
		return 1;
	}


	int ret = 0;
	int hsid;
	ret = RDBGetCurrentHSID( &hsid );
	if( hsid >= 0 ){

		// IuWFNgON/OFFݒǂݍ

		char* dispobjname = 0;
		int* dispobjinfo = 0;

		// IuWFNg̐
		int dispobjnum;
		ret = RDBGetDispObjNum( hsid, &dispobjnum );
		if( ret ){
			_ASSERT( 0 );
			SafeFreeAndClose();
			return 0;
	//		goto OnSelectExit;
		}
		if( dispobjnum == 0 ){
			SafeFreeAndClose();
	//		Write2File( "dispobj not exist return\r\n" );
			return 0;
		}
		// IuWF̃obt@
		dispobjname = (char*)malloc( sizeof( char ) * 256 * dispobjnum );
		if( !dispobjname ){
			_ASSERT( 0 );
			SafeFreeAndClose();
			return 0;
		}
		// IuWF̔zm
		dispobjinfo = (int*)malloc( sizeof( int ) * DOI_MAX * dispobjnum );
		if( !dispobjinfo ){
			_ASSERT( 0 );
			free( dispobjname);
			SafeFreeAndClose();
			return 0;
		}
		// eIuWFNg
		int dispgetnum;
		ret = RDBGetDispObjInfo( hsid, dispobjnum, dispobjname, dispobjinfo, &dispgetnum );
		if( ret ){
			_ASSERT( 0 );
			free( dispobjname);
			free( dispobjinfo);
			SafeFreeAndClose();
			return 0;
		}


		ObjectManager objManager;

		for( int nObjIndex = 0; nObjIndex < dispobjnum; nObjIndex ++ ) {
			int dispobjno = nObjIndex;

			int pbpos = 0;
			if( dispobjnum != 0 )
				pbpos = (int)( (float)dispobjno * 100.0f / (float)dispobjnum );

			// name
			ObjectInfo* lpInfo = new ObjectInfo();
			char* lpszName = dispobjname + 256 * dispobjno;
			lpInfo->m_strName = string(lpszName);
			lpInfo->m_bIsValid = *( dispobjinfo + DOI_MAX * dispobjno + 
				DOI_NOTUSE ) == 0;
			objManager.m_vecObjects.push_back( lpInfo );
		}

		free( dispobjinfo );
		free(dispobjname );


		////////////////////// motions
		// [V̐
		int motnum = 0;
		ret = RDBGetMotionNum( hsid, &motnum );
		if( ret ){
			_ASSERT( 0 );
			free(dispobjinfo );
			free(dispobjname );
			SafeFreeAndClose();
			return 0;
		}

		// WCg̐
		int jointnum;
		ret = RDBGetJointNum( hsid, &jointnum );
		if( ret ){
			_ASSERT( 0 );
			SafeFreeAndClose();
			return 0;
		}
//		Write2File( "jointnum %d\r\n", jointnum );

		if( jointnum > 0 ){
			s_jointname = (char*)malloc( sizeof( char ) * 256 * jointnum );
			if( !s_jointname ){
				_ASSERT( 0 );
				SafeFreeAndClose();
				return 0;
			}
			s_jointinfo = (int*)malloc( sizeof( int ) * JI_MAX * jointnum );
			if( !s_jointinfo ){
				_ASSERT( 0 );
				SafeFreeAndClose();
				return 0;
			}

			int jointgetnum;
			ret = RDBGetJointInfo( hsid, jointnum, s_jointname, s_jointinfo, &jointgetnum );
			if( ret ){
				_ASSERT( 0 );
				SafeFreeAndClose();
				return 0;
			}

			Write2File("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n");
			Write2File("<MetasequoiaDocument>\r\n");

			// t@C̊gq̂擾
			char lpszFilePath[MAX_PATH];
			string str(buf);
			int nFileNamePoint = str.find_last_of("\\");
			if( nFileNamePoint < 0 ) {
				nFileNamePoint = 0;
			} else {
				nFileNamePoint += 1;
			}
			//int nFileExtPoint = PathFindExtension( buf );
			int nFileExtPoint = str.find_last_of(".");
			//strncpy( lpszFilePath, buf, nFileNamePoint , nFileExtPoint - nFileNamePoint);

			Write2File("    <IncludedBy>%s.mqo</IncludedBy>\r\n",
				str.substr( nFileNamePoint, nFileExtPoint - nFileNamePoint  ).c_str() );
				
			Write2File("    <Plugin.BD1224DB.0000002C name=\"{[\">\r\n");
			Write2File("        <XSFormat version=\"0.2\" app=\"Metasequoia\">\r\n");
			Write2File("            <XSConfig>\r\n");
			Write2File("                <XSFileConfig limitFPS=\"0\" FPS=\"60.00\" step=\"0\" freeze=\"0\" fastcalc=\"0\" adjustwgt=\"0\" debugdraw=\"0\" mode=\"0\" multitrack=\"0\" />\r\n");
			Write2File("                <XSSceneConfig col_scn=\"8375551\" />\r\n");
			Write2File("                <XSBoneConfig col_def=\"6737049\" col_sel=\"16757299\" col_hot=\"16776960\" col_cst=\"15040434\" col_phy=\"8362444\" />\r\n");
			Write2File("            </XSConfig>\r\n");
			Write2File("            <XSAnimationContainer>\r\n");

			int motid;
			for( motid = 0; motid < motnum; motid++ ){
				ret = WriteEachMotion( hsid, motid, jointnum,
					objManager);
				if( ret ){
					_ASSERT( 0 );
					SafeFreeAndClose();
					return 0;
				}
			}
			Write2File("            </XSAnimationContainer>\r\n");
			Write2File("        </XSFormat>\r\n");
			Write2File("    </Plugin.BD1224DB.0000002C>\r\n");
			Write2File("</MetasequoiaDocument>\r\n");
		}
	}else{
		//Write2File( "model data is not loaded return !!!\r\n" );
		RDBDbgOut("model data is not loaded");
	}



	SafeFreeAndClose();


	return 0;

}

void SafeFreeAndClose()
{

	if( s_jointname ){
		free( s_jointname );
		s_jointname = 0;
	}
	if( s_jointinfo ){
		free( s_jointinfo );
		s_jointinfo = 0;
	}

	if( s_hfile != INVALID_HANDLE_VALUE ){
		FlushFileBuffers( s_hfile );
		SetEndOfFile( s_hfile );
		CloseHandle( s_hfile );
		s_hfile = INVALID_HANDLE_VALUE;
	}

	MessageBox( NULL, "MQXExporteȑI܂B", "MQXExporter", MB_OK );
}


int Write2File( char* lpFormat, ... )
{
	if( s_hfile == INVALID_HANDLE_VALUE ){
		return 0;
	}

	int ret;
	va_list Marker;
	unsigned long wleng, writeleng;
	char outchar[4098];
			
	va_start( Marker, lpFormat );
	ret = vsprintf( outchar, lpFormat, Marker );
	va_end( Marker );

	if( ret < 0 )
		return 1;

	wleng = (unsigned long)strlen( outchar );
	WriteFile( s_hfile, outchar, wleng, &writeleng, NULL );
	if( wleng != writeleng ){
		return 1;
	}

	return 0;	
}

class BoneJointInformation {
public:
	int m_nBoneID;	// boneno
	int m_nJointID;	// jointno
	BoneJointInformation() {
		this->m_nBoneID = -1;
		this->m_nJointID = -1;
	}
};
class FrameData {
private:
	FrameData(){}
public:
	vector<BoneJointInformation*> m_vecInformations;
	//map<int,BoneJointInformation*> 
	
/*	void add( BoneJointInformation* lpInfo ) {
		this->m_vecInformations.push_back( lpInfo );
	}*/
	FrameData( int nNumOfJoints ) {
		// iNULLŖ߂j
		for( int i = 0; i < nNumOfJoints; i ++ ) {
			m_vecInformations.push_back(NULL);
		}
	}
	~FrameData() {
		for( vector<BoneJointInformation*>::iterator it = this->m_vecInformations.begin();
			it != this->m_vecInformations.end(); it ++ )
		{
			delete *it;
		}
		this->m_vecInformations.clear();
	}
};

class FrameDataManager {
public:
	// <frameindex,framedata>
	map<int,FrameData*> m_mapFrameDatas;

	FrameData* get( int nFrameIndex ) {
		if( this->m_mapFrameDatas.find(nFrameIndex) == this->m_mapFrameDatas.end() ) {
			return NULL;
		}
		return this->m_mapFrameDatas[nFrameIndex];
	}
	void add( int nFrameIndex, FrameData* lpFrame ) {
		if( this->m_mapFrameDatas.find(nFrameIndex) != this->m_mapFrameDatas.end()) {
			// already registered
			delete this->m_mapFrameDatas.find(nFrameIndex)->second;
		}
		this->m_mapFrameDatas[nFrameIndex] = lpFrame;//.push_back( lpFrame );
	}
	~FrameDataManager() {
		for( map<int,FrameData*>::iterator it = this->m_mapFrameDatas.begin();
			it != this->m_mapFrameDatas.end(); it ++ )
		{
			delete it->second;
		}
		this->m_mapFrameDatas.clear();
	}
};
/** sV~}gNXM̐V'߂
  */
void multipleVectorAndMatrix(RDBPoint& vec, RDBMatrix& mat, RDBPoint& vResult) {
//	vResult.x = vec.x * mat._11 + vec.y * mat._12 + vec.z
}
int WriteEachMotion( int hsid, int motid, int jointnum, ObjectManager& objManager )
{
	int ret;
	char motionname[256];
	motionname[0] = 0;

	ret = RDBGetMotionName( hsid, motid, motionname );
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}
	const int INTERPOLATE_TYPE = 21;	//ԃ^CvB
	Write2File("                <XSAnimationSet name=\"%s\" interpolate=\"%d\">\r\n",
		motionname, INTERPOLATE_TYPE);

//	Write2File( "\r\n\r\n///// motion name %s /////\r\n", motionname );

	int frameleng;
	ret = RDBGetFrameLeng( hsid, motid, &frameleng );
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}
				
	if( frameleng == 0 ){
//		Write2File( "frameleng is Zero : motion is not included return !!!\r\n" );
		return 0;
	}

	// L[̃t[ϊpێf[^
	FrameDataManager frameDataManager;

	// convert from {joints1{frames},joints2{frames},...} to {frame1{frames},frame2{frames},...}
	/*for( int i = 0; i < frameleng; i ++ ) {
		FrameData* lpFrame = new FrameDat();
		frameDataManager.add( lpFrame );
	}*/
	// WCgL^p
	vector<string> vecJointNames;
	int jointno;
	for( jointno = 0; jointno < jointnum; jointno++ ){

		//OAVAԍ̏o
		int boneno;
		boneno = *( s_jointinfo + JI_MAX * jointno + JI_SERIAL );
		vecJointNames.push_back( s_jointname + 256 * jointno );

//		Write2File( "\r\n\r\njoint : name %s, boneno %d\r\n", s_jointname + 256 * jointno, boneno );



		//XP[rC]qAړs̏o
		int* keyframearray = 0;
		keyframearray = (int*)malloc( sizeof( int ) * frameleng );
		if( !keyframearray ){
			_ASSERT( 0 );
			return 1;
		}

		int keynum;
		ret = RDBGetKeyFrameNo( hsid, boneno, motid, keyframearray, frameleng, &keynum );
		if( ret ){
			_ASSERT( 0 );
			free( keyframearray );
			return 1;
		}

		if( keynum > 0 ){
			int keycnt, frameno;
			for( keycnt = 0; keycnt < keynum; keycnt++ ){
				frameno = *( keyframearray + keycnt );

				// get specified frame data
				//FrameData* lpFrame = frameDataManager.m_vecFrameDatas[frameno];
				FrameData* lpFrame = frameDataManager.get(frameno );
				if( lpFrame == NULL ) {
					lpFrame = new FrameData(jointnum);
					frameDataManager.m_mapFrameDatas[frameno] = lpFrame;
				}
				BoneJointInformation* lpBoneInfo = new BoneJointInformation();
				lpBoneInfo->m_nBoneID = boneno;
				lpBoneInfo->m_nJointID = jointno;	// {[ɑ΂A
				lpFrame->m_vecInformations[jointno] = lpBoneInfo;
				


			}
		}else{
//			Write2File( "keyframe num is Zero : motion data is not exist in this bone\r\n" );
		}

		free( keyframearray );
	}

	// яϊ̂t@C֏o͂
	for( map<int, FrameData*>::iterator it = frameDataManager.m_mapFrameDatas.begin();
		it != frameDataManager.m_mapFrameDatas.end(); it ++ ) 
	{
//	for( int nFrameIndex = 0; nFrameIndex < (int)frameDataManager.m_vecFrameDatas.size(); nFrameIndex ++ ) {
		int nFrameIndex = it->first;

		Write2File("                    <XSAnimation frame=\"%d\">\r\n",
			nFrameIndex);

		// 1framȅ
		FrameData* lpFrame = it->second;//frameDataManager.m_vecFrameDatas[nFrameIndex];
		for( int nJointIndex = 0; nJointIndex < (int)lpFrame->m_vecInformations.size(); nJointIndex ++ ) {
			BoneJointInformation* lpInfo = lpFrame->m_vecInformations[nJointIndex];

			string jointName = vecJointNames[nJointIndex];
			if( jointName.compare("TopOfbase") == 0 ) {
				// skip!
				continue;
			}
			if( jointName.find( "FLOAT_") == 0 ) {
				// skip!
				continue;
			}
			int nLeftStart = jointName.find( "[L]" );
			int nRightStart = jointName.find( "[R]" );
			if( nLeftStart != string::npos ) {
				jointName = jointName.substr( 0, nLeftStart) + "_L_";
			} else if( nRightStart != string::npos ) {
				jointName = jointName.substr( 0, nRightStart) + "_R_";
			}
			if( lpInfo == NULL ) {
				Write2File("                        <XSAnimationKey name=\"%s\"/>\r\n",
					jointName.c_str());
				continue;
			}

			int boneno = lpInfo->m_nBoneID;
			int joinno = lpInfo->m_nJointID;	// == nJointIndex
			int frameno = nFrameIndex;
			Write2File("                        <XSAnimationKey name=\"%s\">\r\n",
				jointName.c_str() );

			RDBPoint scale, trans;
			RDBQuaternion rotq;

			//DirectX9 SDKSkinnedMeshTvɂ킹`
			//ItZbg}gbNX̏o
			RDBMatrix offsetmat;
			ret = RDBGetOffsetMatrix( hsid, boneno, &offsetmat );
			if( ret ){
				_ASSERT( 0 );
				return 1;
			}
			/*
			Write2File( "offsetmatrix : _11 %f, _12 %f, _13 %f. _14 %f\r\n\t_21 %f, _22 %f, _23 %f. _24 %f\r\n\t_31 %f, _32 %f, _33 %f. _34 %f\r\n\t_41 %f, _42 %f, _43 %f. _44 %f\r\n",
				offsetmat._11, offsetmat._12, offsetmat._13, offsetmat._14,
				offsetmat._21, offsetmat._22, offsetmat._23, offsetmat._24,
				offsetmat._31, offsetmat._32, offsetmat._33, offsetmat._34,
				offsetmat._41, offsetmat._42, offsetmat._43, offsetmat._44
			);*/
/*			ret = RDBGetKeyFrameSRT( hsid, boneno, motid, frameno, &scale, &rotq, &trans );
			if( ret ){
				_ASSERT( 0 );
//				free( keyframearray );
				return 1;
			}
			Write2File( "format type 0 : frameno %d\r\nscale %f, %f, %f\r\nquaternion %f, %f, %f, %f\r\ntranslate %f %f %f\r\n",
				frameno,
				scale.x, scale.y, scale.z,
				rotq.x, rotq.y, rotq.z, rotq.w,
				trans.x, trans.y, trans.z
			);*/

			// ȅ
			int nJointParentID = *(s_jointinfo + JI_MAX * joinno + JI_PARENT );
			BoneJointInformation* lpParentInfo = lpFrame->m_vecInformations[nJointIndex];
			
			//RokDeBone2ł̌`
/**/
			int nBoneID = boneno;//lpParentInfo->m_nBoneID;//boneno,

			ret = RDBGetKeyFrameSRT2( hsid, nBoneID,
				motid, frameno, &scale, &rotq, &trans );
			if( ret ){
				_ASSERT( 0 );
//				free( keyframearray );
				return 1;
			}
			RDBQuaternion quaternion;
			RDBGetBoneQuaternion( hsid, nBoneID, motid, frameno, 1, &quaternion );
			// equaternion
/*			RDBQuaternion qParent;
			RDBGetBoneQuaternion( hsid, lpParentInfo->m_nBoneID, motid, frameno, 0, &quaternion );
			// quaternion̍
			quaternion.x = quaternion.x * quaternion.w + qParent.x * qParent.w;
			quaternion.y = quaternion.y * quaternion.w + qParent.y * qParent.w;
			quaternion.z = quaternion.z * quaternion.z + qParent.z * qParent.w;
			quaternion.w = 1;
*/

			if( trans.x == 0 && trans.y == 0 && trans.z == 0) {
			} else {
				// 6ڂŎľܓ0ȂXLbvi
				Write2File("                            <v>%1.6f %1.6f %1.6f</v>\r\n",
					trans.x, trans.y, trans.z);
			}
			//q
			Write2File("                            <q>%1.6f %1.6f %1.6f %1.6f</q>\r\n",
				quaternion.x, quaternion.y, quaternion.z, quaternion.w );
/*			Write2File( "format type 1 : frameno %d\r\nscale %f, %f, %f\r\nquaternion %f, %f, %f, %f\r\ntranslate %f %f %f\r\n",
				frameno,
				scale.x, scale.y, scale.z,
				rotq.x, rotq.y, rotq.z, rotq.w,
				trans.x, trans.y, trans.z
			);*/
			Write2File("                        </XSAnimationKey>\r\n");
		}	// for bones

		//////////////////////
		// IuWFNgXe[g
		for( int nObjIndex = 0; nObjIndex < (int)objManager.m_vecObjects.size(); nObjIndex ++ ) {
			ObjectInfo* lpObj = objManager.m_vecObjects[nObjIndex];
			Write2File("                        <XSAnimationState name=\"%s\" visible=\"%d\" fvalue=\"0.000000\" />\r\n",
				lpObj->m_strName.c_str(),
				lpObj->m_bIsValid ? 1: 0 );

		}
		Write2File("                    </XSAnimation>\r\n");
	}
	Write2File("                </XSAnimationSet>\r\n");

	return 0;
}