#pragma once

typedef class  CXSDocument *XSDocument;

class CXSDocument
{
public:
	WORD	wver;
	int		m_mesh_count;
	int		m_bone_count;
	int		m_mat_count;
	int		m_aset_count;
	int		m_attr_count;

	XSMesh				*pMesh;
	XSBone				*pBone;
	XSMaterial			*pMaterial;
	XSAnimationSet		*pAnimationSet;
	XSSceneAttribute	*pAttribute;

	inline WORD				GetVersion(void){return wver; };
	inline int 				GetMeshCount(void){return m_mesh_count;};
	inline XSMesh			GetMesh(int index){return pMesh[index];};
	inline int 				GetMaterialCount(void){return m_mat_count;};
	inline XSMaterial		GetMaterial(int index){return pMaterial[index];};
	inline int 				GetBoneCount(void){return m_bone_count;};
	inline XSBone			GetBone(int index){return pBone[index];};
	inline int 				GetAnimationSetCount(void){return m_aset_count;};
	inline XSAnimationSet	GetAnimationSet(int index){return pAnimationSet[index];};
	inline int				GetSceneAttributeCount(void){return m_attr_count; };
	inline XSSceneAttribute	GetSceneAttribute(int index){return pAttribute[index]; };

	CXSDocument(void)
    {
		wver			= 0;
		m_mesh_count	= 0;
		m_bone_count	= 0;
		m_mat_count		= 0;
		m_aset_count	= 0;

		pMesh			= NULL;
		pBone			= NULL;
		pMaterial		= NULL;
		pAnimationSet	= NULL;
		pAttribute		= NULL;
	};

	virtual ~CXSDocument(void){

		for(int i = 0; i < m_mesh_count; i++)
			XS_SAFE_DELETE(pMesh[i]);
		for(int i = 0; i < m_bone_count; i++)
			XS_SAFE_DELETE(pBone[i]);
		for(int i = 0; i < m_mat_count; i++)
			XS_SAFE_DELETE(pMaterial[i]);
		for(int i = 0; i < m_aset_count; i++)
			XS_SAFE_DELETE(pAnimationSet[i]);

		XS_SAFE_DELETE(pMesh);
		XS_SAFE_DELETE(pBone);
		XS_SAFE_DELETE(pMaterial);
		XS_SAFE_DELETE(pAnimationSet);
		XS_SAFE_DELETE(pAttribute);

	};
};
