#ifndef _LINE_MANAGER_
#define _LINE_MANAGER_

using namespace System;
using namespace System::Collections;
using namespace System::Drawing;

#include "CommonFunc.h"

public ref class LineData {
public:
	Point^ start;
	Point^ end;
};
public ref class LineManager{
public:
	ArrayList^ lineList;

	LineManager(){
		lineList = gcnew ArrayList();
	}

	void loadFromMQO( String^ filePath ) {
		this->lineList->Clear();

		cli::array<String^>^ lines = CommonFunc::loadFromText(filePath );
		bool bIsVertexArea = false;
		Point^ prevPoint;
		bool bStocked = false;

		int num = 0;

		for each( String^ line in lines ) {

			if( bIsVertexArea ) {
				if( line->Contains(_T("}")) ) {
					bIsVertexArea = false;
					//break;
					bStocked = false;
				} else {
					// 󔒂ŕ
					cli::array<String^>^ ary = line->Split(_T(' '));
					//lɂX,ZW擾
					int nX = (int)Convert::ToDouble(ary[0]);
					int nZ = (int)Convert::ToDouble(ary[2]);

					Point^ p = gcnew Point(nX, nZ);
					if(bStocked){
						// XgbNς
						// ɂ

						LineData^ lineData = gcnew LineData();
						lineData->start = prevPoint;
						lineData->end = p;
						this->lineList->Add(lineData);
						//bStocked = true;
						//prevPoint = p;
						if( num < 4 ){
							num ++;
							prevPoint = p;
						} else {
							num = 0;
						}
					} else {
						num = 0;
						prevPoint = p;
						bStocked = true;
					}
				}
				
			} else {
				if( line->Contains(_T("vertex"))) {
					bIsVertexArea = true;
				}
			}
			
		}
	}
};

#endif
