#include "GameScene.h"

#include "StaticData.h"

namespace MotionTest {
using namespace std;
using namespace MotionTestConsts;
using namespace HPL;
using namespace E3D;
using namespace BasicStaticDataConsts;
using namespace General;

static EnemySpawnerData ENEMY_SPAWNER_MASTER_DATAS[EnemyType::NUM_MAX];

GameScene::GameScene() : AbstractScene(){
	if( sizeof(ENEMY_SPAWNER_MASTER_DATAS)/sizeof(ENEMY_SPAWNER_MASTER_DATAS[0]) != EnemyType::NUM_MAX ) {
		_ASSERT(9);
	}

	int datas[] = {
		OBJECT_MAX,			// cyclops
		WORM_BIG_MAX,			// 
		WORM_SMALL_MAX,		// 
		ZOMBIE_MAX,			// 
		MOSUKO_MAX,			// 
		MOSUKO_MAX,			// 
		ZOMBIE_B_MAX,			// 
		1,						// troll
		HOVER_MAX,				// 
		1,						// zombieA
		1,						// roper
		PHOBOKO_MAX,			// 
		ARACHNE_MAX,			// 
		1,						// Wall
		1,						// Switch
	};
	for( int i = 0; i < sizeof(datas)/sizeof(int); i ++ ) {
		ENEMY_SPAWNER_MASTER_DATAS[i].m_nRate = 0;
		ENEMY_SPAWNER_MASTER_DATAS[i].m_nMax = datas[i];
	}
	this->resetSpawnerDatas();
}
void GameScene::resetSpawnerDatas() {
	for( int i = 0; i < EnemyType::NUM_MAX; i ++ ) {
		this->m_aryEnemySpawnerDatas[i] = ENEMY_SPAWNER_MASTER_DATAS[i];
	}
}

GameScene::~GameScene() {
}

bool isPlaceStage( int nMissionType ){
	if( nMissionType == MissionType::PRACTICE ||
		nMissionType == MissionType::WORM ||
		nMissionType == MissionType::ZOMBIE ||
		nMissionType == MissionType::TEST_SKY ||
		nMissionType == MissionType::SNAKE)
	{
		return true;
	}

	return false;
}
void GameScene::createAndPlacePhoboko( int nNum ) {
	int ret = 0;

	staticData->m_EnemyManager.createObjects( EnemyType::PHOBOKO, nNum );

	// ߂ɔzu
	for( int i = 0; i < nNum; i ++ ) {
		E3DObject* phoboko = staticData->m_EnemyManager.search( EnemyType::PHOBOKO );

		if( phoboko == NULL ) {
			_ASSERT(0);
			break;
		} else {
			float fDegree = MathTool::nextRandom<float>(0, 360 );
			float fDistance = MathTool::nextRandom<float>( 0, 5000 ) + 2500;

			D3DXVECTOR3 vDiff = D3DXVECTOR3(cos(D3DXToRadian(fDegree)), 0, sin(D3DXToRadian(fDegree)));
			D3DXVec3Scale( &vDiff, &vDiff, fDistance );
			ret = E3DSetPosOnGround( phoboko->m_nSigID, staticData->get_GroundSigID(),
				MAP_HEIGHT, MAP_MIN, 
				staticData->get_Player()->m_Move.m_vPosition.x + vDiff.x,
				staticData->get_Player()->m_Move.m_vPosition.z + vDiff.z );

			// ʒuf[^ɃZbg
			ret = E3DGetPos( phoboko->m_nSigID, &phoboko->m_Move.m_vPosition );

		}
	}
}
void GameScene::init() {

	int ret = 0;
	// }bvI
	if( staticData->m_nScenarioIndex == MissionType::PRACTICE ) {
		staticData->set_GroundType( GroundType::PRACTICE_ROOM );

	} else if( staticData->m_nScenarioIndex == MissionType::WORM ) {
		staticData->set_GroundType( GroundType::WORM );

	} else if( staticData->m_nScenarioIndex == MissionType::STARSHIP_TROOPER) {
		staticData->set_GroundType( GroundType::STARSHIP_TROOPER );

	} else if( staticData->m_nScenarioIndex == MissionType::ZOMBIE ) {
		staticData->set_GroundType( GroundType::ZOMBIE );

	} else if( staticData->m_nScenarioIndex == MissionType::TEST_SKY ) {
		staticData->set_GroundType( GroundType::SKY );

	} else if( staticData->m_nScenarioIndex == MissionType::CHALLENGE) {
		staticData->set_GroundType( GroundType::EVIL_STAR );

	} else if( staticData->m_nScenarioIndex == MissionType::SNAKE ) {
		staticData->set_GroundType( GroundType::SNAKE );

	} else {
		staticData->set_GroundType( GroundType::EVIL_STAR );
	}

	// check in view
	staticData->checkInGround();

	
	BOOL bIsHPMax = TRUE;
	bool bIsMoveToCenter = true;
	staticData->reset_Player( bIsHPMax, bIsMoveToCenter );

	// 
	staticData->m_EnemyManager.reset();
	staticData->m_ShotManager.reset();
	staticData->m_NeutralManager.reset();

	staticData->reset_Weapons();

	// BGMύX
	
	if( staticData->m_nScenarioIndex == MissionType::STARSHIP_TROOPER ) {
		staticData->set_BGMIndex( Sound::PANIC );

	} else if( staticData->m_nScenarioIndex == MissionType::SNAKE ||
		staticData->m_nScenarioIndex == MissionType::TEST_PHOBOKO ||
		staticData->m_nScenarioIndex == MissionType::TEST_HOVER ||
		staticData->m_nScenarioIndex == MissionType::TEST_MOSUKO
		)
	{
		staticData->set_BGMIndex( Sound::EVIL_STAR );
	} else {
		staticData->set_BGMIndex( Sound::GAME );
	}

	// IuWFNg̔zu
	if( staticData->m_nScenarioIndex == MissionType::TEST_PHOBOKO ) {

		this->createAndPlacePhoboko( PHOBOKO_MAX );

	} else if( isPlaceStage( staticData->m_nScenarioIndex ) ) {
		char OBJ_FILE_PATH[][MAX_PATH] = {
			"Media\\Stage\\Stage0-PracticeRoom.txt",
			"Media\\Stage\\Stage1-zombie.txt",
			"Media\\Stage\\Stage2-worm.txt",
			"Media\\Stage\\Stage3-sky.txt",
			"Media\\Stage\\Stage4-Snake.txt",
		};

		int nIndex = 0;
		if( staticData->m_nScenarioIndex == MissionType::WORM){
			nIndex = 2;
		} else if( staticData->m_nScenarioIndex == MissionType::ZOMBIE ) {
			nIndex = 1;
		} else if( staticData->m_nScenarioIndex == MissionType::TEST_SKY ) {
			nIndex = 3;
		} else if( staticData->m_nScenarioIndex == MissionType::SNAKE ) {
			nIndex = 4;
		}

		// zuǂݍ
		vector<string> vecLines;
		ret = TextTool::load_StringLinesFromFile( OBJ_FILE_PATH[ nIndex ], 
			&vecLines );
		if( ret ) {
			_ASSERT( 0 );
		}

		// oꂳ郂fvZ
		std::list<E3DObject*> objList;

		std::map<int,int> objNumList;

		for( int i = 0; i < static_cast<int>(vecLines.size() ); i ++ ) {
			if( TextTool::is_SkipLine( vecLines[i] ) ) {
				continue;
			}

			// split
			vector<string> vecItems = TextTool::split( vecLines[i], "," );

			int nObjectType = atoi( vecItems[0].c_str() );
			int nType = atoi( vecItems[1].c_str() );
			float fX = static_cast<float>(atof( vecItems[2].c_str() ));
			float fY = static_cast<float>(atof( vecItems[3].c_str() ));
			float fZ = static_cast<float>(atof( vecItems[4].c_str() ));
			float fFaceX = static_cast<float>(atof( vecItems[5].c_str() ));
			float fFaceY = static_cast<float>(atof( vecItems[6].c_str() ));
			float fFaceZ = static_cast<float>(atof( vecItems[7].c_str() ));
			int nScenarioIndex = -1;
			if( static_cast<int>(vecItems.size()) > 8 ) {
				nScenarioIndex = atoi( vecItems[8].c_str() );
			}
			E3DObject* obj = new E3DObject();
			obj->m_Game.m_nObjectType = nObjectType;
			obj->m_Game.m_nType = nType;
			obj->m_Move.m_vPosition = D3DXVECTOR3(fX,0,fZ);
			obj->m_Move.m_vVelocity = D3DXVECTOR3( fFaceX, fFaceY, fFaceZ );
			obj->m_Game.m_nScenarioIndex = nScenarioIndex;

			// o^
			objList.push_back(obj);

			if( nObjectType == 0 ) {
				if( objNumList.find(nType ) == objNumList.end() ) {
					objNumList[nType] = 0;
				}
				objNumList[nType] += 1;
			}
		}

		for( std::map<int,int>::iterator it = objNumList.begin();
			it != objNumList.end(); it ++ ) 
		{

			// f쐬
			staticData->m_EnemyManager.createObjects(it->first, it->second );
		}


		// fzu
		for( std::list<E3DObject*>::iterator it = objList.begin();
			it != objList.end(); )
		{

			E3DObject* sourceObject = *it;

			E3DObject* obj = NULL;
			if( sourceObject->m_Game.m_nObjectType == 0 ) {
				obj = staticData->m_EnemyManager.search( sourceObject->m_Game.m_nType );
			} else if( sourceObject->m_Game.m_nObjectType == 1 ) {
				obj = staticData->m_NeutralManager.search( sourceObject->m_Game.m_nType );
			} else {
				_ASSERT(0);
			}
			if( obj != NULL ) {
				//obj->m_Move.m_vPosition = D3DXVECTOR3( fX, fY, fZ );
				//ret = E3DSetPos( obj->m_nSigID, obj->m_Move.m_vPosition );

				ret= E3DSetBeforePos(obj->m_nSigID);
				if(ret){
					_ASSERT(0);
				}
				//if( nObjectType == 0 ) {
					ret = E3DSetPosOnGround( obj->m_nSigID, staticData->get_GroundSigID(),
						MAP_HEIGHT, MAP_MIN, 
						sourceObject->m_Move.m_vPosition.x,
						sourceObject->m_Move.m_vPosition.z
						 );
					if(ret){
						_ASSERT(0);
					}
					ret = E3DGetPos( obj->m_nSigID, &obj->m_Move.m_vPosition );
					if(ret){
						_ASSERT(0);
					}
				//}

				ret = E3DSetBeforePos(obj->m_nSigID);
				if(ret){
					_ASSERT(0);
				}

				staticData->face( sourceObject->m_Move.m_vVelocity,
					1, obj->m_nSigID, obj->m_Move.m_nQuoatanion ) ;
				
				obj->m_Game.m_nScenarioIndex = sourceObject->m_Game.m_nScenarioIndex;
			} else {
				_ASSERT(0);
			}

			// 폜
			it = objList.erase(it);
		}
	} else {

		// _ݒuXe[W
		if( staticData->m_nScenarioIndex == MissionType::TEST_MOSUKO ) {
			staticData->m_EnemyManager.createObjects( EnemyType::MOSUKO, MOSUKO_MAX );
			staticData->m_EnemyManager.createObjects( EnemyType::MOSUKO_LONG, MOSUKO_MAX );

		} else if( staticData->m_nScenarioIndex == MissionType::TEST_HOVER ) {
			staticData->m_EnemyManager.createObjects( EnemyType::HOVER, HOVER_MAX);

		} else {
			// Zbg
			this->resetSpawnerDatas();
			this->m_EnemySpawner.clear();
			if( staticData->m_nScenarioIndex == MissionType::CHALLENGE ) {

				// X|[i[ݒ
				this->m_aryEnemySpawnerDatas[EnemyType::WORM_BIG].m_nRate	= 1;
				this->m_aryEnemySpawnerDatas[EnemyType::CYCLOPS].m_nRate	= 5;
				this->m_aryEnemySpawnerDatas[EnemyType::WORM_SMALL].m_nRate	= 10;
				this->m_aryEnemySpawnerDatas[EnemyType::ZOMBIE].m_nRate	= 20;
				this->m_aryEnemySpawnerDatas[EnemyType::MOSUKO].m_nRate	= 5;
				this->m_aryEnemySpawnerDatas[EnemyType::MOSUKO_LONG].m_nRate	= 5;
				this->m_aryEnemySpawnerDatas[EnemyType::ZOMBIE_B].m_nRate	= 10;
				this->m_aryEnemySpawnerDatas[EnemyType::HOVER].m_nRate	= 10;
				this->m_aryEnemySpawnerDatas[EnemyType::ARACHNE].m_nRate	= 3;


			} else if( staticData->m_nScenarioIndex == MissionType::STARSHIP_TROOPER ) {
				// jׂG̐
				this->m_nTotalSpawnEnemyNum = STARSHIP_TROOPER_MAX_ENEMY_NUM;

				// ׂG̐ic萔j
				this->m_nRemainEnemyNum = STARSHIP_TROOPER_MAX_ENEMY_NUM;

				// X|[i[ݒ
				this->m_aryEnemySpawnerDatas[EnemyType::WORM_BIG].m_nRate	= 1;
				this->m_aryEnemySpawnerDatas[EnemyType::CYCLOPS].m_nRate	= 5;
				this->m_aryEnemySpawnerDatas[EnemyType::WORM_SMALL].m_nRate	= 10;
				this->m_aryEnemySpawnerDatas[EnemyType::ZOMBIE].m_nRate	= 20;
				this->m_aryEnemySpawnerDatas[EnemyType::ZOMBIE_B].m_nRate	= 10;
				this->m_aryEnemySpawnerDatas[EnemyType::HOVER].m_nRate	= 10;
				this->m_aryEnemySpawnerDatas[EnemyType::ARACHNE].m_nRate	= 3;

			}
			int num = 5;
			for( int i = 0; i < EnemyType::NUM_MAX; i ++ ) {
				if( this->m_aryEnemySpawnerDatas[i].m_nRate > 0 ) {
					// o^
					GSpawnItem item;
					item.m_nEnemyType = i;
					item.m_nRate = this->m_aryEnemySpawnerDatas[i].m_nRate;
					this->m_EnemySpawner.add( item );

					// numȏݒuȂAnumpӁB
					// numȉݒuȂ^CvȂA\ʂ̐ݒu
					staticData->m_EnemyManager.createObjects(
						i, 
						num < this->m_aryEnemySpawnerDatas[i].m_nMax ? num : this->m_aryEnemySpawnerDatas[i].m_nMax);
				}
			}
		}
	}

	// ViIZbg
	staticData->m_ScenarioManager.reset();
	staticData->m_ScenarioItem = NULL;

	// jZbg
	staticData->nKilledEnemyNumber = 0;
}
void GameScene::process() {
	int ret = 0;

	// LN^[̈ړ
	ret = this->frameMove();
	if( ret ){
		_ASSERT( 0 );
		return ;
	}

	// `擙
	ret = this->render();
	if( ret ){
		_ASSERT( 0 );
		return ;
	}

}
void GameScene::quit() {
}
/** eLXg\
  * @retval 0
  */
int GameScene::drawText() {
	int ret = 0;

	float zoom = 1.0f;

	int y = 10;
	int STEP = 20;

	vector<string> lines;
	
	lines.push_back( TextTool::get_String( "FPS:%d", staticData->get_FPS() ) );

	// ݂̃t[No擾
	int motid;
	int frameno;
	ret = E3DGetMotionFrameNo( staticData->get_Player()->m_nSigID, &motid, &frameno );


	////////////////////
	// vC[̈ʒu
	D3DXVECTOR3 vCameraPosition;
	D3DXVECTOR3 vPlayerPosition;
	//D3DXVECTOR3 vSatellite;

	E3DGetCameraPos( &vCameraPosition );
	E3DGetPos( staticData->get_Player()->m_nSigID, &vPlayerPosition );

	// @
	// vC[
	lines.push_back( TextTool::get_String( "T:Change player,1-6:Remove cloth,F2:Back to Title,F4:Quit,7:TestMotion" ) );
	lines.push_back( TextTool::get_String( "PlayerPos[%5.2f,%5.2f,%5.2f]",
		vPlayerPosition.x, vPlayerPosition.y, vPlayerPosition.z ));

/*	lines.push_back( TextTool::get_String( "Mosuko num[%d]",
		staticData->m_EnemyManager.get_ValidNum(EnemyType::MOSUKO)+
		staticData->m_EnemyManager.get_ValidNum(EnemyType::MOSUKO_LONG)));
*/
	// j
	lines.push_back( TextTool::get_String( "Killed Enemy Count[%d]",
		staticData->nKilledEnemyNumber ) );


	lines.push_back( TextTool::get_String( "EventNumber[%d,%d], TestMotionIndex[%d]",
		staticData->get_Player()->m_nEventNumber, staticData->get_Player()->m_nUnderEventNumber,
		staticData->m_nTestMotionIndex) );

	if( staticData->get_Player()->m_Game.m_fHP == 0 ) {
		lines.push_back( std::string("") );
		lines.push_back( TextTool::get_String( "You are dead.  Click left mouse button..." ) );
	}
	for(int i = 0; i < static_cast<int>(lines.size()); i ++ ) {
		int r = 255;
		int g = 255;
		int b = 255;

		if( i >= 5 && i == static_cast<int>( lines.size() - 1 ) ) {
			g = 0;
			b = 0;
		}
		ret = E3DTool::drawText(
			10, y,			//pos XY
			r, g, b, 255,	//col RGBA
			zoom,				// zoom
			lines[i].c_str() );
		if( ret ) {
			_ASSERT( 0 );
			return ret;
		}
		y += STEP;
	}



	// \̈̃EBhETCY
	RECT rClientRect;
	staticData->get_ClientRect( &rClientRect );
	int nClientHeight = rClientRect.bottom - rClientRect.top;
	int nClientWidth = rClientRect.right - rClientRect.left;

	if( staticData->m_bNearByConsole ) {
		// R\[ɋ߂Â[F]L[悤\
		ret = E3DTool::drawTextWithFont(
			nClientWidth / 2 - 20, nClientHeight / 3 * 2,			//pos XY
			255, 255, 200, 255,	//col RGBA
			staticData->get_SwapChainID(), staticData->get_FontID(),				// zoom
			"[F]" );
		if( ret ) {
			_ASSERT( 0 );
			return ret;
		}
	}

	return 0;

}


/** 3D_O
  * @retval 0ȊO Ɏsꍇ
  */
int GameScene::render() {
	int ret = 0;


	int nCurrentFrame = 0;
	int status;
	int counter = 0;


	/////////////////////////////
	// test
	// \
/*	if(staticData->get_CurrentKeyBuffer(VK_UP)){
		staticData->m_nRenderNum += 1;
		if(staticData->m_nRenderNum >= OBJECT_MAX ) {
			staticData->m_nRenderNum = OBJECT_MAX;
		}
	}
	if(staticData->get_CurrentKeyBuffer(VK_DOWN)){
		staticData->m_nRenderNum -= 1;
		if(staticData->m_nRenderNum < 0 ) {
			staticData->m_nRenderNum = 0;
		}
	}*/

	// nʂ̃`FbNC
	ret = staticData->checkInGround();
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}

	/////////////////////////////////////////
	// vC[֘A
	// `FbNC
	ret = E3DChkInView( staticData->get_SwapChainID(), staticData->get_Player()->m_nSigID, &status );
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}

	if( staticData->is_Pause() == FALSE ) {
		// nʂƂ̐ڐG
		ret = staticData->checkPlayerOnGround();
		if( ret ){
			_ASSERT( 0 );
			return 1;
		}
	}

	/////////////////////////////////////////
	// r`FbNC
/*	ret = E3DChkInView( staticData->get_SwapChainID(), staticData->m_Building->m_nSigID,
		&status );
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}*/

	////////////////////
	// et`
	staticData->renderWithShadow( TRUE, TRUE, FALSE, FALSE );

	/////////////////////////////////////////
	// V[`Jn
	ret = E3DBeginScene( staticData->get_SwapChainID(), 1 );//skipflag1iNAȂjɂ邱
	if( ret ) { 
		_ASSERT( 0 );
		return 1;
	}

		if( staticData->m_nSelectedWallType >= 0 ) {
			// ǂƓV`
			// sig id擾
			int hsid = staticData->m_mapWallSigMap[staticData->m_nSelectedWallType];

			// ʏ`
			if( E3DRender( staticData->get_SwapChainID(), hsid, 0, 1, 0, 0 ) ){
				_ASSERT( 0 );
				return 1;
			}

			// uh`
			if( E3DRender( staticData->get_SwapChainID(), hsid, 1, 1, 0, 0 ) ){
				_ASSERT( 0 );
				return 1;
			}
		}
		////////////////
		// r`
//		ret = E3DRender( staticData->get_SwapChainID(), staticData->m_Building->m_nSigID, 
//			0,1,0,0);

		///////////////
		// Sr{[h`
		ret = E3DRenderBillboard( staticData->get_SwapChainID(), 0 );
		if( ret ) {
			_ASSERT( 0 );
			return ret;
		}

		//////////////
		// G̈ړƕ`
		ret = staticData->m_EnemyManager.process();

		////////////////
		// e̓ƕ`
		ret = staticData->m_ShotManager.process();

		////////////////
		// ̂̓ƕ`
		staticData->m_bNearByConsole = FALSE;
		ret = staticData->m_NeutralManager.process();

		/////////////////
		// UI\
		ret = E3DBeginSprite();
			RECT rClientRect;
			staticData->get_ClientRect( &rClientRect );
			int nClientHeight = rClientRect.bottom - rClientRect.top;
			int nClientWidth = rClientRect.right - rClientRect.left;

			if( staticData->get_CameraMode() != CameraMode::AT_TARGET_MODE ) {
				// GTAʏ탂[hȊO

				POINT pCenter;
				staticData->get_ClientCenter( &pCenter );

				// Ə\
				int nSpriteW = -1;
				int nSpriteH = -1;
				ret = E3DGetSpriteSize( staticData->m_SpriteIndexManager.get( Sprite::CROSS_HAIR ), 
					&nSpriteW, &nSpriteH );
				if( ret ) {
					_ASSERT( 0 );
					return ret;
				}
				const float CROSS_HAIR_DELTA = 10.f;
				ret = E3DRenderSprite( staticData->m_SpriteIndexManager.get( Sprite::CROSS_HAIR),
					1, 1, D3DXVECTOR3(static_cast<FLOAT>(pCenter.x - nSpriteW / 2 + CROSS_HAIR_DELTA ),
					static_cast<FLOAT>(pCenter.y - nSpriteH / 2 + CROSS_HAIR_DELTA), 0.0f ) );
				if( ret ) {
					_ASSERT( 0 );
					return ret;
				}
			}

			// Life Frame
			int nLifeFrameWidth = -1;
			int nLifeFrameHeight = -1;
			ret = E3DGetSpriteSize( staticData->m_SpriteIndexManager.get( Sprite::LIFE_FRAME), 
				&nLifeFrameWidth, &nLifeFrameHeight );
			if( ret ) {
				_ASSERT( 0 );
				return ret;
			}
			ret = E3DRenderSprite( staticData->m_SpriteIndexManager.get( Sprite::LIFE_FRAME),
				1.f, 1.f, D3DXVECTOR3(
				static_cast<FLOAT>(LIFE_FRAME_MERGINE),
				static_cast<FLOAT>(nClientHeight - LIFE_FRAME_MERGINE - nLifeFrameHeight - WINDOW_FRAME_DELTA), 0.0f ) );
			if( ret ) {
				_ASSERT( 0 );
				return ret;
			}

			// Life
			float fLifeRate = staticData->get_Player()->m_Game.m_fHP / staticData->get_Player()->m_Game.m_fHPMax;
			int nSpriteW = -1;
			int nSpriteH = -1;
			ret = E3DGetSpriteSize( staticData->m_SpriteIndexManager.get( Sprite::LIFE_BAR), 
				&nSpriteW, &nSpriteH );
			if( ret ) {
				_ASSERT( 0 );
				return ret;
			}
			ret = E3DRenderSprite( staticData->m_SpriteIndexManager.get( Sprite::LIFE_BAR),
				1, fLifeRate, D3DXVECTOR3(
				static_cast<float>(LIFE_FRAME_MERGINE),
				static_cast<float>(nClientHeight - LIFE_FRAME_MERGINE - static_cast<float>(nSpriteH) * fLifeRate - WINDOW_FRAME_DELTA ), 0.0f ) );
			if( ret ) {
				_ASSERT( 0 );
				return ret;
			}

			// Guns
			int nGunWidth = -1;
			int nGunHeight = -1;
			int nSpriteID = staticData->get_Weapon()->get_SpriteID();
			ret = E3DGetSpriteSize( nSpriteID, 
				&nGunWidth, &nGunHeight );
			if( ret ) {
				_ASSERT( 0 );
				return ret;
			}
			ret = E3DRenderSprite( nSpriteID,
				1, 1, D3DXVECTOR3(
				static_cast<FLOAT>(LIFE_FRAME_MERGINE + nLifeFrameWidth + LIFE_AND_GUNS_MERGINE ),
				static_cast<FLOAT>(nClientHeight - LIFE_FRAME_MERGINE - nGunHeight - WINDOW_FRAME_DELTA ), 0.1f ) );
			if( ret ) {
				_ASSERT( 0 );
				return ret;
			}

			// G̗͕̑\
			ret = E3DGetSpriteSize( staticData->m_SpriteIndexManager.get( Sprite::ENEMY_LIFE_BAR ),
				&nSpriteW, &nSpriteH );
			counter = 0;
			for(std::list<EnemyLifeBar*>::iterator it = staticData->m_lstEnemyLifeBarList.begin();
				it != staticData->m_lstEnemyLifeBarList.end(); )
			{
				EnemyLifeBar* lifeBar = *it;

				// o[Lk
				float fRate = lifeBar->m_fHP / lifeBar->m_fHPMax;

				// Cto[\
				ret = E3DRenderSprite( staticData->m_SpriteIndexManager.get( Sprite::ENEMY_LIFE_BAR),
					fRate, 1, D3DXVECTOR3(
					static_cast<FLOAT>(nClientWidth - LIFE_FRAME_MERGINE - static_cast<FLOAT>(nSpriteW) * fRate),
					static_cast<FLOAT>(nClientHeight - LIFE_FRAME_MERGINE - (counter+1) * (nSpriteH + ENEMY_LIFE_BAR_INTERVAL_Y) - TEXT_DELTA_Y  ), 0.0f ) );
				// ̗͐l
				ret = E3DTool::drawText(
					nClientWidth - LIFE_FRAME_MERGINE - nSpriteW - TEXT_DELTA_X, 
					nClientHeight - LIFE_FRAME_MERGINE - (counter+1) * (nSpriteH + ENEMY_LIFE_BAR_INTERVAL_Y )- TEXT_DELTA_Y ,			//pos XY
					200, 200, 255, UI_ALPHA,	//col RGBA
					1.2f,				// zoom
					"%s [%d/%d]",
					lifeBar->m_strName.c_str(), 
					static_cast<int>(lifeBar->m_fHP),
					static_cast<int>(lifeBar->m_fHPMax));
				if( ret ) {
					_ASSERT( 0 );
					return ret;
				}
				counter ++;
				if( lifeBar->m_Counter.step() & General::CounterStateType::ALL_LOOP_END ) {
					// 
					it = staticData->m_lstEnemyLifeBarList.erase(it );
					delete lifeBar;
				} else {
					it ++;
				}
			}

			// e
			ret = E3DTool::drawText(
				LIFE_FRAME_MERGINE + nLifeFrameWidth + LIFE_AND_GUNS_MERGINE, 
				nClientHeight - LIFE_FRAME_MERGINE - nGunHeight - AMMO_TEXT_MERGINE,			//pos XY
				200, 200, 255, UI_ALPHA,	//col RGBA
				0.5f,				// zoom
				"[%d/%d]",
				staticData->get_Weapon()->get_LoadedAmmo(), staticData->get_Weapon()->get_ChargedAmmo());
			if( ret ) {
				_ASSERT( 0 );
				return ret;
			}

			// `
			if( this->drawText()) {
				_ASSERT( 0 );
				return 1;
			}

			// ViI\
			staticData->draw_Scenario( staticData->m_ScenarioItem );

		ret = E3DEndSprite();


		
		staticData->afterRenderCommon();
	if( E3DEndScene() ) {
		_ASSERT( 0 );
		return 1;

	}

	return 0;
}


int GameScene::frameMove() {
	int ret = 0;

	if( staticData->is_Pause() == FALSE ) {
		////////////////////////
		// vC[
		// vC[WASDړ
		staticData->movePlayer();

		//
		////////////////////  vC[ end
		/////////////////////
		// vC[̒e̔
		staticData->shotPlayer();


		// [VXV
		ret = staticData->updatePlayerMotion();

		if( staticData->m_nScenarioIndex == MissionType::TEST_PHOBOKO ) {
			// do nothing
		} else if( isPlaceStage( staticData->m_nScenarioIndex ) ) {
			// zuꏊwXe[W
			// do nothing
		} else {
			// _zuXe[W
			bool bIsSkip = false;

			if( staticData->m_nScenarioIndex == MissionType::CHALLENGE ) {
				// do nothing
			} else {
				// `WXe[WȊO
				if( staticData->nKilledEnemyNumber >= this->m_nTotalSpawnEnemyNum ) {
					// j萔𒴂
					// NAI

					// bZ[W\

					// NAZt
					if( staticData->m_ScenarioItem == NULL || staticData->m_nScenarioListID != 10) {
						// Zbg
						staticData->m_ScenarioManager.reset();

						staticData->m_nScenarioListID = 10;
						staticData->m_ScenarioItem = staticData->m_ScenarioManager.get( staticData->m_nScenarioListID )->next();
						// NbNŖ߂
					}
	
					bIsSkip = true;
				}
				if( this->m_nRemainEnemyNum <= 0 ) {
					// I
					bIsSkip = true;
				}
			}
			if( bIsSkip == false ) {
				if((staticData->m_cntEnemyGenerateCounter.step() & CounterStateType::ALL_LOOP_END) == CounterStateType::ALL_LOOP_END ) {
					// G̐ԂɂȂ
					// G̐
					int nType = 0;
					if( staticData->m_nScenarioIndex == MissionType::TEST_MOSUKO ) {
						// Xq
						nType = EnemyType::MOSUKO + MathTool::nextRandom<int>(0,2);

					} else if( staticData->m_nScenarioIndex == MissionType::TEST_HOVER ) {
						// V
						nType = EnemyType::HOVER;
					} else if( staticData->m_nScenarioIndex == MissionType::CHALLENGE ||
						staticData->m_nScenarioIndex == MissionType::STARSHIP_TROOPER)
					{
						// ^CvI
						nType = this->m_EnemySpawner.next()->m_nEnemyType;

					} else {
						_ASSERT(0);
					}

					// oꂳ
					E3DObject* obj = staticData->m_EnemyManager.search( nType );

					// Ԋu
					int nFrameNumMax = 
						static_cast<int>(
						staticData->m_cntEnemyGenerateCounter.get_FrameCounterMax() - 
						GENERATE_DECREASE_STEP );
					if( nFrameNumMax < 1 ) {
						nFrameNumMax = 1;
					}

					if( obj != NULL ) {
						// 

						// xAbv
						obj->m_Move.m_fSpeed *= (1.1f + 0.1f * static_cast<float>(DEFAULT_GENERATE_COUNTER - nFrameNumMax + 1) / static_cast<float>(DEFAULT_GENERATE_COUNTER));// 

						if( staticData->m_nScenarioIndex == MissionType::STARSHIP_TROOPER ) {

							// ƉƂɒu
							float ERR = 10000;
							float RADIUS = 60000;

							float fDegree = MathTool::nextRandom<float>( 0, 360 );
							float fRadius = MathTool::nextRandom<float>( RADIUS - ERR, RADIUS + ERR );

							E3DSetPosOnGround( obj->m_nSigID, staticData->get_GroundSigID(),
								MAP_HEIGHT, MAP_MIN, 
								fRadius * static_cast<float>( cos( D3DXToRadian( fDegree ) ) ),
								fRadius * static_cast<float>( sin( D3DXToRadian( fDegree ) ) ) );
							E3DGetPos( obj->m_nSigID, &obj->m_Move.m_vPosition );
							E3DSetBeforePos( obj->m_nSigID );

							// ŏCÂ
							obj->m_Game.m_bRecognized = TRUE;

							if( staticData->m_nScenarioIndex == MissionType::CHALLENGE ) {
								// do nothing
							} else {
								// ChallengeȊO͌
								this->m_nRemainEnemyNum -- ;
							}
						}
					}


					staticData->m_cntEnemyGenerateCounter.set_FrameCounterMax( nFrameNumMax );
					staticData->m_cntEnemyGenerateCounter.reset();
				}
			}
		}

		staticData->move_BillBoard();

		// eXgFClearSceneֈړ
		if( staticData->get_CurrentKeyBuffer( VK_F3 ) ) {
			staticData->m_SceneManager.set_Scene( SceneType::CLEAR );

		}
	}

	// Jړ
	ret = staticData->moveCamera();
	if( ret ) {
		_ASSERT( 0 );
		return ret;
	}
	return 0;
}



}
