#include "StaticData.h"

#include <fstream>
#include <vector>
#include <string>

#include "GameScene.h"
#include "TitleScene.h"
#include "SelectMissionScene.h"
#include "BriefingScene.h"
#include "EnemyModeScene.h"
#include "GameOverScene.h"
#include "ClearScene.h"
#include "SelectKaisouScene.h"

using namespace HPL;
using namespace E3D;
using namespace General;
using namespace std;

namespace MotionTest {
using namespace MotionTestConsts;
using namespace BasicStaticDataConsts;

static std::ofstream ofs;

const int MAX_PLAYER_MOTION = 55;

int expandMOAArray( E3DObject* obj ) {
	delete obj->m_moaMOAArray;
	obj->m_moaMOAArray = new MOAINFO[MAX_PLAYER_MOTION];
	obj->m_nMOANum = MAX_PLAYER_MOTION;
	return 0;
}

/** vC[ZbgAbv
  *
  */
int StaticData::setupPlayer() {
	int ret;


	// 蔻
	ret = E3DSigLoad( "Media\\model_madogen\\Atari.sig", 
		0, 1.f, &this->m_nAtariSigID );
	if( ret ) {
		_ASSERT(0);
	}

	////////////////////////////
	// [Vf[^
	// MOAt@C[h
	char MOA_PATH_LIST[][MAX_PATH] = {
		"Media\\model_madogen\\motion\\evi.moa",
		"Media\\tanya\\motion\\motion.moa",
		"Media\\model_madogen\\motion\\evi.moa",
		"Media\\model_madogen\\motion\\evi.moa",
		"Media\\model_madogen\\motion\\evi.moa",
	};
	for(int i = 0; i < PlayerType::MAX_NUM; i ++ ) {
		expandMOAArray( &this->m_aryPlayerList[i] );

		this->m_aryPlayerList[i].m_Game.m_nObjectType = ObjectType::PLAYER;
		this->m_aryPlayerList[i].m_Game.m_nType = i;
		if( i == PlayerType::EVIGEN ||
			i == PlayerType::TIGHTS ||
			i == PlayerType::KANRITAN ||
			i == PlayerType::TOZICA)
		{
			int nIndex = 0;

			if( i == PlayerType::TIGHTS ) {
				nIndex = 1;
			} else if( i == PlayerType::KANRITAN ) {
				nIndex = 2;
			} else if( i == PlayerType::TOZICA ) {
				nIndex = 3;
			}

			char SIG_FILE_LIST[][MAX_PATH] = {
				"Media\\model_madogen\\evi2.sig",
				"Media\\model_madogen\\tights.sig",
				"Media\\model_madogen\\kanritan.sig",
				"Media\\model_madogen\\tozica2.sig",
			};


			// Sigt@Cǂݍ
			{
				int n = 0;
				ret = E3DSigLoad( SIG_FILE_LIST[nIndex] , 0, 1.f, &n);
				this->m_aryPlayerList[i].m_nSigID = n;
				this->m_nPlayerType = i;

				//set_Toon(n);

			}

			if( i == 0 ){
				this->m_nCameraTargetSigID = this->get_Player()->m_nSigID;
				if( ret ){
					_ASSERT( 0 );
					return 1;
				}
			}

			// 㔼gAg̃{[No.擾
			ret = E3DGetPartNoByName( this->get_Player()->m_nSigID, "upper", &this->get_Player()->m_nUpperBoneNumber );
			if( ret ){
				_ASSERT( 0 );
				return 1;
			}
			ret = E3DGetPartNoByName( this->get_Player()->m_nSigID, "under", &this->get_Player()->m_nUnderBoneNumber );
			if( ret ){
				_ASSERT( 0 );
				return 1;
			}
			/*ret = E3DGetPartNoByName( this->get_Player()->m_nSigID, "TopOftrunk", &this->get_Player()->m_nWeaponBoneNumber );
			if( ret ){
				_ASSERT( 0 );
				return 1;
			}
			ret = E3DGetPartNoByName( this->get_Player()->m_nSigID, "TopOftrunk_handgun", &this->get_Player()->m_nWeaponBoneNumber2 );
			if( ret ){
				_ASSERT( 0 );
				return 1;
			}*/

			ret = E3DGetPartNoByName( this->get_Player()->m_nSigID, "TopOfbase", &this->get_Player()->m_nBaseBoneNumber );
			if( ret ){
				_ASSERT( 0 );
				return 1;
			}

			ofs << "т񃂃fǂݍ݊" << std::endl;

		} else if( i == PlayerType::TANYA ) {
			// ^[j
			int n;
			//ret = E3DSigLoad( "Media\\tanya\\tanya.sig",0,1.f,&n);
			ret = E3DSigLoad( "Media\\tanya\\tanya.sig",0,1.f,&n);
			this->m_aryPlayerList[PlayerType::TANYA].m_nSigID = n;
			if( ret ) {
				_ASSERT(0);
			}
			//set_Toon(n);

			// 㔼gAg̃{[No.擾
			ret = E3DGetPartNoByName( this->m_aryPlayerList[PlayerType::TANYA].m_nSigID, "upper", &this->m_aryPlayerList[PlayerType::TANYA].m_nUpperBoneNumber );
			if( ret ){
				_ASSERT( 0 );
				return 1;
			}
			ret = E3DGetPartNoByName( this->m_aryPlayerList[PlayerType::TANYA].m_nSigID, "under", &this->m_aryPlayerList[PlayerType::TANYA].m_nUnderBoneNumber );
			if( ret ){
				_ASSERT( 0 );
				return 1;
			}
			ofs << "^[jfǂݍ݊" << std::endl;
		} else {
			_ASSERT(0);
		}


		// VF[_
		//ret = E3DSetShaderType( m_aryPlayerList[i].m_nSigID, COL_MQCLASSIC);// COL_SCHLICK);//COL_PHONG);

		ret = this->loadMOAFile( MOA_PATH_LIST[i], 
			&m_aryPlayerList[i], PLAYER_MOTION_MULTIPLE );
		if( ret ){
			_ASSERT( 0 );
			return 1;
		}
		/*
		ret = E3DLoadMOAFile( m_aryPlayerList[i].m_nSigID , MOA_PATH_LIST[i],
			MOA_FILL_UP_LENGTH, 1.f);
		if( ret ){
			_ASSERT( 0 );
			return 1;
		}

		{
			int nNumberOfMotion = 0;
			ret = E3DGetMoaInfo( m_aryPlayerList[i].m_nSigID, MAX_MOTION,
				m_aryPlayerList[i].m_moaMOAArray , &nNumberOfMotion);
			if( ret ){
				_ASSERT( 0 );
				return 1;
			}
		}*/

		/////////////////////////////////


		// NH[^jI쐬
		ret = E3DCreateQ(&this->m_aryPlayerList[i].m_Move.m_nQuoatanion);

		// ]
		if( E3DRotateY( m_aryPlayerList[i].m_nSigID, 180.f ) ) {
			_ASSERT( 0 );
			return 1;
		}


	}
	return 0;
}

/** 񂾂{V[
  * @retval 0
  */
int StaticData::oneTimeSceneInit() {
	int ret;

	// o
	ofs.open("test.txt");

	ofs << "X^[g" << std::endl;

	///////////////////////////////////////
	// Jʒu
	// 
	//this->set_CameraDistance( 4000.f );

	// 
	//this->set_CameraHeight( 1000.f);

	// ov}bsOL
	//ret = E3DEnableBumpMap( TRUE );
	

//	D3DXVECTOR3 up( 0.f, 1.f, 0.f );
//	D3DXVECTOR3 cross;
//	D3DXVec3Cross( &cross, &diff, &up );
//	D3DXVec3Normalize( &cross, &cross );

	/*ret = E3DSetCameraDeg( 180.0f, 0.0f );
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}*/

	// vWFNVݒ
	ret = E3DSetProjection( 100, 500000.0f, 60.0f );
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}

	// [fBO摜ǂݍ
	/*{
		int spid = 0;
		ret = E3DCreateSprite( "Media\\Sprite\\Loading.png", 1, NULL, &spid );
		if( ret ){
			_ASSERT(0);
			return 1;
		}

		this->m_SpriteIndexManager.set( Sprite::LOADING_SCREEN, spid);
	}*/

	// wi
	//ret = E3DCreateBG( this->get_SwapChainID(), "Media\\Sprite\\Loading.png", "hoge", 0, 0, 0, 10000 );
//		ret = E3DCreateSprite( SPRITE_PATH_LIST[i], 1, NULL, &spid );

//#define BACKGROUND_LOADING 1
#ifdef BACKGROUND_LOADING
	char LOADING_PATH[][MAX_PATH] = {
		"Media\\Sprite\\loading001.png",
		"Media\\Sprite\\loading002.png",
	};
#else
	char LOADING_PATH[][MAX_PATH] = {
		"Media\\Sprite\\loading001a.png",
		"Media\\Sprite\\loading002a.png",
		"Media\\Sprite\\evigensan-sq2.png",
	};
#endif

	// NCAg̈̃TCY擾
	RECT rClientRect;
	this->get_ClientRect( &rClientRect );
	int nClientHeight = rClientRect.bottom - rClientRect.top;
	int nClientWidth = rClientRect.right - rClientRect.left;

	int nTitleImageIndex = 2;
	float fTitleRndRate = MathTool::nextRandom<float>(0,100);
	if( fTitleRndRate < 5 ) {
		nTitleImageIndex = 0;
	} else if( fTitleRndRate < 10 ) {
		nTitleImageIndex = 1;
	}

#ifdef BACKGROUND_LOADING
	ret = E3DCreateBG( this->get_SwapChainID(),
		LOADING_PATH[nTitleImageIndex], "hoge", 0, 0, 0, 10000 );
		E3DBeginScene( this->get_SwapChainID(), 0);
#else
		E3DBeginScene( this->get_SwapChainID(), 0);

	{
		int spid = 0;
		ret = E3DCreateSprite( LOADING_PATH[nTitleImageIndex], 0, NULL, &spid);
		if(ret){
			_ASSERT(0);
		}
		float fHeightMax = 768;
		if( nTitleImageIndex == 2 ) {
			fHeightMax = 768;
		}
		// [fBO摜\
			E3DBeginSprite();
				{
					int nSpriteW;
					int nSpriteH;
					ret = E3DGetSpriteSize( spid, 
						&nSpriteW, &nSpriteH );

					float fRateX = static_cast<float>(nClientWidth) / static_cast<float>(nSpriteW);
					float fRateY = static_cast<float>(nClientHeight) / fHeightMax;

					ret = E3DRenderSprite( spid,
						fRateX, fRateY, D3DXVECTOR3(0.f,
						0.f, 0.0f ) );
				}
			E3DEndSprite();
			ret = E3DTool::drawText(
				nClientWidth - 200, nClientHeight - 50,
				255,255,0, 255,	//col RGBA
				1.f,				// zoom
				"Loading..." );
			if( ret ) {
				_ASSERT( 0 );
				return ret;
			}
	}
#endif
		E3DEndScene();
	E3DPresent( this->get_SwapChainID() );

	ofs << "wi`抮" << std::endl;

	/////////////////////////////
	// vC[LN^[
	ret = this->setupPlayer();
	if( ret ){
		_ASSERT(0);
		return ret;
	}
	ofs << "vC[ZbgAbv" << std::endl;

	// \ȃp[cXg
	char czDestroyablePartName[][100] = {
		"cloth",
		"apron",
		"bra",
		"pants",
		"garter",
	};
	for(int i = 0; i < Parts::MAX_NUM; i ++ ) {
		int nPartNo = 0;
		ret = E3DGetPartNoByName( this->m_aryPlayerList[PlayerType::EVIGEN].m_nSigID,
			czDestroyablePartName[i], &nPartNo );
		if( ret ) {
			_ASSERT(0);
		}
		this->m_aryPartsIndexList[i] = nPartNo;
		this->m_aryPartsValidList[i] = TRUE;
	}
	char czTanyaDestroyablePartName[][100] = {
		"white",
		"wear",
		"bottom",
	};
	for(int i = 0; i < TanyaParts::MAX_NUM; i ++ ) {
		int nPartNo = 0;
		ret = E3DGetPartNoByName( this->m_aryPlayerList[PlayerType::TANYA].m_nSigID,
			czTanyaDestroyablePartName[i], &nPartNo );
		if( ret ) {
			_ASSERT(0);
		}
		this->m_aryTanyaPartsIndexList[i] = nPartNo;
		this->m_aryTanyaPartsValidList[i] = TRUE;
	}
	ofs << "p[c擾" << std::endl;

	/////
	// \
	this->m_nPlayerMaterialIndex = 0;
	// ^[j̍
	this->m_nTanyaBodyMaterialIndex = 0;
	char lpczMaterialPaths[][MAX_PATH] = {
		"Media\\model_madogen\\face.tga",
		"Media\\model_madogen\\shoot.png",
		"Media\\model_madogen\\damage.png",
		"Media\\model_madogen\\damage_crash.png",
		"Media\\model_madogen\\down.png",
		"Media\\model_madogen\\cloth.tga",
		"Media\\model_madogen\\cloth2.tga",//cloth2
		"Media\\model_madogen\\cloth-evi-beto.png",//cloth2
		"Media\\model_madogen\\body.tga",
		"Media\\model_madogen\\body_damage.tga",
		"Media\\model_madogen\\body_ami.tga",//black.tga",
		"Media\\model_madogen\\body_damage_ami.tga",//black.tga",
		"Media\\model_madogen\\under.tga",
		"Media\\model_madogen\\under_black.tga",
		"Media\\js2\\kami1.png",
		"Media\\js2\\kami2.png",
		"Media\\js2\\kao1.png",
		"Media\\js2\\kao2.png",
		"Media\\js2\\kao3.png",
		"Media\\js2\\kao4.png",
		"Media\\js2\\kao5.png",
		"Media\\js2\\karada1.png",
		"Media\\js2\\karada2.png",
		"Media\\js2\\karada3.png",
		"Media\\js2\\karada4.png",
		"Media\\tanya\\o[̂悤Ȃ.png",
		"Media\\tanya\\white.png",
		"Media\\tanya\\hear_Ta.png",
		"Media\\tanya\\face_Ta.png",
		"Media\\tanya\\cloth_Ta.png",
		"Media\\tanya\\body_Ta.png",
		"Media\\tanya\\o[̂悤Ȃ2.png",
		"Media\\tanya\\white2.png",
		"Media\\tanya\\hear_Ta2.png",
		"Media\\tanya\\face_Ta2.png",
		"Media\\tanya\\cloth_Ta2.png",
		"Media\\tanya\\body_Ta2.png",
		"Media\\tanya\\body_Ta_Naked.png",
		"Media\\tanya\\body_Ta_Naked2.png",
		"Media\\Enemy\\Hover\\Hover.png",
		"Media\\Enemy\\Hover\\sak.png",
	};

	int nTextureLoadTo = D3DPOOL_DEFAULT;
	int nTextureLoadToSetting = GetPrivateProfileInt(_T("Evigen"),
		_T("TextureLoadTo"), 0, OPTION_INI_FILE_PATH );

	if( nTextureLoadToSetting == 1 ) {
		nTextureLoadTo = D3DPOOL_MANAGED;
		ofs << "@eNX`DirectX}l[ẄɃ[h" << std::endl;
	} else if( nTextureLoadToSetting == 2 ) {
		nTextureLoadTo = D3DPOOL_SYSTEMMEM;
		ofs << "@eNX`VXeɃ[h" << std::endl;
	} else {
		ofs << "@eNX`ftHg̈iVRAMjɃ[h" << std::endl;
		if( nTextureLoadTo != 0 ) {
			ofs << "W:sȐݒԍ TextureLoadTo=" << TextTool::get_String("[%d]", nTextureLoadTo ) << std::endl;
		}
	}

	for(int i = 0; i < Material::MAX_NUM; i ++ ) {
		int matid;
		ret = E3DCreateTexture( lpczMaterialPaths[i], nTextureLoadTo, 0, &matid );
		if( ret ) {
			_ASSERT( 0 );
			return ret;
		}
		ofs << TextTool::get_String( "@@eNX`[index = %d, materialID = %d, Path=%s][hI",
			i, matid, lpczMaterialPaths[i] ) << std::endl;
		this->m_aryMaterials[i] = matid;
	}
	ofs << "eNX`ǂݍ݊" << std::endl;

	m_nClothBreak = 0;
	m_fClothAlpha = 1;
	m_fUnderAlpha = 1;
	m_fApronAlpha = 1;
	m_fClothUnderAlpha = 1;
	m_fApronUnderAlpha = 1;
	m_fKatyuAlpha = 1;

	m_nUnderColor = 0;


	
	//m_nUnderR = 255;
	//m_nUnderG = 255;
	//m_nUnderB = 255;

	/////
	// eeNX`쐬
	{
		this->m_szShadowTextureSize.cx = 1024;
		this->m_szShadowTextureSize.cy = 1024;

		ret = this->tryToCreateTexture( D3DFMT_A8R8G8B8,// A8R8G8B8,//D3DFMT_A16B16G16R16F,
			&this->m_szShadowTextureSize );

		if( ret ) {
	/*		this->m_szShadowTextureSize.cx = 16;
			this->m_szShadowTextureSize.cy = 16;
			ret = this->tryToCreateTexture (D3DFMT_A8R8G8B8,
				&this->m_szShadowTextureSize );
			if( ret ) {*/
				// s
				_ASSERT( 0 );
				return 1;
			//}
		}
		// VhE}bveNX`\邽߂̃XvCg쐬
		int nTransparentFlag = 0;	// ߃tO
		ret = E3DCreateSprite( "Media\\dummy512.bmp", nTransparentFlag, NULL, &this->m_nShadowSpriteID );

		// TCY擾
		int nShadowSpriteWidth = 0;
		int nShadowSpriteHeight = 0;
		ret = E3DGetSpriteSize( this->m_nShadowSpriteID, &nShadowSpriteWidth, &nShadowSpriteHeight );

		// eNX`̃XvCgɃ}bsO
		ret = E3DSetTextureToDispObj( -2, this->m_nShadowSpriteID,
			this->m_nShadowTextureID );

		// oCAXiǂꂾ邩j
		ret = E3DSetShadowBias ( 0.005f );

		// Â
		ret = E3DSetShadowDarkness( 1.0f );

		// š
		this->m_vLightDirection = D3DXVECTOR3( -0.5f, -1.0f, 1.0f );

		ret = E3DSetShadowMapLightDir( this->m_vLightDirection );

	}
	ofs << "AeNX`쐬" << std::endl;

	
	/////////////////////////////////////////////////////////////////////////////////
	// G}X^f[^ǂݍ
	this->m_EnemyManager.setupAllMaster();

	// ʂŎgp郂f̂ݓǂݍ
	// ̓[hɓǂݍ
	this->m_EnemyManager.createObjects( EnemyType::ZOMBIE_A, 1 );
	this->m_EnemyManager.createObjects( EnemyType::TROL, 1);
	this->m_EnemyManager.createObjects( EnemyType::ROPER, 1 );
	
	
	ofs << "Gfǂݍ݊" << std::endl;

	// pJE^
	this->m_cntEnemyGenerateCounter.set_FrameCounterMax( DEFAULT_GENERATE_COUNTER );
	this->m_cntEnemyGenerateCounter.set_LoopNumMax( 1 );

	
	
	////////////////////////////////////
	// ef
	// Bullet
	ret = this->m_ShotManager.createObjects( ShotType::BULLET,
		SHOT_MAX );

	// ~TC
	ret = this->m_ShotManager.createObjects( ShotType::MISSILE,
		MISSILE_MAX );

	// ~TC
	ret = this->m_ShotManager.createObjects( ShotType::BAKUFU,
		BAKUFU_MAX );

	ofs << "eǂݍ݊" << std::endl;

	////////////////////
	// VF
	ret = this->m_NeutralManager.createObjects( NeutralType::SHELL,
		SHELL_MAX );
	// _jX
	ret = this->m_NeutralManager.createObjects( NeutralType::DANIMOTH,
		1 );
	// ѓ
	ret = this->m_NeutralManager.createObjects( NeutralType::HEAD,
		1 );
	// fBLbg
	ret = this->m_NeutralManager.createObjects( NeutralType::MEDI_KIT,
		MEDI_KIT_NUM );
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}
	// eiAmmoj
	ret = this->m_NeutralManager.createObjects( NeutralType::AMMO,
		AMMO_NUM );
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}
	// Ƃ
	ret = this->m_NeutralManager.createObjects( NeutralType::MEAT,
		MEAT_NUM );
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}
	// 
	ret = this->m_NeutralManager.createObjects( NeutralType::HAND_GUN,
		1 );
	ret = this->m_NeutralManager.createObjects( NeutralType::MINI_GUN,
		1 );
	ret = this->m_NeutralManager.createObjects( NeutralType::CONSOLE,
		CONSOLE_NUM );
	ofs << "Neutralǂݍ݊" << std::endl;

	///////////////////////
	// BillBoard
	for( int i = 0; i < BLOOD_MAX; i ++ ) {
		int nTransparentFlag = 0;	// t@C̃lœFݒ
		int dirMode = 1;			// ɉʂ̕
		int nCenterFlag = 1;		// 摜̒SdS
		int nBillBoardID = 0;

		int bbid= 0;
		ret = E3DCreateBillboard( "Media\\model_madogen\\blood.png", //Animation.gif",//
			BLOOD_SIZE, BLOOD_SIZE, nTransparentFlag, dirMode, nCenterFlag,
			&bbid );
		if(ret ) {
			_ASSERT(0);
			return 1;
		}
		// uh[h
		// 0:[h
		// 1:Add[h
		ret = E3DSetBlendingMode( -1, bbid, 0 );

		// _Oݒ
		// Cg̉e󂯂Ȃ
		ret = E3DSetRenderState( -1, bbid, D3DRS_LIGHTING, 0 );

		// }l[W֓o^
		E3DBillBoard* billBoard = this->m_BloodBillBoardManager.setup_BillBoard(
			bbid );
	}
	ofs << "BillBoardǂݍ݊" << std::endl;


	///////
	// nʃfǂݍ
	int nAdjestUVFlag = 0;
	int nSigID;

	vector<string> vecGroundFilePathList;
	TextTool::load_StringLinesFromFile( "Media/Stage/ground.txt", &vecGroundFilePathList );
	if( static_cast<int>(vecGroundFilePathList.size()) != GroundType::MAX_NUM ) {
		_ASSERT(0);
	}

	float GROUND_MODEL_RATE = 200.f;

	for(int i = 0; i < GroundType::MAX_NUM; i ++ ) {
		ret = E3DLoadMQOFileAsGround( vecGroundFilePathList[i].c_str(), 
			GROUND_MODEL_RATE, nAdjestUVFlag, BONETYPE_RDB2, &nSigID );
		if(ret ) {
			_ASSERT(0);
			return ret;
		}
		this->m_mapGroundMap[i] = nSigID;
	}
	char WALL_MODEL_FILE_PATH_LIST[][MAX_PATH] = {
		//"Media\\PracticeRoomWall.mqo",
		"Media\\PracticeRoom-Wall-NoRoof.mqo",
		"Media\\Stage\\Stage1-zombie-Wall.mqo",
		"Media\\Stage\\Stage2-worm-Wall.mqo",
		"Media\\Stage\\Stage3-sky-Wall.mqo",
		"Media\\Stage\\Stage4-snake-Wall.mqo",
		"Media\\Stage\\Stage5-StarshipTrooper-Wall.mqo",
	};
	char WALL_SIG_FILE_PATH_LIST[][MAX_PATH] = {
		"Media\\PracticeRoomWall.sig",
		"Media\\Stage\\Stage1-zombie-Wall.sig",
		"Media\\Stage\\Stage2-worm-Wall.sig",
		"Media\\Stage\\Stage3-sky-Wall.sig",
		"Media\\Stage\\Stage4-snake-Wall.sig",
		"Media\\Stage\\Stage5-StarshipTrooper-Wall.sig",
	};

	int GROUND_TYPE_FOR_WALL[] = {
		GroundType::PRACTICE_ROOM,
		GroundType::ZOMBIE,
		GroundType::WORM,
		GroundType::SKY,
		GroundType::SNAKE,
		GroundType::STARSHIP_TROOPER,
	};
	for(int i = 0; i < WallType::MAX_NUM; i ++ ) {
		ret = E3DLoadMQOFileAsMovableArea( WALL_MODEL_FILE_PATH_LIST[i], 
			GROUND_MODEL_RATE, &nSigID );
		if(ret ) {
			_ASSERT(0);
			return ret;
		}
		this->m_mapWallMap[i] = nSigID;

		// ǂnʂɔzu
		//E3DSetPos(nSigID, D3DXVECTOR3(0,0,0 ) );
		//E3DSetDir(nSigID, D3DXVECTOR3(0,0,0 ) );
		ret = E3DSetWallOnGround( nSigID, this->m_mapGroundMap[GROUND_TYPE_FOR_WALL[i]],
			MAP_HEIGHT, MAP_MIN, 0);

		ret = E3DSigLoad( WALL_SIG_FILE_PATH_LIST[i], nAdjestUVFlag, GROUND_MODEL_RATE,
			&nSigID );
		if(ret ) {
			_ASSERT(0);
			return ret;
		}
		this->m_mapWallSigMap[i] = nSigID;
	}
	ofs << "nʁ{Ǔǂݍ݊" << std::endl;
	// 
	
	//////
	// XvCgǂݍ
	int spid = -1;
	E3DCOLOR4UC uc = {UI_ALPHA,255,255,255 };
	// g
	char SPRITE_PATH_LIST[][MAX_PATH] = {
		"Media\\CrossHair.png",
		"Media\\LifeFrame.png",
		"Media\\LifeBar.png",
		"Media\\EnemyLifeBar.png",
		"Media\\TitleSubject.png",
		"Media\\SelectMission.png",
		"Media\\MissionFrame.png",
		"Media\\PreviousButton.png",
		"Media\\NextButton.png",
		"Media\\MessageFrame.png",
		"Media\\UI\\CheckBox.png",
		"Media\\UI\\CheckBoxChecked.png",
		"Media\\SelectMemory.png",
	};
	int SPRITE_INDEX_LIST[] = {
		Sprite::CROSS_HAIR,
		Sprite::LIFE_FRAME,
		Sprite::LIFE_BAR,
		Sprite::ENEMY_LIFE_BAR,
		Sprite::TITLE_SUBJECT,
		Sprite::SELECT_MISSION,
		Sprite::MISSION_FRAME,
		Sprite::PREVIOUS_BUTTON,
		Sprite::NEXT_BUTTON,
		Sprite::MESSAGE_FRAME,
		Sprite::CHECK_BOX,
		Sprite::CHECK_BOX_CHECKED,
		Sprite::SELECT_MEMORY,
	};
	int SPRITE_ALPHA_LIST_NUM = sizeof(SPRITE_INDEX_LIST) / sizeof(int);
	for( int i = 0; i < SPRITE_ALPHA_LIST_NUM; i ++ ) {

		ret = E3DCreateSprite( SPRITE_PATH_LIST[i], 1, NULL, &spid );
		ret = E3DSetSpriteARGB( spid, uc );
		this->m_SpriteIndexManager.set( SPRITE_INDEX_LIST[i], spid );
	}

	ret = E3DCreateSprite( "Media\\Title.png", 1, NULL, &spid );
	this->m_SpriteIndexManager.set( Sprite::TITLE, spid );

	ret = E3DCreateSprite( "Media\\Sprite\\evi_3.png", 1, NULL, &spid );
	this->m_SpriteIndexManager.set( Sprite::TITLE_SCREEN, spid);

	/*	MINI_GUN,
		MACHINE_GUN,
		MISSILE_LAUNCHER,
		HAND_GUN,
		GRANADE_LAUNCHER,
		MAX_NUM*/
	// XvCg
	char WEAPON_SPRITE_PATH_LIST[][MAX_PATH] = {
		"Media\\Gun-001-MiniGun.png",
		"Media\\Weapon\\Gun-002-MachineGun.png",
		"Media\\Weapon\\Gun-003-MissileLauncher.png",
		"Media\\Weapon\\Gun-004-HandGun.png",
		"Media\\Weapon\\Gun-005-GranadeLauncher.png",
		"Media\\Weapon\\Gun-007-Fist.png",
		"Media\\Weapon\\Gun-008-Moppu.png",
		"Media\\Weapon\\Gun-006-Crowbar.png",
	};
	int WEAPON_SPRITE_USER_ID_LIST[] = {
		Sprite::GUN_01_MINI_GUN,
		Sprite::GUN_02_MACHINE_GUN,
		Sprite::GUN_03_MISSILE_LAUNCHER,
		Sprite::GUN_04_HAND_GUN,
		Sprite::GUN_05_GRANADE_LAUNCHER,
		Sprite::GUN_07_FIST,
		Sprite::GUN_08_MOPPU,
		Sprite::GUN_06_CROWBAR,
	};
	char WEAPON_SIG_FILE_PATH_LIST[][MAX_PATH] = {
		"Media\\model_madogen\\minigun.sig",
		"",
		"",
		"Media\\model_madogen\\handgun.sig",
		"",
		"",
		"Media\\model_madogen\\moppu.sig",
		"",
	};
	char WEAPON_MOA_FILE_PATH_LIST[][MAX_PATH] = {
		"Media\\model_madogen\\motion\\Minigun.moa",
		"",
		"",
		"Media\\model_madogen\\motion\\evi.moa",
		"",
		"",
		"Media\\model_madogen\\motion\\evi.moa",
		"",
	};
	for(int i = 0; i < WeaponType::MAX_NUM; i ++ ) {
		this->m_aryWeaponList[i].set_Type( i );

		ret = E3DCreateSprite( WEAPON_SPRITE_PATH_LIST[i], 1, NULL, &spid );
		if(ret ) {
			_ASSERT(0);
			return ret;
		}
		ret = E3DSetSpriteARGB( spid, uc );
		this->m_SpriteIndexManager.set( WEAPON_SPRITE_USER_ID_LIST[i], spid );
		this->m_aryWeaponList[i].set_SpriteID( spid );

		// sigǂݍ
		if( strcmp(WEAPON_SIG_FILE_PATH_LIST[i], "") != 0 ) {
			// ǂݍݗL
			if( i != WeaponType::MINI_GUN ) {
				expandMOAArray( &this->m_aryWeaponList[i] );
			}

			ret = E3DSigLoad( WEAPON_SIG_FILE_PATH_LIST[i], 0, 1, &this->m_aryWeaponList[i].m_nSigID );
			if( ret ) {
				_ASSERT(0);
				return ret;
			}
			
			// MOAǂݍ
			ret = this->loadMOAFile( WEAPON_MOA_FILE_PATH_LIST[i], &this->m_aryWeaponList[i], PLAYER_MOTION_MULTIPLE );
			if( ret ) {
				_ASSERT(0);
				return ret;
			}
		}

		// Quatanion
		ret = E3DCreateQ( &this->m_aryWeaponList[i].m_Move.m_nQuoatanion );

	}

	// BackPack
	{
		expandMOAArray( &this->m_BackPack );
		ret = E3DSigLoad( "Media\\model_madogen\\BackPack.sig", 0, 1, &this->m_BackPack.m_nSigID);
		if( ret ){
			_ASSERT(0);
			return ret;
		}
		// MOA
		ret = this->loadMOAFile( "Media\\model_madogen\\motion\\evi.moa", &this->m_BackPack, PLAYER_MOTION_MULTIPLE);
		if( ret ){
			_ASSERT(0);
			return ret;
		}
		// Quatanion
		ret = E3DCreateQ( &this->m_BackPack.m_Move.m_nQuoatanion );
		
	}

	// evC[^CvIł镐̃}bsO
	m_mapWeaponEnableMap[ PlayerType::EVIGEN ].push_back( WeaponType::FIST );
	m_mapWeaponEnableMap[ PlayerType::EVIGEN ].push_back( WeaponType::GRANADE_LAUNCHER );
	m_mapWeaponEnableMap[ PlayerType::EVIGEN ].push_back( WeaponType::HAND_GUN );
	m_mapWeaponEnableMap[ PlayerType::EVIGEN ].push_back( WeaponType::MACHINE_GUN );
	m_mapWeaponEnableMap[ PlayerType::EVIGEN ].push_back( WeaponType::MINI_GUN );
	m_mapWeaponEnableMap[ PlayerType::EVIGEN ].push_back( WeaponType::MISSILE_LAUNCHER );
	m_mapWeaponEnableMap[ PlayerType::EVIGEN ].push_back( WeaponType::MOPPU );

	// ^Cc
	m_mapWeaponEnableMap[ PlayerType::TIGHTS ].push_back( WeaponType::FIST );
	// Ǘ
	m_mapWeaponEnableMap[ PlayerType::KANRITAN ].push_back( WeaponType::FIST );
	m_mapWeaponEnableMap[ PlayerType::KANRITAN ].push_back( WeaponType::MOPPU );
	// Ƃ
	m_mapWeaponEnableMap[ PlayerType::TOZICA ].push_back( WeaponType::FIST );
	m_mapWeaponEnableMap[ PlayerType::TOZICA ].push_back( WeaponType::MOPPU );

	// ^[j
	m_mapWeaponEnableMap[ PlayerType::TANYA ].push_back( WeaponType::FIST );
	m_mapWeaponEnableMap[ PlayerType::TANYA ].push_back( WeaponType::CROWBAR );

	this->m_nWeaponIndex = 0;
	ofs << "XvCgǂݍ݊" << std::endl;

	///////////////////
	// BGM
	vector<string> vecBGMFilePathListRaw;
	ret = TextTool::load_StringLinesFromFile( "Media\\BGM\\bgm.txt" , &vecBGMFilePathListRaw);
	if( ret ) {
		_ASSERT(0);
	}
	vector<string> vecBGMFilePathList;
	for( int i = 0; i < static_cast<int>(vecBGMFilePathListRaw.size()); i ++ ) {
		if( TextTool::is_SkipLine( vecBGMFilePathListRaw[i] ) ) {
			continue;
		}
		vecBGMFilePathList.push_back( string("Media\\BGM\\") + vecBGMFilePathListRaw[i] );
	}

	vector<string> vecList;
	TextTool::load_StringLinesFromFile( "Media\\SE\\se.txt", &vecList);
	vector<string> vecSEPathList;

	for( int i = 0; i < static_cast<int>(vecList.size()); i ++ ) {
		if( TextTool::is_SkipLine( vecList[i] ) ) {
			continue;
		}
		vecSEPathList.push_back( string("Media\\SE\\") + vecList[i] );
	}


	float SE_VOLUME_RATE = static_cast<float>(GetPrivateProfileInt( _T("Evigen"), _T("SE"), 60, OPTION_INI_FILE_PATH )) / 100.f;
	float VOICE_VOLUME_RATE = static_cast<float>(GetPrivateProfileInt( _T("Evigen"), _T("VOICE"), 100, OPTION_INI_FILE_PATH )) / 100.f;
	float BGM_VOLUME_RATE = static_cast<float>(GetPrivateProfileInt( _T("Evigen"), _T("BGM"), 30, OPTION_INI_FILE_PATH )) / 100.f;

	for(int i = 0; i < Sound::MAX_NUM; i ++ ) {
		int id = 0;
		if( i < Sound::BGM_NUM ) {
			ret = E3DLoadSound( vecBGMFilePathList[i].c_str(), 0, 0, 1, &id );
		} else {
			ret = E3DLoadSound( vecSEPathList[i - Sound::BGM_NUM].c_str(), 0, 0, 1, &id);
		}
		if(ret ) {
			_ASSERT(0);
			return ret;
		}
		this->m_arySoundList[i] = id;

		if( i == Sound::GUN ||
			i == Sound::ENEMY_HIT_1 ||
			i == Sound::ENEMY_HIT_2 ) 
		{
			ret = E3DSetSoundVolume( SE_VOLUME_RATE, id) ;
		} else if( i < Sound::BGM_NUM ) {
			ret = E3DSetSoundVolume( BGM_VOLUME_RATE, id) ;
		} else if( i >= Sound::VOICE_HIT_1 )
		{
			// {CX̉
			ret = E3DSetSoundVolume( VOICE_VOLUME_RATE, id) ;
		}
	}
	this->m_nBGMIndex = Sound::TITLE;

	//ret = E3DPlaySound( this->m_arySoundList[this->m_nBGMIndex], 0, 0, 255 );
	ofs << "SE&BGMǂݍ݊" << std::endl;

	BOOL bDefaultList[] = {
		1,
		0,
		1,
		0,
		1,
		1,
		0,
	};
	for(int i = 0; i < TitleSceneConsts::CheckType::NUM_MAX; i ++ ) {
		TCHAR tcSectionName[100];
		if( i == TitleSceneConsts::CheckType::TOZICA_NO_BRA ) {
			wsprintf( tcSectionName, _T("Tozica"));
		} else {
			wsprintf( tcSectionName, _T("Evigen"));
		}
		this->m_aryOptionList[i] = GetPrivateProfileInt(tcSectionName, OPTION_ELEMENT_LIST[i], bDefaultList[i],
			OPTION_INI_FILE_PATH);
	}
	this->m_nTanya2PColor = m_aryOptionList[TitleSceneConsts::CheckType::TANYA_2P_COLOR];

	if( this->m_nTanya2PColor > 0 ) {
		// 2PJ[
		this->set_Tanya2PColor();
	}
	ofs << "IvVǂݍ݊" << std::endl;


	///////////////////////////////////
	// Cg쐬
	E3DCOLOR4UC col= {255, 255, 255, 255 };

	if( this->m_LightManager.create( GEnum::LightType::Default,
		this->m_vLightDirection,
		col ) != 0 )
	{
		_ASSERT( 0 );
		return 1;
	}
	ofs << "Cg쐬" << std::endl;

	// V[쐬
	this->m_SceneManager.add_Scene( SceneType::TITLE, new TitleScene() );
	this->m_SceneManager.add_Scene( SceneType::SELECT_MISSION, new SelectMissionScene() );
	this->m_SceneManager.add_Scene( SceneType::BRIEFING, new BriefingScene() );
	this->m_SceneManager.add_Scene( SceneType::GAME, new GameScene() );
	this->m_SceneManager.add_Scene( SceneType::ENEMY_MODE, new EnemyModeScene() );
	this->m_SceneManager.add_Scene( SceneType::GAME_OVER, new GameOverScene() );
	this->m_SceneManager.add_Scene( SceneType::CLEAR, new ClearScene() );
	this->m_SceneManager.add_Scene( SceneType::SELECT_MEMORY, new SelectKaisouScene() );

	ofs << "V[쐬" << std::endl;

	// V[I
	this->m_SceneManager.set_Scene( SceneType::TITLE );


	//////////
	// Z[uf[^ǂݍ
	this->m_SaveData.load();
	this->m_GameSetting.load();
	ofs << "Z[uǂݍ݊" << std::endl;


	this->m_nTestMotionIndex = 0;
	this->m_nTestTanyaMotionIndex = 0;
	this->m_nTestMotionEnemySigID = -1;

	ofs << "" << std::endl;

	ofs.close();
	return 0;
}

}
