#include "SaveData.h"
#include "HPLE3DLapper.h"

#include "StaticData.h"

#include <fstream>
#include <string>

using namespace HPL;
using namespace General;
using namespace MotionTest;
using namespace SaveDataConsts;
using namespace MotionTestConsts;

using namespace std;

SaveData::SaveData(){
}

SaveData::~SaveData(){
}

int SaveData::save() {

	ofstream ofs( SAVE_DATA_FILE_PATH );

	if( ofs.is_open() == false ) {
		const int MAX_SIZE = 1024;
		TCHAR tcBuffer[MAX_SIZE];
		wsprintf( tcBuffer, _T("[%s]J܂BQ[e͕ۑ܂B"), SAVE_DATA_FILE_PATH );
		// ۑłȂ
		MessageBox( NULL, tcBuffer, _T("Error"), MB_OK );
		return ErrorType::ERR_IO;
	}
	
	ofs << ItemName::MISSION << string("=");
	for( int i = 0; i < MissionType::MAX_NUM; i ++ ) {
		ofs << TextTool::get_String( "%d", staticData->bMissionOpenFlagList[i] ? 1 : 0);
		if( i < MissionType::MAX_NUM - 1 ) {
			ofs << string(",");
		}
	}
	ofs << endl;

	ofs << ItemName::WEAPON << string("=");
	for(int i = 0; i < WeaponType::MAX_NUM; i ++ ) {
		ofs << TextTool::get_String( "%d", staticData->m_aryWeaponList[i].is_Valid() ? 1 : 0);
		if( i < WeaponType::MAX_NUM - 1 ) {
			ofs << string(",");
		}
	}
	ofs << endl;

	ofs.close();
	return ErrorType::ERR_NONE;

}

int SaveData::load() {
	ifstream ifs( SAVE_DATA_FILE_PATH );
	if( ifs.is_open() == false ) {
		// ftHgݒ
		this->setAsDefault( );

		return this->save();
	}

	// f[^[h
	vector<string> vecLines;
	if( TextTool::load_StringLinesFromFile( SAVE_DATA_FILE_PATH, &vecLines ) != 0 ) {
		return ErrorType::ERR_IO;
	}

	// G[bZ[Wp
	const int MAX_SIZE = 1024;
	TCHAR tcBuffer[MAX_SIZE];

	int nCheckSum = 0;

	for( int i = 0; i < static_cast<int>(vecLines.size()); i ++ ) {
		if( TextTool::is_SkipLine( vecLines[i] ) ) {
			continue;
		}
		vector<string> vecItems = TextTool::split( vecLines[i], "=");
		bool bIsError = false;
		if( vecItems.size() < 2 ) {
			bIsError = true;
		} else {
			vector<string> vecDatas = TextTool::split( vecItems[1], ",");
			if( vecItems[0].compare( ItemName::MISSION ) == 0 ) {
				for(int j = 0; j < MissionType::MAX_NUM; j ++ ) {
					bool bIsOpen = false;
					if( j < static_cast<int>(vecDatas.size()) ) {
						bIsOpen = atoi( vecDatas[j].c_str() ) != 0;
					} else {
						// f[^ȂiftHg
						// do nothing
					}
					staticData->bMissionOpenFlagList[j] = bIsOpen;
				}
				nCheckSum ++;
			} else if( vecItems[0].compare( ItemName::WEAPON) == 0 ) {
				for(int j = 0; j < WeaponType::MAX_NUM; j ++ ) {
					bool bIsOpen = false;
					if( j < static_cast<int>(vecDatas.size()) ) {
						bIsOpen = atoi( vecDatas[j].c_str() ) != 0;
					} else {
						// f[^ȂiftHg
						// do nothing
					}
					staticData->m_aryWeaponList[j].set_Valid( bIsOpen ? TRUE: FALSE );
				}
				nCheckSum ++;
			} else {
				bIsError = true;
			}
		}

		if( bIsError ) {
			// tH[}bgُ
			wsprintf( tcBuffer, _T("tH[}bgُ[%d]"), vecLines[i] );
			MessageBox(NULL, tcBuffer, _T("Error"), MB_OK );
			return ErrorType::ERR_SAVE_DATA_FORMAT;
		}

	}

	const int DEFAULT_CHECKSUM = 2;

	// f[^TCYύX̂Ƃ̂߂ɈUZ[uĂ

	ifs.close();

	if( nCheckSum < DEFAULT_CHECKSUM ) {
		// Ȃ
		MessageBox(NULL, _T("f[^܂B܂BiȂҔ\łj"), _T("Warning"), MB_OK );
		// ftHgݒ
		setAsDefault();
	}
	save();

	return ErrorType::ERR_NONE;
}

int SaveData::setAsDefault() {

	{
		int aryOpenDefaultList[] = {
			MissionType::CHALLENGE,
			MissionType::PRACTICE,
			MissionType::WORM,
		};
		for(int i = 0; i < MissionType::MAX_NUM; i ++ ) {
			bool bIsOpen = false;

			for(int j = 0; j < sizeof(aryOpenDefaultList)/sizeof(aryOpenDefaultList[0]); j ++ ) {
				if( aryOpenDefaultList[j] == i ) {
					bIsOpen = true;
					break;
				}
			}
			
			staticData->bMissionOpenFlagList[i] = bIsOpen;
		}
	}

	{
		int aryOpenWeaponList[] = {
			WeaponType::CROWBAR,
			WeaponType::MOPPU,
			WeaponType::FIST,
		};
		for(int i = 0; i < WeaponType::MAX_NUM; i ++ ) {
			BOOL bIsOpen = FALSE;
			for(int j = 0; j < sizeof(aryOpenWeaponList)/sizeof(aryOpenWeaponList[0]); j ++ ) {
				if( aryOpenWeaponList[j] == i ) {
					bIsOpen = TRUE;
					break;
				}
			}
			staticData->m_aryWeaponList[i].set_Valid( bIsOpen );
		}
	}

	return ErrorType::ERR_NONE;
}
