#include "ShotManager.h"
#include "StaticData.h"
#include <cstdlib>

namespace MotionTest {
using namespace HPL;
using namespace E3D;
using namespace General;
using namespace MotionTestConsts;

ShotManager::ShotManager() {
}
ShotManager::~ShotManager() {
}

///////////////////
// I[o[Ch
BOOL ShotManager::is_Skip( E3DObject* obj ) {
	return obj->get_Valid() == FALSE ? TRUE: FALSE;

}
int ShotManager::checkInView( E3DObject* obj ) {
	int status;
	// `FbNC
	if( E3DChkInView( staticData->get_SwapChainID(), obj->m_nSigID, &status ) ){
		_ASSERT( 0 );
		return 1;
	}
	return 0;
}
int ShotManager::move( E3DObject* obj ) {
	int ret= 0;

	bool bIsMove = true;

	if( obj->m_Game.m_nType == ShotType::BAKUFU ) {
		bIsMove = false;
	}

	if( bIsMove) {
		ret = E3DPosForward( obj->m_nSigID, obj->m_Move.m_fSpeed );

		// ʒuݒ
		E3DGetPos( obj->m_nSigID, &obj->m_Move.m_vPosition );
	}

	if( obj->m_Game.m_Counter->step() & General::CounterStateType::ALL_LOOP_END ) {
		// S
		// 
		obj->set_Valid( FALSE) ;
		E3DSetValidFlag( obj->m_nSigID, -1, FALSE );
	}else {
		// `FbNC
		int status;
		//E3DLookAtQ( obj->m_Move.m_nQuoatanion, obj->m_Move.m_vVelocity, D3DXVECTOR3(0,0,1), 0, 1 );
		if( E3DChkInView( staticData->get_SwapChainID(), obj->m_nSigID, &status ) ){
			_ASSERT( 0 );
			return 1;
		}
	}

	return 0;
}
int ShotManager::checkHitToGround( E3DObject* obj ) {
	int ret = 0;

/*	ret = staticData->checkObjectOnGround( obj);
	if( ret ) {
		_ASSERT(0);
		return ret;
	}*/
	int nMode = 0;	//n𔇂

	// 
	int nResult = 0;

	D3DXVECTOR3 vAdjust;
	D3DXVECTOR3 n;
	float fDiffMaxY = 20000.f;
	ret = E3DChkConfGround( obj->m_nSigID, staticData->get_GroundSigID(), nMode, 
		fDiffMaxY, MAP_MIN, &nResult, &vAdjust, &n );
	if(ret ) {
		_ASSERT(0);
		return 1;
	}

	D3DXVECTOR3 vPosition;
	E3DGetPos( obj->m_nSigID, &vPosition );

	if( vPosition.y > vAdjust.y )	{
		// 
	} else {
		if( nResult ) {
			// Gꂽ

			bool bIsDisappear = true;
			if( obj->m_Game.m_nType == ShotType::BAKUFU ) {
				// Ȃ
				bIsDisappear = false;
			}

			if( bIsDisappear ){
				// 
				obj->set_Valid( FALSE );
				E3DSetValidFlag( obj->m_nSigID , -1, FALSE);
			}
			if( obj->m_Game.m_nType == ShotType::BULLET ) {
				// Ȃ
			} else if( obj->m_Game.m_nType == ShotType::MISSILE ) {
				// 
				// Bakufu
				E3DObject* bakufu = this->search( ShotType::BAKUFU );
				if( bakufu ) {

					bakufu->m_Move.m_vPosition = obj->m_Move.m_vPosition ;
					E3DSetPos( bakufu->m_nSigID, obj->m_Move.m_vPosition );
				}
			} else if( obj->m_Game.m_nType == ShotType::BAKUFU ) {
				// Ȃ
			}
		}
	}

	return 0;
}
/*int ShotManager::checkHitToBillBoard( E3DObject* obj ) {

	// VbgSigIDXg
	int nShotID[MotionTestConsts::SHOT_MAX];

	// Vbg̐
	int nConfNum;

	// ǂ̌
	int confptr = 0;

	int ret = 0;

	// Sr{[hƂ̓蔻`FbN
	ret = E3DChkConfBillboard( obj->m_nSigID,
		1.f, &confptr, nShotID, MotionTestConsts::SHOT_MAX, &nConfNum );

	if( confptr != 0 ) {
		// ɓ

		for(int i = 0; i < nConfNum; i ++ ) {
			// e
			ret = E3DSetValidFlag( -1, nShotID[i] , FALSE);

			// tŃr{[h擾
			E3DBillBoard* billBoard = staticData->m_ShotBillBoardManager.m_mapSigIDToBillBoardMap[ nShotID[i] ];
			billBoard->set_Alive( FALSE );

			// G̗̑͂炷
			float fNextHP = obj->m_Game.m_fHP - MotionTestConsts::SHOT_POWER;
			if( fNextHP <= 0) {
				fNextHP = 0;
				// S
				obj->set_Valid( FALSE );
				E3DSetValidFlag( obj->m_nSigID, -1, FALSE );
			}
			obj->m_Game.m_fHP = fNextHP;
		}



	}
	return 0;
}*/
int ShotManager::checkHitToEnemy( E3DObject* obj ) {

	if( obj->is_Valid() == FALSE) {
		return 0;
	}

	int ret = 0;
	int confptr = 0;		

	int inviewptr;

	for( std::map<int, std::list<E3DObject*> >::iterator mit = staticData->m_EnemyManager.m_mapObjectListMap.begin();
		mit != staticData->m_EnemyManager.m_mapObjectListMap.end();
		mit ++ ) 
	{
		if( mit->first == EnemyType::ZOMBIE_A ||
			mit->first == EnemyType::ROPER )
		{
			// Ϗܗp
			continue;
		}
//		for( std::list<E3DObject*>::iterator it = mit->second.begin();
//			it != mit->second.end();
//			it ++ )
		for( std::list<E3DObject*>::iterator it = staticData->m_EnemyManager.m_mapValidObjectListMap[mit->first].begin();
			it != staticData->m_EnemyManager.m_mapValidObjectListMap[mit->first].end();
			it ++ )
		{
			E3DObject* enemy = *it;

			if( enemy->is_Valid() == FALSE ) {
				continue;
			}

			ret = E3DChkConflictOBB( enemy->m_nSigID, -1,
				obj->m_nSigID, -1, &confptr , &inviewptr);
			if( ret ) {
				_ASSERT( 0 );
				return 1;
			}
			if( confptr ) {
				// 
				bool bIsDisappear = true;
				if( obj->m_Game.m_nType == ShotType::BAKUFU ) {
					// Ȃ
					bIsDisappear = false;
				}

				if( bIsDisappear ){
					// 
					obj->set_Valid( FALSE );
					E3DSetValidFlag( obj->m_nSigID , -1, FALSE);
				}

				if( obj->m_Game.m_nType == ShotType::MISSILE ) {
					// 
					// Bakufu
					E3DObject* bakufu = this->search( ShotType::BAKUFU );
					if( bakufu ) {

						bakufu->m_Move.m_vPosition = obj->m_Move.m_vPosition ;
						E3DSetPos( bakufu->m_nSigID, obj->m_Move.m_vPosition );
					}
				}

				float fBlowRate = 1.f;
				float fDamageRate = 1.f;
				staticData->m_EnemyManager.damage( obj, enemy, fBlowRate, fDamageRate);
			}
		}
	}

	return 0;
}
int ShotManager::render( E3DObject* obj ) {

	// sig id擾
	int hsid = obj->m_nSigID;

	// ʏ`
	if( E3DRender( staticData->get_SwapChainID(), hsid, 0, 1, 0, 0 ) ){
		_ASSERT( 0 );
		return 1;
	}

	// uh`
	if( E3DRender( staticData->get_SwapChainID(), hsid, 1, 1, 0, 0 ) ){
		_ASSERT( 0 );
		return 1;
	}
	int ret = E3DSetBeforePos( obj->m_nSigID) ;
	return 0;
}

int ShotManager::createObjects( int nType, int nNum ) {
	int ret = 0;

	char lpszSigFilePath[MAX_PATH];

	if( nType == ShotType::BULLET ) {
		strcpy_s( lpszSigFilePath, MAX_PATH, "Media\\model_madogen\\bullet.sig");
	}else if( nType == ShotType::MISSILE ){
		strcpy_s( lpszSigFilePath, MAX_PATH, "Media\\Weapon\\Missile.sig");
	}else if( nType == ShotType::BAKUFU ){
		strcpy_s( lpszSigFilePath, MAX_PATH, "Media\\Shot\\Bakufu\\Bakufu.sig");
	} else {
		_ASSERT( 0 );
		return 1;
	}

	// Lꗗɒǉ
	this->m_mapValidObjectListMap[nType] = std::list<E3DObject*>();

	// Rs[ƂȂ}X^SIGID
	int nMasterSigID = 0;

	float fZoom = this->getZoom( nType );

	/////////////////
	// Sigt@Cǂݍ
	ret = E3DSigLoad( lpszSigFilePath, 0, fZoom, &nMasterSigID );
	if( ret ) {
		_ASSERT( 0 );
		return ret;
	}

	// ǉ
	ret = this->add_Object( nType, nMasterSigID );

	// N[}l[Wɓo^
	ret = this->m_CloneManager.add_MasterBuffer( nType, nMasterSigID);

	// \
	nNum --;

	if( nNum >= 1 ) {
		// ܂쐬ׂ̂
		// obt@ɃRs[Sig𕡐

		// eNX`pX
		char lpszTextureDirPath[MAX_PATH];
		if( nType == ShotType::BULLET ) {
			strcpy_s( lpszTextureDirPath, MAX_PATH, "Media\\model_madogen\\");
		}else if( nType == ShotType::MISSILE ) {
			strcpy_s( lpszTextureDirPath, MAX_PATH, "Media\\Weapon\\");
		}else if( nType == ShotType::BAKUFU ) {
			strcpy_s( lpszTextureDirPath, MAX_PATH, "Media\\Shot\\Bakufu\\");
		} else {
			_ASSERT( 0 );
			return 1;
		}

		for(int i = 0; i < nNum; i ++ ) {
			E3DSigBufferData* bfSigBufferData = this->m_CloneManager.get_MasterBuffer(nType);
			// Rs[
			int nSigID = 0;
			ret = E3DSigLoadFromBuf( lpszTextureDirPath,
				bfSigBufferData->m_lpczBuffer,
				bfSigBufferData->m_nBufferSize,
				0, fZoom, &nSigID );
				
			// o^
			ret = this->add_Object( nType, nSigID );
		}

	}

	//N[}l[W
	this->m_CloneManager.free(nType);
	return 0;
}

int ShotManager::add_Object(int nType, int nSigID ) {
	int ret = 0;

	// IuWFNg
	E3DObject* obj = new E3DObject();

	//! IuWFNg^Cv
	obj->m_Game.m_nObjectType = ObjectType::NEUTRAL;

	//! ^Cv
	obj->m_Game.m_nType = nType;

	// sig id o^
	obj->m_nSigID = nSigID;

	// tɓo^
	this->m_mapSigIDToObjectMap[ nSigID ] = obj;

	// Xgɒǉ
	this->m_mapObjectListMap[nType].push_back( obj );

	// NH[^jI
	ret = E3DCreateQ( &obj->m_Move.m_nQuoatanion );

	/////
	// 
	obj->m_Game.m_Counter = new HPLCounter( SHOT_LIFE_COUNT, 1);

	float fSpeed = SHOT_SPEED;
	if( nType == ShotType::MISSILE ) {
		fSpeed = 150.f;
	} else if( nType == ShotType::MISSILE ) {
		fSpeed = 0.f;
	}
	obj->m_Move.m_fSpeed = fSpeed;

	return 0;
}

/** MOAt@Cǂݍ
  *
  */
int ShotManager::loadMOAFile( const char* lpszFilePath, E3DObject* obj ) {

	return 1;
	/**
	int ret = 0;
	// ǂݍ
	ret = E3DLoadMOAFile( obj->m_nSigID,
		lpszFilePath,
		5, 1.f);
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}

	int nNumberOfMotion = 0;
	ret = E3DGetMoaInfo( obj->m_nSigID, MAX_MOTION,
		obj->m_moaMOAArray , &nNumberOfMotion);
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}
	return 0;*/

}
/** ҋ@ĂIuWFNgĂяo܂B
  * @retval NULL	ɑSĖ܂Ăđ݂Ȃꍇ
  */
E3DObject* ShotManager::search( int nType ) {
	for(std::list<E3DObject*>::iterator it = this->m_mapObjectListMap[nType].begin();
		it != this->m_mapObjectListMap[nType].end(); it ++ )
	{
		E3DObject* obj = *it;
		if( obj->get_Valid() == FALSE ) {

			// LXgɒǉ
			this->m_mapValidObjectListMap[nType].push_back(obj);

			obj->set_Valid( TRUE );
			E3DSetValidFlag( obj->m_nSigID, -1, TRUE );
			//obj->m_Game.m_fHP = obj->m_Game.m_fHPMax;
			//obj->m_Game.m_fDamage = ENEMY_DAMAGE;
			//obj->m_Game.m_fDamageError = ENEMY_DAMAGE / 2.f;

			//////////////////////
			// test ꏊzu
			/*float MAX_DISTANCE = 15000;
			float ERR = 5000;

			float DEG = MathTool::nextRandom<float>(0, 360 );
			float fDistance = MAX_DISTANCE + MathTool::nextRandom<float>(-ERR,ERR);

			E3DSetPosOnGround( obj->m_nSigID, 
				staticData->get_GroundSigID(),
				MAP_HEIGHT, MAP_MIN, 
				fDistance * cos(D3DXToRadian( DEG )),
				fDistance * sin(D3DXToRadian( DEG )));*/

			return obj;
		}
	}
	return NULL;
}

float ShotManager::getZoom( int nType ) {
	// ShotType::MISSILE
	float fZooms[] = {
		1.f,
		1.f,
		2.f,
	};
	_ASSERT(nType >= 0 && nType < sizeof(fZooms)/ sizeof(float) );
	return fZooms[nType];
}

int ShotManager::checkHitToPlayer( HPL::E3D::E3DObject* obj ) {

	int ret;
	// vC[Ƃ̐ڐG

	bool bIsHitToPlayer = false;

	if( obj->m_Game.m_nType == ShotType::BAKUFU ) {
		bIsHitToPlayer = true;
	}

	if( bIsHitToPlayer ){
		int confptr = 0;		

		int inviewptr;

		ret = E3DChkConflictOBB( staticData->get_Player()->m_nSigID, -1,
			obj->m_nSigID, -1, &confptr , &inviewptr);
		if( ret ) {
			_ASSERT( 0 );
			return 1;
		}
		if( confptr ) {
			// 
			staticData->blow_Out( obj, staticData->get_Player(), 1.f );

			// _[W
			float fPower = SHOT_BAKUFU_POWER;
			staticData->get_Player()->m_Game.set_HP( staticData->get_Player()->m_Game.m_fHP - fPower );
			
			// _[W\
			ret = staticData->setFace( staticData->get_Player()->m_nSigID, Material::DAMAGE, TRUE );
			

			if( staticData->isEvigenizePlayer() ) {
				staticData->get_Player()->m_nEventNumber = Motion::Evigen::DAMAGE_CRASH_UP;
				staticData->get_Player()->m_nUnderEventNumber = -1;

			}
		
		}
	}

	return checkHitToEnemy( obj );
}
	
}
