#include "DCameraManager.h"

#include "VectorTool.h"

namespace HPL {
namespace DirectX {
using namespace VectorTool;

static const D3DXVECTOR3 DEFAULT_NORMALIZED_OBJECT_POSITION(0,0,1);
//////////////////////////////////////////////////////////////
DCameraManager::DCameraManager( float fDistance) {
	this->set_Distance( fDistance );

	this->m_vNormalizedQuatanionDireciton = DEFAULT_NORMALIZED_OBJECT_POSITION;

}
DCameraManager::~DCameraManager() {
}


//////////////////////////////////////////////////////////////
// Getter/Setter
HRESULT DCameraManager::set_Distance( float fDistance ) {
	this->m_fDistance = fDistance;
	return S_OK;
}
float DCameraManager::get_Distance() {
	return this->m_fDistance;
}
HRESULT DCameraManager::set_NormalizedQuatanionDirection( D3DXVECTOR3& vNormalizedQuatanionDirection ) {
	D3DXVec3Normalize( &vNormalizedQuatanionDirection, &vNormalizedQuatanionDirection );
	this->m_vNormalizedQuatanionDireciton = vNormalizedQuatanionDirection;
	return S_OK;
}
D3DXVECTOR3 DCameraManager::get_NormalizedQuatanionDirection()  {
	return this->m_vNormalizedQuatanionDireciton;
}

//////////////////////////////////////////////////////////////
// inner operations
/** r[XV
  * @param[in]	vCorePosition			qʒu̒SW
  * @param[out]	vSatellitePosition		q̈ʒu
  * @retval XVɈُ픭isvZj
  */
HRESULT DCameraManager::get_SatellitePosition(
	D3DXVECTOR3& vCorePosition,
	D3DXVECTOR3* vSatellitePosition)
{
	
	//! J`^[Qbg̋
	D3DXVec3Scale( vSatellitePosition, &this->m_vNormalizedQuatanionDireciton, this->m_fDistance );

	//! ΈʒuΈʒu
	D3DXVec3Add( vSatellitePosition, vSatellitePosition, &vCorePosition );

	return S_OK;
}

/////////////////////////////////////////////////////////////
// Operations
/** ]݂̎Ɉܓx]
  * @param[in]	fRotateHorizontalDegree
  * @retval		HRESULT					TRUE ]_ϊ
  */
HRESULT DCameraManager::rotateHorizontalDegree( float fRotateHorizontalDegree ) {
	return rotateHorizontal( &this->m_vNormalizedQuatanionDireciton, &m_vNormalizedQuatanionDireciton, fRotateHorizontalDegree );
}

//! c]i݂̎Ɍox]
//! Longitudinal
HRESULT DCameraManager::rotateVerticalDegree( float fRotateVerticalDegree ) {
	return rotateVertical( &this->m_vNormalizedQuatanionDireciton, &m_vNormalizedQuatanionDireciton,
		fRotateVerticalDegree );
	
}


}
}
