#include "E3DTool.h"

//! C ^C wb_[ t@C
//#include <cstdlib>


namespace HPL {
namespace E3D {
namespace E3DTool {
int drawText(int x, int y, int colR, int colG, int colB, int colA,
			 float zoom, const char* format, ... )
{
	char message[E3DToolConsts::BUFFER_MAX];

	va_list maker;
	va_start( maker, format );
	vsprintf_s( message, E3DToolConsts::BUFFER_MAX, format, maker );

	D3DXVECTOR2 vPosition;
	vPosition.x = static_cast<FLOAT>(x);
	vPosition.y = static_cast<FLOAT>(y);

	E3DCOLOR4UC cColor;
	cColor.a = colA;
	cColor.r = colR;
	cColor.g = colG;
	cColor.b = colB;

	if( E3DDrawText( vPosition, zoom, cColor, message ) ) {
		_ASSERT( 0 );
		return 1;
	}
	return 0;

}
int drawTextWithFont( int x, int y, int colR, int colG, int colB, int colA,
				 int nSwapChainID, int nFontID, const char* format, ... ) 
{
	char message[E3DToolConsts::BUFFER_MAX];

	va_list maker;
	va_start( maker, format );
	vsprintf_s( message, E3DToolConsts::BUFFER_MAX, format, maker );

	//D3DXVECTOR2 vPosition;
	//vPosition.x = static_cast<FLOAT>(x);
	//vPosition.y = static_cast<FLOAT>(y);
	POINT pPos = {x, y};

	E3DCOLOR4UC cColor;
	cColor.a = colA;
	cColor.r = colR;
	cColor.g = colG;
	cColor.b = colB;

	if( E3DDrawTextByFontID( nSwapChainID, nFontID, pPos, message, cColor) ) {
		_ASSERT( 0 );
		return 1;
	}
	return 0;
}

int createRenderTexture( int nFormat, SIZE& szTextureSize, 
						int* nSwapChainID, int* nTextureID)
{
	int nFormatOK = 0;
	int ret = 0;
	ret = E3DCheckRTFormat( nFormat, &nFormatOK );
	if( ret ) {
		_ASSERT( 0 );
		return 1;
	}

	if( nFormatOK != 0 ) {

		int nOK = 0;

		ret = E3DCreateRenderTargetTexture( szTextureSize,
			nFormat,
			nSwapChainID, nTextureID, &nOK );
		if( ret ) {
			_ASSERT( 0 );
			return 1;
		}
		
		if( nOK != 0 ) {	// TRUE
			return 0;
		}
	}

	return 1;
}

} // E3DTool
} // E3D
} // HPL
