#include "HPLCounter.h"

namespace HPL {
namespace General {

HPLCounter::HPLCounter() {
	this->m_nLoopNum = 0;
	this->m_nFrameCounter = 0;
	this->set_FrameCounterMax(1);
	this->set_LoopNumMax(1);
}
HPLCounter::HPLCounter(int nFrameCounterMax, int nLoopNumMax) :
m_nFrameCounterMax( nFrameCounterMax), m_nLoopNumMax(nLoopNumMax)
{
	this->m_nLoopNum = 0;
	this->m_nFrameCounter = 0;
}
HPLCounter::~HPLCounter() {
}

DWORD HPLCounter::get_State() {
	return this->m_dwState;
}

/** 1Xebvi߂
  * @retval	state
  */
DWORD HPLCounter::step() {
	if( this->m_nLoopNumMax >= 0 ) {
		// L[v
		if( this->m_nLoopNum >= this->m_nLoopNumMax) {
			// ɍő僋[v𒴂
			this->set_State( CounterStateType::ALL_LOOP_END );
			return this->get_State();
		} else {
			// ܂ĂȂ
			// -> DO NOTHING
		}
	} else{
		// [v
		// -> DO NOTHING
	}

	// Xebvi߂
	this->m_nFrameCounter ++;

	// V
	int dwState = CounterStateType::NONE;

	if( this->m_nFrameCounter >= this->m_nFrameCounterMax ) {
		// t[𒴂

		// [vI
		dwState |= CounterStateType::ONE_LOOP_END;

		this->m_nLoopNum ++;

		if( this->m_nLoopNum >= this->m_nLoopNumMax ) {
			// Ō̃[vI
			dwState |= CounterStateType::ALL_LOOP_END;
		}
		// t[JE^0ɖ߂
		this->m_nFrameCounter = 0;
	}

	this->set_State(dwState );
	return dwState;

}

int HPLCounter::get_FrameCounter() {
	return this->m_nFrameCounter;
}
int HPLCounter::get_FrameCounterMax() {
	return this->m_nFrameCounterMax;
}
int HPLCounter::get_LoopNum() {
	return this->m_nLoopNum;
}
int HPLCounter::get_LoopNumMax() {
	return this->m_nLoopNumMax;
}
void HPLCounter::set_State( DWORD dwState ) {
	this->m_dwState = dwState;
}
void HPLCounter::set_FrameCounterMax( int nFrameCounterMax ) {
	this->m_nFrameCounterMax = nFrameCounterMax;
}
void HPLCounter::set_LoopNumMax(int nLoopNumMax) {
	this->m_nLoopNumMax = nLoopNumMax;
}

/** Zbg
  *
  */
void HPLCounter::reset() {
	this->m_nFrameCounter = 0;
	this->m_nLoopNum = 0;
}
}
}
