#include "ScenarioManager.h"

#include "TextTool.h"


#include <fstream>

namespace HPL {
namespace E3D {
using namespace std;
using namespace General;
ScenarioManager::ScenarioManager() {
}

ScenarioManager::~ScenarioManager() {
	for( std::map<int, ScenarioList*>::iterator it = this->m_mapScenarioListMap.begin();
		it != m_mapScenarioListMap.end(); it ++ ) 
	{
		delete it->second;
	}
	this->m_mapScenarioListMap.clear();
}
void ScenarioManager::reset() {
	for( std::map<int, ScenarioList*>::iterator it = this->m_mapScenarioListMap.begin();
		it != m_mapScenarioListMap.end(); it ++ ) 
	{
		it->second->reset();
	}
}

/** 
  * @param[in]	nUserID			[Uw肵ID
  * @param[in]	iScenarioItem	
  *
  */
void ScenarioManager::set( int nUserID, ScenarioList* iScenarioList ) {
	if( this->m_mapScenarioListMap.find( nUserID ) != this->m_mapScenarioListMap.end() ) {
		// ɑ
		// Õf[^͏
		delete this->m_mapScenarioListMap[ nUserID];
	}
	this->m_mapScenarioListMap[nUserID] = iScenarioList;
}

ScenarioList* ScenarioManager::get( int nUserID ) {
	if( this->m_mapScenarioListMap.find( nUserID ) == this->m_mapScenarioListMap.end() ) {
		_ASSERT(0);
	}
	return this->m_mapScenarioListMap[ nUserID];
}

/**
  * @retval	0		
  * @retval	0ȊO	s
  */
int ScenarioManager::load_ScenariosFromOneText( const char* lpszFilePath ) {
	vector<string> lines;

	// t@CSsǂݍ
	TextTool::load_StringLinesFromFile( lpszFilePath, &lines );

	int index = -1;

	bool bIsMissionNumber = true;

	for( vector<string>::iterator it = lines.begin();
		it != lines.end(); it ++ )
	{
		string line = *it;
		if( TextTool::is_SkipLine(line ) ) {
			continue;
		}

		if( line.at(0) == '[' && line.at(line.size() - 1 ) == ']' ) {
			// CfbNX

			// CfbNXԍo
			index = atoi( line.substr(1, line.size() - 2 ).c_str() );

			// VKǉ
			ScenarioList* lst = new ScenarioList();

			// VKǉ
			this->set( index, lst );
		} else if( line.at(0) == '$' ) {
			if( index < 0 ) {
				// ܂CfbNXw肳ĂȂ
				_ASSERT( 0 );
				continue;
			}
			ScenarioList* lst = this->get( index );

			int nType = -1;

			// ߂̍s
			if( line.compare("$TEXT") == 0 ) {
				nType = ScenarioType::TEXT;
			} else if( line.compare( "$IMAGE" ) == 0 ) {
				nType = ScenarioType::IMAGE;
			} else if( line.compare( "$MAP_AND_SCENE" ) == 0 ) {
				nType = ScenarioType::MAP_AND_SCENE;

				bIsMissionNumber = true;
			}

			if( nType < 0 ) {
				_ASSERT( 0 );
				continue;
			}

			ScenarioItem* item = new ScenarioItem();
			item->m_nType = nType;

			lst->add( item );
		} else {
			if( index < 0 ) {
				//
			}
			ScenarioList* lst = this->get(index );

			ScenarioItem* item = lst->get_Last();

			if( item == NULL ) {
				_ASSERT( 0 );
				continue;
			}
			if( item->m_nType == ScenarioType::TEXT ||
				item->m_nType == ScenarioType::IMAGE )
			{
				if( item->m_strTextString.compare("") != 0 ) {
					item->m_strTextString += string("\n");
				}
				item->m_strTextString += line;
			} else if( item->m_nType == ScenarioType::MAP_AND_SCENE ) {
				if( item->m_strTextString.compare("") != 0 ) {
					if( bIsMissionNumber ) {
						item->m_nMissionNumber = atoi( line.c_str());
						bIsMissionNumber = false;
					} else {
						item->m_nSceneNumber = atoi( line.c_str());
					}
				}
			}
		}
	}

	return 0;
}


}

}
