#include "EnemyManager.h"
#include "StaticData.h"
#include <cstdlib>

namespace MotionTest {
using namespace HPL;
using namespace E3D;
using namespace General;
using namespace MotionTestConsts;
using namespace BasicStaticDataConsts;

/**********************************************************************************************
*/
int EnemyManager::move( E3DObject* obj ) {
	int ret= 0;

	// ړO̕
	D3DXVECTOR3 vOldFaceDirection;
	ret = E3DGetCharaDir( obj->m_nSigID, 0,0, &vOldFaceDirection );

	BOOL bGotoPlayer = TRUE;
	if( staticData->is_SkipPlayer(obj) ) {
		bGotoPlayer = FALSE;
	}

	// [V~
	BOOL bStopMotion = FALSE;

	float fSpeedRate = 1.0f;

	if( obj->m_nSigID == staticData->m_nCameraTargetSigID ) {
		// ̓G͑Ώۂ̓Gł

		////////////////////////
		// vC[
		// vC[WASDړ
		//staticData->movePlayer();
		// ړȂ

		// vC[̒e̔
		//staticData->shotPlayer();

		// Gړ

		ret = this->key_Move(obj);

		// ̓GƂ̓蔻
		checkHitToEnemy( obj );
	} else {

		// ݂̃t[ԍ擾
		int motid;
		int frameno;
		ret = E3DGetMotionFrameNo( obj->m_nSigID, &motid, &frameno );

		float fDegXZ = 0;

		// [VĂ邩H
		BOOL bIsContinueMotion = obj->m_nOldEventNumber == obj->m_nEventNumber && motid != 0;

		// ړ
		//E3DPosForward( obj->m_nSigID, PLAYER_RUN_SPEED );

		// ݈ʒu擾
		D3DXVECTOR3 vPosition;
		ret = E3DGetPos( obj->m_nSigID, &vPosition );

		// ݂̕擾(KVelocityɂȂƂ͌Ȃ)
		D3DXVECTOR3 vDirection = vOldFaceDirection;

		// vC[̈ʒu
		D3DXVECTOR3 vTargetPosition;
		ret = E3DGetPos( staticData->m_nCameraTargetSigID, &vTargetPosition );

		// Ԃ̋
		D3DXVECTOR3 vDistance = vTargetPosition - vPosition;
		float fDistance = D3DXVec3Length( &vDistance);

		if( obj->m_Game.m_bRecognized == FALSE ) {
			if( fDistance <= RECOGNIZE_THRESHOLD ) {
				obj->m_Game.m_bRecognized = TRUE;
			}
		} else if( obj->m_Game.m_nType == EnemyType::TROL ) {
			// vC[̕B󋵂ɂĂ̓_ȕɂȂ
			this->rotate_AgainstTarget( obj, staticData->m_nCameraTargetSigID );

		} else if( obj->m_Game.m_nType == EnemyType::CYCLOPS ) {
			// TCNvX

			// vC[̕B󋵂ɂĂ̓_ȕɂȂ
			this->rotate_AgainstTarget( obj, staticData->m_nCameraTargetSigID );

		} else if( obj->m_Game.m_nType == EnemyType::MOSUKO ||
			obj->m_Game.m_nType == EnemyType::MOSUKO_LONG)
		{
			// 
			// Ώۂ̕B󋵂ɂĂ̓_ȕɂȂ

			int eventno = obj->m_nEventNumber;

			// x߂Â牡 or 荞݁B
			float DECIDE_THRESHOLD = 8000.f;

			// vC[炱ꂾꂽꏊڕWn_ɂ
			float GOAL_RADIUS = 3000.f;
			// S[Ƃ̋܂ŗ牡/UɈڍs
			float GOAL_THRESHOLD = 1000.f;

			BOOL bFaceToTarget = FALSE;

			int nFaceMaterial = -1;

			if( eventno == Motion::Mosuko::IDLE ) {
				// RUNɈڍs
				eventno = Motion::Mosuko::RUN;

			} else if( eventno == Motion::Mosuko::RUN ) {

				if( obj->m_Game.m_nMoveType < 0 ) {

					if( fDistance <= DECIDE_THRESHOLD ) {
						obj->m_Game.m_nMoveType = MathTool::nextRandom<int>(0,2);
						if( obj->m_Game.m_nMoveType == 1 ) {
							// ̂܂܉
							obj->m_Game.m_nMoveType = -1;
							eventno = Motion::Mosuko::SIDEWALK;
						} else {
							// 荞

							// GvC[ƂA̕獶E60xt߂ɓ˂

							// vC[Gւ̕
							D3DXVECTOR3 vEnemyToTarget = vTargetPosition - vPosition;

							// y]̂
							vEnemyToTarget.y = 0;

							float BASIC_DEGREE = 60;
							float ERR_DEGREE = 10;
							// E (})60deg + ERR(10deg)]
							D3DXVECTOR3 vRotatedDirection;
							VectorTool::rotateHorizontal( &vRotatedDirection, &vEnemyToTarget, 
								static_cast<float>(MathTool::nextRandom<int>(0,2) * 2 - 1) * BASIC_DEGREE +
								MathTool::nextRandom<float>(-ERR_DEGREE, ERR_DEGREE ));

							// normalize
							D3DXVec3Normalize( &vRotatedDirection, &vRotatedDirection );
							// scale
							D3DXVec3Scale( &vRotatedDirection, &vRotatedDirection, GOAL_RADIUS );

							obj->m_Move.m_vGoalPosition = vTargetPosition + vRotatedDirection;
						}
					}
					bFaceToTarget = TRUE;
					
				} else {
					// S[ڎw
					D3DXVECTOR3 vEnemyToGoal = obj->m_Move.m_vGoalPosition - vPosition;

					// y]̂
					vEnemyToGoal.y = 0;

					float fDistanceToGoal = D3DXVec3Length( &vEnemyToGoal );

					// K
					//D3DXVec3Normalize( &vEnemyToGoal, &vEnemyToGoal );

					// ̕
					staticData->face( -vEnemyToGoal, 2, obj->m_nSigID, obj->m_Move.m_nQuoatanion );

					// ړ
					obj->m_Move.m_vVelocity = vEnemyToGoal;

					// S[ɋ߂Â
					if( fDistanceToGoal <= GOAL_THRESHOLD ) {
						obj->m_Game.m_nMoveType = -1;
						eventno = Motion::Mosuko::SIDEWALK ;
					}
				}



			} else if( eventno == Motion::Mosuko::SIDEWALK ) {

				// 
				staticData->faceToTarget( obj, staticData->m_nCameraTargetSigID, 1 );

				fDegXZ = 90;

				if( fDistance > DECIDE_THRESHOLD ) {
					// Ă܂
					eventno = Motion::Mosuko::RUN;
				} else {
					if( obj->m_Game.m_Counter->step() & CounterStateType::ALL_LOOP_END ){
						// т؂炵

						// JE^Zbg
						obj->m_Game.m_Counter->reset();

						/*if( obj->m_Game.m_nWeaponType == MosukoWeaponType::BOTH ||
							obj->m_Game.m_nWeaponType == MosukoWeaponType::KATANA )
						{*/

							// UɈڂ
						if( MathTool::nextRandom<int>(0,2 ) == 1 ) {
							eventno = Motion::Mosuko::ATTACK_A;
						} else {
							eventno = Motion::Mosuko::GUN;
						}

						// U\
						nFaceMaterial = Material::MOSUKO_KAO_2;
						//}
					}
				}
			} else if( eventno == Motion::Mosuko::ATTACK_A ) {
				bFaceToTarget = TRUE;
				if( bIsContinueMotion && frameno > 32){
					eventno = Motion::Mosuko::ATTACK_B;
				}
			} else if( eventno == Motion::Mosuko::ATTACK_B ) {
				bFaceToTarget = TRUE;
				if( bIsContinueMotion && frameno > 32){
					eventno = Motion::Mosuko::ATTACK_C;
				}
			} else if( eventno == Motion::Mosuko::ATTACK_C ) {
				bFaceToTarget = TRUE;
				if( bIsContinueMotion && frameno > 42){

					eventno = Motion::Mosuko::IDLE;
					nFaceMaterial = Material::MOSUKO_KAO_1;
				}
			} else if( eventno == Motion::Mosuko::GUN ) {
				if( obj->m_Game.m_Counter->step() & CounterStateType::ALL_LOOP_END ) {
					eventno = Motion::Mosuko::IDLE;
					obj->m_Game.m_Counter->reset();
					nFaceMaterial = Material::MOSUKO_KAO_1;
				}
				/*
				if( bIsContinueMotion && frameno > 4){
					eventno = Motion::Mosuko::IDLE;
				}*/
			}

			// 炵΂炭UABC


			if( eventno == Motion::Mosuko::RUN) {
				fSpeedRate = 3.f;
			} else if( eventno == Motion::Mosuko::ATTACK_A ||
				eventno == Motion::Mosuko::ATTACK_B  ||
				eventno == Motion::Mosuko::ATTACK_C )
			{
				fSpeedRate = 0.5f;
			} else if( eventno == Motion::Mosuko::SIDEWALK ) {
				fSpeedRate = 1.8f;

			} else if( eventno == Motion::Mosuko::IDLE ||
				eventno == Motion::Mosuko::GUN ) {
				fSpeedRate = 0;
			} else {
				_ASSERT(0);
			}

			float NEARBY_THRESHOLD = 1200.f;

			if( //eventno == Motion::Mosuko::RUN ||
				eventno == Motion::Mosuko::SIDEWALK ||
				eventno == Motion::Mosuko::ATTACK_A ||
				eventno == Motion::Mosuko::ATTACK_B ||
				eventno == Motion::Mosuko::ATTACK_C
				)
			{
				if( fDistance <= NEARBY_THRESHOLD ) {
					// ߂Â
					// ړ~߂
					fSpeedRate = 0.f;
				}
			}


			if( nFaceMaterial >= 0 ){
				// \ύX
				staticData->set_Texture( obj->m_nSigID, "me", nFaceMaterial , FALSE);
				staticData->set_Texture( obj->m_nSigID, "mayu", nFaceMaterial , FALSE );
				staticData->set_Texture( obj->m_nSigID, "kuchi", nFaceMaterial , FALSE );
			}
			if( bFaceToTarget ) {
				// vC[̕B󋵂ɂĂ̓_ȕɂȂ
				this->rotate_AgainstTarget( obj, staticData->m_nCameraTargetSigID );
			}

			obj->m_nEventNumber = eventno;

		} else if( obj->m_Game.m_nType == EnemyType::ZOMBIE_B ) {

			int eventno = obj->m_nEventNumber ;

			BOOL bFaceToTarget = FALSE;

			float DECIDE_THRESHOLD = 8000.f;

			float ATTACK_THRESHOLD = 3000.f;

			if( eventno == Motion::Zombie_B::RUN ) {
				bFaceToTarget = TRUE;

				if( obj->m_Game.m_nMoveType < 0 && fDistance <= DECIDE_THRESHOLD ) {
					// ߂ÂA܂sj߂ĂȂ

					// sji_j
					obj->m_Game.m_nMoveType = MathTool::nextRandom<int>(0,2 );

				}

				if( fDistance <= ATTACK_THRESHOLD ) {
					if( obj->m_Game.m_nMoveType == 0 ) {
						eventno = Motion::Zombie_B::ATTACK_A;
					} 
				} else if( fDistance <= DECIDE_THRESHOLD ) {
					if( obj->m_Game.m_nMoveType == 1 ) {
						eventno = Motion::Zombie_B::JUMP_ON;
					}
				} else {
					obj->m_Game.m_nMoveType = -1;
				}

			} else if( eventno == Motion::Zombie_B::DEAD ) {
				if( bIsContinueMotion && frameno > 43 )
				{
					// [VωȂ
					bStopMotion = TRUE;

					if( obj->m_Game.m_DeathCounter->step() & CounterStateType::ALL_LOOP_END ) {
						// 
						obj->set_Valid( FALSE );
						E3DSetValidFlag( obj->m_nSigID, -1, FALSE );
					}
				}
			} else if( eventno == Motion::Zombie_B::JUMP_ON ) {
				if( bIsContinueMotion &&
					frameno > 13)
				{
					// 
					// 

					obj->m_Move.m_vVelocity.y = ZOMBIE_B_JUMP_SPEED;

					eventno = Motion::Zombie_B::JUMP_ATTACK;

					obj->m_Move.set_Trigger( TriggerType::ON_THE_GROUND , FALSE );
				}
			} else if( eventno == Motion::Zombie_B::JUMP_ATTACK ) {

				// Ăֈړ
				staticData->set_DirectionToVelocity( obj, 3.f);

				if( bIsContinueMotion &&
					frameno > 68 ) 
				{
					bStopMotion = TRUE;
					if( obj->m_Move.get_Trigger( TriggerType::ON_THE_GROUND ) == TRUE ) {
						// ߂
						eventno = Motion::Zombie_B::IDLE;
					}
				}

			} else if( eventno == Motion::Zombie_B::IDLE ) {
				eventno = Motion::Zombie_B::RUN;
			} else if( eventno == Motion::Zombie_B::AIR_DAMAGE ) {
				if( bIsContinueMotion &&
					frameno > 42 ) 
				{
					// ߂
					eventno = Motion::Zombie_B::IDLE;
				}
			
			} else if( eventno == Motion::Zombie_B::ATTACK_A ) {
				if( bIsContinueMotion &&
					frameno > 97 ) 
				{
					// ߂
					eventno = Motion::Zombie_B::IDLE;
				}
			
			} else {
				_ASSERT(0);
				// jumpon 14
				// jump_attack 69
				// attack 26~98
				// air_damage 43
				eventno = Motion::Zombie_B::RUN;
				bFaceToTarget = TRUE;
			}

			if( bFaceToTarget ) {
				// vC[̕B󋵂ɂĂ̓_ȕɂȂ
				this->rotate_AgainstTarget( obj, staticData->m_nCameraTargetSigID );
			}

			
			obj->m_nEventNumber = eventno;

			if( eventno == Motion::Zombie_B::RUN ) {
				fSpeedRate = 2.f;
			} else if( eventno == Motion::Zombie_B::JUMP_ATTACK ) {
				fSpeedRate = 3.f;
			} else if( eventno == Motion::Zombie_B::ATTACK_A ) {
				fSpeedRate = 1.f;
			} else {
				fSpeedRate = 0.f;
			}
		} else if( obj->m_Game.m_nType == EnemyType::ZOMBIE ) {

			int eventno = obj->m_nEventNumber;

			BOOL bFaceToTarget = FALSE;

			//eventno = Motion::Zombie::WALK;

			const float THRESHOLD = 1000.f;

			
			
			if( eventno == Motion::Zombie::IDLE )  {
				eventno = Motion::Zombie::WALK;

			} else if( eventno == Motion::Zombie::WALK ) {

				bFaceToTarget = TRUE;

				if( obj->m_Game.m_nMoveType < 0 && fDistance <= THRESHOLD ) {
					// ߂ÂA܂sj߂ĂȂ

					// sji_j
					obj->m_Game.m_nMoveType = MathTool::nextRandom<int>(0,3 );

				}

				if( fDistance <= THRESHOLD ) {
					if( obj->m_Game.m_nMoveType == 0 ) {
						eventno = Motion::Zombie::ATTACK_A;
					} else if( obj->m_Game.m_nMoveType == 1 ) {
						eventno = Motion::Zombie::ATTACK_B;
					} else if( obj->m_Game.m_nMoveType == 2 ) {
						eventno = Motion::Zombie::ATTACK_C;
					}
				} else {
					obj->m_Game.m_nMoveType = -1;
				}
			} else if( eventno == Motion::Zombie::ATTACK_A ) {

				if( bIsContinueMotion &&
					frameno > 88 )
				{
					// ړ֖߂
					eventno = Motion::Zombie::WALK;
				}
			} else if( eventno == Motion::Zombie::ATTACK_B ) {
				if( bIsContinueMotion &&
					frameno > 88 )
				{
					eventno = Motion::Zombie::WALK;
				}
			} else if( eventno == Motion::Zombie::ATTACK_C ) {
				if( obj->m_Game.m_nHoldTargetSigID >= 0 ) {
					// ߂܂

					// z[hԂɂ
					eventno = Motion::Zombie::HOLD;

				} else if( bIsContinueMotion &&
					frameno > 88 )
				{
					// U

					// ɖ߂
					eventno = Motion::Zombie::WALK;
				}
			} else if( eventno == Motion::Zombie::HOLD ) {
				// vC[Œ肷
				hold_Player( obj );

				if( bIsContinueMotion &&
					frameno > 88 )
				{
					if( obj->m_Game.m_nHoldTargetSigID >= 0 ) {
						// ̂܂
					} else {
						// łȂ߂
						eventno = Motion::Zombie::WALK;
					}
				}
			} else if( eventno == Motion::Zombie::RELEASE ) {
				if( bIsContinueMotion &&
					frameno > 38 )
				{
					// ړɖ߂
					eventno = Motion::Zombie::WALK;

				}
			} else if( eventno == Motion::Zombie::DEAD ) {
				if( bIsContinueMotion &&
					frameno > 57 )
				{
					bStopMotion = TRUE;

					if( obj->m_Game.m_DeathCounter->step() & CounterStateType::ALL_LOOP_END ) {
						// 
						obj->set_Valid( FALSE );
						E3DSetValidFlag( obj->m_nSigID, -1, FALSE );
					}
				}

				
			}

			if( bFaceToTarget ) {
				// vC[̕B󋵂ɂĂ̓_ȕɂȂ
				this->rotate_AgainstTarget( obj, staticData->m_nCameraTargetSigID );
			}

			obj->m_nEventNumber = eventno;

			if( 
				eventno == Motion::Zombie::ATTACK_A ||
				eventno == Motion::Zombie::ATTACK_B ||
				eventno == Motion::Zombie::ATTACK_C ||
				eventno == Motion::Zombie::DEAD ||
				eventno == Motion::Zombie::IDLE ||
				eventno == Motion::Zombie::HOLD
				) 
			{
				//if( bStopMotion == FALSE ) {
					// Ȃ
					fSpeedRate = 0.f;
				//} else {
					// [V~Ԃł͒ʏʂ蓮
				//	fSpeedRate = 1.f;
				//}

				
			} else {
				fSpeedRate = 0.6f;
			}


		} else if( obj->m_Game.m_nType == EnemyType::WORM_BIG ||
			obj->m_Game.m_nType == EnemyType::WORM_SMALL )
		{
			float THRESHOLD = 10000.f;
			if(obj->m_Game.m_nType == EnemyType::WORM_SMALL ) {
				THRESHOLD = 2000.f;
			}
			int eventno = obj->m_nEventNumber;

			// ݒ
			float fY = obj->m_Move.m_vVelocity.y;
			obj->m_Move.m_vVelocity.x = vDirection.x;
			obj->m_Move.m_vVelocity.z = vDirection.z;
			//obj->m_Move.m_vVelocity.y = 0;
			obj->m_Move.m_vVelocity.y = 0;
			D3DXVec3Normalize( &obj->m_Move.m_vVelocity, &obj->m_Move.m_vVelocity );

			obj->m_Move.m_vVelocity *= obj->m_Move.m_fSpeed;
			obj->m_Move.m_vVelocity.y = fY;

			BOOL bFaceToTarget = FALSE;

			// [
			if( obj->m_nEventNumber == Motion::Worm::MOVE ||
				obj->m_nEventNumber == Motion::Worm::TURN_LEFT ||
				obj->m_nEventNumber == Motion::Worm::TURN_RIGHT )
			{
				// vC[̕
				bFaceToTarget = TRUE;

				if( obj->m_Game.m_nMoveType < 0 && fDistance < THRESHOLD ) {
					obj->m_Game.m_nMoveType = MathTool::nextRandom<int>(0,3);
				}
				if( fDistance < THRESHOLD ) {
					// ߂Â

					if( obj->m_Game.m_nMoveType == 0 ) {
						// オ
						eventno = Motion::Worm::STAND;
						obj->m_Game.m_nMoveType = -1;
					} else if( obj->m_Game.m_nMoveType == 1 ){
						// ːi
						eventno = Motion::Worm::BRITS;
						obj->m_Game.m_nMoveType = -1;
					} else if( obj->m_Game.m_nMoveType == 2){
						// 
						eventno = Motion::Worm::DIVE;
						// 
						obj->m_Game.m_nMoveType = -1;

						// pJE^
						obj->m_Game.m_Counter->reset();
					}

				} else if( fDistance > THRESHOLD ) {
					// 

					// sjZbg
					obj->m_Game.m_nMoveType = -1;
					
				}
			} else if( obj->m_nEventNumber == Motion::Worm::DIVE ||
				obj->m_nEventNumber == Motion::Worm::DOWN_DIVE )
			{
				int nMax = 58;
				if( obj->m_nEventNumber == Motion::Worm::DOWN_DIVE ) {
					nMax = 68;
				}
				if( motid != 0 && frameno > nMax ) {
					// 肫
					
					/*if( obj->m_Game.m_nMoveType < 0 && fDistance < THRESHOLD) {
						// ߂ÂāAs肵ĂȂ
						//obj->m_Game.m_nMoveType = MathTool::nextRandom<int>(0,2);
						obj->m_Game.m_nMoveType = 0;
					}*/

					/*if( obj->m_Game.m_nMoveType == 0 && fDistance < THRESHOLD ) {
						// ߂Â

						// o
						eventno = Motion::Worm::APPEAR;

					} else */if(// obj->m_Game.m_nMoveType == 0 &&
						fDistance < THRESHOLD / 6 ){
						// Ƌ߂Â
						// U
						eventno = Motion::Worm::ATTACK_B;
						bStopMotion = TRUE;

					} else {
						// ܂߂ɋȂ

						// Ƃ肠̂܂ܐq
						bStopMotion = TRUE;

						// vC[̕
						bFaceToTarget = TRUE;

						// 莞ԂoĂ
						if( obj->m_Game.m_Counter->step() & CounterStateType::ALL_LOOP_END ) {
							obj->m_Game.m_Counter->reset();

							eventno = Motion::Worm::APPEAR;
						}
					}
				}
			} else if( obj->m_nEventNumber == Motion::Worm::APPEAR ) {
				if( motid != 0 && motid != 5 && motid!= 9 && frameno > 58 ) {
					eventno = Motion::Worm::MOVE;
				}
			} else if( obj->m_nEventNumber == Motion::Worm::ATTACK_A ) {
				// Ԃ犚ݕtU

				if( motid != 0 && frameno > 48 ) {
					if( fDistance < THRESHOLD ) {
						// U
						eventno = Motion::Worm::ATTACK_A;

						// vC[̕
						bFaceToTarget = TRUE;
					} else {
						// ԂMOVEֈڂ
						eventno = Motion::Worm::DOWN;
					}
				}
			} else if( obj->m_nEventNumber == Motion::Worm::DOWN ) {
				if( motid != 0 && frameno > 28 ) {
					// ʏ
					eventno = Motion::Worm::MOVE;

				}
			} else if( obj->m_nEventNumber == Motion::Worm::ATTACK_B ) {
				// nݍݍU
				if( motid != 0 && motid == 11 && frameno > 58 ) {
					// ʏ
					eventno = Motion::Worm::MOVE;
				}
			} else if( obj->m_nEventNumber == Motion::Worm::BRITS ) {
				// ːiݕt
				if( motid != 0 && frameno > 58 ) {
					// ʏ
					eventno = Motion::Worm::MOVE;
				}
			} else if( obj->m_nEventNumber == Motion::Worm::STAND ) {
				if( motid != 0 && frameno > 38 ) {
					if( fDistance < THRESHOLD * 2.f ) {
						// U
						eventno = Motion::Worm::ATTACK_A;
					} else {
						// ܂
						eventno = Motion::Worm::DOWN_DIVE;
					}
				}
			} else if( obj->m_nEventNumber == Motion::Worm::DEAD ) {
				if( motid != 0 && frameno > 88 ) {
					// Ȃ
					bStopMotion = TRUE;


					// TODO {Xdlɂ
					if( obj->m_Game.m_DeathCounter->step() & CounterStateType::ALL_LOOP_END ) {
						// 
						obj->set_Valid( FALSE );
						E3DSetValidFlag( obj->m_nSigID, -1, FALSE );
					}
				}
			} else if( obj->m_nEventNumber == Motion::Worm::SWALLOW ) {

				// vC[Œ肷
				hold_Player( obj );

				if( motid != 0 ) {
					if( frameno > 438 ) {
						// [VI

						// Ȃ
						bStopMotion = TRUE;

					} else if( frameno == 200 && staticData->m_aryOptionList[ TitleSceneConsts::CheckType::TRANSPARENT_]) {
						// ɂȂ
						int mat = 0;
						ret = E3DGetMaterialNoByName( obj->m_nSigID, "worm", &mat );
						ret = E3DSetMaterialAlpha( obj->m_nSigID, mat, 0.8f);
					} 
				}
			} else if( obj->m_nEventNumber == Motion::Worm::IDLE ){
				eventno = Motion::Worm::MOVE;//obj->m_nEventNumber;

			} else {
				_ASSERT(0);

			}

			if( bFaceToTarget ) {
				// vC[̕B󋵂ɂĂ̓_ȕɂȂ
				this->rotate_AgainstTarget( obj, staticData->m_nCameraTargetSigID );
			}

			obj->m_nEventNumber = eventno;

			if( eventno == Motion::Worm::BRITS ) {
				// ړxAbv
				fSpeedRate = 2.f;
			} else if( 
				//eventno == Motion::Worm::ATTACK_A ||
				eventno == Motion::Worm::APPEAR ||
				eventno == Motion::Worm::ATTACK_B ||
				eventno == Motion::Worm::DIVE ||
				eventno == Motion::Worm::DOWN_DIVE ||
				eventno == Motion::Worm::IDLE ||
				eventno == Motion::Worm::STAND ||
				eventno == Motion::Worm::VOMIT || 
				eventno == Motion::Worm::DOWN ) 
			{
				if( bStopMotion == FALSE ) {
					// Ȃ
					fSpeedRate = 0.f;
				} else {
					// [V~Ԃł͒ʏʂ蓮
					fSpeedRate = 1.f;
				}

				
			} else if( eventno == Motion::Worm::DEAD ||
				eventno == Motion::Worm::SWALLOW ) {
				fSpeedRate = 0;
			}

		}

		D3DXVECTOR3 vNewFaceDirection;
		ret = E3DGetCharaDir( obj->m_nSigID, fDegXZ ,0, &vNewFaceDirection );

		vOldFaceDirection.y = 0;
		vNewFaceDirection.y = 0;


		// Y0ɂ
		float fY = obj->m_Move.m_vVelocity.y;
		obj->m_Move.m_vVelocity.y = 0;
		//vDirection.y = 0;

		// K
		D3DXVec3Normalize( &obj->m_Move.m_vVelocity, &obj->m_Move.m_vVelocity );

		// Scale
		obj->m_Move.m_vVelocity *=  obj->m_Move.m_fSpeed * fSpeedRate ;

		// Wv̏̂߁AY͕ۑĂ̂𗘗p
		obj->m_Move.m_vVelocity.y = fY;

		// Add
		vPosition += obj->m_Move.m_vVelocity;

		// ʒuɐݒ
		ret = E3DSetPos( obj->m_nSigID, vPosition );
		obj->m_Move.m_vPosition = vPosition;
	}

	// [VύX
	if( bStopMotion == FALSE ) {
		int eventno = 0;

		if( obj->m_Game.m_nType == EnemyType::CYCLOPS ) {
			eventno = 1;
		} else //if( obj->m_Game.m_nType == EnemyType::WORM_BIG ||
			//obj->m_Game.m_nType == EnemyType::WORM_SMALL 
			//)
		{
			eventno = obj->m_nEventNumber;


			
		}
		// eXg
		for(int i = 0; i < 12; i ++ ) {
			int nKey = '1' + i - 4;
			if( staticData->get_CurrentKeyBuffer(nKey ) ) {
				eventno = i;
			}
		}
	
		obj->m_nEventNumber = eventno;
		ret = E3DSetNewPoseByMOA( obj->m_nSigID, eventno );
		if( ret ){
			_ASSERT( 0 );
			return 1;
		}
	}

	obj->m_nOldEventNumber = obj->m_nEventNumber;

	return 0;
}

void EnemyManager::hold_Player( E3DObject* obj ) {
	// vC[Œ肷

	// G̈ʒu
	D3DXVECTOR3 vPos;
	E3DGetPos( obj->m_nSigID, &vPos );



	// 낦
	D3DXVECTOR3 vDir;
	E3DGetCharaDir(obj->m_nSigID, 0,0, &vDir );

	// 炷
	D3DXVECTOR3 vDelta(0,0,0);
	if( obj->m_Game.m_nType == EnemyType::ZOMBIE ) {

		// ]r̕ɂ
		vDelta = D3DXVECTOR3( vDir.x, 0, vDir.z );

		D3DXVec3Normalize( &vDelta, &vDelta ) ;
		// 
		vDelta *= ZOMBIE_HOLD_DISTANCE;

	} else if( obj->m_Game.m_nType == EnemyType::WORM_BIG ||
		obj->m_Game.m_nType == EnemyType::WORM_SMALL ) 
	{
	}

	// ʒuݒ
	E3DSetPos( staticData->get_Player()->m_nSigID, vPos + vDelta );

	// 
	if( obj->m_Game.m_nType == EnemyType::ZOMBIE ) {
	} else if( obj->m_Game.m_nType == EnemyType::WORM_BIG ||
		obj->m_Game.m_nType == EnemyType::WORM_SMALL ) 
	{
		vDir *= -1;
	}

	// ݒ
	staticData->face( vDir, 1, staticData->get_Player()->m_nSigID, staticData->get_Player()->m_Move.m_nQuoatanion );
}

}
