#include "EnemyManager.h"
#include "StaticData.h"
#include <cstdlib>

namespace MotionTest {
using namespace HPL;
using namespace E3D;
using namespace General;
using namespace MotionTestConsts;
using namespace BasicStaticDataConsts;

int EnemyManager::key_Move( HPL::E3D::E3DObject* obj ) {
	int ret = 0;
	//////////////////////////////
	// vC[̈ړ
	D3DXVECTOR3 vCameraPosition;
	E3DGetCameraPos( & vCameraPosition );

	D3DXVECTOR3 vPlayerPosition;
	E3DGetPos( obj->m_nSigID, &vPlayerPosition );

	// 
	D3DXVECTOR3 vDiff = vPlayerPosition - vCameraPosition;

	// ŒH
	BOOL bSTRAIF = FALSE;

	if( obj->m_Game.m_nType != EnemyType::TROL ) {
		_ASSERT(0);
	}

	if( staticData->get_CameraMode() == CameraMode::SHOT_BEHIND_MODE ) 
	{
		// Œ
		bSTRAIF = TRUE;

		// ˌ[h̓vC[TuTeCgiƏjւ̕{Ƃ

		D3DXVECTOR3 vSatellitePosition ;

		staticData->get_Camera()->get_SatellitePosition( vPlayerPosition,
			&vSatellitePosition );
		vDiff = vSatellitePosition - vPlayerPosition;

	} else if( staticData->get_CameraMode() == CameraMode::SNIPER_MODE ) {
		// Œ
		bSTRAIF = TRUE;

		// ȂۂƎˌ[h̓vC[ڕWւ̕{Ƃ

		D3DXVECTOR3 vSatellitePosition ;

		staticData->get_Camera()->get_SatellitePosition( vPlayerPosition,
			&vSatellitePosition );
		vDiff = vSatellitePosition - vPlayerPosition;
	}

	// Y͐
	vDiff.y = 0;

	// ŏIIȕ
	D3DXVECTOR3 vFinalDirection(0,0,0); 

	// ړH
	BOOL bToMove = FALSE;

	// ݂̃t[No擾
//	int motid;
//	int frameno;
	//ret = E3DGetMotionFrameNoML( obj->m_nSigID, obj->m_nUpperBoneNumber, &motid, &frameno );

	// LN^[ړ
	if( staticData->get_CurrentKeyBuffer( 'W' ) != 0 ) {
		bToMove = TRUE;

		// ̂܂܂̕֌Ĉړ
		D3DXVECTOR3 vDirection = vDiff;

		vFinalDirection += vDiff;

	}
	if( staticData->get_CurrentKeyBuffer( 'S' ) != 0 ) {
		bToMove = TRUE;
		
		// t
		D3DXVECTOR3 vDirection = vDiff * -1;

		vFinalDirection += vDirection;

	}
	if( staticData->get_CurrentKeyBuffer( 'D' ) != 0 ) {
		bToMove = TRUE;

		// 90x]֌違ړ
		D3DXMATRIX matrix;									//}gNXp
		D3DXMatrixRotationY( &matrix, D3DXToRadian( 90) );

		D3DXVECTOR3 vDirection;
		D3DXVec3TransformCoord( &vDirection, &vDiff, &matrix );

		vFinalDirection += vDirection;

	}
	if( staticData->get_CurrentKeyBuffer( 'A' ) != 0 ) {
		bToMove = TRUE;

		// E90x]֌違ړ
		D3DXMATRIX matrix;									//}gNXp
		D3DXMatrixRotationY( &matrix, D3DXToRadian( -90) );

		D3DXVECTOR3 vDirection;
		D3DXVec3TransformCoord( &vDirection, &vDiff, &matrix );

		vFinalDirection += vDirection;

	}

	///////////////////////////
	/// [VύX
	int eventno = obj->m_nEventNumber;

	if(bToMove == TRUE) {

		// w肵NH[^jIɃZbg
		if( bSTRAIF ) {
			// ˌ[hȂǁAOŒ
			staticData->face( -1 * vDiff, PLAYER_ROTATE_DIVISION, obj->m_nSigID,
				obj->m_Move.m_nQuoatanion);
		} else {
			// O㍶EɃvC[
			staticData->face( -1 * vFinalDirection, PLAYER_ROTATE_DIVISION, obj->m_nSigID,
				obj->m_Move.m_nQuoatanion);
		}

		float fSpeed = PLAYER_WALK_SPEED;


		eventno = Motion::Trol::WALK;

		if( !staticData->get_CurrentKeyBuffer(VK_SHIFT )  &&
			staticData->is_Runnable() == TRUE)
		{
			fSpeed = PLAYER_RUN_SPEED;
		}else {
		}

		// w肵ֈړ
		D3DXVECTOR3 vOldVelocity = obj->m_Move.m_vVelocity;

		D3DXVECTOR3 vVelocity = staticData->move( 
			vFinalDirection, fSpeed , 
			obj->m_Move.m_vPosition,
			&obj->m_Move.m_vPosition);
		E3DSetPos( obj->m_nSigID, obj->m_Move.m_vPosition );
		obj->m_Move.m_vVelocity.x = vVelocity.x;
		obj->m_Move.m_vVelocity.z = vVelocity.z;

		// ݂Ǝ̂ŊOς߁AEɉɉf
		D3DXVECTOR3 vOutterProduct;
		D3DXVec3Cross( &vOutterProduct, &vOldVelocity, &obj->m_Move.m_vVelocity );
//		nRotateY = MathTool::get_Sgn<float, int>( vOutterProduct.y );

		// ʒuݒ
		ret = E3DGetPos( obj->m_nSigID, &obj->m_Move.m_vPosition);
		if(ret ) {
			_ASSERT(0);
			return ret;
		}

	
	} else if( obj->m_Move.get_Trigger( TriggerType::ON_THE_GROUND ) ) {
		eventno = Motion::Trol::IDLE;
	}

	if( obj->m_Move.get_Trigger( TriggerType::ON_THE_GROUND ) ) {
		// nʂɋ
		if( staticData->get_CurrentKeyBuffer(VK_SPACE ) && staticData->get_PreviousKeyBuffer( VK_SPACE ) == 0 ) {
			// nʂɂƂɃWv{^

			// x
			obj->m_Move.m_vVelocity.y = PLAYER_JUMP_ACCEL_Y;

			// イ  
			obj->m_Move.set_Trigger( TriggerType::ON_THE_GROUND, FALSE );

			// ړ
			obj->m_Move.m_vPosition += obj->m_Move.m_vVelocity;
			E3DSetPos( obj->m_nSigID, obj->m_Move.m_vPosition );
		}
	} else {
		// 󒆂ɋ
		if( obj->m_Move.m_vVelocity.y > 0.f) {
			// ㏸
			eventno = Motion::Trol::JUMP_UP;

		} else {
			eventno = Motion::Trol::JUMP_DOWN;
		}
		if(obj->m_Move.m_bJumpAccelable ){
			// Wv\
			if( staticData->get_CurrentKeyBuffer( VK_SPACE ) == 0) {
				// {^𗣂
				obj->m_Move.m_bJumpAccelable = ( FALSE );
			}else if( obj->m_Move.m_vVelocity.y > PLAYER_JUMP_SPEED_Y ) {
				// ōxɒB
				obj->m_Move.m_bJumpAccelable = ( FALSE );
			}else {
				// Wv
				obj->m_Move.m_vVelocity.y += PLAYER_JUMP_ACCEL_Y;
				// ړ
				obj->m_Move.m_vPosition += obj->m_Move.m_vVelocity;
				E3DSetPos( obj->m_nSigID, obj->m_Move.m_vPosition );
			}
		}
	}


	// U
	DIMOUSESTATE2* mouse = staticData->get_DIMouse()->get_CurrentState();
//	DIMOUSESTATE2* previousMouse = staticData->get_DIMouse()->get_PreviousState();

	if( mouse->rgbButtons[0] ) {
		// U[V
		eventno = Motion::Trol::ATTACK;
	}

	// [VύX
	obj->m_nEventNumber = eventno;

	return 0;
}
}
