#include "EnemyModeScene.h"

#include "StaticData.h"

namespace MotionTest {
using namespace HPL ;
using namespace E3D ;
using namespace General;
using namespace MotionTestConsts;
using namespace BasicStaticDataConsts;


EnemyModeScene::EnemyModeScene() : AbstractScene() {
}
EnemyModeScene::~EnemyModeScene() {
}

void EnemyModeScene::init() {
	int ret = 0;

	// wi
	ret = E3DCreateBG( staticData->get_SwapChainID(), "Media\\sea03.png", "hoge", 0, 0, 0, 20000 );

	// }EX͎RɓȂ
	staticData->set_Grab( TRUE );

	// n`eXgtB[hɂ
	staticData->set_GroundType( GroundType::TEST) ;

	// vC[
	BOOL bIsHPMax = TRUE;
	staticData->reset_Player( bIsHPMax );

	// BGMύX
	staticData->set_BGMIndex( Sound::TROL );

	// 
	for(int i = 0; i < Parts::MAX_NUM; i ++ ) {
		staticData->m_aryPartsValidList[i] = TRUE;
		ret = E3DSetValidFlag( staticData->m_aryPlayerList[PlayerType::EVIGEN].m_nSigID,
			staticData->m_aryPartsIndexList[i], staticData->m_aryPartsValidList[i] );
		if(ret ) {
			_ASSERT(0);
		}
	}

	staticData->get_Player()->m_nEventNumber = 0;
	staticData->get_Player()->m_nUnderEventNumber = -1;

	{
		int baseList[] = {
			-1,
			0
		};
		int baseNoList[] = {
			0
		};
		int eventno = staticData->get_Player()->m_nEventNumber;
		ret = E3DSetMOAEventNoML( staticData->get_Player()->m_nSigID, eventno,
			baseList, baseNoList );
		if( ret ){
			_ASSERT( 0 );
			return ;
		}
		ret = E3DSetNewPoseML( staticData->get_Player()->m_nSigID );
		if( ret ){
			_ASSERT( 0 );
			return ;
		}
	}

	// 
	staticData->m_EnemyManager.reset();
	staticData->m_ShotManager.reset();
	staticData->m_NeutralManager.reset();

	// 삷GI
	m_Enemy = staticData->m_EnemyManager.search( EnemyType::TROL );

	// _𑀍삷G𐳖ʂ猩ʒuɕς
	staticData->set_CameraInFrontOfObject( m_Enemy->m_nSigID, 0 );

	// _GSɂ
	staticData->m_nCameraTargetSigID = m_Enemy->m_nSigID;

	// Gzu
	ret = E3DSetPosOnGround( m_Enemy->m_nSigID, staticData->get_GroundSigID(), 
		MAP_HEIGHT, MAP_MIN, 10000, 10000 );
	if( ret ) {
		_ASSERT(0);
	}

	// ɂ
	int mat = -1;
	/*
	// TCNvX
	ret = E3DGetMaterialNoByName( m_Enemy->m_nSigID, "Material.001 _Untitled", &mat );
	if( ret ) {
		_ASSERT( 0 );
		return ;
	}*/
	// [

	/*	// ɂ
	ret = E3DGetMaterialNoByName( m_Enemy->m_nSigID, "Material.001 _Untitled", &mat );
	if( ret ) {
		_ASSERT(0);
	}
	ret = E3DSetMaterialAlpha( m_Enemy->m_nSigID, mat, 0.8f);
	if( ret ) {
		_ASSERT(0);
	}*/


	// Xqo
	for( int i = 0; i < MOSUKO_MAX; i ++ ) {
		E3DObject* obj = staticData->m_EnemyManager.search( EnemyType::MOSUKO );
		obj = staticData->m_EnemyManager.search( EnemyType::MOSUKO_LONG );
	}
}
void EnemyModeScene::process() {
	int ret = 0;

	// LN^[̈ړ
	ret = this->frameMove();
	if( ret ){
		_ASSERT( 0 );
		return ;
	}

	// `擙
	ret = this->render();
	if( ret ){
		_ASSERT( 0 );
		return ;
	}
}
void EnemyModeScene::quit() {
	// _vC[Sɖ߂
	staticData->m_nCameraTargetSigID = staticData->get_Player()->m_nSigID;
	int mat;
	int ret = 0;
	ret = E3DGetMaterialNoByName( m_Enemy->m_nSigID, "Material.001 _Untitled", &mat );
	if(ret){
		_ASSERT(0);
	}
	ret = E3DSetMaterialAlpha( m_Enemy->m_nSigID, mat, 1.f);
	if(ret){
		_ASSERT(0);
	}
}

//! `
int EnemyModeScene::drawText() {
	int ret = 0;
	float zoom = 1;

	ret = E3DTool::drawText(
		10, 10,			//pos XY
		255, 255, 255, 255,	//col RGBA
		zoom,				// zoom
		"FPS:%d", staticData->get_FPS() );
	if( ret ) {
		_ASSERT( 0 );
		return ret;
	}
	return 0;
}

//! _O
int EnemyModeScene::render() {

	int ret = 0;

	// nʂ̃`FbNC
	ret = staticData->checkInGround();
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}

	/////////////////////////////////////////
	// vC[֘A
	// vC[f`FbNC
	int status;
	if( E3DChkInView( staticData->get_SwapChainID(), staticData->get_Player()->m_nSigID, &status ) ){
		_ASSERT( 0 );
		return 1;
	}

	// nʂƂ̐ڐG
	ret = staticData->checkPlayerOnGround();
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}

	/////////////////////////////////////////
	// et`
	staticData->renderWithShadow( TRUE, TRUE, FALSE, FALSE );

	/////////////////////////////////////////
	// V[`Jn
	ret = E3DBeginScene( staticData->get_SwapChainID(), 1 );//skipflag 
	if( ret ) { 
		_ASSERT( 0 );
		return 1;
	}

		//////////////
		// G̈ړƕ`
		ret = staticData->m_EnemyManager.process();

		///////////////
		// Sr{[h`
		ret = E3DRenderBillboard( staticData->get_SwapChainID(), 0 );
		if( ret ) {
			_ASSERT( 0 );
			return ret;
		}

		//////////
		// XvCg\
		ret = E3DBeginSprite();
		ret = E3DEndSprite();

		// `
		this->drawText();
		staticData->afterRenderCommon();
	if( E3DEndScene() ) {
		_ASSERT( 0 );
		return 1;
	}
	return 0;
}

//! t[Ƃ̈ړ
int EnemyModeScene::frameMove() {

	int ret = 0;


	if( staticData->is_Pause() == FALSE ) {
		// [Vω
		ret = staticData->updatePlayerMotion();
		staticData->move_BillBoard();

	}

	DIMOUSESTATE2* mouse = staticData->get_DIMouse()->get_CurrentState();
	DIMOUSESTATE2* mousePreious = staticData->get_DIMouse()->get_PreviousState();

	///////////////////////////////
	// Jړ
	ret = staticData->moveCamera();
	if( ret ) {
		_ASSERT( 0 );
		return ret;
	}

	return 0;
}


}
