#include "StaticData.h"

namespace MotionTest {
using namespace MotionTestConsts;
using namespace HPL;
using namespace E3D;
using namespace BasicStaticDataConsts;

/*int StaticData::renderObjectList( std::list<E3DObject*> *lstObjectList ) {
	int ret = 0;
	for( std::list<E3DObject*>::iterator it = lstObjectList->begin();
		it != lstObjectList->end();
		it ++ )
	{
		E3DObject* obj = *it;

		ret = E3DRender( this->get_SwapChainID(), obj->m_nSigID,
			0, 1, 0, 0 );
		ret = E3DRender( this->get_SwapChainID(), obj->m_nSigID,
			1, 1, 0, 0 );
	}
	return 0;
}*/

/** eNX`ύX
  * @param[in]	nSigID			SIG id
  * @param[in]	lpszMaterialName	\tގ
  * 
  */
int StaticData::set_Texture( int nSigID, const char* lpszMaterialName, int nMaterial , BOOL bIsPlayerMaterial) {
	int ret = 0;
	int matid = 0;
	ret = E3DGetMaterialNoByName( nSigID, 
		lpszMaterialName, &matid );
	if( ret ) {
		_ASSERT( 0 );
		return ret;
	}
	if( bIsPlayerMaterial && this->m_nPlayerType == PlayerType::EVIGEN) {
		this->m_nPlayerMaterialIndex = nMaterial;
	}
	ret = E3DSetTextureToMaterial( nSigID, matid, this->m_aryMaterials[nMaterial] );
	if( ret ) {
		_ASSERT( 0 );
		return ret;
	}
	return 0;
}

void StaticData::set_MaterialAlpha( int nSigID, const char* lpczPartName, float* fTargetAlpha, float fStepAlpha) {

	int ret = 0;

	float fNewAlpha = *fTargetAlpha;

	fNewAlpha += fStepAlpha;
	if( fNewAlpha < 0 ) {
		fNewAlpha = 0;
	}
	if( fNewAlpha > 1.f ) {
		fNewAlpha = 1;
	}
	if( fNewAlpha != *fTargetAlpha) {
		*fTargetAlpha = fNewAlpha;

		// x
		int mat = 0;
		ret = E3DGetMaterialNoByName( this->get_Player()->m_nSigID, lpczPartName, &mat );
		if( ret ) {
			_ASSERT( 0 );
			return ;
		}
		ret = E3DSetMaterialAlpha( this->get_Player()->m_nSigID, mat, fNewAlpha);
		if( ret ) {
			_ASSERT( 0 );
			return ;
		}
	}
}
/** MOAt@Cǂݍ
  *
  */
int StaticData::loadMOAFile( const char* lpszFilePath, E3DObject* obj, float fZoom ) {

	int ret = 0;
	// ǂݍ
	ret = E3DLoadMOAFile( obj->m_nSigID,
		lpszFilePath,
		5, fZoom);
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}

	int nNumberOfMotion = 0;
	ret = E3DGetMoaInfo( obj->m_nSigID, MAX_MOTION,//GEnum::Motion::Evigen::MAX_NUM,
		obj->m_moaMOAArray , &nNumberOfMotion);
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}
	return 0;

}
int StaticData::draw_Scenario(HPL::E3D::ScenarioItem *item) {
	int ret = 0;

	if( item != NULL ) {
		RECT rClientRect;
		staticData->get_ClientRect( &rClientRect );
		int nClientHeight = rClientRect.bottom - rClientRect.top;
		int nClientWidth = rClientRect.right - rClientRect.left;

		// bZ[Wt[\
		int nMessageFrameSpriteW;
		int nMessageFrameSpriteH;
		int nMessageFrameLeft;
		int nMessageFrameTop;
		{
			const int MESSAGE_FRAME_MERGINE_Y = 10;
			int nSpriteID = this->m_SpriteIndexManager.get( Sprite::MESSAGE_FRAME );
			ret = E3DGetSpriteSize( nSpriteID, 
				&nMessageFrameSpriteW, &nMessageFrameSpriteH );
			nMessageFrameLeft = nClientWidth / 2 - nMessageFrameSpriteW / 2;
			nMessageFrameTop = nClientHeight - nMessageFrameSpriteH - MESSAGE_FRAME_MERGINE_Y;

			ret = E3DRenderSprite( nSpriteID,
				1, 1, D3DXVECTOR3(static_cast<FLOAT>(nMessageFrameLeft),
				static_cast<FLOAT>(nMessageFrameTop), 0.1f ) );
		}

		if( item->m_nType == ScenarioType::TEXT ||
			item->m_nType == ScenarioType::IMAGE )
		{
			// bZ[W\
			const int LEFT_TEXT_DELTA = 10;
			const int TOP_TEXT_DELTA = 10;
			// \
			ret = E3DTool::drawTextWithFont(
				nMessageFrameLeft + LEFT_TEXT_DELTA, nMessageFrameTop +TOP_TEXT_DELTA,			//pos XY
				50, 50, 200, 255,	//col RGBA
				this->get_SwapChainID(),
				this->get_FontID(),
				item->m_strTextString.c_str()
				);
		} else if( item->m_nType == ScenarioType::MAP_AND_SCENE ) {
			if( item->m_nSceneNumber >= 0 ) {
				this->m_SceneManager.set_Scene( item->m_nSceneNumber ) ;
			}
		}
	}
	return 0;
}

}