#include "SelectMissionScene.h"
#include "StaticData.h"

namespace MotionTest {
using namespace HPL;
using namespace General;
using namespace MotionTestConsts;
using namespace std;

SelectMissionScene::SelectMissionScene() : AbstractScene(){

	// y[W1
	vector<string> vecStrings;
	vecStrings.push_back(string( "vNeBX@F@Ɋ悤iȗ\j" ) );
	vecStrings.push_back(string( "TCNvX@FƂb̈ڏmnɁIH\n@@@@@@@@ނ𒾖ق" ) );
	vecStrings.push_back(string( "[̑QIF[rB\n@@@@@@@@eʂǂɂ͂B" ) );
	vecStrings.push_back(string( "]r@@FAr₦nɐ\n@@@@@@@@(eXgF[̐êݓo)" ) );
	vecStrings.push_back(string( "uтPv@F̐̂𓝎lH\n@@@@@@@@ڐG(eXgF[̂ݓo)" ) );
	m_vecMissionTextList.push_back(vecStrings );
	// y[W2
	vecStrings.clear();
	vecStrings.push_back(string( "[т͂@@F[тƂĂȂ\n@@@@@@@@ieXgF]r̂ݓoj" ) );
	vecStrings.push_back(string( "т̂F̂킢B߂Ă\n@@@@@@@@TĎEȂ" ) );
	vecStrings.push_back(string( "Bs@@@Fт̋ꏊ˂~߂\n@@@@@@@@ieXgF]râݓoj" ) );
	vecStrings.push_back(string( "˔j@@@@FтƍĊHo" ) );
	vecStrings.push_back(string( "̋@@@@@FnɋA҂" ) );
	m_vecMissionTextList.push_back(vecStrings );

	this->m_nCurrentPage = 0;
	this->m_nMaxPage = static_cast<int>(m_vecMissionTextList.size());

	this->m_bIsSelectedPrevious = FALSE;
	this->m_bIsSelectedNext = FALSE;
}
SelectMissionScene::~SelectMissionScene() {
	for( vector< vector< string> >::iterator vit = this->m_vecMissionTextList.begin();
		vit != this->m_vecMissionTextList.end();
		vit ++ )
	{
		vit->clear();
	}
}

void SelectMissionScene::init() {
	int ret = 0;

	staticData->set_Grab( FALSE );
	staticData->set_Pause( FALSE );
	// _jX[
	staticData->set_GroundType( GroundType::DANIMOTH_ROOM );
}
void SelectMissionScene::process() {
	int ret = 0;

	// LN^[̈ړ
	ret = this->frameMove();
	if( ret ){
		_ASSERT( 0 );
		return ;
	}

	// `擙
	ret = this->render();
	if( ret ){
		_ASSERT( 0 );
		return ;
	}
}
void SelectMissionScene::quit() {
}

//! `
int SelectMissionScene::drawText() {
	return 0;
}

//! _O
int SelectMissionScene::render() {
	int ret = 0;

	// nʂ̃`FbNC
	ret = staticData->checkInGround();
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}

	/////////////////////////////////////////
	// vC[֘A
	// vC[f`FbNC
	int status;
	if( E3DChkInView( staticData->get_SwapChainID(), staticData->get_Player()->m_nSigID, &status ) ){
		_ASSERT( 0 );
		return 1;
	}

	// nʂƂ̐ڐG
	ret = staticData->checkPlayerOnGround();
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}

	/////////////////////////////////////////
	// et`
	staticData->renderWithShadow( TRUE, TRUE, FALSE, FALSE );

	/////////////////////////////////////////
	// V[`Jn
	ret = E3DBeginScene( staticData->get_SwapChainID(), 1 );//skipflag 
	if( ret ) { 
		_ASSERT( 0 );
		return 1;
	}


		//////////
		// XvCg\
		ret = E3DBeginSprite();

			// NCAg̈̃TCY擾
			RECT rClientRect;
			staticData->get_ClientRect( &rClientRect );
			int nClientHeight = rClientRect.bottom - rClientRect.top;
			int nClientWidth = rClientRect.right - rClientRect.left;

			// ^Cg\
			int nTitleSpriteW;
			int nTitleSpriteH;
			int nTitleTop = nClientHeight / 20;
			{
				ret = E3DGetSpriteSize( staticData->m_SpriteIndexManager.get( Sprite::SELECT_MISSION ), 
					&nTitleSpriteW, &nTitleSpriteH );
				int nLeft = nClientWidth / 2 - nTitleSpriteW / 2;

				ret = E3DRenderSprite( staticData->m_SpriteIndexManager.get( Sprite::SELECT_MISSION),
					1, 1, D3DXVECTOR3(static_cast<FLOAT>(nLeft),
					static_cast<FLOAT>(nTitleTop), 0.0f ) );
			}

			POINT p;

			this->m_nSelectedButton = -1;

			GetCursorPos( &p);
			ScreenToClient( staticData->get_WindowHandle(), 
				&p );
			int nSpriteW;
			int nSpriteH;
			// ~bV{^\
			// {^
			{
				const int MISSION_NUM = 5;

				int nSpriteID = staticData->m_SpriteIndexManager.get( Sprite::MISSION_FRAME );
				ret = E3DGetSpriteSize( nSpriteID, 
					&nSpriteW, &nSpriteH );
				int nLeft = nClientWidth / 2 - nSpriteW / 2;
				int nInterval = static_cast<int>(nSpriteH + 1.f );
				int nTop = static_cast<int>(nClientHeight / 20 + nTitleSpriteH + 5.f);


				for(int i = 0; i < MISSION_NUM && i < static_cast<int>(this->m_vecMissionTextList[m_nCurrentPage].size()); i ++ ) {
					int nTopNow = nTop + i * nInterval;
					if( staticData->set_MouseOverSpriteColor(
						nSpriteID, p.x, p.y, nLeft, nTopNow, nSpriteW, nSpriteH, 
						255,100,100,230, 255,255,255, 230 ) )
					{
						this->m_nSelectedButton = i;
					}
					ret = E3DRenderSprite( nSpriteID,
						1, 1, D3DXVECTOR3(static_cast<FLOAT>(nLeft),
						static_cast<FLOAT>(nTopNow), 0.1f ) );

					// 
					const int LEFT_TEXT_DELTA = 10;
					const int TOP_TEXT_DELTA = 10;
					// \
					ret = E3DTool::drawTextWithFont(
						nLeft + LEFT_TEXT_DELTA, nTopNow +TOP_TEXT_DELTA,			//pos XY
						50, 50, 200, 255,	//col RGBA
						staticData->get_SwapChainID(),
						staticData->get_FontID(),
						"%s",
						m_vecMissionTextList[this->m_nCurrentPage][i].c_str());
				}
			}
			{
				// y[W{^/
				int nSpriteID = 0;
				nSpriteID = staticData->m_SpriteIndexManager.get( Sprite::PREVIOUS_BUTTON );
				ret = E3DGetSpriteSize( nSpriteID, 
					&nSpriteW, &nSpriteH );

				// ʒ[̋
				const int MERGINE_X = 10;

				// Previous
				ret = E3DRenderSprite( nSpriteID,
					1, 1, D3DXVECTOR3(static_cast<FLOAT>(MERGINE_X),
					static_cast<FLOAT>(nTitleTop), 0.0f ) );
				this->m_bIsSelectedPrevious = staticData->set_MouseOverSpriteColor(
					nSpriteID, p.x, p.y, MERGINE_X, nTitleTop, nSpriteW, nSpriteH, 
					255,100,100,200, 255,255,255, 100 );

				// Next
				nSpriteID = staticData->m_SpriteIndexManager.get( Sprite::NEXT_BUTTON );
				ret = E3DGetSpriteSize( nSpriteID,
					&nSpriteW, &nSpriteH );
				int nLeft = nClientWidth - nSpriteW - MERGINE_X;
				ret = E3DRenderSprite( nSpriteID,
					1, 1, D3DXVECTOR3(static_cast<FLOAT>(nLeft),
					static_cast<FLOAT>(nTitleTop), 0.0f ) );
				this->m_bIsSelectedNext = staticData->set_MouseOverSpriteColor(
					nSpriteID, p.x, p.y, nLeft, nTitleTop, nSpriteW, nSpriteH, 
					255,100,100,200, 255,255,255, 100 );


				// y[Wԍ\
				// \
				ret = E3DTool::drawText(
					nClientWidth - 50, nClientHeight - 50,			//pos XY
					255, 255, 255, 255,	//col RGBA
					1,				// zoom
					"%d/%d", 
					this->m_nCurrentPage + 1, this->m_nMaxPage
					);
			}
			// Ə\
			ret = E3DGetSpriteSize( staticData->m_SpriteIndexManager.get( Sprite::CROSS_HAIR ), 
				&nSpriteW, &nSpriteH );
			if( ret ) {
				_ASSERT( 0 );
				return ret;
			}
			ret = E3DRenderSprite( staticData->m_SpriteIndexManager.get( Sprite::CROSS_HAIR),
				1, 1, D3DXVECTOR3(static_cast<FLOAT>(p.x - nSpriteW / 2),
				static_cast<FLOAT>(p.y - nSpriteH / 2), 0.0f ) );
			if( ret ) {
				_ASSERT( 0 );
				return ret;
			}
			// \
			ret = E3DTool::drawText(
				500, 10,			//pos XY
				255, 255, 255, 255,	//col RGBA
				1,				// zoom
				"Select Mission");
		ret = E3DEndSprite();

		staticData->afterRenderCommon();
	if( E3DEndScene() ) {
		_ASSERT( 0 );
		return 1;
	}
	return 0;
}

//! t[Ƃ̈ړ
int SelectMissionScene::frameMove() {
	int ret = 0;

	////////////////////////
	// vC[
	// vC[WASDړ
	staticData->movePlayer();

	// vC[̒e̔
	staticData->shotPlayer();

	// [Vω
	ret = staticData->updatePlayerMotion();

	DIMOUSESTATE2* mouse = staticData->get_DIMouse()->get_CurrentState();
	DIMOUSESTATE2* mousePreious = staticData->get_DIMouse()->get_PreviousState();

	if( mouse->rgbButtons[0] && mousePreious->rgbButtons[0] == FALSE) {
		// NbN

		if( this->m_bIsSelectedNext || mouse->lZ > 0) {
			// {^
			this->m_nCurrentPage ++;
			if( this->m_nCurrentPage >= this->m_nMaxPage ) {
				this->m_nCurrentPage = 0;
			}
		} else if( this->m_bIsSelectedPrevious || mouse->lZ < 0) {
			// O{^
			this->m_nCurrentPage --;
			if( this->m_nCurrentPage < 0 ) {
				this->m_nCurrentPage = this->m_nMaxPage - 1 ;
			}
		} else if( this->m_nSelectedButton >= 0 ) {
			staticData->m_nScenarioIndex = this->m_nSelectedButton;
			for( int i = 0; i < this->m_nCurrentPage; i ++ ) {
				staticData->m_nScenarioIndex += this->m_vecMissionTextList[i].size();
			}
			// u[tBO֐i
			staticData->m_SceneManager.set_Scene( SceneType::BRIEFING );
		}
	} else if( mouse->lZ ) {
		if( mouse->lZ > 0) {
			// {^
			this->m_nCurrentPage ++;
			if( this->m_nCurrentPage >= this->m_nMaxPage ) {
				this->m_nCurrentPage = 0;
			}
		} else if( mouse->lZ < 0 ) {
			// O{^
			this->m_nCurrentPage --;
			if( this->m_nCurrentPage < 0 ) {
				this->m_nCurrentPage = this->m_nMaxPage - 1 ;
			}
		}
	}
	///////////////////////////////
	// Jړ
	ret = staticData->moveCamera();
	if( ret ) {
		_ASSERT( 0 );
		return ret;
	}

	return 0;
}
}
