#include "StaticData.h"

#include <vector>
#include <string>

#include "GameScene.h"
#include "TitleScene.h"
#include "SelectMissionScene.h"
#include "BriefingScene.h"
#include "EnemyModeScene.h"

using namespace HPL;
using namespace E3D;
using namespace General;
using namespace std;

namespace MotionTest {
using namespace MotionTestConsts;
using namespace BasicStaticDataConsts;

StaticData::StaticData(HINSTANCE hInstance): BasicStaticData(hInstance) {
/*	int ret = 0;
	ret = SetMediaDir();
	if( ret ){
		_ASSERT( 0 );
		//return FALSE;
	}*/

	// AˊԊuJE^
	this->m_cntShotAutomaticCounter = new HPLCounter(
		6,	// [v1
		1 );

	this->m_lpPlayerSigBuffer = NULL;

	this->m_nSelectedGroundType = 0;

	this->m_bNearByConsole = FALSE;

	//this->m_Console = NULL;

	int ret = 0;
	// ViIACeǂݍ
	ret = m_ScenarioManager.load_ScenariosFromOneText( "Media\\Scenario\\Game.txt");
}
StaticData::~StaticData() {
	delete this->m_cntShotAutomaticCounter;
	if(this->m_lpPlayerSigBuffer != NULL ) {
		delete this->m_lpPlayerSigBuffer;
	}
//	delete this->m_Building;

	for(std::list<EnemyLifeBar*>::iterator it = this->m_lstEnemyLifeBarList.begin();
		it != this->m_lstEnemyLifeBarList.end();
		it ++ ) 
	{
		delete *it;
	}
	this->m_lstEnemyLifeBarList.clear();

	this->m_mapGroundMap.clear();
	this->m_mapWallMap.clear();
}

/** 1024x1024̃eNX`쐬s
  * @param[in]	nFormat			DirectXݒ肵ĂtH[}bg
  * @param[out]	lpszSize		쐬łTCYB쐬Ɏsꍇg͕ύXȂ
  * @retval		0				
  * @retval		1				s
  */
int StaticData::tryToCreateTexture( int nFormat, SIZE* lpszSize ) {
	int ret = 0;

	ret = E3DTool::createRenderTexture( nFormat,
		*lpszSize,
		&this->m_nShadowSwapChainID,
		&this->m_nShadowTextureID );
	if( ret ) {
		lpszSize->cx = 512;
		lpszSize->cy = 512;
		ret = E3DTool::createRenderTexture( nFormat,
			*lpszSize,
			&this->m_nShadowSwapChainID,
			&this->m_nShadowTextureID );
		if( ret ) {
			lpszSize->cx = 256;
			lpszSize->cy = 256;
			ret = E3DTool::createRenderTexture( nFormat,
				*lpszSize,
				&this->m_nShadowSwapChainID,
				&this->m_nShadowTextureID );
			if(ret ) {

				return 1;
			}
		}
	}

	return ret;
}

/** 񂾂{V[
  * @retval 0
  */
int StaticData::oneTimeSceneInit() {
	int ret;

	///////////////////////////////////////
	// Jʒu
	// 
	//this->set_CameraDistance( 4000.f );

	// 
	//this->set_CameraHeight( 1000.f);

	// ov}bsOL
	ret = E3DEnableBumpMap( TRUE );
	

//	D3DXVECTOR3 up( 0.f, 1.f, 0.f );
//	D3DXVECTOR3 cross;
//	D3DXVec3Cross( &cross, &diff, &up );
//	D3DXVec3Normalize( &cross, &cross );

	/*ret = E3DSetCameraDeg( 180.0f, 0.0f );
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}*/

	// vWFNVݒ
	ret = E3DSetProjection( 100, 500000.0f, 60.0f );
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}

	// [fBO摜ǂݍ
	/*{
		int spid = 0;
		ret = E3DCreateSprite( "Media\\Sprite\\Loading.png", 1, NULL, &spid );
		if( ret ){
			_ASSERT(0);
			return 1;
		}

		this->m_SpriteIndexManager.set( Sprite::LOADING_SCREEN, spid);
	}*/

	// wi
	ret = E3DCreateBG( this->get_SwapChainID(), "Media\\Sprite\\Loading.png", "hoge", 0, 0, 0, 10000 );

	// [fBO摜\
	E3DBeginScene( this->get_SwapChainID(), 0);
		E3DBeginSprite();
		E3DEndSprite();
	E3DEndScene();

	E3DPresent( this->get_SwapChainID() );



	/////////////////////////////
	// vC[LN^[



	////////////////////////////
	// [Vf[^
	// MOAt@C[h
	char MOA_PATH_LIST[][MAX_PATH] = {
		"Media\\model_madogen\\motion\\evi.moa",
		"Media\\tanya\\motion\\motion.moa",
	};
	for(int i = 0; i < PlayerType::MAX_NUM; i ++ ) {
		this->m_aryPlayerList[i].m_Game.m_nObjectType = ObjectType::PLAYER;
		this->m_aryPlayerList[i].m_Game.m_nType = i;
		if( i == PlayerType::EVIGEN ) {
			// т
			// Sigt@Cǂݍ
			{
				int n = 0;
				ret = E3DSigLoad( "Media\\model_madogen\\evi.sig",0,1.f,&n);
				this->m_aryPlayerList[PlayerType::EVIGEN].m_nSigID = n;
				this->m_nPlayerType = PlayerType::EVIGEN;
			}


			this->m_nCameraTargetSigID = this->get_Player()->m_nSigID;
			if( ret ){
				_ASSERT( 0 );
				return 1;
			}

			// 㔼gAg̃{[No.擾
			ret = E3DGetPartNoByName( this->get_Player()->m_nSigID, "upper", &this->get_Player()->m_nUpperBoneNumber );
			if( ret ){
				_ASSERT( 0 );
				return 1;
			}
			ret = E3DGetPartNoByName( this->get_Player()->m_nSigID, "under", &this->get_Player()->m_nUnderBoneNumber );
			if( ret ){
				_ASSERT( 0 );
				return 1;
			}
			ret = E3DGetPartNoByName( this->get_Player()->m_nSigID, "TopOftrunk", &this->get_Player()->m_nWeaponBoneNumber );
			if( ret ){
				_ASSERT( 0 );
				return 1;
			}
			ret = E3DGetPartNoByName( this->get_Player()->m_nSigID, "TopOftrunk_handgun", &this->get_Player()->m_nWeaponBoneNumber2 );
			if( ret ){
				_ASSERT( 0 );
				return 1;
			}
			ret = E3DGetPartNoByName( this->get_Player()->m_nSigID, "TopOfbase", &this->get_Player()->m_nBaseBoneNumber );
			if( ret ){
				_ASSERT( 0 );
				return 1;
			}

		} else if( i == PlayerType::TANYA ) {
			// ^[j
			int n;
			ret = E3DSigLoad( "Media\\tanya\\tanya.sig",0,1.f,&n);
			ret = E3DSigLoad( "Media\\tanya\\tanya.sig",0,1.f,&n);
			this->m_aryPlayerList[PlayerType::TANYA].m_nSigID = n;
			if( ret ) {
				_ASSERT(0);
			}

			// 㔼gAg̃{[No.擾
			ret = E3DGetPartNoByName( this->m_aryPlayerList[PlayerType::TANYA].m_nSigID, "upper", &this->m_aryPlayerList[PlayerType::TANYA].m_nUpperBoneNumber );
			if( ret ){
				_ASSERT( 0 );
				return 1;
			}
			ret = E3DGetPartNoByName( this->m_aryPlayerList[PlayerType::TANYA].m_nSigID, "under", &this->m_aryPlayerList[PlayerType::TANYA].m_nUnderBoneNumber );
			if( ret ){
				_ASSERT( 0 );
				return 1;
			}
		} else {
			_ASSERT(0);
		}


		ret = E3DLoadMOAFile( m_aryPlayerList[i].m_nSigID , MOA_PATH_LIST[i],
			5, 1.f);
		if( ret ){
			_ASSERT( 0 );
			return 1;
		}

		{
			int nNumberOfMotion = 0;
			ret = E3DGetMoaInfo( m_aryPlayerList[i].m_nSigID, MAX_MOTION,
				m_aryPlayerList[i].m_moaMOAArray , &nNumberOfMotion);
			if( ret ){
				_ASSERT( 0 );
				return 1;
			}
		}

		/////////////////////////////////

		// VF[_
		//ret = E3DSetShaderType( m_aryPlayerList[i].m_nSigID, COL_SCHLICK);//COL_PHONG);

		// NH[^jI쐬
		ret = E3DCreateQ(&this->m_aryPlayerList[i].m_Move.m_nQuoatanion);

		// ]
		if( E3DRotateY( m_aryPlayerList[i].m_nSigID, 180.f ) ) {
			_ASSERT( 0 );
			return 1;
		}


	}

	// \ȃp[cXg
	char czDestroyablePartName[][100] = {
		"cloth",
		"apron",
		"bra",
		"pants",
		"garter",
	};
	for(int i = 0; i < Parts::MAX_NUM; i ++ ) {
		int nPartNo = 0;
		ret = E3DGetPartNoByName( this->m_aryPlayerList[PlayerType::EVIGEN].m_nSigID,
			czDestroyablePartName[i], &nPartNo );
		if( ret ) {
			_ASSERT(0);
		}
		this->m_aryPartsIndexList[i] = nPartNo;
		this->m_aryPartsValidList[i] = TRUE;
	}
	char czTanyaDestroyablePartName[][100] = {
		"white",
		"wear",
		"bottom",
	};
	for(int i = 0; i < TanyaParts::MAX_NUM; i ++ ) {
		int nPartNo = 0;
		ret = E3DGetPartNoByName( this->m_aryPlayerList[PlayerType::TANYA].m_nSigID,
			czTanyaDestroyablePartName[i], &nPartNo );
		if( ret ) {
			_ASSERT(0);
		}
		this->m_aryTanyaPartsIndexList[i] = nPartNo;
		this->m_aryTanyaPartsValidList[i] = TRUE;
	}

	/////
	// \
	this->m_nPlayerMaterialIndex = 0;
	char lpczMaterialPaths[][MAX_PATH] = {
		"Media\\model_madogen\\face.tga",
		"Media\\model_madogen\\shoot.png",
		"Media\\model_madogen\\damage.png",
		"Media\\model_madogen\\damage_crash.png",
		"Media\\model_madogen\\down.png",
		"Media\\model_madogen\\cloth.tga",
		"Media\\model_madogen\\cloth2.tga",
		"Media\\model_madogen\\body.tga",
		"Media\\model_madogen\\body_damage.tga",
		"Media\\model_madogen\\body_black.tga",
		"Media\\model_madogen\\body_damage_black.tga",
		"Media\\model_madogen\\under.tga",
		"Media\\model_madogen\\under_black.tga",
		"Media\\js2\\kami1.png",
		"Media\\js2\\kami2.png",
		"Media\\js2\\kao1.png",
		"Media\\js2\\kao2.png",
		"Media\\js2\\kao3.png",
		"Media\\js2\\kao4.png",
		"Media\\js2\\kao5.png",
		"Media\\js2\\karada1.png",
		"Media\\js2\\karada2.png",
		"Media\\js2\\karada3.png",
		"Media\\js2\\karada4.png",
	};

	for(int i = 0; i < Material::MAX_NUM; i ++ ) {
		int matid;
		ret = E3DCreateTexture( lpczMaterialPaths[i], 0, D3DPOOL_DEFAULT, &matid );
		if( ret ) {
			_ASSERT( 0 );
			return ret;
		}
		this->m_aryMaterials[i] = matid;
	}

	m_nClothBreak = 0;
	m_fClothAlpha = 1;
	m_fUnderAlpha = 1;
	m_fApronAlpha = 1;
	m_fClothUnderAlpha = 1;
	m_fApronUnderAlpha = 1;
	m_fKatyuAlpha = 1;

	m_nUnderColor = 0;

	//m_nUnderR = 255;
	//m_nUnderG = 255;
	//m_nUnderB = 255;

	/////
	// eeNX`쐬
	{
		this->m_szShadowTextureSize.cx = 1024;
		this->m_szShadowTextureSize.cy = 1024;

		ret = this->tryToCreateTexture( D3DFMT_A8R8G8B8,// A8R8G8B8,//D3DFMT_A16B16G16R16F,
			&this->m_szShadowTextureSize );

		if( ret ) {
	/*		this->m_szShadowTextureSize.cx = 16;
			this->m_szShadowTextureSize.cy = 16;
			ret = this->tryToCreateTexture (D3DFMT_A8R8G8B8,
				&this->m_szShadowTextureSize );
			if( ret ) {*/
				// s
				_ASSERT( 0 );
				return 1;
			//}
		}
		// VhE}bveNX`\邽߂̃XvCg쐬
		int nTransparentFlag = 0;	// ߃tO
		ret = E3DCreateSprite( "Media\\dummy512.bmp", nTransparentFlag, NULL, &this->m_nShadowSpriteID );

		// TCY擾
		int nShadowSpriteWidth = 0;
		int nShadowSpriteHeight = 0;
		ret = E3DGetSpriteSize( this->m_nShadowSpriteID, &nShadowSpriteWidth, &nShadowSpriteHeight );

		// eNX`̃XvCgɃ}bsO
		ret = E3DSetTextureToDispObj( -2, this->m_nShadowSpriteID,
			this->m_nShadowTextureID );

		// oCAXiǂꂾ邩j
		ret = E3DSetShadowBias ( 0.005f );

		// Â
		ret = E3DSetShadowDarkness( 1.0f );

		// š
		this->m_vLightDirection = D3DXVECTOR3( -0.5f, -1.0f, 1.0f );

		ret = E3DSetShadowMapLightDir( this->m_vLightDirection );

	}


	
	/////////////////////////////////////////////////////////////////////////////////
	// TCNvX
	
	this->m_EnemyManager.createObjects( EnemyType::CYCLOPS, OBJECT_MAX );
	this->m_EnemyManager.createObjects( EnemyType::WORM_BIG, WORM_BIG_MAX );
	this->m_EnemyManager.createObjects( EnemyType::WORM_SMALL, WORM_SMALL_MAX );
	this->m_EnemyManager.createObjects( EnemyType::ZOMBIE, ZOMBIE_MAX );
	this->m_EnemyManager.createObjects( EnemyType::MOSUKO, MOSUKO_MAX );
	this->m_EnemyManager.createObjects( EnemyType::MOSUKO_LONG, MOSUKO_MAX );
	this->m_EnemyManager.createObjects( EnemyType::ZOMBIE_B, ZOMBIE_B_MAX );
	this->m_EnemyManager.createObjects( EnemyType::TROL, 1);

	// pJE^
	this->m_cntEnemyGenerateCounter.set_FrameCounterMax( DEFAULT_GENERATE_COUNTER );
	this->m_cntEnemyGenerateCounter.set_LoopNumMax( 1 );

	
	
	////////////////////////////////////
	// ef
	// Bullet
	ret = this->m_ShotManager.createObjects( ShotType::BULLET,
		SHOT_MAX );

	// ~TC
	ret = this->m_ShotManager.createObjects( ShotType::MISSILE,
		MISSILE_MAX );


	////////////////////
	// VF
	ret = this->m_NeutralManager.createObjects( NeutralType::SHELL,
		SHELL_MAX );
	// _jX
	ret = this->m_NeutralManager.createObjects( NeutralType::DANIMOTH,
		1 );
	// ѓ
	ret = this->m_NeutralManager.createObjects( NeutralType::HEAD,
		1 );
	// fBLbg
	ret = this->m_NeutralManager.createObjects( NeutralType::MEDI_KIT,
		MEDI_KIT_NUM );
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}
	// eiAmmoj
	ret = this->m_NeutralManager.createObjects( NeutralType::AMMO,
		AMMO_NUM );
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}
	// Ƃ
	ret = this->m_NeutralManager.createObjects( NeutralType::MEAT,
		MEAT_NUM );
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}
	// 
	ret = this->m_NeutralManager.createObjects( NeutralType::HAND_GUN,
		1 );
	ret = this->m_NeutralManager.createObjects( NeutralType::MINI_GUN,
		1 );
	ret = this->m_NeutralManager.createObjects( NeutralType::CONSOLE,
		CONSOLE_NUM );

	///////////////////////
	// BillBoard
	for( int i = 0; i < BLOOD_MAX; i ++ ) {
		int nTransparentFlag = 0;	// t@C̃lœFݒ
		int dirMode = 1;			// ɉʂ̕
		int nCenterFlag = 1;		// 摜̒SdS
		int nBillBoardID = 0;

		int bbid= 0;
		ret = E3DCreateBillboard( "Media\\model_madogen\\blood.png", //Animation.gif",//
			BLOOD_SIZE, BLOOD_SIZE, nTransparentFlag, dirMode, nCenterFlag,
			&bbid );
		if(ret ) {
			_ASSERT(0);
			return 1;
		}
		// uh[h
		// 0:[h
		// 1:Add[h
		ret = E3DSetBlendingMode( -1, bbid, 0 );

		// _Oݒ
		// Cg̉e󂯂Ȃ
		ret = E3DSetRenderState( -1, bbid, D3DRS_LIGHTING, 0 );

		// }l[W֓o^
		E3DBillBoard* billBoard = this->m_BloodBillBoardManager.setup_BillBoard(
			bbid );
	}


	///////
	// nʃfǂݍ
	int nAdjestUVFlag = 0;
	int nSigID;

	vector<string> vecGroundFilePathList;
	TextTool::load_StringLinesFromFile( "Media/Stage/ground.txt", &vecGroundFilePathList );
	if( static_cast<int>(vecGroundFilePathList.size()) != GroundType::MAX_NUM ) {
		_ASSERT(0);
	}

	float GROUND_MODEL_RATE = 200.f;

	for(int i = 0; i < GroundType::MAX_NUM; i ++ ) {
		ret = E3DLoadMQOFileAsGround( vecGroundFilePathList[i].c_str(), 
			GROUND_MODEL_RATE, nAdjestUVFlag, BONETYPE_RDB2, &nSigID );
		if(ret ) {
			_ASSERT(0);
			return ret;
		}
		this->m_mapGroundMap[i] = nSigID;
	}
	char WALL_MODEL_FILE_PATH_LIST[][MAX_PATH] = {
		"Media\\PracticeRoomWall.mqo",
		"Media\\Stage\\Stage1-zombie-Wall.mqo",
		"Media\\Stage\\Stage2-worm-Wall.mqo",
	};
	char WALL_SIG_FILE_PATH_LIST[][MAX_PATH] = {
		"Media\\PracticeRoomWall.sig",
		"Media\\Stage\\Stage1-zombie-Wall.sig",
		"Media\\Stage\\Stage2-worm-Wall.sig",
	};

	int GROUND_TYPE_FOR_WALL[] = {
		GroundType::PRACTICE_ROOM,
		GroundType::ZOMBIE,
		GroundType::WORM,
	};
	for(int i = 0; i < WallType::MAX_NUM; i ++ ) {
		ret = E3DLoadMQOFileAsMovableArea( WALL_MODEL_FILE_PATH_LIST[i], 
			GROUND_MODEL_RATE, &nSigID );
		if(ret ) {
			_ASSERT(0);
			return ret;
		}
		this->m_mapWallMap[i] = nSigID;

		// ǂnʂɔzu
		//E3DSetPos(nSigID, D3DXVECTOR3(0,0,0 ) );
		//E3DSetDir(nSigID, D3DXVECTOR3(0,0,0 ) );
		ret = E3DSetWallOnGround( nSigID, this->m_mapGroundMap[GROUND_TYPE_FOR_WALL[i]],
			MAP_HEIGHT, MAP_MIN, 0);

		ret = E3DSigLoad( WALL_SIG_FILE_PATH_LIST[i], nAdjestUVFlag, GROUND_MODEL_RATE,
			&nSigID );
		if(ret ) {
			_ASSERT(0);
			return ret;
		}
		this->m_mapWallSigMap[i] = nSigID;
	}

	// 

	
	//////
	// XvCgǂݍ
	int spid = -1;
	E3DCOLOR4UC uc = {UI_ALPHA,255,255,255 };
	// g
	char SPRITE_PATH_LIST[][MAX_PATH] = {
		"Media\\CrossHair.png",
		"Media\\LifeFrame.png",
		"Media\\LifeBar.png",
		"Media\\EnemyLifeBar.png",
		"Media\\TitleSubject.png",
		"Media\\SelectMission.png",
		"Media\\MissionFrame.png",
		"Media\\PreviousButton.png",
		"Media\\NextButton.png",
		"Media\\MessageFrame.png",
		"Media\\UI\\CheckBox.png",
		"Media\\UI\\CheckBoxChecked.png",
	};
	int SPRITE_INDEX_LIST[] = {
		Sprite::CROSS_HAIR,
		Sprite::LIFE_FRAME,
		Sprite::LIFE_BAR,
		Sprite::ENEMY_LIFE_BAR,
		Sprite::TITLE_SUBJECT,
		Sprite::SELECT_MISSION,
		Sprite::MISSION_FRAME,
		Sprite::PREVIOUS_BUTTON,
		Sprite::NEXT_BUTTON,
		Sprite::MESSAGE_FRAME,
		Sprite::CHECK_BOX,
		Sprite::CHECK_BOX_CHECKED,
	};
	int SPRITE_ALPHA_LIST_NUM = sizeof(SPRITE_INDEX_LIST) / sizeof(int);
	for( int i = 0; i < SPRITE_ALPHA_LIST_NUM; i ++ ) {

		ret = E3DCreateSprite( SPRITE_PATH_LIST[i], 1, NULL, &spid );
		ret = E3DSetSpriteARGB( spid, uc );
		this->m_SpriteIndexManager.set( SPRITE_INDEX_LIST[i], spid );
	}

	ret = E3DCreateSprite( "Media\\Title.png", 1, NULL, &spid );
	this->m_SpriteIndexManager.set( Sprite::TITLE, spid );

	ret = E3DCreateSprite( "Media\\Sprite\\evi_3.png", 1, NULL, &spid );
	this->m_SpriteIndexManager.set( Sprite::TITLE_SCREEN, spid);

	/*	MINI_GUN,
		MACHINE_GUN,
		MISSILE_LAUNCHER,
		HAND_GUN,
		GRANADE_LAUNCHER,
		MAX_NUM*/
	// XvCg
	char WEAPON_SPRITE_PATH_LIST[][MAX_PATH] = {
		"Media\\Gun-001-MiniGun.png",
		"Media\\Weapon\\Gun-002-MachineGun.png",
		"Media\\Weapon\\Gun-003-MissileLauncher.png",
		"Media\\Weapon\\Gun-004-HandGun.png",
		"Media\\Weapon\\Gun-005-GranadeLauncher.png",
		"Media\\Weapon\\Gun-006-Crowbar.png",
	};
	int WEAPON_SPRITE_USER_ID_LIST[] = {
		Sprite::GUN_01_MINI_GUN,
		Sprite::GUN_02_MACHINE_GUN,
		Sprite::GUN_03_MISSILE_LAUNCHER,
		Sprite::GUN_04_HAND_GUN,
		Sprite::GUN_05_GRANADE_LAUNCHER,
		Sprite::GUN_06_CROWBAR,
	};
	for(int i = 0; i < WeaponType::MAX_NUM; i ++ ) {
		ret = E3DCreateSprite( WEAPON_SPRITE_PATH_LIST[i], 1, NULL, &spid );
		if(ret ) {
			_ASSERT(0);
			return ret;
		}
		ret = E3DSetSpriteARGB( spid, uc );
		this->m_SpriteIndexManager.set( WEAPON_SPRITE_USER_ID_LIST[i], spid );
		this->m_aryWeaponList[i].set_SpriteID( spid );

		// 
		// TODO ECxgŎg悤ɂ
		if( //i == WeaponType::HAND_GUN ||
			//i == WeaponType::MINI_GUN ||
			i == WeaponType::CROWBAR 
			) 
		{
			this->m_aryWeaponList[i].set_Enable( FALSE );
		} else {
			this->m_aryWeaponList[i].set_Enable( TRUE );
		}
		this->m_aryWeaponList[i].set_Type( i );
	}


	this->m_nWeaponIndex = 0;

	///////////////////
	// BGM
	vector<string> vecBGMFilePathListRaw;
	ret = TextTool::load_StringLinesFromFile( "Media\\BGM\\bgm.txt" , &vecBGMFilePathListRaw);
	if( ret ) {
		_ASSERT(0);
	}
	vector<string> vecBGMFilePathList;
	for( int i = 0; i < static_cast<int>(vecBGMFilePathListRaw.size()); i ++ ) {
		if( TextTool::is_SkipLine( vecBGMFilePathListRaw[i] ) ) {
			continue;
		}
		vecBGMFilePathList.push_back( string("Media\\BGM\\") + vecBGMFilePathListRaw[i] );
	}

	vector<string> vecList;
	TextTool::load_StringLinesFromFile( "Media\\SE\\se.txt", &vecList);
	vector<string> vecSEPathList;

	for( int i = 0; i < static_cast<int>(vecList.size()); i ++ ) {
		if( TextTool::is_SkipLine( vecList[i] ) ) {
			continue;
		}
		vecSEPathList.push_back( string("Media\\SE\\") + vecList[i] );
	}


	float SE_VOLUME_RATE = static_cast<float>(GetPrivateProfileInt( _T("Evigen"), _T("SE"), 60, OPTION_INI_FILE_PATH )) / 100.f;
	float VOICE_VOLUME_RATE = static_cast<float>(GetPrivateProfileInt( _T("Evigen"), _T("VOICE"), 100, OPTION_INI_FILE_PATH )) / 100.f;
	float BGM_VOLUME_RATE = static_cast<float>(GetPrivateProfileInt( _T("Evigen"), _T("BGM"), 30, OPTION_INI_FILE_PATH )) / 100.f;

	for(int i = 0; i < Sound::MAX_NUM; i ++ ) {
		int id = 0;
		if( i < Sound::BGM_NUM ) {
			ret = E3DLoadSound( vecBGMFilePathList[i].c_str(), 0, 0, 1, &id );
		} else {
			ret = E3DLoadSound( vecSEPathList[i - Sound::BGM_NUM].c_str(), 0, 0, 1, &id);
		}
		if(ret ) {
			_ASSERT(0);
			return ret;
		}
		this->m_arySoundList[i] = id;

		if( i == Sound::GUN ||
			i == Sound::ENEMY_HIT_1 ||
			i == Sound::ENEMY_HIT_2 ) 
		{
			ret = E3DSetSoundVolume( SE_VOLUME_RATE, id) ;
		} else if( i < Sound::BGM_NUM ) {
			ret = E3DSetSoundVolume( BGM_VOLUME_RATE, id) ;
		} else if( i == Sound::VOICE_CRASH || i == Sound::VOICE_HIT_1 ||
			i == Sound::VOICE_HIT_2)
		{
			ret = E3DSetSoundVolume( VOICE_VOLUME_RATE, id) ;
		}
	}
	this->m_nBGMIndex = Sound::TITLE;

	//ret = E3DPlaySound( this->m_arySoundList[this->m_nBGMIndex], 0, 0, 255 );

	BOOL bDefaultList[] = {
		1,
		0,
		1,
		0,
		1,
	};
	for(int i = 0; i < TitleSceneConsts::CheckType::NUM_MAX; i ++ ) {
		this->m_aryOptionList[i] = GetPrivateProfileInt(_T("Evigen"), OPTION_ELEMENT_LIST[i], bDefaultList[i],
			OPTION_INI_FILE_PATH);
	}
	///////////////////////////////////
	// Cg쐬
	E3DCOLOR4UC col= {255, 255, 255, 255 };

	if( this->m_LightManager.create( GEnum::LightType::Default,
		this->m_vLightDirection,
		col ) != 0 )
	{
		_ASSERT( 0 );
		return 1;
	}

	// V[쐬
	this->m_SceneManager.add_Scene( SceneType::TITLE, new TitleScene() );
	this->m_SceneManager.add_Scene( SceneType::SELECT_MISSION, new SelectMissionScene() );
	this->m_SceneManager.add_Scene( SceneType::BRIEFING, new BriefingScene() );
	this->m_SceneManager.add_Scene( SceneType::GAME, new GameScene() );
	this->m_SceneManager.add_Scene( SceneType::ENEMY_MODE, new EnemyModeScene() );


	// V[I
	this->m_SceneManager.set_Scene( SceneType::TITLE );
	return 0;
}

int StaticData::checkObjectOnGround( E3DObject* obj, BOOL bIsPlayer) {

	D3DXVECTOR3 vPlayerPosition;
	E3DGetPos( obj->m_nSigID, &vPlayerPosition );

	int nMode =1;	//n𔇂

	int ret = 0;

	// 
	int nResult = 0;

	BOOL bIsFlyingBefore = obj->m_Move.get_Trigger( TriggerType::ON_THE_GROUND ) == FALSE;

	D3DXVECTOR3 vAdjust;
	D3DXVECTOR3 n;
	float fDiffMaxY = 2000.f;
	{
		ret = E3DChkConfGround( obj->m_nSigID, this->get_GroundSigID(), nMode, 
			fDiffMaxY, MAP_MIN, &nResult, &vAdjust, &n );
		if(ret ) {
			_ASSERT(0);
			return 1;
		}
	}

	// ǂnʂɐڐGǂ̔
	// vC[pB
	BOOL bIsHitGroundOrWall = FALSE;

	if( vPlayerPosition.y > vAdjust.y )
	{
		{
			// 󒆂ɋ
			// 
			obj->m_Move.m_vVelocity.y += GRAVITY;
			obj->m_Move.m_vPosition += obj->m_Move.m_vVelocity;

			E3DSetPos( obj->m_nSigID, obj->m_Move.m_vPosition );
			obj->m_Move.set_Trigger( TriggerType::ON_THE_GROUND ,
				FALSE);
		}
	} else {

		if( nResult != 0 ) {
			// ڒn
			//if( bIsPlayer ) {
				vPlayerPosition.z = vAdjust.z;
				vPlayerPosition.x = vAdjust.x;
			//}
			vPlayerPosition.y = vAdjust.y;

			obj->m_Move.m_vPosition = vPlayerPosition;
			obj->m_Move.m_vVelocity.y = 0;

			if(obj->m_Move.get_Trigger( TriggerType::ON_THE_GROUND ) == FALSE ) {
				// ړ0
				obj->m_Move.m_vVelocity.x = 0;
				obj->m_Move.m_vVelocity.z = 0;
			}
			obj->m_Move.set_Trigger( TriggerType::ON_THE_GROUND, TRUE ) ;
			obj->m_Move.m_bJumpAccelable = TRUE ;


			if( bIsPlayer == TRUE ) {
				// vC[ł

				bIsHitGroundOrWall = TRUE;
			}
		}
	}
	E3DSetPos( obj->m_nSigID, obj->m_Move.m_vPosition );
	if( this->m_nSelectedWallType >= 0 ) {
		float fSpeed = D3DXVec3Length( &obj->m_Move.m_vVelocity );
		const float DISTANCE_FROM_WALL = 500.f+ fSpeed;
		ret = E3DChkConfWall( obj->m_nSigID, this->get_WallSigID(), DISTANCE_FROM_WALL, 
			&nResult, &vAdjust, &n );
		if( nResult ) {
			obj->m_Move.m_vPosition = vAdjust;
			E3DSetPos( obj->m_nSigID, vAdjust );

			bIsHitGroundOrWall = TRUE;
		}
	} else {}

	if( bIsHitGroundOrWall ) {
		if( this->get_Player()->m_Game.m_nType == PlayerType::EVIGEN ) {

			if( this->get_Player()->m_nEventNumber == Motion::Evigen::DAMAGE_CRASH_UP ) {

				// т璅n
				// BOUNDɂȂ
				this->get_Player()->m_nEventNumber = Motion::Evigen::DAMAGE_BOUND ;

			} else if( this->get_Player()->m_nEventNumber == Motion::Evigen::DOWN &&
				bIsFlyingBefore == TRUE ) 
			{
				// 󒆂DOWNɂȂĂ
				// Œn
				// oEh
				this->get_Player()->m_nEventNumber = Motion::Evigen::DAMAGE_BOUND ;

			} else if( this->get_Player()->m_nEventNumber == Motion::Evigen::DAMAGE_A ||
				this->get_Player()->m_nEventNumber == Motion::Evigen::DAMAGE_B )
			{
				// _[W

				if( this->get_Player()->m_Game.m_fHP <= 0 ) {
					// 
					this->get_Player()->m_nEventNumber = Motion::Evigen::DEATH;
				} else if( this->get_Player()->m_Game.m_nHolderSigID >= 0 ) {
					// X^[ɕ߂܂Ă
					// ̂܂܌p

				} else {
					// [VƂɖ߂
					this->get_Player()->m_nEventNumber = Motion::Evigen::WALK;

					// A
					this->restorePlayer();
				}
			}
		} else if( this->get_Player()->m_Game.m_nType == PlayerType::TANYA ) {
		} else {
			_ASSERT(0);
		}
	}
	return 0;
}

void StaticData::set_NextWeapon() {
	if( this->get_Player()->m_Game.m_fHP == 0 )  {
		return;
	}
	int nNewWeaponIndex = this->m_nWeaponIndex + 1;
	while( true ) {
		if( nNewWeaponIndex >= WeaponType::MAX_NUM ) {
			nNewWeaponIndex = 0;
		}

		if( nNewWeaponIndex == this->m_nWeaponIndex ) {
			// T
			return ;
		}
		if( this->m_aryWeaponList[ nNewWeaponIndex ].is_Enable()== TRUE ) {
			this->set_WeaponIndex( nNewWeaponIndex );
			return ;
		}
		nNewWeaponIndex ++;
	}

}
void StaticData::set_PreviousWeapon() {
	if( this->get_Player()->m_Game.m_fHP == 0 )  {
		return;
	}
	int nNewWeaponIndex = this->m_nWeaponIndex - 1;
	while( true ) {
		if( nNewWeaponIndex < 0 ) {
			nNewWeaponIndex = WeaponType::MAX_NUM - 1;
		}

		if( nNewWeaponIndex == this->m_nWeaponIndex ) {
			// T
			return ;
		}
		if( this->m_aryWeaponList[ nNewWeaponIndex ].is_Enable() == TRUE ) {
			this->set_WeaponIndex( nNewWeaponIndex );
			return ;
		}
		nNewWeaponIndex --;
	}

}
/*int StaticData::get_WeaponIndex() {
	return this->m_nWeaponIndex;
}*/
Weapon* StaticData::get_Weapon() {
	return &this->m_aryWeaponList[this->m_nWeaponIndex];
}
void StaticData::set_WeaponIndex( int nNewWeaponIndex ) {
	this->m_nWeaponIndex = nNewWeaponIndex;

	// EFCg^CύX
	this->m_cntShotAutomaticCounter->set_FrameCounterMax( this->get_Weapon()->m_nShotAutomaticInterval );
	this->m_cntShotAutomaticCounter->reset();

	int ret = 0;
	if( nNewWeaponIndex == WeaponType::MINI_GUN || 
		nNewWeaponIndex == WeaponType::HAND_GUN)
	{
		// o
		this->set_WeaponEnable( TRUE );
	} else {
		// ʏ탂[Vɖ߂
		this->get_Player()->m_nEventNumber = 0;

		// ~jKB
		this->set_WeaponEnable( FALSE );
	}
}

void StaticData::get_ShotDirection( D3DXVECTOR3* vDirection, D3DXVECTOR3& vShotFrom) {

	float fErrorDegree = 0;
	if( this->get_CameraMode() == CameraMode::AT_TARGET_MODE )  {
		// vC[̌Ă@+ERROR
		E3DGetCharaDir( this->get_Player()->m_nSigID, 0,0, vDirection);
		// ERROR
		fErrorDegree = this->get_Weapon()->get_Error() * SHOT_AT_TARGET_MODE_ERROR_RATE;

	} else if( this->get_CameraMode() == CameraMode::SHOT_BEHIND_MODE ) {
		// TeCgiƏj
		D3DXVECTOR3 vSatellitePosition;
		this->get_Camera()->get_SatellitePosition(
			vShotFrom,
			&vSatellitePosition );

		//
		*vDirection = vSatellitePosition - vShotFrom;
		fErrorDegree = this->get_Weapon()->get_Error();

	} else if( this->get_CameraMode() == CameraMode::SNIPER_MODE ) {
		// ڂ̍猩Ă܂
		D3DXVECTOR3 vSatellitePosition;
		this->get_Camera()->get_SatellitePosition( 
			vShotFrom,
			&vSatellitePosition );
		*vDirection = vSatellitePosition - vShotFrom;

		// G[0
		fErrorDegree = 0;

	}

	// K
	D3DXVec3Normalize( vDirection, vDirection );


	// G[]
	VectorTool::rotateHorizontal( vDirection, vDirection, MathTool::nextRandom<float>(-fErrorDegree, fErrorDegree) );

	// cG[]
	VectorTool::rotateVertical( vDirection, vDirection, MathTool::nextRandom<float>(-fErrorDegree, fErrorDegree) );
}

/**
  *
  */
BOOL StaticData::is_Runnable() {
	
	if( this->m_nWeaponIndex == WeaponType::MINI_GUN ||
		this->m_nWeaponIndex == WeaponType::MISSILE_LAUNCHER ||
		(this->m_nWeaponIndex != WeaponType::MACHINE_GUN && this->get_CameraMode() == CameraMode::SHOT_BEHIND_MODE ) ||
		this->get_CameraMode() == CameraMode::SNIPER_MODE/* ||
		this->get_DIMouse()->get_CurrentState()->rgbButtons[0]*/)
	{
		return FALSE;
	}

	return TRUE;
}
/** nʂ̃`FbNC
  *
  */
int StaticData::checkInGround() {
	int ret = 0;
	int status;
	ret = E3DChkInView( this->get_SwapChainID(), this->get_GroundSigID() , &status);
	if(ret ) {
		_ASSERT(0);
		return ret;
	}

	if( this->m_nSelectedWallType >= 0 ) {
		ret = E3DChkInView( this->get_SwapChainID(), this->m_mapWallSigMap[this->m_nSelectedWallType] , &status);
		if(ret ) {
			_ASSERT(0);
			return ret;
		}
		ret = E3DChkInView( this->get_SwapChainID(), this->get_WallSigID() , &status);
		if(ret ) {
			_ASSERT(0);
			return ret;
		}
	}
	return 0;
}

/** vC[ƒnʂ̐ڐG
  *
  */
int StaticData::checkPlayerOnGround( ) {
	int ret = 0;
	if( this->get_Player()->m_Game.m_nHolderSigID < 0 ) {
		// vC[ƃ}bṽ`FbNC
		ret = this->checkObjectOnGround( this->get_Player(), TRUE);
		if( ret ) {
			_ASSERT(0);
			return ret;
		}
	}
	return 0;
}
int StaticData::renderWithShadow( BOOL bIsGround, BOOL bIsPlayer, BOOL bIsMissile, BOOL bIsEnemy ) {
	int ret = 0;

	// vC[؂ւeXg
	
	if( this->get_CurrentKeyBuffer('T') && this->get_PreviousKeyBuffer('T') == FALSE ) {
		int nType = PlayerType::EVIGEN;
		if( this->get_Player()->m_Game.m_nType == PlayerType::EVIGEN ) {
			nType = PlayerType::TANYA;
		}

		this->change_PlayerType( nType );
	}

	if( this->get_Player()->m_Game.m_nType == PlayerType::TANYA ) {
		for(int i = 0; i < TanyaParts::MAX_NUM; i ++ ) {
			char nVirKey = '0' + i + 1;
			if( this->get_CurrentKeyBuffer( nVirKey ) && this->get_PreviousKeyBuffer( nVirKey ) == 0 ) {
				// ؂ւ
				this->m_aryTanyaPartsValidList[i] = !this->m_aryTanyaPartsValidList[i];
				E3DSetValidFlag( this->get_Player()->m_nSigID, this->m_aryTanyaPartsIndexList[i], this->m_aryTanyaPartsValidList[i] );
			}
		}
	} else if( this->get_Player()->m_Game.m_nType == PlayerType::EVIGEN ) {
		//////
		// ؂ւ
		for(int i = 0; i < Parts::MAX_NUM; i ++ ) {
			char nVirKey = '0' + i + 1;
			if( this->get_CurrentKeyBuffer( nVirKey ) && this->get_PreviousKeyBuffer( nVirKey ) == 0 ) {
				// ؂ւ
				this->m_aryPartsValidList[i] = !this->m_aryPartsValidList[i];
				E3DSetValidFlag( this->get_Player()->m_nSigID, this->m_aryPartsIndexList[i], this->m_aryPartsValidList[i] );
			}
		}

		//////
		// 
		float fStep = 0;
		if( this->get_CurrentKeyBuffer( 'P' ) && this->get_PreviousKeyBuffer( 'P' ) == 0 ) {
			fStep = CLOTH_ALPHA_STEP;
		}
		if( this->get_CurrentKeyBuffer( 'O' ) && this->get_PreviousKeyBuffer( 'O' ) == 0 ) {
			fStep = -CLOTH_ALPHA_STEP;
		}
		if( fStep != 0 ){
			this->set_MaterialAlpha( this->get_Player()->m_nSigID, "huku", &this->m_fClothAlpha, fStep );
		}
		fStep = 0;
		if( this->get_CurrentKeyBuffer( 'J' ) && this->get_PreviousKeyBuffer( 'J' ) == 0 ) {
			fStep = CLOTH_ALPHA_STEP;
		}
		if( this->get_CurrentKeyBuffer( 'H' ) && this->get_PreviousKeyBuffer( 'H' ) == 0 ) {
			fStep = -CLOTH_ALPHA_STEP;
		}
		if( fStep != 0 ){
			this->set_MaterialAlpha( this->get_Player()->m_nSigID, "huku_under", &this->m_fClothUnderAlpha, fStep );
		}
		fStep = 0;
		if( this->get_CurrentKeyBuffer( 'L' ) && this->get_PreviousKeyBuffer( 'L' ) == 0 ) {
			fStep = CLOTH_ALPHA_STEP;
		}
		if( this->get_CurrentKeyBuffer( 'K' ) && this->get_PreviousKeyBuffer( 'K' ) == 0 ) {
			fStep = -CLOTH_ALPHA_STEP;
		}
		if( fStep != 0 ){
			this->set_MaterialAlpha( this->get_Player()->m_nSigID, "apron", &this->m_fApronAlpha, fStep );
		}
		fStep = 0;
		if( this->get_CurrentKeyBuffer( 'N' ) && this->get_PreviousKeyBuffer( 'N' ) == 0 ) {
			fStep = CLOTH_ALPHA_STEP;
		}
		if( this->get_CurrentKeyBuffer( 'B' ) && this->get_PreviousKeyBuffer( 'B' ) == 0 ) {
			fStep = -CLOTH_ALPHA_STEP;
		}
		if( fStep != 0 ){
			this->set_MaterialAlpha( this->get_Player()->m_nSigID, "apron_under", &this->m_fApronUnderAlpha, fStep );
		}
		fStep = 0;
		if( this->get_CurrentKeyBuffer( VK_OEM_COMMA ) && this->get_PreviousKeyBuffer( VK_OEM_COMMA ) == 0 ) {
			fStep = CLOTH_ALPHA_STEP;
		}
		if( this->get_CurrentKeyBuffer( 'M' ) && this->get_PreviousKeyBuffer( 'M' ) == 0 ) {
			fStep = -CLOTH_ALPHA_STEP;
		}
		if( fStep != 0 ){
			this->set_MaterialAlpha( this->get_Player()->m_nSigID, "shitagi", &this->m_fUnderAlpha, fStep );
		//	this->set_MaterialAlpha( this->get_Player()->m_nSigID, "shitagi_under", &this->m_fUnderAlpha, fStep );
		}
		fStep = 0;
		if( this->get_CurrentKeyBuffer( 'U' ) && this->get_PreviousKeyBuffer( 'U' ) == 0 ) {
			fStep = CLOTH_ALPHA_STEP;
		}
		if( this->get_CurrentKeyBuffer( 'Y' ) && this->get_PreviousKeyBuffer( 'Y' ) == 0 ) {
			fStep = -CLOTH_ALPHA_STEP;
		}
		if( fStep != 0 ){
			this->set_MaterialAlpha( this->get_Player()->m_nSigID, "katyu", &this->m_fKatyuAlpha, fStep );
		}

		// j
		if( this->get_CurrentKeyBuffer( 'I' ) && this->get_PreviousKeyBuffer( 'I' ) == 0 ) {
			if( this->m_nClothBreak == 0 ) {
				this->m_nClothBreak = 1;
			} else {
				this->m_nClothBreak = 0;
			}
			this->set_Texture( this->get_Player()->m_nSigID, "huku", Material::CLOTH_NORMAL + this->m_nClothBreak, FALSE );
			this->set_Texture( this->get_Player()->m_nSigID, "huku_under", Material::CLOTH_NORMAL + this->m_nClothBreak, FALSE );
		}

		// ̐FύX
	/*	if( this->get_CurrentKeyBuffer( 'T' ) && this->get_PreviousKeyBuffer( 'T' ) == 0 ) {
			int nColor = 0;
			if( this->m_nUnderColor == 0 ) {
				nColor = 1;
			} else {
				nColor = 0;
			}
			this->setup_Under(nColor );
		}*/
	}

	/////////////////////////////////////////
	// et`Ώ
	int naryShadowSigIDList[ 100 ];// + OBJECT_MAX ];

	int cnt = 0;

	if( bIsPlayer ) {
		if( this->get_CameraMode() == CameraMode::SNIPER_MODE ) {
			// XiCp[[h͕\Ȃ
		} else {
			// XiCp[ȊOȂvC[\B
			naryShadowSigIDList[cnt] = this->get_Player()->m_nSigID;
			cnt ++;
		}
	}

	if( bIsGround ) {
		// n
		naryShadowSigIDList[ cnt] = this->get_GroundSigID();
		cnt ++;
	}

	if( cnt == 0 ) {
		return 0;
	}
	
	
	// et`
	ret = E3DRenderWithShadow( this->get_SwapChainID(), 
		this->m_nShadowSwapChainID,
		this->m_nShadowTextureID,
		naryShadowSigIDList,
		cnt,
		0);	// skipflag

	if( ret ) {
		_ASSERT( 0 );
		return ret;
	}
	return 0;
}

int StaticData::get_WallSigID() {
	return m_mapWallMap[ this->m_nSelectedWallType ];
}
int StaticData::set_WallType( int nWallType ) {
	this->m_nSelectedWallType = nWallType;
	return 0;
}

int StaticData::get_GroundSigID() {
	// TODO Xe[WɂĒn`ω
	return m_mapGroundMap[ m_nSelectedGroundType ];
}

/**
  *
  */
int StaticData::updatePlayerMotion() {
	int ret = 0;

	// ݂̃t[No擾
	int motid;
	int frameno;
	ret = E3DGetMotionFrameNoML( this->get_Player()->m_nSigID, this->get_Player()->m_nUpperBoneNumber, &motid, &frameno );

	//! Aj[V~߂
	BOOL bIsSkip = FALSE;

	//! Aj[V܂Ă
	BOOL bContinue = motid != 0 && this->get_Player()->m_nOldEventNumber == this->get_Player()->m_nEventNumber;

	if( motid != 0 && bContinue /* &&
		this->get_Player()->m_nOldEventNumber == this->get_Player()->m_nEventNumber*/)
	{
		// Aj[Voߒ

		BOOL bIsFlying = this->get_Player()->m_Move.get_Trigger( TriggerType::ON_THE_GROUND ) == FALSE;

		if( this->get_Player()->m_Game.m_nType == PlayerType::EVIGEN ) {
			if( frameno > 28 && this->get_Player()->m_nEventNumber == Motion::Evigen::MINI_GUN_UP ) {
				// ɏグ铮삪I

				// SԂɂ
				this->get_Player()->m_nEventNumber = Motion::Evigen::MINI_GUN_CARRY;

			} else if( frameno > 43 && this->get_Player()->m_nEventNumber == Motion::Evigen::HAND_GUN_RELOAD ) {
				// [hI

				// IDLEԂɖ߂
				this->get_Player()->m_nEventNumber = Motion::Evigen::HAND_GUN_IDLE;

			} else if( frameno > 8 && this->get_Player()->m_nEventNumber == Motion::Evigen::HAND_GUN_UP ) {
				// グ铮
				this->get_Player()->m_nEventNumber = Motion::Evigen::HAND_GUN_IDLE;

			} else if( this->get_Player()->m_nEventNumber == Motion::Evigen::DAMAGE_A ||
				this->get_Player()->m_nEventNumber == Motion::Evigen::DAMAGE_B )
			{
				// _[W

				if( this->get_Player()->m_Game.m_nHolderSigID >= 0) {
					// ߂܂Ă
					// ̂܂܌p
					if( frameno == 18) {
						
						// o
						if( MathTool::nextRandom<float>(0,100 ) < 50 ) {
							int nVoiceID = Sound::VOICE_HIT_1 + MathTool::nextRandom<int>(0,2 );
							ret = E3DPlaySound( this->m_arySoundList[ nVoiceID ], 0, 0, 0 );
						}

						// o
						this->create_PlayerBlood();

						//float fOldHP = this->get_Player()->m_Game.m_fHP;

						const float ZOMBIE_HOLD_DAMAGE = 3;
						// _[W
						this->get_Player()->m_Game.set_HP( this->get_Player()->m_Game.m_fHP - ZOMBIE_HOLD_DAMAGE );

					}
				} else {
					
					if( bContinue && frameno > 10) {
						// ܂Ă
						// 10t[̓Xgbv
						bIsSkip = TRUE;
					}
				}
			} else if( this->get_Player()->m_nEventNumber == Motion::Evigen::DAMAGE_CRASH_UP &&
				bContinue && bIsFlying && frameno > 10) {
				// &

				//ωȂ
		//		if( bContinue ) {
					bIsSkip = TRUE;
		//		}

			} else if( this->get_Player()->m_nEventNumber == Motion::Evigen::DAMAGE_BOUND ) {

				if( frameno > 48 && bContinue) {
					// DOWNցB
					this->get_Player()->m_nEventNumber = Motion::Evigen::DOWN;

					// \ύX
					ret = this->set_Texture( this->get_Player()->m_nSigID, "atama", Material::DOWN, TRUE );
				}

			} else if( frameno > 65 && this->get_Player()->m_nEventNumber == Motion::Evigen::RETURN ) {

				// [VƂɖ߂
				this->get_Player()->m_nEventNumber = Motion::Evigen::IDLE;

				// A
				this->restorePlayer();

			} else if( frameno > 109 && this->get_Player()->m_nEventNumber == Motion::Evigen::DEATH ) {
				bIsSkip = TRUE;
			} else if( frameno == 370 && this->get_Player()->m_nEventNumber == Motion::Evigen::SWALLOW ) {
				// n
				for(int i = 0; i < Parts::MAX_NUM; i ++ ) {
					
					if( this->m_aryPartsValidList[i] == TRUE ) {
						// ܂Ă
						// 
						this->m_aryPartsValidList[i] = FALSE;
						ret = E3DSetValidFlag( this->get_Player()->m_nSigID, this->m_aryPartsIndexList[i], this->m_aryPartsValidList[i] );
					}

				}
			} else if( frameno > 438 && this->get_Player()->m_nEventNumber == Motion::Evigen::SWALLOW ) {
				bIsSkip = TRUE;
			}
		
		}else if( this->get_Player()->m_Game.m_nType == PlayerType::TANYA ) {
			if( frameno > 18 && bContinue && this->get_Player()->m_nEventNumber == Motion::Tanya::JUMP_UP ) {
				bIsSkip = TRUE;
			}
		} else {
			_ASSERT(0);
		}
	}

	if( this->get_Player()->m_Game.m_nType == PlayerType::EVIGEN ) {
		if( this->get_Player()->m_nEventNumber >= Motion::Evigen::DAMAGE_A &&
			this->get_Player()->m_nEventNumber <= Motion::Evigen::RETURN ||
			this->get_Player()->m_nEventNumber == Motion::Evigen::SWALLOW
			)
		{
			// _[W
				
			// ~jKB
			this->set_WeaponEnable( FALSE );

		} else if( this->m_nWeaponIndex == WeaponType::MINI_GUN &&
			this->get_Player()->m_nEventNumber >= Motion::Evigen::MINI_GUN_SETTLE &&
			this->get_Player()->m_nEventNumber <= Motion::Evigen::MINI_GUN_DOWN ||
			this->m_nWeaponIndex == WeaponType::HAND_GUN &&
			this->get_Player()->m_nEventNumber >= Motion::Evigen::HAND_GUN_SETTLE &&
			this->get_Player()->m_nEventNumber <= Motion::Evigen::HAND_GUN_RELOAD
			) {
			// ~jK/nho
			this->set_WeaponEnable( TRUE );

			if( this->m_nWeaponIndex == WeaponType::MINI_GUN ) {
				if( this->get_Player()->m_nUnderEventNumber == Motion::Evigen::RUN ) {
					this->get_Player()->m_nUnderEventNumber = Motion::Evigen::WALK;
				}
			}
		}
	}

	// vC[̃[VύX
	if( bIsSkip == FALSE ) {
		if( this->get_Player()->m_nUnderEventNumber >= 0 ) {
			//	this->get_Player()->m_nUpperBoneNumber,
			//	this->get_Player()->m_nUnderBoneNumber,
			// ㉺ŕĂ
			// 㔼g
			int upperList[5];
			int upperNoList[5];
			int underList[5];
			int underNoList[5];
#define UPPER_BASE 1
#ifdef UPPER_BASE
			//㔼g
			upperList[0] = -1;
			upperList[1] = 0;
			upperNoList[0] = 0;

			// g
			underList[0] = this->get_Player()->m_nUnderBoneNumber;
			underList[1] = 0;
			underNoList[0] = 0;

			ret = E3DSetMOAEventNoML( this->get_Player()->m_nSigID, this->get_Player()->m_nEventNumber,
				upperList, upperNoList );
			ret = E3DSetMOAEventNoML( this->get_Player()->m_nSigID, this->get_Player()->m_nUnderEventNumber,
				underList, underNoList );
#else
			//㔼g
			upperList[0] = -1;//this->get_Player()->m_nUpperBoneNumber;
			upperList[1] = 0;//this->get_Player()->m_nWeaponBoneNumber;
			upperList[2] = 0;//this->get_Player()->m_nWeaponBoneNumber2;
			upperList[3] = 0;

			upperNoList[0] = 0;//this->get_Player()->m_nUnderBoneNumber;
			upperNoList[1] = 0;

			// g
			underList[0] = this->get_Player()->m_nBaseBoneNumber;
			underList[1] = 0;
			underNoList[0] = this->get_Player()->m_nUpperBoneNumber;
			underNoList[1] = 0;

			ret = E3DSetMOAEventNoML( this->get_Player()->m_nSigID, this->get_Player()->m_nEventNumber,
				upperList, upperNoList );
			ret = E3DSetMOAEventNoML( this->get_Player()->m_nSigID, this->get_Player()->m_nUnderEventNumber,
				underList, underNoList );
#endif

			/*if( ret ){
				_ASSERT( 0 );
				return 1;
			}*/
			/*if( ret ){
				_ASSERT( 0 );
				return 1;
			}*/

			/*int weapList[] = {
				this->get_Player()->m_nWeaponBoneNumber,
				0
			};
			int weapNoList[] = {
				0
			};
			ret = E3DSetMOAEventNoML( this->get_Player()->m_nSigID, this->get_Player()->m_nEventNumber,
				weapList, weapNoList );*/

			ret = E3DSetNewPoseML( this->get_Player()->m_nSigID );
			/*if( ret ){
				_ASSERT( 0 );
				return 1;
			}*/
		} else
		{
		/*	int upperList[] = {
				this->get_Player()->m_nUpperBoneNumber,
				0
			};
			int upperNoList[] = {
				0
			};
			// g
			int underList[] = {
				this->get_Player()->m_nUnderBoneNumber,
				0
			};
			int underNoList[] = {
				0
			};
			ret = E3DSetMOAEventNoML( this->get_Player()->m_nSigID, this->get_Player()->m_nEventNumber,
				underList, underNoList );
			ret = E3DSetMOAEventNoML( this->get_Player()->m_nSigID, this->get_Player()->m_nEventNumber,
				upperList, upperNoList );

			E3DSetNewPoseML( this->get_Player()->m_nSigID );*/
			int baseList[] = {
				-1,
				0
			};
			int baseNoList[] = {
				0
			};
			int eventno = this->get_Player()->m_nEventNumber;
			ret = E3DSetMOAEventNoML( this->get_Player()->m_nSigID, eventno,
				baseList, baseNoList );
			if( ret ){
				_ASSERT( 0 );
				return 1;
			}
			ret = E3DSetNewPoseML( this->get_Player()->m_nSigID );
			if( ret ){
				_ASSERT( 0 );
				return 1;
			}
			//ret = E3DSetNewPoseByMOA(this->get_Player()->m_nSigID, this->get_Player()->m_nEventNumber );
		}
	}

	// XV
	this->get_Player()->m_nOldEventNumber = this->get_Player()->m_nEventNumber;
	return 0;
}

StaticData* staticData = NULL;

/**
  * J[hAT_TARGETɂB
  * JʒuvC[̖ڂ̑Oɂ
  * @param[in]	nSigID			ڂ̑OɈړΏۂSIGID
  * @param[in]	fHeightDelta	YDelta
  */
int StaticData::set_CameraInFrontOfObject( int nSigID, float fHeightDelta ) {
	// AT_TARGET[h
	this->set_CameraMode( CameraMode::AT_TARGET_MODE, nSigID ) ;

	// vC[̕
	D3DXVECTOR3 vDirection;
	int ret = 0;
	ret = E3DGetCharaDir( nSigID, 0,0, &vDirection);
	// ɏ炷
	vDirection.y = fHeightDelta;//-200.f;
	D3DXVec3Normalize( &vDirection, &vDirection );


	// JiTeCgj̏AT_TARGETJvC[̕ɂ
	this->get_Camera()->set_NormalizedQuatanionDirection( vDirection );
	return 0;
}

/** ̕\/\؂ւ
  * @param[in]	bEnable	TRUE	\
  * @param[in]	bEnable	FALSE	\
  *
  */
int StaticData::set_WeaponEnable( BOOL bEnable ) {
	int w = this->m_nWeaponIndex;

	int ret = 0;
	int partno = 0;
	if( this->get_Player()->m_Game.m_nType == PlayerType::EVIGEN ) {

		BOOL bMiniGunEnable = FALSE;
		BOOL bHandGunEnable = FALSE;
		if( w == WeaponType::MINI_GUN ) {
			bMiniGunEnable = bEnable;
		} else if( w == WeaponType::HAND_GUN ) {
			bHandGunEnable = bEnable;
		}
		ret = E3DGetPartNoByName( this->get_Player()->m_nSigID, "barrel", &partno );
		if( ret ) {
			_ASSERT( 0 );
		}
		ret = E3DSetValidFlag( this->get_Player()->m_nSigID, partno, bMiniGunEnable );
		if( ret ) {
			_ASSERT( 0 );
		}
		ret = E3DGetPartNoByName( this->get_Player()->m_nSigID, "trunk", &partno );
		if( ret ) {
			_ASSERT( 0 );
		}
		ret = E3DSetValidFlag( this->get_Player()->m_nSigID, partno, bMiniGunEnable );
		if( ret ) {
			_ASSERT( 0 );
		}

		ret = E3DGetPartNoByName( this->get_Player()->m_nSigID, "barrel_handgun", &partno );
		if( ret ) {
			_ASSERT( 0 );
		}
		ret = E3DSetValidFlag( this->get_Player()->m_nSigID, partno, bHandGunEnable );
		if( ret ) {
			_ASSERT( 0 );
		}
		ret = E3DGetPartNoByName( this->get_Player()->m_nSigID, "trunk_handgun", &partno );
		if( ret ) {
			_ASSERT( 0 );
		}
		ret = E3DSetValidFlag( this->get_Player()->m_nSigID, partno, bHandGunEnable );
		if( ret ) {
			_ASSERT( 0 );
		}
		ret = E3DGetPartNoByName( this->get_Player()->m_nSigID, "cartridge_handgun", &partno );
		if( ret ) {
			_ASSERT( 0 );
		}
		ret = E3DSetValidFlag( this->get_Player()->m_nSigID, partno, bHandGunEnable );
		if( ret ) {
			_ASSERT( 0 );
		}
	}

	return 0;
}

// A
int StaticData::restorePlayer() {
	int ret = 0;

	if( this->get_Player()->m_Game.m_nType == PlayerType::EVIGEN ) {
		// \ɖ߂
		ret = this->set_Texture( this->get_Player()->m_nSigID, "atama", Material::NORMAL, TRUE );
	}

	return 0;
}

BOOL StaticData::is_MultiLayerMotion() {
	return this->m_nWeaponIndex == WeaponType::MINI_GUN ||
			this->m_nWeaponIndex == WeaponType::HAND_GUN;
}

/** {^NbNȂǁAUIIȓsV[ł̋ʏ
  * ΏہF^Cg/ViII/Q[I[o[
  *
  */
int StaticData::initUISceneCommon() {
	// }EX͎Rɓ
	this->set_Grab( FALSE );

	return 0;
}

int StaticData::set_GroundType( int nGroundType ) {
	this->m_nSelectedGroundType = nGroundType;
	if( nGroundType == GroundType::PRACTICE_ROOM ) {
		this->set_WallType( WallType::PRACTICE_ROOM ) ;
	} else if( nGroundType == GroundType::ZOMBIE ) {
		this->set_WallType( WallType::ZOMBIE ) ;
	} else if( nGroundType == GroundType::WORM ) {
		this->set_WallType( WallType::WORM ) ;
	} else {
		this->set_WallType( -1 ) ;
	}
	return 0;
}

BOOL StaticData::set_MouseOverSpriteColor(int nSpriteID, int nPointX, int nPointY, int nRectX, int nRectY, int nRectWidth, int nRectHeight,
	int nOverColR, int nOverColG, int nOverColB, int nOverColA,
	int nNormalColR, int nNormalColG, int nNormalColB, int nNormalColA ) 
{
	int ret = 0;
	if( nPointX >= nRectX && nPointX <= nRectX + nRectWidth &&
		nPointY >= nRectY && nPointY <= nRectY + nRectHeight )
	{
		// J[\ɓ
		E3DCOLOR4UC uc = {nOverColA, nOverColR, nOverColG, nOverColB };
		// Ԃ
		ret = E3DSetSpriteARGB( nSpriteID, uc );

		return TRUE;
	} else {
		E3DCOLOR4UC uc = {nNormalColA,nNormalColR,nNormalColG,nNormalColB };
		ret = E3DSetSpriteARGB( nSpriteID, uc );

		return FALSE;
	}
	
}

void StaticData::reset_Weapons() {
	for( int i = 0; i < WeaponType::MAX_NUM; i ++ ) {
		m_aryWeaponList[i].resetFirst();
	}
}
void StaticData::set_BGMIndex( int nBGMIndex ) {
	int ret = 0;
	int nIsPlay;
	ret = E3DIsSoundPlaying( this->m_arySoundList[this->m_nBGMIndex] , &nIsPlay );
	if( nIsPlay ) {
		ret = E3DStopSound( this->m_arySoundList[this->m_nBGMIndex] );
	}
	this->m_nBGMIndex = nBGMIndex;
	ret = E3DPlaySound( this->m_arySoundList[this->m_nBGMIndex], 0, 0, 255 );
}
E3DBillBoard* StaticData::create_Blood( D3DXVECTOR3& vPosition,
									   D3DXVECTOR3& vDirection) {
	E3DBillBoard* billBoard = this->m_BloodBillBoardManager.search();
	if( billBoard != NULL ) {
		// 

		// ʒuݒ
		E3DSetBillboardPos( billBoard->get_BillBoardID(), vPosition );

		// _ɂ
		D3DXVECTOR3 v = vDirection;

		// AɃ_ɗh炷
		VectorTool::rotateHorizontal( &v, &v, MathTool::nextRandom<float>(-BLOOD_ERROR_DEGREE,BLOOD_ERROR_DEGREE) );
		VectorTool::rotateVertical( &v, &v, MathTool::nextRandom<float>(-BLOOD_ERROR_DEGREE,BLOOD_ERROR_DEGREE) );

		// x
		D3DXVec3Scale( &v, &v, BLOOD_SPEED );

		// ړAxo^
		billBoard->set_Velocity( v );

		// JE^ݒ
		billBoard->set_LifeCounterMax( BLOOD_LIFE_COUNT );
		billBoard->reset();

	}
	return billBoard;

}


void StaticData::create_PlayerBlood() {
	////////////
	// vC[̈ʒu{vC[̕~苗猌o
	// ڂ̍
	D3DXVECTOR3 vEyeHeight( 0, PLAYER_EYE_HEIGHT_FROM_CENTER , 0 );
	D3DXVECTOR3 vBloodPosition = this->get_Player()->m_Move.m_vPosition;

	// ڂ̍ɂ
	vBloodPosition += vEyeHeight;

	// vC[̕
	D3DXVECTOR3 vDirection;
	E3DGetCharaDir( this->get_Player()->m_nSigID, 0,0, &vDirection );
	vDirection *= -1;
	vDirection.y = 0;
	// normalize
	D3DXVec3Normalize( &vDirection, &vDirection );

	D3DXVECTOR3 vBloodDistance = vDirection;
	//scale
	D3DXVec3Scale( &vBloodDistance, &vBloodDistance, SHOT_FROM_DISTANCE );

	vBloodPosition += vBloodDistance;

	// 萔o
	for(int i = 0; i < PLAYER_DAMAGE_BLOOD_NUM; i ++ ) {
		this->create_Blood( vBloodPosition, vDirection );
	}
}

void StaticData::remove_Head() {
	if( this->get_Player()->m_Game.m_nType != PlayerType::EVIGEN ) {
		return ;
	}

	int ret = 0;

	// 
	char MATS[][100] = {
		"atama",
		"kami",
		"katyu",
	};
	for(int i = 0; i < 3; i ++ ) {
		int mat = 0;
		ret = E3DGetMaterialNoByName( this->get_Player()->m_nSigID, MATS[i], &mat );
		if( ret ) {
			_ASSERT(0);
		}
		ret = E3DSetMaterialAlpha( this->get_Player()->m_nSigID, mat, 0.f );
		if( ret ) {
			_ASSERT(0);
		}
	}
	// ̒fʂ\
	int mat = 0;
	ret = E3DGetMaterialNoByName( this->get_Player()->m_nSigID, "danmen", &mat );
	if( ret ) {
		_ASSERT( 0 );
		return ;
	}
	ret = E3DSetMaterialAlpha( this->get_Player()->m_nSigID, mat, 1.f );
	if( ret ) {
		_ASSERT( 0 );
		return ;
	}

	/////
	// 񐶐
	E3DObject* head = this->m_NeutralManager.search( NeutralType::HEAD );
	if( head != NULL ) {
		// ڂ̍
		D3DXVECTOR3 vEyeHeightVector(0,PLAYER_EYE_HEIGHT_FROM_CENTER,0);

		// vC[̈ʒu
		D3DXVECTOR3 vPlayerPosition;
		E3DGetPos( this->get_Player()->m_nSigID, &vPlayerPosition );
		E3DSetPos( head->m_nSigID, 
			vPlayerPosition + vEyeHeightVector);

		D3DXVECTOR3 vError(MathTool::nextRandom<float>(-HEAD_ERROR, HEAD_ERROR),
			0,MathTool::nextRandom<float>(-HEAD_ERROR, HEAD_ERROR ) );

		// _
		this->face( vError, 1, head->m_nSigID, head->m_Move.m_nQuoatanion );

		head->m_Move.m_vVelocity = vError;
		head->m_Move.m_vVelocity.y = HEAD_SPEED + MathTool::nextRandom<float>(-HEAD_ERROR, HEAD_ERROR );

	}

}
void StaticData::set_DirectionToVelocity( HPL::E3D::E3DObject* obj, float fSpeedRate ) {
	int ret = 0;

	//D3DXVECTOR3 vPosition;
	//ret = E3DGetPos( obj->m_nSigID, &vPosition );
	// vC[ւ̕擾
	//D3DXVECTOR3 vDiff = vPlayerPosition - vPosition;

	D3DXVECTOR3 vDirection;
	ret = E3DGetCharaDir( obj->m_nSigID, 0, 0, &vDirection );
	//vDirection *= -1;


	
	// Y͕ςȂiWvƂ̂ŕύXȂƁj
	vDirection.y = 0;
	D3DXVec3Normalize( &vDirection, &vDirection );
	D3DXVec3Scale( &vDirection, &vDirection, obj->m_Move.m_fSpeed * fSpeedRate);

	// ړʂݒiĂɂj
	obj->m_Move.m_vVelocity.x = vDirection.x;
	obj->m_Move.m_vVelocity.z = vDirection.z;
}

void StaticData::setup_Under( int nColor ) {

	E3DObject* player = &(m_aryPlayerList[PlayerType::EVIGEN]);

	//if( this->get_Player()->m_Game.m_nType == PlayerType::EVIGEN ) {
	this->m_nUnderColor = nColor;
	this->set_Texture( player->m_nSigID, "shitagi", Material::UNDER + this->m_nUnderColor, FALSE );

	// ̂ύX

	int nTex = m_nUnderColor == 0 ? Material::KARADA_NORMAL : Material::KARADA_BLACK;
	this->set_Texture( player->m_nSigID, "karada", nTex, FALSE );

	int ret = 0;

	ret = this->set_Texture( player->m_nSigID, "karada_under", nTex, FALSE );
	//}
}


void StaticData::blow_Out( E3DObject* oBlower, E3DObject* oTarget , float fRate ) {
	D3DXVECTOR3 vPlayerPosition;
	E3DGetPos( oTarget->m_nSigID, 
		&vPlayerPosition );
	D3DXVECTOR3 vObjectPosition;
	E3DGetPos( oBlower->m_nSigID, 
		&vObjectPosition );

	D3DXVECTOR3 vDiff = vObjectPosition - vPlayerPosition;

	
	D3DXVECTOR3 vVel = -vDiff;
	D3DXVec3Normalize( &vVel, &vVel );
	if( fabs(vVel.x) <= PLAYER_DAMAGE_MIN_DISTANCE && fabs(vVel.z) <= PLAYER_DAMAGE_MIN_DISTANCE ) {
		vVel.x = MathTool::nextRandom<float>(-1.f,1.f);
		vVel.z = MathTool::nextRandom<float>(-1.f,1.f);
		D3DXVec3Normalize( &vVel, &vVel );
	}
	vVel *= PLAYER_RUN_SPEED * PLAYER_BLOWEN_SPEED_RATE * fRate;

	vVel.y = PLAYER_JUMP_SPEED_Y;
	oTarget->m_Move.set_Trigger( TriggerType::ON_THE_GROUND, FALSE );

	//oTarget->m_Move.m_vPosition = vPlayerPosition;
	oTarget->m_Move.m_vVelocity = vVel;
	oTarget->m_Move.m_vPosition += oTarget->m_Move.m_vVelocity;
	E3DSetPos( oTarget->m_nSigID, oTarget->m_Move.m_vPosition );

}

void StaticData::afterRenderCommon() {
	int ret = 0;
	// beforepos
	ret = E3DSetBeforePos( this->get_Player()->m_nSigID) ;

	//ret = E3DSetBeforeBlur( this->get_Player()->m_nSigID );
}

void StaticData::change_PlayerType( int nType ) {
	int ret = 0;

	if( nType != this->get_Player()->m_Game.m_nType ) {
		// Õf
		ret = E3DSetValidFlag( this->get_Player()->m_nSigID, -1, FALSE );
		if( ret ){
			_ASSERT(0);
		}

		//this->get_Player()->m_Game.m_nType = nType;
		this->m_nPlayerType = nType;

		// ݂̃fo
		ret = E3DSetValidFlag( this->get_Player()->m_nSigID, -1, TRUE );
		if( ret ){
			_ASSERT(0);
		}

		if( nType == PlayerType::EVIGEN ) {

			this->reset_EvigenMaterial();
		} else if( nType == PlayerType::TANYA ) {
			// 
			for(int i = 0; i < TanyaParts::MAX_NUM; i ++ ) {
				this->m_aryTanyaPartsValidList[i] = TRUE;
				ret = E3DSetValidFlag( this->get_Player()->m_nSigID,
					this->m_aryTanyaPartsIndexList[i], this->m_aryTanyaPartsValidList[i] );
				if(ret ) {
					_ASSERT(0);
				}
			}
		}
			// ύX
		//this->get_Player()->m_nSigID = this->m_aryPlayerSigIDList[nType];
		// J̒S
		this->m_nCameraTargetSigID = this->get_Player()->m_nSigID;

		// 평
		this->reset_Weapons();

		// ύX
		//TODO
		for( int i = 0; i < WeaponType::MAX_NUM; i ++ ) {
			BOOL bEnable = FALSE;

			if( i < WeaponType::MAX_EVIGEN ) {
				if( nType == PlayerType::EVIGEN ) {
					bEnable = TRUE;
				} else {
				}
			} else {
				if( nType == PlayerType::TANYA ) {
					bEnable = TRUE;
				} else {
				}

			}
			this->m_aryWeaponList[i].set_Enable( bEnable );
		}

		int nWeaponType = WeaponType::GRANADE_LAUNCHER;
		if( nType == PlayerType::EVIGEN ) {
		} else if( nType == PlayerType::TANYA ) {
			nWeaponType = WeaponType::CROWBAR;
		}
		this->set_WeaponIndex( nWeaponType);
	}
}

void StaticData::reset_EvigenMaterial() {
	int ret = 0;

	E3DObject* player = &(this->m_aryPlayerList[PlayerType::EVIGEN]);

	// 
	for(int i = 0; i < Parts::MAX_NUM; i ++ ) {
		this->m_aryPartsValidList[i] = TRUE;
		ret = E3DSetValidFlag( player->m_nSigID,
			this->m_aryPartsIndexList[i], this->m_aryPartsValidList[i] );
		if(ret ) {
			_ASSERT(0);
		}
	}
	// }eA
	char MATS[][100] = {
		"atama",
		"kami",
		"karada",
		"huku",
		"apron",
		"katyu",
		"shitagi",
		"huku_under",
		//"shitagi_under",
		"apron_under",
	};
	for(int i = 0; i < 9; i ++ ) {
		int mat = 0;
		ret = E3DGetMaterialNoByName( player->m_nSigID, MATS[i], &mat );
		if( ret ) {
			_ASSERT( 0 );
			return ;
		}
		ret = E3DSetMaterialAlpha( player->m_nSigID, mat, 1 );
		if( ret ) {
			_ASSERT( 0 );
			return ;
		}
	}
	// fʂ͏Ă
	char MATS_FALSE[][100] = {
		"danmen",
		"danmen_body",
	};
	for(int i = 0; i < 2; i ++ ) {
		int mat = 0;
		E3DGetMaterialNoByName( player->m_nSigID, MATS_FALSE[i], &mat );
		if( ret ) {
			_ASSERT( 0 );
			return ;
		}
		E3DSetMaterialAlpha( player->m_nSigID, mat, 0.f );
		if( ret ) {
			_ASSERT( 0 );
			return ;
		}
	}
	ret = staticData->set_Texture( player->m_nSigID, "atama", Material::NORMAL, TRUE );
	if( ret ) {
		_ASSERT( 0 );
		return ;
	}
	int nTex = staticData->m_nUnderColor == 0 ? Material::KARADA_NORMAL : Material::KARADA_BLACK;
	ret = staticData->set_Texture( player->m_nSigID, "karada", nTex, FALSE );
	if( ret ) {
		_ASSERT( 0 );
		return ;
	}
	ret = staticData->set_Texture( player->m_nSigID, "karada_under", nTex, FALSE );
	if( ret ) {
		_ASSERT( 0 );
		return ;
	}
}

E3DObject* StaticData::get_Player() {
	return &this->m_aryPlayerList[this->m_nPlayerType];
}

}// namespace MotionTest end



