#ifndef _STATIC_DATA_
#define _STATIC_DATA_

#include <HPLE3DLapper.h>

#include "resource.h"

#include "GEnum.h"
#include "EnemyLifeBar.h"

#include "Weapon.h"

#include "EnemyManager.h"
#include "ShotManager.h"
#include "NeutralManager.h"

#include "TitleScene.h"

using namespace HPL;
using namespace E3D;

namespace MotionTest {

/** [VeXg̒萔
  *
  */
namespace MotionTestConsts {
	static const float GRAVITY = -3.0f;
	static const float GROUND_SIZE = 60000.0f;
	static const float GROUND_DIVX = 30.f;
	static const float GROUND_DIVZ = 30.f;
	static const float GROUND_HEIGHT = 0.f;

	static const float PLAYER_WALK_SPEED = 20.f;
	static const float PLAYER_RUN_SPEED = 120.f;
	static const float PLAYER_BACKWARD_SPEED = 20.f;
	static const float PLAYER_STRAIF_SPEED = 20.f;
	static const int PLAYER_ROTATE_DIVISION = 3;
	static const float PLAYER_BLOWEN_SPEED_RATE = 2.f;
	//static const float MOUSE_LOOK_ZOOM_STEP = 10.f;		//! JߕύXXebv
	static const float MOUSE_LOOK_ZOOM_MAX = 10000.f;		//! JߕύXől
	static const float MOUSE_LOOK_ZOOM_MIN = 800.f;		//! JߕύXŏl
	static const float MOUSE_LOOK_ZOOM_STEP_RATE = 0.001f;	//! JgύX(݂̋*̒l=ύX)

	static const int OBJECT_MAX = 10;
	static const int WORM_BIG_MAX = 1;
	static const int WORM_SMALL_MAX = 10;
	static const int ENEMY_LIFE_BAR_STACK_NUM_MAX = 5;
	static const int ENEMY_LIFE_BAR_INTERVAL_Y = 5;
	static const int ENEMY_LIFE_BAR_REMAIN_COUNT = 30;
	static const float ENEMY_WALK_RATE = 1.3f;
	static const float RECOGNIZE_THRESHOLD = 20000.f;
	static const int ZOMBIE_MAX = 10;
	static const float ZOMBIE_HOLD_DISTANCE = 400.f;
	static const int MOSUKO_MAX = 20;
	static const int ZOMBIE_B_MAX = 1;
	static const float ZOMBIE_B_JUMP_SPEED = 20.f;

	static const int SHOT_MAX = 20;
	static const int SHOT_LIFE_COUNT = 120;
	static const float SHOT_SPEED = 500.f;
	static const float SHOT_SIZE = 200.f;
//	static const float SHOT_AT_TARGET_MODE_ERROR = 5.f;	//! ˕̃Y(x) TODO 킲ƂɈقȂ
//	static const float SHOT_SHOT_BEHIND_MODE_ERROR = 2.f;
	static const float SHOT_AT_TARGET_MODE_ERROR_RATE = 2.5f;

	static const int SHELL_LIFE_COUNT = 50;

	static const int MISSILE_MAX = 10;
	static const int SHELL_MAX = 10;
	static const float SHELL_SPEED = 25.f;
	static const float SHELL_ERROR = 5.f;
	static const float HEAD_ERROR = 5.f;
	static const float HEAD_SPEED = 70.f;

	static const float MAP_SIZE = 60000;
	static const int MAP_DIV = 30;
	static const float MAP_HEIGHT = 200000.f;
	static const float MAP_MIN = -100.f;

	//static const int MAP_NUM = 1;
	static const float PLAYER_JUMP_SPEED_Y = 70.f;
	static const float PLAYER_JUMP_ACCEL_Y = 30.f;

	static const int LIFE_FRAME_MERGINE = 10;			//! Cto[̃t[ʒ[ǂꂾĕ`悷邩
	//static const int LIFE_BAR_LEFT_DELTA = 12;
	//static const int LIFE_BAR_TOP_DELTA = 12;

	static const int LIFE_AND_GUNS_MERGINE = 10;	//! \ƃCtt[̊Ԃ̃XL}
	static const int AMMO_TEXT_MERGINE = 60;
	static const int UI_ALPHA = 180;
	static const int WINDOW_FRAME_DELTA = 10;

	static const int TEXT_DELTA_X = 0;
	static const int TEXT_DELTA_Y = 0;

	static const float ENEMY_DAMAGE = 10;
	static const float PLAYER_DAMAGE_MIN_DISTANCE = 100.f;

	static const float SHOT_POWER = 10;
	static const float SHOT_MISSILE_POWER = 100;

	static const int DEFAULT_GENERATE_COUNTER = 100;
	static const int GENERATE_DECREASE_STEP = 1;

	static const int MEDI_KIT_NUM = 10;
	static const int AMMO_NUM = 10;
	static const int MEAT_NUM = 3;
	static const int CONSOLE_NUM = 10;

	static const int ITEM_REMAIN_COUNTER_MAX = 20000;

	static const float MEDI_KIT_HEAL_RATE = 0.3f;
	static const float MEAT_HEAL_RATE = 1.f;

	static const float SHOT_FROM_DISTANCE = 1200.f;

	static const float CLOTH_ALPHA_STEP = 0.1f;

	static const int OPTION_MERGINE_X = 170;
	static const int OPTION_TEXT_MERGINE_Y = 8;				//! ^CgʁAẼIvVʒu

	static const int BLOOD_MAX = 10;						//! MAX
	static const float BLOOD_SIZE = 300.f;
	static const int BLOOD_LIFE_COUNT = 120;
	static const float BLOOD_SPEED = 100.f;
	static const int PLAYER_DAMAGE_BLOOD_NUM = 10;
	static const float BLOOD_ERROR_DEGREE = 60.f;

	static const long TITLE_ROTATE_Y_SPEED = 1;
	namespace Sprite {
		enum {
			CROSS_HAIR,
			LIFE_FRAME,
			LIFE_BAR,
			GUN_01_MINI_GUN,
			ENEMY_LIFE_BAR,
			GUN_02_MACHINE_GUN,
			GUN_03_MISSILE_LAUNCHER,
			TITLE,
			TITLE_SUBJECT,
			GUN_04_HAND_GUN,
			GUN_05_GRANADE_LAUNCHER,
			SELECT_MISSION,
			MISSION_FRAME,
			PREVIOUS_BUTTON,
			NEXT_BUTTON,
			MESSAGE_FRAME,
			CHECK_BOX,
			CHECK_BOX_CHECKED,
			//LOADING_SCREEN,
			TITLE_SCREEN,
			GUN_06_CROWBAR,
		};
	}
	namespace Motion {
		namespace Evigen {
			enum {
				IDLE,
				RUN,
				WALK,
				CROUCH,
				JUMP_UP,
				JUMP_DOWN,
				MINI_GUN_SETTLE,// \
				MINI_GUN_FIRE,	// 
				MINI_GUN_UP,	// グ
				MINI_GUN_CARRY,	// ĂȂ
				MINI_GUN_DOWN,	// \Ԃɓ
				DAMAGE_A,		// _[W
				DAMAGE_B,		// _[W
				DAMAGE_CRASH_UP,// 
				DAMAGE_BOUND,	// n
				DOWN,			//_EandтŎS
				DEATH,
				RETURN,			// ߂
				HAND_GUN_IDLE,		//ҋ@
				HAND_GUN_SETTLE,	//\
				HAND_GUN_FIRE,
				HAND_GUN_UP,
				HAND_GUN_DOWN,
				HAND_GUN_RELOAD,
				SWALLOW,			//ۓۂ܂
			};
		}
		namespace Tanya{
			enum {
				IDLE,
				WALK,
				RUN,
				CROUCH,
				JUMP_UP,
				JUMP_DOWN,
				BAR_SET,
				BAR_ATTACK,
			};
		}
		namespace Worm{
			enum {
				IDLE,
				TURN_RIGHT,
				TURN_LEFT,
				MOVE,				//Oi
				DIVE,
				APPEAR,
				STAND,
				ATTACK_A,			// オ聨ݕt
				DOWN_DIVE,			// オ聨
				BRITS,				// Jēːi
				ATTACK_B,			// 蒆Ɋݕt
				VOMIT,				// fo
				DEAD,				// 
				DOWN,				// ԂMOVEɈڍs
				SWALLOW,			// ۓۂ
			};
		}

		namespace Zombie {
			enum {
				IDLE,
				WALK,
				ATTACK_A,			// UP
				ATTACK_B,			// UQ
				ATTACK_C,			// z[hB-> HOLDցB
				HOLD,				// ݕt
				RELEASE,			// vC[
				DEAD,				// S
			};
		}
		namespace Zombie_B {
			enum {
				IDLE,
				RUN,
				JUMP_ON,			// WvJn
				JUMP_ATTACK,
				ATTACK_A,			// nUBOi
				AIR_DAMAGE,
				DEAD,

			};
		}

		namespace Head {
			enum {
				IDLE,
				I_CAN_FLY,
				SLEEP,
			};
		}

		namespace Mosuko {
			enum {
				IDLE,
				RUN,
				SIDEWALK,
				GUN,
				ATTACK_A,
				ATTACK_B,
				ATTACK_C,
			
			};
		}
		namespace Trol {
			enum {
				IDLE,
				WALK,
				JUMP_UP,
				JUMP_DOWN,
				ATTACK,
			};
		}
	}

	namespace Parts {
		// ォ璅Ă̂珇ɂB
		enum {
			CLOTH,
			APRON,
			BRA,
			PANTS,
			GARTER,

			MAX_NUM
		};
	}

	namespace TanyaParts {
		enum {
			CLOTH,
			WEAR,
			PANTS,

			MAX_NUM,
		};
	}

	namespace SceneType {
		enum {
			TITLE,
			SELECT_MISSION,
			BRIEFING,
			GAME,
			ENEMY_MODE,
			GAME_OVER,
		};
	}

	namespace Material {
		enum {
			NORMAL,
			SHOOT,
			DAMAGE,
			DAMAGE_CRASH,
			DOWN,

			CLOTH_NORMAL,
			CLOTH_BREAK,

			KARADA_NORMAL,
			KARADA_DAMAGE,
			KARADA_BLACK,
			KARADA_DAMAGE_BLACK,

			UNDER,
			UNDER_BLACK,

			// MOSUKO
			MOSUKO_HAIR,	//blue
			MOSUKO_HAIR_GOLD,
			MOSUKO_KAO_1,	//normal
			MOSUKO_KAO_2,	//attack
			MOSUKO_KAO_3,	//raped
			MOSUKO_KAO_4,	//damage/death
			MOSUKO_KAO_5,	//higii
			
			//
			MOSUKO_KARADA_1,	//naked
			MOSUKO_KARADA_2,	// ?
			MOSUKO_KARADA_3,	//cloth(XJ[g͂Œ)
			MOSUKO_KARADA_4,	//SUKUMIZU


			MAX_NUM
		};
	}
	namespace GroundType {
		enum {
			TEST,
			DANIMOTH_ROOM,
			EVIL_STAR,
			PRACTICE_ROOM,
			ZOMBIE,
			WORM,
			MAX_NUM
		};
	}

	namespace WallType {
		enum {
			PRACTICE_ROOM,
			ZOMBIE,
			WORM,
			MAX_NUM,
		};
	}
	namespace Sound {
		enum {
			TITLE,
			GAME,
			PANIC,
			EVIL_STAR,
			TROL,

			BGM_NUM,

			GUN = BGM_NUM,
			ENEMY_HIT_1,
			ENEMY_HIT_2,
			VOICE_HIT_1,
			VOICE_HIT_2,
			VOICE_CRASH,
			MAX_NUM,
		};
	}

	namespace PlayerType{
		enum {
			EVIGEN,
			TANYA,

			MAX_NUM,
		};
	}
	// `p\
	static const TCHAR OPTION_ELEMENT_LIST[][100] = {
		_T("Kubi"),
		_T("Transparent"),
		_T("Black"),
		_T("NoCloth"),
		_T("Mugen"),
	};

	static const TCHAR* OPTION_INI_FILE_PATH = _T("Media\\Option\\Option.ini");

	namespace MosukoWeaponType {
		enum {
			NONE,	// Ԃ
			KATANA,	// 
			GUN,	// e
			BOTH,	// 

			NUM_MAX
		};
	}
}

class StaticData : public BasicStaticData{
public:
	//! vC[ԍSigID̑Ή
	//int m_aryPlayerSigIDList[MotionTestConsts::PlayerType::MAX_NUM ];

	//! BGM̃CfbNX
	int m_nBGMIndex;

	/** BGMԍZbgiOBGM~ƁA̋ȊJnj
	  *
	  */
	void set_BGMIndex( int nBGMIndex );

	/** SEԍsound id̑Ή
	  *
	  */
	int m_arySoundList[MotionTestConsts::Sound::MAX_NUM];

	int m_nPlayerMaterialIndex;
	int m_aryMaterials[MotionTestConsts::Material::MAX_NUM];

	//! G}l[W
	EnemyManager m_EnemyManager;
	ShotManager m_ShotManager;
	NeutralManager m_NeutralManager;

	//! vC[
private:
	//E3DObject* player;
public:
	int m_nPlayerType;

	E3DObject m_aryPlayerList[MotionTestConsts::PlayerType::MAX_NUM];


	//! IĂ镐CfbNX
	int m_nWeaponIndex;

	//! 탊Xg
	Weapon m_aryWeaponList[WeaponType::MAX_NUM ];

	//! ̕I
	void set_NextWeapon();

	//! O̕I
	void set_PreviousWeapon();

	//! 擾
	Weapon* get_Weapon();

	// p[c
	BOOL m_aryPartsValidList[ MotionTestConsts::Parts::MAX_NUM ];
	int m_aryPartsIndexList[ MotionTestConsts::Parts::MAX_NUM ];

	// ^jp[c
	BOOL m_aryTanyaPartsValidList[ MotionTestConsts::TanyaParts::MAX_NUM ];
	int m_aryTanyaPartsIndexList[ MotionTestConsts::TanyaParts::MAX_NUM ];

	//! ftHgiтjSIGID
//	int m_nDefaultPlayerSigID;

	//! JΏ
	int m_nCameraTargetSigID;

	//! 
	float m_fClothAlpha;

	//
	float m_fUnderAlpha;

	float m_fApronAlpha;

	// g
	float m_fClothUnderAlpha;
	float m_fApronUnderAlpha;

	float m_fKatyuAlpha;

	// RGB
	//float m_nUnderR;
	//float m_nUnderG;
	//float m_nUnderB;

	//! j
	//! 0:
	//! 1:j
	int m_nClothBreak;

	//! ̐F
	//! 0:I
	//! 1:I
	int m_nUnderColor;

	//! ݂̃ViICfbNX
	int m_nScenarioIndex;

	//! `p\LH
	BOOL m_aryOptionList[ TitleSceneConsts::CheckType::NUM_MAX ];
///	BOOL m_bIsKubi;

	//! ۓۂݎ
//	BOOL m_bIsTransparent;

	//! R\[̂΂ɂ([F]L[KCh\邽߂̃tO)
	BOOL m_bNearByConsole;

	//! GĂR\[̏
	//E3DObject* m_Console;
	// ViI
	HPL::E3D::ScenarioManager m_ScenarioManager;
	//! ݂̕\ACe
	HPL::E3D::ScenarioItem* m_ScenarioItem;
	int m_nScenarioListID;
private:
	//int get_WeaponIndex();

	//! Cg̕
	D3DXVECTOR3 m_vLightDirection;

	//! G̗͕̑\i
	//int m_nEnemyLifeBarStackNum;

	// sig idIuWFNgQƁB
	// IuWFNgɂ̃}bv폜B
	//std::map<int, E3DObject*> m_mapSigIDToObjectMap;
public:
	//! ݒ
	void set_WeaponIndex(int nNewWeaponIndex);
	// vC[Sigf[^ۑpobt@
	char* m_lpPlayerSigBuffer;
	int m_nPlayerSigBufferSize;

	//! e̊Ǘ
	//! ̃r{[h͂܂VɃr{[h}l[W쐬邱
	//! r{[h̍v2000𒴂邱Ƃ͂łȂ
	//HPL::E3D::E3DBillBoardManager m_ShotBillBoardManager;

	//! ̂r{[h
	HPL::E3D::E3DBillBoardManager m_BloodBillBoardManager;

	//! A˂̃C^[oJE^
	General::HPLCounter* m_cntShotAutomaticCounter;

	/////////////////////////////////// e}l[WKvH
	//! ẽXbv`FCID
	int m_nShadowSwapChainID;
	//! ẽeNX`ID
	int m_nShadowTextureID;
	//! ẽeNX`ID
	SIZE m_szShadowTextureSize;
	//! ẽXvCgID
	int m_nShadowSpriteID;

	//! XvCgԍǗ
	E3DSpriteIndexManager m_SpriteIndexManager;

	//EnemyLifeBar m_aryEnemyLifeBarStack[MotionTestConsts::ENEMY_LIFE_BAR_STACK_NUM_MAX];
	std::list<EnemyLifeBar*> m_lstEnemyLifeBarList;

	//! Fr̃IuWFNg
//	E3DObject* m_Building;

	StaticData(HINSTANCE hInstance);
	virtual ~StaticData();

	//! \ĂG̐
	//int m_nRenderNum;

public: //I[o[Ch
	/** 񂾂{V[
	  * @retval 0
	  */
	int oneTimeSceneInit();

	HPL::General::HPLCounter m_cntEnemyGenerateCounter;

	// |
	int m_nScore;

	std::map<int, int> m_mapWallSigMap;
	int m_nSelectedWallType;
private:
	std::map<int, int> m_mapGroundMap;
	std::map<int, int> m_mapWallMap;
	int m_nSelectedGroundType;
	//! n`sigid
/*	int m_nGroundSigID;

	//! _jX[
	int m_nDanimothRoomSigID;

	// ݎgpĂn`f[^SIG
	int m_nSelectedGroundSigID;*/

	// TODO n`/IuWFNgzuf[^}l[W쐬

	//! n`Ƃ̓蔻
	//int m_nResultGroundChk[4];


protected:
	///////////////////////////////////////////////////////////
	// GXg̑

	/** r{[hƓG̐ڐG
	  *
	  */
	int checkEnemyHitToBillBoard( E3DObject* obj );

public:
	/** vC[ƒnʂ̐ڐG
	  *
	  */
	int checkPlayerOnGround( );
	/** IuWFNgƒnʂ̐ڐG
	  *
	  */
	int checkObjectOnGround( E3DObject* obj, BOOL bIsPlayer);

	

	/** 1024x1024̃eNX`쐬s
	  * @param[in]	nFormat			DirectXݒ肵ĂtH[}bg
	  * @param[out]	lpszSize		쐬łTCYB쐬Ɏsꍇg͕ύXȂ
	  * @retval		0				
	  * @retval		1				s
	  */
	int tryToCreateTexture( int nFormat, SIZE* lpszSize );

	//E3DObject* searchMissile();

	/** ˕ݒ
	  * @param[out]	vDirection		˕iIC[WxNgj
	  */
	void get_ShotDirection( D3DXVECTOR3* vDirection, D3DXVECTOR3& vShotFrom );

	/**
	  *
	  */
	BOOL is_Runnable();

	/** et`
	  *
	  */
	int renderWithShadow( BOOL bIsGround, BOOL bIsPlayer, BOOL bIsMissile, BOOL bIsEnemy );

	/**
	  *
	  */
	int movePlayer();

	/**
	  *
	  */
	int shotPlayer();

	/**
	  *
	  */
	int updatePlayerMotion();

	/** nʂ̃`FbNC
	  *
	  */
	int checkInGround();

	/** ݂̃Xe[WSIGID擾
	  *
	  */
	int get_GroundSigID();
	int set_GroundType( int nGroundType );
	int get_WallSigID();
	int set_WallType( int nWallType );

	//! Jړ
	int moveCamera();

	/**
	  * J[hAT_TARGETɂB
	  * JʒuvC[̖ڂ̑Oɂ
	  * @param[in]	nSigID			ڂ̑OɈړΏۂSIGID
	  * @param[in]	fHeightDelta	YDelta
      */
	int set_CameraInFrontOfObject( int nSigID, float fHeightDelta );

	/** ̕\/\؂ւ
	  * @param[in]	bEnable	TRUE	\
	  * @param[in]	bEnable	FALSE	\
	  *
	  */
	int set_WeaponEnable( BOOL bEnable );

	/** eNX`ύX
	  * @param[in]	nSigID			SIG id
	  * @param[in]	lpszMaterialName	\tގip[cł͂Ȃj
	  * 
	  */
	int set_Texture( int nSigID, const char* lpszMaterialName, int nMaterial , BOOL bIsPlayerMaterial );
	// A
	int restorePlayer();

	BOOL is_MultiLayerMotion();

	/** {^NbNȂǁAUIIȓsV[ł̋ʏ
	  * ΏہF^Cg/ViII/Q[I[o[
	  *
	  */
	int initUISceneCommon();

	BOOL set_MouseOverSpriteColor(int nSpriteID, int nPointX, int nPointY, int nRectX, int nRectY, int nRectWidth, int nRectHeight,
		int nOverColR, int nOverColG, int nOverColB, int nOverColA,
		int nNormalColR, int nNormalColG, int nNormalColB, int nNormalColA );

	/** ŏɍs탊ZbgB
	  * LoadedőɂACharged0ɂB
	  * TODO Z[u\ɂ
	  */
	void reset_Weapons();

	HPL::E3D::E3DBillBoard* create_Blood( D3DXVECTOR3& vPosition,
		D3DXVECTOR3& vDirection);

	// ގ̓xύX
	void set_MaterialAlpha( int nSigID, const char* lpczPartName, float* fTargetAlpha, float fStepAlpha );

	/** MOAt@Cǂݍ
	  *
	  */
	int loadMOAFile( const char* lpszFilePath, HPL::E3D::E3DObject* obj, float fZoom = 1.f );

	/** r{[ḧړ
	  *
	  */
	void move_BillBoard();

	/** vC[ւ̊^[QbeBO邩ǂf
	  * @param[in]	obj		ĂG
	  * @retval		TRUE	vC[ւ̊͂ȂB߂ɂĂ
	  *				FALSE	vC[ւ̊sB
	  *
	  */
	BOOL is_SkipPlayer( HPL::E3D::E3DObject* obj);

	int draw_Scenario(HPL::E3D::ScenarioItem* item);

	void create_PlayerBlood();

	void remove_Head();

	void set_DirectionToVelocity( HPL::E3D::E3DObject* obj, float fSpeedRate );

	// ̐FƂύX
	void setup_Under(int nColor);

	void blow_Out( E3DObject* oBlower, E3DObject* oTarget , float fRate);

	void afterRenderCommon();

	/** FromTo֕ݒ肷
	  *
	  */
	void faceToTarget( HPL::E3D::E3DObject* objFrom, int nToSigID, int nDivision );

	/** vC[
	  *
	  */
	void reset_Player( BOOL bIsHPMax );

	/** vC[
	  *
	  */
	void change_PlayerType( int nType );

	/** ݂̃vC[擾
	  *
	  */
	E3DObject* get_Player();

	/** vC[̃p[c}eA
	  *
	  */
	void reset_EvigenMaterial();
};


extern StaticData* staticData;
}

#endif
