#include "TitleScene.h"

#include "StaticData.h"

namespace MotionTest {
using namespace HPL;
using namespace General;
using namespace MotionTestConsts;
using namespace TitleSceneConsts;

TitleScene::TitleScene() : AbstractScene() {
	staticData->set_Pause( FALSE );
}
TitleScene::~TitleScene() {
}

void TitleScene::init() {

	// wiݒ
	//E3DCreateBG(staticData->get_SwapChainID(), "Media\\Sprite\\Title.png", "hoge", 
	//	0, 0, 0, 20000 );
	
	// n`eXgtB[hɂ
	// n`_ɂ
	staticData->set_GroundType( MathTool::nextRandom<int>(0, GroundType::MAX_NUM ));//GroundType::TEST ) ;

	// J̈ʒuvC[ɂ
	staticData->m_nCameraTargetSigID = staticData->get_Player()->m_nSigID;

	int ret = 0;
	ret = staticData->initUISceneCommon();

	// }EX͎Rɓ
	//staticData->set_Grab( FALSE );

	staticData->set_WeaponIndex(WeaponType::GRANADE_LAUNCHER);
	// vC[
	BOOL bIsHPMax = TRUE;
	staticData->reset_Player( bIsHPMax );
	
	staticData->reset_EvigenMaterial();

	staticData->get_Player()->m_Game.reset();



	staticData->change_PlayerType( PlayerType::EVIGEN );


	// _vC[𐳖ʂ猩ʒuɕς
	staticData->set_CameraInFrontOfObject( staticData->m_nCameraTargetSigID, 0 );

	this->m_nSelectedButton = -1;

	// BGMύX
	staticData->set_BGMIndex( Sound::TITLE );

	staticData->m_bNearByConsole = FALSE;
}
void TitleScene::process() {
	int ret = 0;

	// LN^[̈ړ
	ret = this->frameMove();
	if( ret ){
		_ASSERT( 0 );
		return ;
	}

	// `擙
	ret = this->render();
	if( ret ){
		_ASSERT( 0 );
		return ;
	}
}
void TitleScene::quit() {
}

//! `
int TitleScene::drawText() {
	return 0;
}

//! _O
int TitleScene::render() {

	int ret = 0;


	/////////////////////////////////////////
	// V[`Jn
	ret = E3DBeginScene( staticData->get_SwapChainID(), 0 );//skipflag 
	if( ret ) { 
		_ASSERT( 0 );
		return 1;
	}



		int r = 255, g = 200, b = 200, a = 200;

		//////////
		// XvCg\
		ret = E3DBeginSprite();

			// NCAg̈̃TCY擾
			RECT rClientRect;
			staticData->get_ClientRect( &rClientRect );
			int nClientHeight = rClientRect.bottom - rClientRect.top;
			int nClientWidth = rClientRect.right - rClientRect.left;

			// ^Cgwi
			{
				int nSpriteW;
				int nSpriteH;
				ret = E3DGetSpriteSize( staticData->m_SpriteIndexManager.get( Sprite::TITLE_SCREEN ), 
					&nSpriteW, &nSpriteH );

				float fRateX = static_cast<float>(nClientWidth) / static_cast<float>(nSpriteW);
				float fRateY = static_cast<float>(nClientHeight) / static_cast<float>(768);

				ret = E3DRenderSprite( staticData->m_SpriteIndexManager.get( Sprite::TITLE_SCREEN),
					fRateX, fRateY, D3DXVECTOR3(0.f,
					0.f, 0.2f ) );
			}

			int TITLE_TOP_MERGINE =0;
			int TITLE_BUTTON_MERGINE = TITLE_TOP_MERGINE;

			int nTitleSpriteH = 128;
			// ^Cg
			/*{
				int nSpriteW;
				int spid = staticData->m_SpriteIndexManager.get( Sprite::TITLE );
				ret = E3DGetSpriteSize( spid, 
					&nSpriteW, &nTitleSpriteH );
				int nLeft = nClientWidth / 4 * 3 - nSpriteW / 2;
				int nTop = TITLE_TOP_MERGINE ;

				//E3DCOLOR4UC uc = {a, r, g, b};
				// Ԃ
				//ret = E3DSetSpriteARGB( spid, uc );

				ret = E3DRenderSprite( spid,
					1, 1, D3DXVECTOR3(static_cast<FLOAT>(nLeft),
					static_cast<FLOAT>(nTop), 0.0f ) );
			}*/

			POINT p;
			GetCursorPos( &p);
			ScreenToClient( staticData->get_WindowHandle(), 
				&p );

			const int UI_TOP = static_cast<int>(nClientHeight / 2.f);
			// {^
			{
				const int BUTTON_NUM = 4;

				char LABELS[][100] = {
					"Scenario",
					"Enemy Mode",
					"Challenge Mode",
					"Exit"
				};
				const float HEIGHT_RATE = 0.7f;

				int nSpriteW;
				int nSpriteH;
				int nSpriteID = staticData->m_SpriteIndexManager.get( Sprite::TITLE_SUBJECT );
				ret = E3DGetSpriteSize( nSpriteID, 
					&nSpriteW, &nSpriteH );

				int nLeft = nClientWidth / 5 * 4 - nSpriteW / 2;
				int nInterval = static_cast<int>(nSpriteH * (HEIGHT_RATE + 0.01f) );


				this->m_nSelectedButton = -1;

				for(int i = 0; i < BUTTON_NUM; i ++ ) {
					int nTopNow = TITLE_TOP_MERGINE + nTitleSpriteH + TITLE_BUTTON_MERGINE +
						i * nInterval;//UI_TOP + i * nInterval;

					if( i >= 3){// BUTTON_NUM - 1 ) {

						if( staticData->m_nScreenWidth <= 640 ) {
							// e悤ɁA2ڈȍ~͂Ɖ̕ɐݒu
							nTopNow = UI_TOP + i * nInterval;
						} else if( staticData->m_nScreenWidth < 960 ) {

							// 800ƂƂԂ
							nTopNow = UI_TOP + i * nInterval + 10;
						} else { 
							// 傫ꍇ́Â܂܂ŏ\
						}
					} else {
						if( staticData->m_nScreenWidth <= 640 ) {
							// e悤ɁA2ڈȍ~͂Ɖ̕ɐݒu
							nTopNow -= nTitleSpriteH / 2;
						}
					}
					if( staticData->set_MouseOverSpriteColor(
						nSpriteID, p.x, p.y, nLeft, nTopNow, nSpriteW, static_cast<int>(nSpriteH * HEIGHT_RATE), 
						255,100,100,200, 255,255,255, 200 ) )
					{
						this->m_nSelectedButton = i;
					}
/*					if( p.x >= nLeft && p.x <= nLeft + nSpriteW &&
						p.y >= nTopNow && p.y <= nTopNow + nSpriteH )
					{
						// J[\ɓ
						E3DCOLOR4UC uc = {200,255,100,100 };
						// Ԃ
						ret = E3DSetSpriteARGB( nSpriteID, uc );

						this->m_nSelectedButton = i;
					} else {
						E3DCOLOR4UC uc = {100,255,255,255 };
						ret = E3DSetSpriteARGB( nSpriteID, uc );
					}*/
					ret = E3DRenderSprite( nSpriteID,
						1, 0.7f, D3DXVECTOR3(static_cast<FLOAT>(nLeft),
						static_cast<FLOAT>(nTopNow), 0.1f ) );

					// 
					const int LEFT_TEXT_DELTA = 20;
					const int TOP_TEXT_DELTA = 10;
					// \
					ret = E3DTool::drawTextWithFont(
						nLeft + LEFT_TEXT_DELTA, nTopNow +TOP_TEXT_DELTA,			//pos XY
						100, 10, 0, 255,	//col RGBA
						staticData->get_SwapChainID(),
						staticData->get_FontID(),
										// zoom
						"%s",
						LABELS[i]);
				}
				// Ə\
				ret = E3DGetSpriteSize( staticData->m_SpriteIndexManager.get( Sprite::CROSS_HAIR ), 
					&nSpriteW, &nSpriteH );
				if( ret ) {
					_ASSERT( 0 );
					return ret;
				}
				ret = E3DRenderSprite( staticData->m_SpriteIndexManager.get( Sprite::CROSS_HAIR),
					1, 1, D3DXVECTOR3(static_cast<FLOAT>(p.x - nSpriteW / 2),
					static_cast<FLOAT>(p.y - nSpriteH / 2), 0.0f ) );
				if( ret ) {
					_ASSERT( 0 );
					return ret;
				}

				// \
				ret = E3DTool::drawText(
					10, 10,			//pos XY
					255, 255, 255, 255,	//col RGBA
					1,				// zoom
					"p[%ld,%ld]",
					p.x, p.y);

			}

	/*		// IvV
			{
				// `FbN{bNX
				int nSpriteW;
				int nSpriteH;
				int nCheckedSpriteID = staticData->m_SpriteIndexManager.get( Sprite::CHECK_BOX_CHECKED ) ;
				int nNoCheckedSpriteID = staticData->m_SpriteIndexManager.get( Sprite::CHECK_BOX );

				ret = E3DGetSpriteSize( nCheckedSpriteID, 
					&nSpriteW, &nSpriteH );
				if( ret ) {
					_ASSERT( 0 );
					return ret;
				}

				int nLeft = nClientWidth  - OPTION_MERGINE_X;
				int nTop = UI_TOP;

				char aryLabelList[][100] = {
					"ؒf",
					"ۓۂݓ",
					"",
					"QڂĖYꂽ",
					"o_i",
				};

				// Ԋu
				const int STEP = 32;
				for(int i = 0; i < TitleSceneConsts::CheckType::NUM_MAX; i ++ ) {
					// IvV̏cW
					int nTopNow = nTop + STEP * i;

					int nSpriteID = staticData->m_aryOptionList[i] == TRUE ? nCheckedSpriteID : nNoCheckedSpriteID;
					BOOL bIsChecked = staticData->m_aryOptionList[i];

					// {^̏ɃJ[\Ă邩H͉
					this->m_aryIsChecked[i] = FALSE;

					if( staticData->set_MouseOverSpriteColor(
						nSpriteID, p.x, p.y, nLeft, nTopNow, nSpriteW, nSpriteH, 
						255,100,100,200, 255,255,255, 200 ) )
					{
						this->m_aryIsChecked[i] = TRUE;
					}

					ret = E3DRenderSprite( nSpriteID,
						1, 1, D3DXVECTOR3(static_cast<FLOAT>(nLeft),
						static_cast<FLOAT>(nTopNow), 0.0f ) );
					if( ret ) {
						_ASSERT( 0 );
						return ret;
					}



					// \
					ret = E3DTool::drawTextWithFont(
						nLeft + nSpriteW, nTopNow + OPTION_TEXT_MERGINE_Y,
						255, 255, 255, 255,	//col RGBA
						staticData->get_SwapChainID(),
						staticData->get_FontID(),				// zoom
						aryLabelList[i]
						);

				}
			}*/

		ret = E3DEndSprite();

		staticData->afterRenderCommon();
	if( E3DEndScene() ) {
		_ASSERT( 0 );
		return 1;
	}
	return 0;
}

//! t[Ƃ̈ړ
int TitleScene::frameMove() {
	int ret = 0;

	////////////////////////
	// vC[
	// vC[WASDړ
	//staticData->movePlayer();

	// vC[̒e̔
	//staticData->shotPlayer();

	// [Vω
	//ret = staticData->updatePlayerMotion();

	DIMOUSESTATE2* mouse = staticData->get_DIMouse()->get_CurrentState();
	DIMOUSESTATE2* mousePreious = staticData->get_DIMouse()->get_PreviousState();
	if( mouse->rgbButtons[0] && mousePreious->rgbButtons[0] == FALSE) {
		if( m_nSelectedButton == ButtonType::SCENARIO ) {
			// Q[֐i
			staticData->m_SceneManager.set_Scene( SceneType::SELECT_MISSION );
		} else if( m_nSelectedButton == ButtonType::ENEMY_MODE ) {
			// G[h֐i
			staticData->m_SceneManager.set_Scene( SceneType::ENEMY_MODE );
		} else if( m_nSelectedButton == ButtonType::CHALLENGE_MODE ) {
			// Q[֐i
			// TODO `W[h̍쐬
			staticData->m_SceneManager.set_Scene( SceneType::SELECT_MISSION );
		} else if( m_nSelectedButton == ButtonType::EXIT ) {
			PostQuitMessage( 0 );
		} else {
		/*	for( int i = 0; i < TitleSceneConsts::CheckType::NUM_MAX; i ++ ) {
				if( this->m_aryIsChecked[ i ] ) {
					staticData->m_aryOptionList[i] = !staticData->m_aryOptionList[i];

					// ۑ
					WritePrivateProfileString( _T("Evigen"), OPTION_ELEMENT_LIST[i] , 
						staticData->m_aryOptionList[i] ? _T("1"): _T("0"),
						OPTION_INI_FILE_PATH);
				}
			}*/
		}
	}
	///////////////////////////////
	// Jړ
	ret = staticData->moveCamera();
	if( ret ) {
		_ASSERT( 0 );
		return ret;
	}

	return 0;
}

}
