#pragma once

typedef class  CXSAnimationSet *XSAnimationSet;

class CXSAnimationSet
{
public:

	char		m_name[256];
	int			m_index;
	int			m_nInterpolate;
	int			m_key_count;
	int			m_state_count;

	XSAnimationKey		*pKey;
	XSAnimationState	*pState;

	inline int				GetIndex(void){return m_index; };
	inline int 				GetAnimationKeyCount(void){return m_key_count;};
	inline XSAnimationKey	GetAnimationKey(int index){return pKey[index];};
	inline int 				GetAnimationStateCount(void){return m_state_count;};
	inline XSAnimationState	GetAnimationState(int index){return pState[index];};
	inline std::string			GetName(void){return (std::string)m_name; };

	CXSAnimationSet(void){

		pKey	= NULL;
		pState	= NULL;
	
	};
	virtual ~CXSAnimationSet(void){

		for(int i = 0; i < m_key_count; i++)
			XS_SAFE_DELETE(pKey[i]);

		for(int i = 0; i < m_state_count; i++)
			XS_SAFE_DELETE(pState[i]);

		XS_SAFE_DELETE(pKey);
		XS_SAFE_DELETE(pState);
	};

};
