#ifndef _GL_LIB_
#define _GL_LIB_

//#include "general.h"
#include "Matrix/CVector3.h"
#include <SDL/SDL.h>
#include <SDL/SDL_opengl.h>

#include <cstdio>
#include "Mesh/CTextureManager.h"
#include "Matrix/CMatrix.h"
#include <cmath>
#include "Mesh/CMesh.h"

class GLLib{
private:
	/*r[|[gʒu*/
	CVector3 vViewPort;

	/*p[XyNeBu*/
	float fFovy;
	float fAspect;
	float fNearZ;
	float fFarZ;

	/*t[[g*/
	float fMoveRate;

	/** ``̋ʍ */
	void drawRectCommon( int x, int y, int w, int h,  float* color, int blend, float alpha,
		int winw, int winh, bool isFill);
	
	/**
		Kɐݒ肳ꂽ2_x,y,width,heightŕ\ł`ɕϊ
		@param rect ԂlB[0]珇ɍXWAYWAA
	*/
	void convertValidRect(int x0, int y0, int x1, int y1, int rect[]);

	/**
		Primitive `悷Ƃ͂OŌĂԂƍK
	*/
	void doBeforePrimitiveDraw(int blend);
	void doAfterPrimitiveDraw();
public:
	/*F̃uh^CvBZ/ʏ*/
	enum {
		BLEND_TYPE_NORMAL=0,
		BLEND_TYPE_ADD,
		BLEND_TYPE_MAX
	};

private:
	CVector3 vCameraPos;
	CVector3 vCameraAt;
	CVector3 vCameraUp;
public:
	void setCameraPos(float x, float y, float z){
		vCameraPos = CVector3(x, y, z);
	}
	void setCameraAt(float x, float y, float z){
		vCameraAt = CVector3(x, y, z);
	}
	void setCameraUp(float x, float y, float z){
		vCameraUp = CVector3(x, y, z);
	}

public:
	GLLib();

	~GLLib();

	void initSystem( int winw, int winh, int bpp);

	void setViewPort( int x, int y);

	void setPerspective( float fovy, float aspect, float nearz, float farz );

	/*r[̏Ԃ*/
	void setUpViewState();

	/*OFF*/
	void ambientOff();
	/*̐Fݒ*/
	void setAmbient( CVector3 Color );

	/*
		CǧOFF
		@id:CgID
	*/
	void deffuseLightOff( int id );
	/*
		Cg̈ʒuAFݒ
		@id:
		@Color:F
		@Position:ʒu
	*/
	void setDeffuseLight( int id, CVector3 Color, CVector3 Position );

	/*
		CgZbg
	*/
	void setSpeclarLight( CVector3 Color, CVector3 Position );
	/*OFF*/
	void speclarLightOff();

	/*
		n̊iq̕`
		@n:̖{
		@size:̑傫
	*/
	void drawGridXZ( int n, float size );

	/*
		@arg pos 4̒_̈ʒuzœn
		@arg col Fw肷
	*/
	void drawQuad3D( CVector3 *pos, CVector3 col);

	/*FPS*/
	void checkFrameRate();
	/**/
	float getMoveRate();


	/*
		XvCg̕`
		@dest:o͈͐
		@src:C[W̐؂ʒu
		@name:
		@blend:uh^Cv
		@alpha:l
	*/
	void drawSprite( SDL_Rect* dest, SDL_Rect* src, char* name, int winw, int winh,
		int blend = 0,
		float alpha = 1.0f );
	void drawSprite( SDL_Rect* dest, SDL_Rect* src, char* name, int winw, int winh,
		float rot, int blend, float alpha){
		int destcenter[] = {dest->x + dest->w / 2, dest->y + dest->h / 2};
		int destsize[] = {dest->w, dest->h};
		float col[] = {1,1,1};
		drawSprite( destcenter, destsize, rot, src, name, winw, winh, col, blend, alpha);
	}

	/*
		@destcenter:[3]o͐̈ʒu
		@destsize:[2]o͂TCY
		@rot:]
		@src:̓C[W̐؂͈
		@name:
		@color: }XNB1ɂȂقǌ̐FoB
		@blend:
		@alpha
	*/
	void drawSprite( int* destcenter, int* destsize, float rot, SDL_Rect* src,
		char* name, int winw, int winh,	float *color, int blend, float alpha );
	void drawSprite( CVector3 center, int w, int h, float rot, int srcx, int srcy, int srcw, int srch,
		char* name, int winw, int winh,	float cr, float cg, float cb, int blend, float alpha ){
		int cen[]={(int)center.x,(int)center.y,(int)center.z};
		int size[]={w,h};
		float color[]={cr,cg,cb};
		SDL_Rect srcrect={
			srcx,srcy,srcw,srch
		};
		drawSprite( cen,size,rot, &srcrect, name, winw, winh, color, blend, alpha);
	}

	/*
		3XvCg\
		@pos:ʒu
		@src:؂͈
		@size_h,size_v:傫
		@rot:]
		@nae:
		@blend:uh^Cv
		@alpha:l
	*/
	void draw3DSprite( CVector3& pos, SDL_Rect* src, 
		float size_h, float size_v, float rot, char* name,
		int blend = 0, float alpha = 1.0f );

	/*
		2D̎lp`
		rect ʒuA傫
		color[3] F
	*/
	void fillRect( int x, int y, int w, int h,  float* color, int blend, float alpha,
		int winw, int winh){
			drawRectCommon(x, y, w, h, color, blend, alpha, winw, winh, true);
	}
	void drawRect( int x, int y, int w, int h,  float* color, int blend, float alpha,
		int winw, int winh){
			drawRectCommon(x, y, w, h, color, blend, alpha, winw, winh, false);
	}


	/**
		`W3DWɕύXB
		3DWŕ\2D̂悤ɕ\B

		ʂɋ`ȊÔ̂`Ă̂ŁA
		̕`Ȃǂ̕ϊpOK

		_͑傫1̋`Ƃĕ\ĂA1_GL_POINTSĂ

	*/
	void convertViewToScreen(int x, int y, int w, int h, int winw, int winh,
		float pt[][2], float rot);


	void drawLine(int x0, int y0, int x1, int y1, int winw, int winh,
		float* color, int blend, float alpha);
	
};

#endif
