
#include "GLLib.h"
#include "Mesh/CTextureManager.h"

static int ViewPortX;
static int ViewPortY;

static float Fovy;
static float Aspect;
static float NearZ;
static float FarZ;

static float CameraPos[3];
static float CameraAt[3];
static float CameraUp[3];

void SetViewPort( int x, int y )
{
	ViewPortX = x;
	ViewPortY = y;
}

void SetPerspective( float fovy, float aspect, float nearz, float farz )
{
	Fovy = fovy;
	Aspect = aspect;
	NearZ = nearz;
	FarZ = farz;

}

void SetCameraPos( float x, float y, float z )
{
	CameraPos[0] = x;
	CameraPos[1] = y;
	CameraPos[2] = z;
}

void SetCameraAt( float x, float y, float z )
{
	CameraAt[0] = x;
	CameraAt[1] = y;
	CameraAt[2] = z;
}

void SetCameraUp( float x, float y, float z )
{
	CameraUp[0] = x;
	CameraUp[1] = y;
	CameraUp[2] = z;
}

void SetUpViewState()
{
	glViewport( 0, 0, ViewPortX, ViewPortY );

	glMatrixMode( GL_PROJECTION );
	glLoadIdentity();

	gluPerspective( Fovy, Aspect, NearZ, FarZ );

	glMatrixMode( GL_MODELVIEW );
	glLoadIdentity();

	gluLookAt(
		CameraPos[0], CameraPos[1], CameraPos[2],
		CameraAt[0], CameraAt[1], CameraAt[2],
		CameraUp[0], CameraUp[1], CameraUp[2]
		);


	glEnable(GL_LIGHTING);
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_NORMALIZE);
}

void SetAmbient( CVector3& Color )
{
	float color[4] ={ Color.x, Color.y, Color.z, 1.0f };
	glLightfv( GL_LIGHT2, GL_AMBIENT, color );

	glEnable( GL_LIGHT2 );
}
void AmbientOff()
{
	glDisable( GL_LIGHT2 );
}

void SetDeffuseLight( int id, CVector3& Color, CVector3& Position )
{
	if( id < 0 || id >= 2)return;
	float pos[4] = { Position.x, Position.y, Position.z, 1.0f };
	glLightfv( GL_LIGHT0+id, GL_POSITION, pos );

	float color[4] ={ Color.x, Color.y, Color.z, 1.0f };
	glLightfv( GL_LIGHT0+id, GL_DIFFUSE, color );
	
	glEnable( GL_LIGHT0 + id );
}

void DeffuseLightOff( int id )
{
	glDisable( GL_LIGHT0 + id );
}


void SetSpeclarLight( CVector3& Color, CVector3& Position )
{
	glLightModelf(GL_LIGHT_MODEL_LOCAL_VIEWER,GL_TRUE);
	float pos[4] = { Position.x, Position.y, Position.z, 1.0f };
	glLightfv( GL_LIGHT3, GL_POSITION, pos );

	float color[4] ={ Color.x, Color.y, Color.z, 1.0f };
	glLightfv( GL_LIGHT3, GL_SPECULAR, color );
	
	glEnable( GL_LIGHT3 );
}

void SpeclarLightOff()
{
	glDisable( GL_LIGHT3 );
}


void DrawGridXZ( int n, float size )
{
	glDisable(GL_TEXTURE_2D);
	/*AmbientOff();
	DeffuseLightOff( 0 );
	DeffuseLightOff( 1 );
	SpeclarLightOff();*/
	glDisable(GL_LIGHTING);
	float max = size * (float)(n);

	glPolygonMode( GL_FRONT, GL_LINE );

	glBegin( GL_LINES );

	for( int x = -n ; x <= n ; x++ ){
		float fx = size * (float)(x);
		glVertex3f( fx, 0.0f, max );
		glVertex3f( fx, 0.0f, -max );
	}
	for( int z = -n ; z <= n ; z++ ){
		float fz = size * (float)(z);
		glVertex3f( max, 0.0f, fz );
		glVertex3f( -max, 0.0f, fz );
	}
	glEnd();

	glEnable(GL_LIGHTING);
}

// �t���[�����[�g�̃`�F�b�N
static float sMoveRate = 1.0f;
void CheckFrameRate()
{
	static Uint32 preCount;
	Uint32 nowCount = SDL_GetTicks();
	if( preCount ){
		Uint32 Interval = nowCount - preCount;// �O�񂩂�̌o�ߎ���
		if( Interval < 1 )Interval = 1;
		float FrameRate = 1000.0f / float(Interval);

		sMoveRate = ((float)Interval) / 16.0f;
	}
	preCount = nowCount;
}

float GetMoveRate()
{
	return sMoveRate;
}

void DrawSprite( SDL_Rect* dest, SDL_Rect* src, char* name
, int nScreenWidth, int nScreenHeight, float rot, int blend, float alpha)
{
	int destsize[2];
	destsize[0] = dest->w;
	destsize[1] = dest->h;
	int destcenter[2];
	destcenter[0] = dest->x - destsize[0]/2;
	destcenter[1] = dest->y - destsize[1]/2;
	
	DrawSprite( destcenter, destsize, 0.0f, src, name,
        nScreenWidth, nScreenHeight, blend, alpha );
	
}

void DrawSprite( int* destcenter, int* destsize, float rot, SDL_Rect* src, char* name
, int nScreenWidth, int nScreenHeight, int blend, float alpha)
{
	glMatrixMode( GL_PROJECTION );
	glLoadIdentity();
	
	glMatrixMode( GL_MODELVIEW );
	glLoadIdentity();
	
	glDisable(GL_LIGHTING);
	glDisable(GL_DEPTH_TEST);
	glEnable(GL_TEXTURE_2D);
	const TEXTURE_DATA* pTex = gTextureManager.BindTexture( name );
	if( !pTex )return;
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
	
	// Texture Cood
	int u = 0;
	int v = 0;
	int uu = pTex->Width;
	int vv = pTex->Height;
	if( src ){
		u = src->x;
		v = src->y;
		uu = src->x + src->w;
		vv = src->y + src->h;
	}
	
	float uk = 0.5f / (float)pTex->Width;
	float vk = 0.5f / (float)pTex->Height;
	float fu = (float)u / (float)pTex->Width;
	float fv = (float)v / (float)pTex->Height;
	float fuu = (float)uu / (float)pTex->Width;
	float fvv = (float)vv / (float)pTex->Height;
	
	// position
	int w = pTex->Width;
	int h = pTex->Height;
	if( destsize ){
		w = destsize[0];
		h = destsize[1];
	}
	float left = -((float)w) * 0.5f;
	float top = -((float)h) * 0.5f;
	float right = ((float)w) * 0.5f;
	float bottom = ((float)h) * 0.5f;
	
	float pt_src[4][2];
	pt_src[0][0] = left;
	pt_src[0][1] = top;
	pt_src[1][0] = left;
	pt_src[1][1] = bottom;
	pt_src[2][0] = right;
	pt_src[2][1] = bottom;
	pt_src[3][0] = right;
	pt_src[3][1] = top;
	
	float pt[4][2];
	for( int i = 0 ; i < 4 ; i++ ){
		pt[i][0] = cos(rot) * pt_src[i][0] - sin(rot) * pt_src[i][1] + (float)destcenter[0];
		pt[i][1]  = sin(rot) * pt_src[i][0] + cos(rot) * pt_src[i][1] + (float)destcenter[1];
		
		pt[i][0] = pt[i][0]/(float)(nScreenWidth);
		pt[i][0] = (pt[i][0] - 0.5f) * 2.0f;
		pt[i][1] = pt[i][1]/(float)(nScreenHeight);
		pt[i][1] = -(pt[i][1] - 0.5f) * 2.0f;
		
		
	}
	glEnable(GL_BLEND);
	switch( blend )
	{
	case BLEND_TYPE_ADD:
		glBlendFunc(GL_SRC_ALPHA, GL_ONE);
		break;
	default:
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		break;
	}
	glPolygonMode( GL_FRONT, GL_FILL );
	glBegin( GL_QUADS );

	{
		glTexCoord2f( fu, fv );
		glColor4f( 1.0f, 1.0f, 1.0f, alpha );
		glVertex3f( pt[0][0], pt[0][1], 0.0f );
	
		glTexCoord2f( fu, fvv );
		glColor4f( 1.0f, 1.0f, 1.0f, alpha );
		glVertex3f( pt[1][0], pt[1][1], 0.0f );
	
		glTexCoord2f( fuu, fvv );
		glColor4f( 1.0f, 1.0f, 1.0f, alpha );
		glVertex3f( pt[2][0], pt[2][1], 0.0f );
	
		glTexCoord2f( fuu, fv );
		glColor4f( 1.0f, 1.0f, 1.0f, alpha );
		glVertex3f( pt[3][0], pt[3][1], 0.0f );
	}
	glEnd();

	glDisable(GL_BLEND);
	SetUpViewState();
}

void Draw3DSprite( CVector3& pos, SDL_Rect* src, float size_h, float size_v, float rot, char* name, int blend, float alpha )
{
	glDisable(GL_LIGHTING);
	glEnable(GL_TEXTURE_2D);
	const TEXTURE_DATA* pTex = gTextureManager.BindTexture( name );
	if( !pTex )return;
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	
	// Texture Cood
	int u = 0;
	int v = 0;
	int uu = pTex->Width;
	int vv = pTex->Height;
	if( src ){
		u = src->x;
		v = src->y;
		uu = src->x + src->w;
		vv = src->y + src->h;
	}
	
	float uk = 0.5f / (float)pTex->Width;
	float vk = 0.5f / (float)pTex->Height;
	float fu = (float)u / (float)pTex->Width + uk;
	float fv = (float)v / (float)pTex->Height + vk;
	float fuu = (float)uu / (float)pTex->Width;
	float fvv = (float)vv / (float)pTex->Height;
	
	// position
	CVector3 vec_z = CVECTOR3( 0.0f, 0.0f, 1.0f );
	CVector3 vec_y = CVECTOR3( 0.0f, 1.0f, 0.0f );
	CVector3 vec_x = CVECTOR3( 1.0f, 0.0f, 0.0f );
	CVector3 view_pos = CVECTOR3( CameraPos[0],CameraPos[1],CameraPos[2]);
	CVector3 view_at = CVECTOR3( CameraAt[0],CameraAt[1],CameraAt[2]);
	
	CVector3 view_vec = view_pos - view_at;
	view_vec.y = 0.0f;
	
	CMatrix rotY;
	if( view_vec.GetLength() > 0.0f ){
		view_vec.Normalize();
		float cs = vec_z.InnerProduct( view_vec );
		if( cs < -1.0f )cs = -1.0f;
		if( cs >  1.0f )cs =  1.0f;
		float rot = acos( cs );
		CVector3 axiss = vec_z.OuterProduct( view_vec );
		axiss.Normalize();
		float d = axiss.InnerProduct( vec_y );
		if( d < 0.0f )rot = -rot;
		rotY.SetRotationY( rot );
	}
	CMatrix rotX;
	{
		CMatrix rotY_inv = rotY;
		rotY_inv.Inverse();
		view_vec = view_pos - view_at;
		view_vec = rotY_inv * view_vec;
		view_vec.Normalize();
		
		float cs = vec_z.InnerProduct( view_vec );
		if( cs < -1.0f )cs = -1.0f;
		if( cs >  1.0f )cs =  1.0f;
		float rot = acos( cs );
		CVector3 axiss = vec_z.OuterProduct( view_vec );
		axiss.Normalize();
		float d = axiss.InnerProduct( vec_x );
		if( d < 0.0f )rot = -rot;
		rotX.SetRotationX( rot );
	}
	
	CMatrix rotMtx = rotX * rotY;
	CVector3 bpos[4];
	bpos[0] = CVECTOR3( -size_h, size_v, 0.0f );
	bpos[1] = CVECTOR3( -size_h, -size_v, 0.0f );
	bpos[2] = CVECTOR3( size_h,  -size_v, 0.0f );
	bpos[3] = CVECTOR3( size_h,  size_v, 0.0f );
	for( int i = 0 ; i < 4 ; i++ ){
		bpos[i] = rotMtx * bpos[i] + pos;
	}
	
	
	glEnable(GL_BLEND);
	switch( blend )
	{
	case BLEND_TYPE_ADD:
		glBlendFunc(GL_SRC_ALPHA, GL_ONE);
		break;
	default:
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		break;
	}
	
	glPolygonMode( GL_FRONT, GL_FILL );
	glBegin( GL_QUADS );
	{
		glTexCoord2f( fu, fv );
		glColor4f( 1.0f, 1.0f, 1.0f, alpha );
		glVertex3f( bpos[0].x, bpos[0].y, bpos[0].z );
	
		glTexCoord2f( fu, fvv );
		glColor4f( 1.0f, 1.0f, 1.0f, alpha );
		glVertex3f( bpos[1].x, bpos[1].y, bpos[1].z );
	
		glTexCoord2f( fuu, fvv );
		glColor4f( 1.0f, 1.0f, 1.0f, alpha );
		glVertex3f( bpos[2].x, bpos[2].y, bpos[2].z );
	
		glTexCoord2f( fuu, fv );
		glColor4f( 1.0f, 1.0f, 1.0f, alpha );
		glVertex3f( bpos[3].x, bpos[3].y, bpos[3].z );
	}
	glEnd();

	glEnable(GL_LIGHTING);
	glDisable(GL_BLEND);
	SetUpViewState();
}


