////////////////////////////////////////////////////////////////////////////////
// GLLib.h
////////////////////////////////////////////////////////////////////////////////
#ifndef __GLLIB_H__
#define __GLLIB_H__
#ifdef MINGW
#define SDLCALL
#endif

#include "SDL.h"
#include "SDL_opengl.h"
#include "Matrix/CMatrix.h"
#include "Mesh/CTextureManager.h"
#include "Mesh/CMesh.h"

#include <math.h>

void SetViewPort( int x, int y );
void SetPerspective( float fovy, float aspect, float nearz, float farz );
void SetCameraPos( float x, float y, float z );
void SetCameraAt( float x, float y, float z );
void SetCameraUp( float x, float y, float z );

void SetUpViewState();


void AmbientOff();
void SetAmbient( CVector3& Color );

void DeffuseLightOff( int id );
void SetDeffuseLight( int id, CVector3& Color, CVector3& Position );

void SetSpeclarLight( CVector3& Color, CVector3& Position );
void SpeclarLightOff();

void DrawGridXZ( int n, float size );

void CheckFrameRate();
float GetMoveRate();

enum {
	BLEND_TYPE_NORMAL=0,
	BLEND_TYPE_ADD,
	BLEND_TYPE_MAX
};

void DrawSprite( SDL_Rect* dest, SDL_Rect* src, char* name
, int nScreenWidth, int nScreenHeight, float rot, int blend = 0, float alpha = 1.0f );
void DrawSprite( int* destcenter, int* destsize, float rot, SDL_Rect* src, char* name
, int nScreenWidth, int nScreenHeight, int blend = 0, float alpha = 1.0f );

void Draw3DSprite( CVector3& pos, SDL_Rect* src, float size_h, float size_v, float rot, char* name,
 int blend = 0, float alpha = 1.0f );

#endif
