////////////////////////////////////////////////////////////////////////////////
// CMQOData.h
// 2004N1019 12:59:52
////////////////////////////////////////////////////////////////////////////////
#ifndef __CMQODATA_H__
#define __CMQODATA_H__
#include "CMyList.h"

#define CMQO_NAME_LENGTH 64

struct MQOHeaderData
{
	float Pos[3];
	float Lookat[3];
	float Head;
	float Pich;
	float Ortho;
	float Zoom2;
	float Amb[3];
};

struct MQOMaterialData
{
	char  MaterilaName[CMQO_NAME_LENGTH];
	float Color[3];
	float Diffuse;
	float Ambient;
	float Emissive;
	float Speculer;
	float Power;
	char  TextureName[CMQO_NAME_LENGTH];
};

struct MQOObjectInfo
{
	char  ObjectName[CMQO_NAME_LENGTH];
	int   Visible;
	int   Locking;
	int   Shading;
	float Facet;
	float Color[3];
	int   ColorType;
};

struct MQOObjectVertex
{
	float x,y,z;
};

struct MQOObjectFace
{
	int VertexNum;
	int Index[4];
	int Material;
	float TexCood[8];
};

class CMQOObjectData
{
public:
	CMQOObjectData();
	~CMQOObjectData();

	void Release();

	void SetInfo( const MQOObjectInfo* pInfo );
	const MQOObjectInfo* GetInfo(){ return &mInfo; }

	bool CreateVertex( int num );
	bool CreateFace( int num );

	int GetVertexNum(){ return mVertexNum; }
	int GetFaceNum(){ return mFaceNum; }

	void SetVertex( int n, const MQOObjectVertex* pVertex );
	void SetFace( int n, const MQOObjectFace* pFace );

	const MQOObjectVertex* GetVertex(){ return mVertex; }
	const MQOObjectFace*   GetFace()  { return mFace; }

private:
	MQOObjectInfo    mInfo;
	MQOObjectVertex* mVertex;
	MQOObjectFace*   mFace;
	int mVertexNum;
	int mFaceNum;
};

class CMQOData
{
public:
	CMQOData();
	~CMQOData();

	void Release();
	
	void SetVersion( const char* version );
	void SetHeader( const MQOHeaderData* pHeader );

	bool CreateMaterial( int num );
	bool SetMaterial( int index, const MQOMaterialData* pMaterial );
	bool SetObject( CMQOObjectData* pObjectData );
	void DebugPrint();

	const MQOHeaderData* GetHeader();

	int   GetMaterialNum();
	const MQOMaterialData* GetMaterial( int idx );

	int GetObjectNum();
	CMQOObjectData* GetObject( int idx );

private:
	
	char mVersion[8];
	MQOHeaderData mHeader;

	MQOMaterialData* mMaterialData;
	int              mMaterialNum;

	CMyList<CMQOObjectData> mObjectList;
	int                     mObjectNum;

	void ReleaseMaterial();
	void ReleaseObject();

};

float GetMaxSize( CMQOData* pMqoData );

#endif
