////////////////////////////////////////////////////////////////////////////////
// CMatrix.cpp
///////////////////////////////////////////////////////////////////////////////

#include "../Matrix/CMatrix.h"
#include <string.h>
#include <math.h>

CMatrix::CMatrix()
{
	Identity();
}

CMatrix::~CMatrix()
{
}


void CMatrix::Identity()
{
	for( int i = 0 ; i < 4 ; i++ ){
		for( int j = 0 ; j < 4 ; j++ ){
			if( i == j ){
				m[i][j] = 1.0f;
			}else{
				m[i][j] = 0.0f;
			}
		}
	}
}

CMatrix CMatrix::operator = ( CMatrix mt )
{
	memcpy( &(this->m[0][0]), &(mt.m[0][0]), sizeof(float)*16 );
	return (*this);
}

CMatrix CMatrix::operator * ( CMatrix mt )
{
	CMatrix ret;

	ret.m[0][0] = 
	this->m[0][0] * mt.m[0][0] +
	this->m[0][1] * mt.m[1][0] +
	this->m[0][2] * mt.m[2][0] +
	this->m[0][3] * mt.m[3][0];

	ret.m[0][1] = 
	this->m[0][0] * mt.m[0][1] +
	this->m[0][1] * mt.m[1][1] +
	this->m[0][2] * mt.m[2][1] +
	this->m[0][3] * mt.m[3][1];

	ret.m[0][2] =
	this->m[0][0] * mt.m[0][2] +
	this->m[0][1] * mt.m[1][2] +
	this->m[0][2] * mt.m[2][2] +
	this->m[0][3] * mt.m[3][2];

	ret.m[0][3] =
	this->m[0][0] * mt.m[0][3] +
	this->m[0][1] * mt.m[1][3] +
	this->m[0][2] * mt.m[2][3] +
	this->m[0][3] * mt.m[3][3];

	ret.m[1][0] =
	this->m[1][0] * mt.m[0][0] +
	this->m[1][1] * mt.m[1][0] +
	this->m[1][2] * mt.m[2][0] +
	this->m[1][3] * mt.m[3][0];

	ret.m[1][1] =
	this->m[1][0] * mt.m[0][1] +
	this->m[1][1] * mt.m[1][1] +
	this->m[1][2] * mt.m[2][1] +
	this->m[1][3] * mt.m[3][1];

	ret.m[1][2] =
	this->m[1][0] * mt.m[0][2] +
	this->m[1][1] * mt.m[1][2] +
	this->m[1][2] * mt.m[2][2] +
	this->m[1][3] * mt.m[3][2];

	ret.m[1][3] =
	this->m[1][0] * mt.m[0][3] +
	this->m[1][1] * mt.m[1][3] +
	this->m[1][2] * mt.m[2][3] +
	this->m[1][3] * mt.m[3][3];

	ret.m[2][0] =
	this->m[2][0] * mt.m[0][0] +
	this->m[2][1] * mt.m[1][0] +
	this->m[2][2] * mt.m[2][0] +
	this->m[2][3] * mt.m[3][0];

	ret.m[2][1] =
	this->m[2][0] * mt.m[0][1] +
	this->m[2][1] * mt.m[1][1] +
	this->m[2][2] * mt.m[2][1] +
	this->m[2][3] * mt.m[3][1];

	ret.m[2][2] =
	this->m[2][0] * mt.m[0][2] +
	this->m[2][1] * mt.m[1][2] +
	this->m[2][2] * mt.m[2][2] +
	this->m[2][3] * mt.m[3][2];

	ret.m[2][3] =
	this->m[2][0] * mt.m[0][3] +
	this->m[2][1] * mt.m[1][3] +
	this->m[2][2] * mt.m[2][3] +
	this->m[2][3] * mt.m[3][3];

	ret.m[3][0] =
	this->m[3][0] * mt.m[0][0] +
	this->m[3][1] * mt.m[1][0] +
	this->m[3][2] * mt.m[2][0] +
	this->m[3][3] * mt.m[3][0];

	ret.m[3][1] =
	this->m[3][0] * mt.m[0][1] +
	this->m[3][1] * mt.m[1][1] +
	this->m[3][2] * mt.m[2][1] +
	this->m[3][3] * mt.m[3][1];

	ret.m[3][2] =
	this->m[3][0] * mt.m[0][2] +
	this->m[3][1] * mt.m[1][2] +
	this->m[3][2] * mt.m[2][2] +
	this->m[3][3] * mt.m[3][2];

	ret.m[3][3] =
	this->m[3][0] * mt.m[0][3] +
	this->m[3][1] * mt.m[1][3] +
	this->m[3][2] * mt.m[2][3] +
	this->m[3][3] * mt.m[3][3];

	return ret;
}


CMatrix CMatrix::operator *= ( CMatrix mt )
{
/*	CMatrix tmp = (*this);
	CMatrix tmp2 = tmp * mt;
	*this = tm;*/
	(*this) = ((*this) * (mt));
	return (*this);
}


CVector3 CMatrix::operator * ( CVector3 v )
{
	CVector3 ret;
	ret.x = v.x * m[0][0] + v.y * m[1][0] + v.z * m[2][0] + m[3][0];
	ret.y = v.x * m[0][1] + v.y * m[1][1] + v.z * m[2][1] + m[3][1];
	ret.z = v.x * m[0][2] + v.y * m[1][2] + v.z * m[2][2] + m[3][2];

	return ret;
}

void CMatrix::Transpose()
{
	CMatrix tmp = (*this);
	for( int i = 0 ; i < 4 ; i++ ){
		for( int j = 0 ; j < 4 ; j++ ){
			m[i][j] = tmp.m[j][i];
		}
	}
}

void CMatrix::Inverse()
{
	int i, j, k;
	double p, q;
	for (k = 0; k < 4; k++) {
		p = m[k][k];
		m[k][k] = 1.0;
		for (j = 0; j < 4; j++) m[k][j] /= static_cast<float>(p);
		for (i = 0; i < 4; i++) {
			if (i != k) {
				q = m[i][k];
				m[i][k] = 0.0;
				for (j = 0; j < 4; j++) m[i][j] -= static_cast<float>(q * m[k][j]);
			}
		}
	}
}

void CMatrix::SetTranslation( float x, float y, float z )
{
	Identity();
	m[3][0] = x;
	m[3][1] = y;
	m[3][2] = z;
}

void CMatrix::SetRotationX( float r )
{
	Identity();
	m[1][1] =  cos( r );
	m[1][2] =  sin( r );
	m[2][1] =  -sin( r );
	m[2][2] =  cos( r );
}

void CMatrix::SetRotationY( float r )
{
	Identity();
	m[0][0] =  cos( r );
	m[0][2] = -sin( r );
	m[2][0] =  sin( r );
	m[2][2] =  cos( r );
}

void CMatrix::SetRotationZ( float r )
{
	Identity();
	m[0][0] =  cos( r );
	m[0][1] =  sin( r );
	m[1][0] = -sin( r );
	m[1][1] =  cos( r );
}


void CMatrix::SetRotationAxiss( CVector3 v, float r )
{
	Identity();
	if( r == 0.0f )return;
	v.Normalize();
	float d = v.GetLength();
	if( d == 0.0f )return;
	float cs = cos( r );
	float sn = sin( r );
	
	m[0][0] = v.x*v.x*(1.0f-cs) + cs;
	m[0][1] = v.x*v.y*(1.0f-cs) + v.z*sn;
	m[0][2] = v.z*v.x*(1.0f-cs) - v.y*sn;
	
	m[1][0] = v.x*v.y*(1.0f-cs) - v.z*sn;
	m[1][1] = v.y*v.y*(1.0f-cs) + cs;
	m[1][2] = v.y*v.z*(1.0f-cs) + v.x*sn;
	
	m[2][0] = v.z*v.x*(1.0f-cs) + v.y*sn;
	m[2][1] = v.y*v.z*(1.0f-cs) - v.x*sn;
	m[2][2] = v.z*v.z*(1.0f-cs) + cs;
}

void CMatrix::SetScale( float x, float y, float z )
{
	Identity();
	m[0][0] = x;
	m[1][1] = y;
	m[2][2] = z;
}






