////////////////////////////////////////////////////////////////////////////////
// CMatrix.h
////////////////////////////////////////////////////////////////////////////////
#ifndef __CMATRIX_H__
#define __CMATRIX_H__

#include "CVector3.h"

class CMatrix
{
public:
	CMatrix();
	~CMatrix();

	void Identity();

	CMatrix operator = ( CMatrix mt );

	CMatrix operator * ( CMatrix mt );
	CMatrix operator *= ( CMatrix mt );

	CVector3 operator * ( CVector3 v );
	
	void Transpose();
	void Inverse();

	void SetTranslation( float x, float y, float z );
	void SetRotationX( float r );
	void SetRotationY( float r );
	void SetRotationZ( float r );
	void SetRotationAxiss( CVector3 v, float r );
	void SetScale( float x, float y, float z );
	float m[4][4];
private:
	
};

#endif
