////////////////////////////////////////////////////////////////////////////////
// CVector3.h
////////////////////////////////////////////////////////////////////////////////
#ifndef __CVECTOR3_H__
#define __CVECTOR3_H__

class CVector3
{
public:
	CVector3();
	//CVector3( CVector3& v );
	CVector3( float fx, float fy, float fz );
	~CVector3();

	CVector3 operator = ( CVector3 v );
	CVector3 operator = ( float f);
	CVector3 operator = ( float* pf );

	CVector3 operator + ( CVector3 v );
	CVector3 operator += ( CVector3 v );
	CVector3 operator - ( CVector3 v );
	CVector3 operator -= ( CVector3 v );

	CVector3 operator * ( float f );
	CVector3 operator *= ( float f );

	CVector3 operator / ( float f );
	CVector3 operator /= ( float f );

	CVector3 Normalize();
	CVector3 NormalizeVec();
	float    GetLength();

	float    InnerProduct( CVector3 v );
	CVector3 OuterProduct( CVector3 v );
	
	bool     Cmp(CVector3 v);
	
	float x, y, z;
};

CVector3 CVECTOR3( float x, float y, float z );

#endif
