
#include "Calc.h"
#include <stdio.h>
#include <math.h>

void CreateLineData( float* p1, float* p2, LINE_DATA* pout )
{
	if( p1[0] == p2[0] ){
		pout->type = 0;
		pout->x = p1[0];
	}else if( p1[1] == p2[1] ){
		pout->type = 1;
		pout->y = p1[1];
	}else{
		pout->type = 2;
		pout->a = (p1[1] - p2[1]) / (p1[0] - p2[0]);
		pout->b = p1[1] - pout->a * p1[0];
	}
}

float GetLineDist( float* p1, float* p2, float* pout )
{
	float d;
	LINE_DATA Data;
	CreateLineData( p1, p2, &Data );
	
	if( Data.type == 0 ){
		pout[0] = Data.x;
		pout[1] = 0.0f;
		d = fabs(Data.x);
	}else if( Data.type == 1 ){
		pout[0] = 0.0f;
		pout[1] = Data.y;
		d = fabs(Data.y);
	}else{
		// y = ax + b
		// y = -1/ax
		// 1/ax + ax = -b
		// x = -b/(1/a + a)
		pout[0] = -Data.b / ((1.0f / Data.a) + Data.a );
		pout[1] = Data.a * pout[0] + Data.b;
		
		d = sqrt( pout[0]*pout[0] + pout[1]*pout[1] );
	}
	
	return d;
}

float GetDist( float* p1, float* p2 )
{
	float x = p1[0] - p2[0];
	float y = p1[1] - p2[1];
	
	float d = sqrt( x * x + y * y );
	return d;
}

void CreatePlaneData( CVector3* p, PLANE_DATA* out )
{
	CVector3 v1 = p[1] - p[0];
	CVector3 v2 = p[2] - p[0];
	CVector3 nml = v1.OuterProduct( v2 );
	//nml.Normalize();
	out->a = nml.x;
	out->b = nml.y;
	out->c = nml.z;
	// d = -(ax + by + cz)
	out->d = -(out->a * p[0].x + out->b * p[0].y + out->c * p[0].z );
}

// pp  p1-p2 ܂ޒ̓_łȂ΂ȂȂ
// pp  p1-p2 ̒ȂtrueAOȂfalse
bool CheckLineIn( CVector3 p1, CVector3 p2, CVector3 pp )
{
	CVector3 v = p1 - p2;
	float line_length = v.GetLength();
	
	CVector3 v1 = p1 - pp;
	float length_1 = v1.GetLength();
	if( length_1 > line_length )return false;
	
	CVector3 v2 = p2 - pp;
	float length_2 = v2.GetLength();
	if( length_2 > line_length )return false;
	return true;
}

bool CheckCrossPoint( CVector3* pos, CVector3* pt, CVector3* out )
{
	PLANE_DATA plane;// 3_ʂ̎
	//printf( "CreatePlaneData\n" );
	CreatePlaneData( pos, &plane );
	{
		//float d = plane.a * pos[0].x + plane.b * pos[0].y + plane.c * pos[0].z + plane.d;
		//printf( "d = %.2f\n", d );
	}
	
	CVector3 v = pt[0] - pt[1];// ̌xNg
	{
		//float x,y,z;
		//x = pt[1].x + v.x;
		//y = pt[1].y + v.y;
		//z = pt[1].z + v.z;
		//printf( "(%.2f, %.2f, %.2f)\n", x,y,z );
	}
	// x = pt[1].x + v.x * t// ̎
	// y = pt[1].y + v.y * t// ̎
	// z = pt[1].z + v.z * t// ̎
	// ax + by + cz + d = 0// ʂ̎
	// A
	//a(pt[1].x + v.x * t) + b(pt[1].y + v.y * t) + c(pt[1].z + v.z * t) + d= 0
	// a*pt[1].x + a*v.x*t + b*pt[1].y + b*v.y*t + c*pt[1].z + c*v.z*t + d= 0
	// (a,b,c)pt[1] + t*(a,b,c)v + d = 0
	// t = -((a,b,c)pt[1] + d)/((a,b,c)v)
	//printf( "abc\n" );
	CVector3 abc = CVECTOR3( plane.a, plane.b, plane.c );
	float d_abc = abc.InnerProduct(v);
	if( d_abc == 0.0f )return false;
	float t = -( abc.InnerProduct(pt[1]) + plane.d)/d_abc;
	
	CVector3 point;// ʂƒ̌_
	// x = pt[1].x + v.x * t// ̎
	// y = pt[1].y + v.y * t// ̎
	// z = pt[1].z + v.z * t// ̎
	point = pt[1] + v * t;
	if( !CheckLineIn( pt[0], pt[1], point ) )return false;

	// _ƎOp`̓O
	CVector3 vec[3];
	vec[0] = pos[0] - point;
	vec[1] = pos[1] - point;
	vec[2] = pos[2] - point;
	if( vec[0].GetLength() == 0.0f ){
		*out = point;
		return true;
	}
	if( vec[1].GetLength() == 0.0f ){
		*out = point;
		return true;
	}
	if( vec[2].GetLength() == 0.0f ){
		*out = point;
		return true;
	}
	
	CVector3 op[3];	
	op[0] = vec[0].OuterProduct(vec[1]);
	op[1] = vec[1].OuterProduct(vec[2]);
	op[2] = vec[2].OuterProduct(vec[0]);

	for( int i = 0 ; i < 3 ; i++ ){
		float d = op[i].GetLength();
		if( d == 0.0f ){
			int ii = (i + 1) % 3;
			if( !CheckLineIn( pos[i], pos[ii], point ) ){
				return false;
			}
			*out = point;
			return true;
		}
	}
	op[0].Normalize();
	op[1].Normalize();
	op[2].Normalize();
	float ip;
	ip = op[0].InnerProduct(op[1]);
	if( ip < 0.0f )return false;
	ip = op[1].InnerProduct(op[2]);
	if( ip < 0.0f )return false;
	ip = op[2].InnerProduct(op[0]);
	if( ip < 0.0f )return false;

	*out = point;
	return true;
	
}

bool CheckHitObjectCircle( float* p1, float* p2, float* center, float radius )
{
	float point[2][2];
	point[0][0] = p1[0] - center[0];
	point[0][1] = p1[1] - center[1];
	point[1][0] = p2[0] - center[0];
	point[1][1] = p2[1] - center[1];
	
	return CheckHitObjectCircle( point[0], point[1], radius );
}
// 񎟌Ő(p1-p2)aradius̉~ƌĂ true
bool CheckHitObjectCircle( float* p1, float* p2, float radius )
{
	{
		float d = sqrt(p1[0]*p1[0] + p1[1]*p1[1]);
		if( d < radius )return true;
	}
	{
		float d = sqrt(p2[0]*p2[0] + p2[1]*p2[1]);
		if( d < radius )return true;
	}
	if( (p1[0] == p2[0]) && (p1[1] == p2[1]) ){
		float d = sqrt(p1[0]*p1[0] + p1[1]*p1[1]);
		if( d > radius )return false;
	}else{
		float pos[2];
		float d = GetLineDist( p1, p2, pos );
		if( d > radius )return false;
		float length = GetDist( p1, p2 );
		float d1 = GetDist( p1, pos );
		float d2 = GetDist( p2, pos );
		if( d1 > length )return false;
		if( d2 > length )return false;
	}
	
	return true;
}
