////////////////////////////////////////////////////////////////////////////////
// CMesh.h
////////////////////////////////////////////////////////////////////////////////

#ifndef __CMESH_H__
#define __CMESH_H__

#ifdef MINGW
#define SDLCALL
#endif
#ifndef CMQO_NAME_LENGTH
#define CMQO_NAME_LENGTH 64
#endif

#include "../Matrix/CMatrix.h"
#include "../Matrix/CVector3.h"

struct MeshInfo
{
	char Name[CMQO_NAME_LENGTH];
	int  MaterialNum;
	int  ObjectNum;
};

struct MeshMaterial
{
	char  MaterilaName[CMQO_NAME_LENGTH];
	char  TextureName[CMQO_NAME_LENGTH];
	float Diffuse[4];
	float Ambient[4];
	float Emissive[4];
	float Speculer[4];
	float Power;
};

struct MeshVertex
{
	float x,y,z;
	float nx, ny, nz;
	unsigned char  Color[4];
	float u,v;
};

struct MeshObjectFace
{
	int     PrimitiveType;
	int     Material;
	int     VertexIndexNum;
	int*    VertexIndex;
};

struct MeshObject
{
	char              ObjectName[CMQO_NAME_LENGTH];
	int               VertexNum;
	MeshVertex*       Vertex;

	int               FaceNum;
	MeshObjectFace*   Face;
	CMatrix            Matrix;
	
	CVector3         CenterPos;
	float             Radius;
};

class CMesh
{
public:
	CMesh();
	~CMesh();

	void Release();
	bool LoadFromMQO( char* filename, float scale = 1.0f );
	void Draw();
	
	void ClearMatrix();
	void SetMatrix( char* Name, CMatrix* pMatrix );

	void SetName( const char* name );

	bool CreateMaterial( int n );
	bool SetMaterial( int idx, const MeshMaterial* material );

	bool CreateObject( int n );
	bool CreateObjectVertex( int idx, int num );
	bool CreateObjectFace( int idx, int num );
	bool CreateObjectFaceVertexIndex( int idx, int fidx, int num );
	

	bool SetObjectName( int indx, const char* name );
	bool SetObjectVertex( int idx, int n, const MeshVertex* vertex );
	bool SetObjectFaceMaterial( int idx, int fidx, int material_id );
	bool SetObjectFaceVertexIndex( int idx, int fidx, int n, const int* index );
	bool SetObjectFacePrimitiveType( int idx, int fidx, int type );
	bool SetObjectCenter( int idx, CVector3* pos, float radius );

	int                 GetMaterialNum();
	const MeshMaterial* GetMaterial( int id );
	int                 GetObjectNum();
	const char*         GetObjectName( int indx );
	int                 GetObjectVertexNum( int idx );
	const MeshVertex*   GetObjectVertex( int idx );
	int                 GetObjectFaceNum( int idx );
	int                 GetObjectFaceMaterial( int idx, int fidx );
	int                 GetObjectFaceVertexIndexNum( int idx, int fidx );
	const int*          GetObjectFaceVertexIndex( int idx, int fidx );
	int                 GetObjectFacePrimitiveType( int idx, int fidx );
	const CVector3*     GetObjectCenter( int idx );
	float               GetObjectRadius( int idx );
	CMatrix*            GetObjectMatrix( int idx );

	void DebugPrint();
	
	bool CheckHit( CVector3* p1, CVector3* p2, CVector3* out );
	bool CheckHitBall( CVector3* p1, CVector3* p2 );
	
private:

	MeshInfo      mInfo;
	MeshMaterial* mMaterial;
	MeshObject*   mObject;
	
	CMatrix       mMatrix;

};

#endif
