////////////////////////////////////////////////////////////////////////////////
// CMQOLoader.cpp
// 2004N1012 2:17:01
///////////////////////////////////////////////////////////////////////////////

#include "../MQOLib/CMQOLoader.h"
#include "../MQOLib/CTextCmd.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

////////////////////////////////////////////////////////////////////////////////
// CMQOLoader::CMQOLoader
////////////////////////////////////////////////////////////////////////////////
CMQOLoader::CMQOLoader()
{
}

////////////////////////////////////////////////////////////////////////////////
// CMQOLoader::~CMQOLoader
////////////////////////////////////////////////////////////////////////////////
CMQOLoader::~CMQOLoader()
{
}

////////////////////////////////////////////////////////////////////////////////
// bool CMQOLoader::Load
////////////////////////////////////////////////////////////////////////////////
bool CMQOLoader::Load( CMQOData* pMQOData, const char* path )
{
	CTextBuffer cTextBuffer;
	cTextBuffer.Open( path );

	if( !CheckHeader( pMQOData, &cTextBuffer ) )return false;

	char LineBuffer[256];
	char Buffer[256];
	CTextCmd cTextCmd;

	int n;
	while( (n = cTextBuffer.GetLine( LineBuffer )) >= 0 )
	{
		if( n == 0 )continue;
		cTextCmd.Set( LineBuffer );
		if( cTextCmd.Get( Buffer ) <= 0 )break;
		if( strcmp( Buffer, "Eof" ) == 0 )
		{
			//printf( "Eof\n" );
			break;
		}
		else if( strcmp( Buffer, "Scene" ) == 0 )
		{
			//printf( "Scene\n" );
			LoadScene( pMQOData, &cTextBuffer );
		}
		else if( strcmp( Buffer, "Material" ) == 0 )
		{
			cTextCmd.Get( Buffer );
			int material_num = atoi( Buffer );
			LoadMaterial( pMQOData, &cTextBuffer, material_num );
		}
		else if( strcmp( Buffer, "Object" ) == 0 )
		{
			cTextCmd.GetValue( Buffer );
			//cTextCmd.Get( Buffer );
			LoadObject( pMQOData, &cTextBuffer, Buffer );
		}
	}

	cTextBuffer.Release();

	return true;
}

////////////////////////////////////////////////////////////////////////////////
// bool CMQOLoader::CheckHeader
////////////////////////////////////////////////////////////////////////////////
bool CMQOLoader::CheckHeader( CMQOData* pMQOData, CTextBuffer* pTextBuffer)
{
	char LineBuffer[256];
	char Buffer[256];
	CTextCmd cTextCmd;

	char Version[8] = "";//

	char* CheckWord_Header[] = {
		"Metasequoia",
		"Document",
	};
	char* CheckWord_Format[] = {
		"Format",
		"Text",
		"Ver"
	};
		
	if( pTextBuffer->GetLine( LineBuffer ) <= 0 )return false;
	cTextCmd.Set( LineBuffer );

	for( int i = 0 ; i < 2 ; i++ ){
		if( cTextCmd.Get( Buffer ) <= 0 )return false;
		if( strcmp( Buffer, CheckWord_Header[i] ) != 0 )return false;
	}

	if( pTextBuffer->GetLine( LineBuffer ) <= 0 )return false;
	cTextCmd.Set( LineBuffer );

	for( int i = 0 ; i < 3 ; i++ ){
		if( cTextCmd.Get( Buffer ) <= 0 )return false;
		if( strcmp( Buffer, CheckWord_Format[i] ) != 0 )return false;
	}
	if( cTextCmd.Get( Buffer ) <= 0 )return false;
	strcpy( Version, Buffer );
	
	pMQOData->SetVersion( Version );
	//printf( "Version[%s]\n", Version );

	return true;
}

////////////////////////////////////////////////////////////////////////////////
// bool CMQOLoader::LoadScene
////////////////////////////////////////////////////////////////////////////////
bool CMQOLoader::LoadScene( CMQOData* pMQOData, CTextBuffer* pTextBuffer )
{
	char LineBuffer[256];
	char Buffer[256];
	CTextCmd cTextCmd;
	MQOHeaderData HeaderData;

	while( 1 )
	{
		int len = pTextBuffer->GetLine( LineBuffer );
		if( len < 0 )return false;
		if( len == 0 )continue;

		cTextCmd.Set( LineBuffer );
		cTextCmd.Get(Buffer);
		if( strcmp( Buffer, "}" )  == 0 ){
			break;
		}else if( strcmp( Buffer, "pos" ) == 0 ){
			if( !cTextCmd.GetValue( HeaderData.Pos, 3 ) )return false;
		}else if( strcmp( Buffer, "lookat" ) == 0 ){
			if( !cTextCmd.GetValue( HeaderData.Lookat, 3 ) )return false;
		}else if( strcmp( Buffer, "head" ) == 0 ){
			if( !cTextCmd.GetValue( &HeaderData.Head , 1 ) )return false;
		}else if( strcmp( Buffer, "pich" ) == 0 ){
			if( !cTextCmd.GetValue( &HeaderData.Pich, 1 ) )return false;
		}else if( strcmp( Buffer, "ortho" ) == 0 ){
			if( !cTextCmd.GetValue( &HeaderData.Ortho, 1 ) )return false;
		}else if( strcmp( Buffer, "zoom2" ) == 0 ){
			if( !cTextCmd.GetValue( &HeaderData.Zoom2, 1 ) )return false;
		}else if( strcmp( Buffer, "amb" ) == 0 ){
			if( !cTextCmd.GetValue( HeaderData.Amb, 3 ) )return false;
		}
	}

	pMQOData->SetHeader( &HeaderData );
	return true;
}

////////////////////////////////////////////////////////////////////////////////
// bool CMQOLoader::LoadMaterial
////////////////////////////////////////////////////////////////////////////////
bool CMQOLoader::LoadMaterial( CMQOData* pMQOData, CTextBuffer* pTextBuffer, int MaterialNum )
{
	char LineBuffer[256];
	char Buffer[256];
	CTextCmd cTextCmd;
	int index = 0;

	pMQOData->CreateMaterial( MaterialNum );
	while( 1 )
	{
		int len = pTextBuffer->GetLine( LineBuffer );
		if( len < 0 )return false;
		if( len == 0 )continue;

		cTextCmd.Set( LineBuffer );
		cTextCmd.Get(Buffer);
		if( strcmp( Buffer, "}" )  == 0 ){
			break;
		}else{
			MQOMaterialData MaterialData;
			memset( &MaterialData, 0, sizeof(MQOMaterialData) );
			strcpy( MaterialData.MaterilaName, Buffer );
			while( 1 )
			{
				if( cTextCmd.Get(Buffer) < 1 )break;
				if( strcmp( Buffer, "col") == 0 ){
					cTextCmd.GetValue( MaterialData.Color, 3 );
				}else if( strcmp( Buffer, "dif") == 0 ){
					cTextCmd.GetValue( &MaterialData.Diffuse, 1 );
				}else if( strcmp( Buffer, "amb") == 0 ){
					cTextCmd.GetValue( &MaterialData.Ambient, 1 );
				}else if( strcmp( Buffer, "emi") == 0 ){
					cTextCmd.GetValue( &MaterialData.Emissive, 1 );
				}else if( strcmp( Buffer, "spc") == 0 ){
					cTextCmd.GetValue( &MaterialData.Speculer, 1 );
				}else if( strcmp( Buffer, "power") == 0 ){
					cTextCmd.GetValue( &MaterialData.Power, 1 );
				}else if( strcmp( Buffer, "tex") == 0 ){
					cTextCmd.GetValue( MaterialData.TextureName );
					//strcpy( MaterialData.TextureName, Buffer );
				}
			}

			pMQOData->SetMaterial( index, &MaterialData);
			index++;
		}
	}
	return true;
}

////////////////////////////////////////////////////////////////////////////////
// bool CMQOLoader::LoadObject
////////////////////////////////////////////////////////////////////////////////
bool CMQOLoader::LoadObject( CMQOData* pMQOData, CTextBuffer* pTextBuffer, char* name )
{
	char LineBuffer[256];
	char Buffer[256];
	CTextCmd cTextCmd;

	CMQOObjectData ObjectData;
	MQOObjectInfo  ObjectInfo;
	memset( &ObjectInfo, 0, sizeof(MQOObjectInfo) );
	strcpy( ObjectInfo.ObjectName, name );

	while( 1 )
	{
		int len = pTextBuffer->GetLine( LineBuffer );
		if( len < 0 )return false;
		if( len == 0 )continue;

		cTextCmd.Set( LineBuffer );
		cTextCmd.Get(Buffer);

		if( strcmp( Buffer, "}") == 0 ){
			break;
		}else if( strcmp( Buffer, "visible") == 0 ){
			cTextCmd.GetValue( &ObjectInfo.Visible , 1 );
		}else if( strcmp( Buffer, "locking") == 0 ){
			cTextCmd.GetValue( &ObjectInfo.Locking, 1 );
		}else if( strcmp( Buffer, "shading") == 0 ){
			cTextCmd.GetValue( &ObjectInfo.Shading, 1 );
		}else if( strcmp( Buffer, "facet") == 0 ){
			cTextCmd.GetValue( &ObjectInfo.Facet, 1 );
		}else if( strcmp( Buffer, "color") == 0 ){
			cTextCmd.GetValue( ObjectInfo.Color, 3 );
		}else if( strcmp( Buffer, "color_type") == 0 ){
			cTextCmd.GetValue( &ObjectInfo.ColorType, 1 );
		}else if( strcmp( Buffer, "vertex") == 0 ){
			int VertexNum;
			cTextCmd.GetValue( &VertexNum, 1 );
			ObjectData.CreateVertex( VertexNum );
			MQOObjectVertex Vertx;
			float tmpVertex[3];
			for( int i = 0 ; i < VertexNum ; i++ ){
				int len = pTextBuffer->GetLine( LineBuffer );
				if( len < 0 )return false;
				cTextCmd.Set( LineBuffer );
				cTextCmd.GetValue( tmpVertex, 3 );
				Vertx.x = tmpVertex[0];Vertx.y = tmpVertex[1];
				Vertx.z = tmpVertex[2];
				ObjectData.SetVertex( i, &Vertx );
			}
			int len = pTextBuffer->GetLine( LineBuffer );

		}else if( strcmp( Buffer, "face") == 0 ){
			int FaceNum;
			cTextCmd.GetValue( &FaceNum, 1 );
			ObjectData.CreateFace( FaceNum );
			MQOObjectFace Face;
			for( int i = 0 ; i < FaceNum ; i++ ){
				int len = pTextBuffer->GetLine( LineBuffer );
				if( len < 0 )return false;
				cTextCmd.Set( LineBuffer );
				cTextCmd.GetValue( &Face.VertexNum, 1 );
				cTextCmd.Get( Buffer );// V
				cTextCmd.GetValue( Face.Index, Face.VertexNum );
				cTextCmd.Get( Buffer );// M
				cTextCmd.GetValue( &Face.Material, 1 );
				cTextCmd.Get( Buffer );// UV
				cTextCmd.GetValue( Face.TexCood, Face.VertexNum*2 );
				ObjectData.SetFace( i, &Face );
			}

			int len = pTextBuffer->GetLine( LineBuffer );
		}
	}

	ObjectData.SetInfo( &ObjectInfo );
	pMQOData->SetObject( &ObjectData );
	ObjectData.Release();
	return true;
}

////////////////////////////////////////////////////////////////////////////////
// bool CMQOLoader::DebugSkip
////////////////////////////////////////////////////////////////////////////////
bool CMQOLoader::DebugSkip( CTextBuffer* pTextBuffer )
{
	int n = 1;
	int len = 0;

	char LineBuffer[256];
	char Buffer[256];
	CTextCmd cTextCmd;

	while( 1 )
	{
		len = pTextBuffer->GetLine( LineBuffer );
		if( len < 0 )return false;
		if( len == 0 )continue;

		cTextCmd.Set( LineBuffer );
		while( cTextCmd.Get(Buffer) > 0 )
		{
			if( strcmp( Buffer, "{") == 0 )n++;
			if( strcmp( Buffer, "}") == 0 )n--;
		}

		if( n <= 0 )break;
	}

	return true;
}
