////////////////////////////////////////////////////////////////////////////////
// CMyList.h
////////////////////////////////////////////////////////////////////////////////
#ifndef __CMYLIST_H__
#define __CMYLIST_H__

#include <stdio.h>

template <typename T> class CMyListNode
{
public:
	CMyListNode(){ pPrev = NULL;pNext = NULL; }
	void Set( const T* pData ){
		if( pData )memcpy( &Data, pData, sizeof(T) );
	}
	T Data;
	CMyListNode< T >* pPrev;
	CMyListNode< T >* pNext;
};

template <typename T> class CMyList
{
public:
	CMyList(){ pTop = NULL;pCurrent = NULL; }
	bool Add( const T* pData ){
		CMyListNode <T>* newNode = new CMyListNode <T>;
		if( !newNode )return false;
		newNode->Set( pData );
		if( pTop ){
			pTop->pPrev = newNode;
		}
		newNode->pNext = pTop;
		newNode->pPrev = NULL;
		pTop = newNode;
		return true;
	}
	bool AddTail( const T* pData ){
		CMyListNode <T>* newNode = new CMyListNode <T>;
		if( !newNode )return false;
		SeekTail();
		if( !pCurrent ){
			return Add( pData );
		}else{
			newNode->Set( pData );
			newNode->pNext = NULL;
			newNode->pPrev = pCurrent;
			pCurrent->pNext = newNode;
		}
		return true;
	}
	void SeekTop(){ pCurrent = pTop; }
	void SeekTail(){
		SeekTop();
		if( !pCurrent )return;
		while( pCurrent->pNext )pCurrent = pCurrent->pNext;
	}
	bool Next(){
		if( !pCurrent )return false;
		pCurrent = pCurrent->pNext;
		if( !pCurrent )return false;
		return true;
	}
	T* GetData(){
		if( !pCurrent )return NULL;
		return &(pCurrent->Data);
	}
	void Delete(){
		if( !pCurrent )return;
		CMyListNode< T >* pPrev = pCurrent->pPrev;
		CMyListNode< T >* pNext = pCurrent->pNext;
		if( pPrev ){
			pPrev->pNext = pNext;
		}else{
			pTop = pNext;
		}
		if( pNext )pNext->pPrev = pPrev;
		delete pCurrent;
		if( pPrev ){
			pCurrent = pPrev;
		}else{
			pCurrent = pTop;
		}
	}
private:
	CMyListNode <T>* pTop;
	CMyListNode <T>* pCurrent;
};

#endif
