// Calc

#ifndef __CALC_H__
#define __CALC_H__

#include "CVector3.h"

struct LINE_DATA
{
	int type;
	union{
		float x;
		float y;
		struct{
			float a;
			float b;
		};
	};
};

void CreateLineData( float* p1, float* p2, LINE_DATA* pout );
float GetLineDist( float* p1, float* p2, float* pout );

float GetDist( float* p1, float* p2 );


struct PLANE_DATA
{
	float a,b,c,d;// ax + by + cz + d = 0
};

void CreatePlaneData( CVector3* p, PLANE_DATA* out );
bool CheckCrossPoint( CVector3* pos, CVector3* pt, CVector3* out );


bool CheckHitObjectCircle( float* p1, float* p2, float* center, float radius );
bool CheckHitObjectCircle( float* p1, float* p2, float radius );
#endif
