////////////////////////////////////////////////////////////////////////////////
// CTextureManager.cpp
////////////////////////////////////////////////////////////////////////////////
#define __CTEXTUREMANAGER_CPP__
#include "../Mesh/CTextureManager.h"
#include "../Mesh/MeshDef.h"
#include <string.h>

bool LoadImgTexture( char* filename, TEXTURE_DATA* pdata );

CTextureManager::CTextureManager()
{
}

CTextureManager::~CTextureManager()
{
	Release();
}

void CTextureManager::Release()
{
	vector<TEXTURE_DATA>::iterator i;
	for (i = mTextureData.begin(); i != mTextureData.end(); i++) {
		glDeleteTextures( 1, &(*i).TextureID );
	}
	
	mTextureData.clear();
}

void CTextureManager::Release( char* name )
{
	vector<TEXTURE_DATA>::iterator i;
	for (i = mTextureData.begin(); i != mTextureData.end(); i++) {
		if( strcmp( (*i).Name, name) == 0 ){
			(*i).RefCnt--;
			
			if( (*i).RefCnt <= 0 ){
				glDeleteTextures( 1, &(*i).TextureID );
				mTextureData.erase( i );
				return;
			}
			return;
		}
	}
}

bool CTextureManager::LoadTexture( char* filename, char* name )
{
	vector<TEXTURE_DATA>::iterator i;
	for (i = mTextureData.begin(); i != mTextureData.end(); i++) {
		if( strcmp( (*i).Name, name) == 0 ){
			(*i).RefCnt++;
			return true;
		}
	}
	
	TEXTURE_DATA newData;
	if( !LoadImgTexture( filename, &newData ) )return false;
	
	strcpy( newData.Name, name );
	newData.RefCnt = 1;
	
	mTextureData.push_back( newData );

	return true;
}

const TEXTURE_DATA*  CTextureManager::BindTexture( char* name )
{
	vector<TEXTURE_DATA>::iterator i;
	for (i = mTextureData.begin(); i != mTextureData.end(); i++) {
		if( strcmp( (*i).Name, name) == 0 ){
			glBindTexture( GL_TEXTURE_2D, (*i).TextureID );
			return &(*i);
		}
	}
	glBindTexture( GL_TEXTURE_2D, 0 );
	return NULL;
}

void CTextureManager::DebugPrint()
{
	int num = (int)mTextureData.size();
	//printf( "TextureNum %d\n", num );
	vector<TEXTURE_DATA>::iterator i;
	for (i = mTextureData.begin(); i != mTextureData.end(); i++) {
		//printf( "%s\n", (*i).Name );
	}
}


bool LoadImgTexture( char* filename, TEXTURE_DATA* pdata )
{
	//printf( "filename %s\n", filename );
	SDL_Surface *Image=NULL;
	if( !(Image=IMG_Load( filename )) ){
		//printf( "Load Error\n" );
		return false;
	}
	//printf( "Load OK\n" );
	SDL_Surface* tmpImage =
	SDL_CreateRGBSurface(
		SDL_SWSURFACE,
		0, 0, 32, 
		0x000000ff, 
		0x0000ff00, 
		0x00ff0000, 
		0xff000000
		);
	Image = SDL_ConvertSurface( Image, tmpImage->format, SDL_SWSURFACE );
	SDL_FreeSurface( tmpImage );
	glGenTextures( 1, &(pdata->TextureID) );
	glBindTexture( GL_TEXTURE_2D, pdata->TextureID );
	glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );//GL_NEAREST );
	glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );//GL_NEAREST );
	glTexImage2D(
		GL_TEXTURE_2D, 0, GL_RGBA8,
		Image->w, Image->h, 0,
		GL_RGBA, GL_UNSIGNED_BYTE, Image->pixels
		);
	pdata->Width = Image->w;
	pdata->Height = Image->h;

	SDL_FreeSurface( Image );
	//printf( "TextureID %d\n", pdata->TextureID );

	return true;
}
