
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <map>
#include <list>

#include "SDL.h"
#include "SDL_net.h"

#include <SDL_thread.h>

#include "game/GStaticData.h"
GStaticData* staticData = NULL;

#ifdef _DEV_CPP_
#undef main
#endif

//static UDPsocket serverSocket;
//static UDPpacket *serverPacket;
TCPsocket socketDescriptor;

const int BUFFER_SIZE_MAX = 80;
char buf[BUFFER_SIZE_MAX];

const short PORT = 7000;
std::vector<std::string> logger;

int MAX_MEMBER = 10;


class HPLClient{
private:
public:
	HPLClient(){
		timeOutCounter = 0;
		channel = -1;
	}
	virtual ~HPLClient(){
		delete player;
	}

	int host;
	IPaddress address;
	GPlayer* player;

	std::string key;
	int channel;
	
	int timeOutCounter;

	TCPsocket socket;
};

/**
	<IP, NCAg>
	Ew`lNULLȂVKo^
	Ew`lNULLŖꍇrVKo^
*/
std::map<int, HPLClient*> clientMap;

const int MAX_ID = 10;

bool isContains(int host){
	if(clientMap.find(host) == clientMap.end()){
		return false;
	}
	return true;
}

void delClient(int host){
	if(isContains(host)){
		printf("Client[%d] added\n", host);
		delete clientMap[host];
		clientMap[host] = NULL;
		clientMap.erase(host);
	}
}

HPLClient* addClient(int host, IPaddress address){
	if(isContains(host)){
		delete clientMap[host];
		clientMap.erase(host);
	}
	HPLClient* client = new HPLClient();
	client->host = host;
	client->address = address;

	client->player = new GPlayer(PlayerType::Udonge);

	clientMap[host] = client;
	return client;
}

HPLClient* getClient(int host){
	return clientMap[host];
}

static void cleanup(int exitcode)
{
	SDLNet_TCP_Close(socketDescriptor);
	SDLNet_Quit();
	exit(exitcode);
}
/*
int getEmptySlot(){
	for(int i = 0; i < MAX_ID; i ++){
		if(isContains(i) == false){
			return i;
		}
	}
	return -1;
}*/


void sendAll( char* dat){
			//printf("Now clients:");
			for(std::map<int, HPLClient*>::iterator it = clientMap.begin();
				it != clientMap.end();it ++ ){
					//printf("[%x:%d],",
					//	it->second->address.host,
					//	it->second->address.port);


					HPLClient* client = it->second;
					//serverPacket->address = myAddress;
					std::string s = HPLString::chrToStr("Send to Address: %x %d[%s]\n",
						client->address.host,
						client->address.port,
						dat);
					printf("%s", s.c_str());
					logger.push_back(s);

					/*}serverPacket->address.host = client->address.host;
					serverPacket->address.port = client->address.port;
					serverPacket->channel = client->channel;*/
/*					int result = SDLNet_UDP_Send(serverSocket,
						serverPacket->channel,
						serverPacket);*/
					int len = strlen(dat) + 1;
					if(SDLNet_TCP_Send(client->socket,dat, len) < len){
						fprintf(stderr, "ERROR:SDLNet_TCP_Send: %s\n", SDLNet_GetError());
						//exit(EXIT_FAILURE);
					}

					/*for(std::map<int, HPLClient*>::iterator oit = clientMap.begin();
						oit != clientMap.end(); oit ++){
							GPlayer* o = oit->second->player;
						std::string key = std::string("0");
						std::string datStr = staticData->getSendString(
							oit->first,
							o, key);
						serverPacket->data = (Uint8*)datStr.c_str();
						serverPacket->len = strlen((char *)serverPacket->data) + 1;
						int result = SDLNet_UDP_Send(serverSocket,
							serverPacket->channel,
							serverPacket);
					}*/

					it->second->timeOutCounter ++;
					/*if(it->second->timeOutCounter > 20){
						///
						// 폜
						delete it->second;
						it = clientMap.erase(it);
					}else{
						it ++;
					}*/

			}
}

int threadProc(void *unused){
	IPaddress* remoteIP;

	std::list<std::string> bufferList;

	while(staticData->isRunning()){
		TCPsocket clientSocetDescriptor;
		if((clientSocetDescriptor = SDLNet_TCP_Accept(socketDescriptor))){
			if((remoteIP = SDLNet_TCP_GetPeerAddress(clientSocetDescriptor))){
				//printf("Host connected: %x %d\n",
				//	SDLNet_Read32(&remoteIP->host), SDLNet_Read16(&remoteIP->port));
				int id = remoteIP->host;
				if(isContains(id)){
					/////
					// AhX`FbN
					//HPLClient* client = getClient(serverPacket->address.host);
					printf("Already registered\n");
					clientMap[id]->timeOutCounter = 0;
					clientMap[id]->socket = clientSocetDescriptor;
				}else {
					HPLClient* cl = addClient(id, *remoteIP);
					cl->socket = clientSocetDescriptor;
				}
			}else{
				fprintf(stderr, "SDLNet_TCP_GetPeerAddress: %s\n", SDLNet_GetError());
			}

/*			int quit2 = 0;
			while(!quit2){
				if(SDLNet_TCP_Recv(clientSocetDescriptor, buf, BUFFER_SIZE_MAX) > 0){
					printf("Client say: %s\n", buf);
					staticData->setSendString(
						clientMap[id]->player,
						std::string((const char*)serverPacket->data));

					/////
					// terminate connection
					qui2 = 1;
				}
			}*/
		}

		for(std::map<int, HPLClient*>::iterator it = clientMap.begin();
		it != clientMap.end(); it ++){
			char b[BUFFER_SIZE_MAX];
			if(SDLNet_TCP_Recv(it->second->socket, b, BUFFER_SIZE_MAX) > 0){
				printf("Client %d say: %s\n", it->first, b);
				bufferList.push_back(std::string(b));
			}
		}
		if(bufferList.size() > 0){
			printf("Buffer size:%d\n", bufferList.size());
		}

		static int count = 0;
		const int SEND_INTERVAL = 1;

		count ++;
		if(count > SEND_INTERVAL){
			for(std::list<std::string>::iterator it = bufferList.begin();
				it != bufferList.end(); ){
					std::string s = *it;
					printf("Buffer %s\n", s.c_str());
					sendAll((char*)s.c_str());
					it = bufferList.erase(it);
			}
			count = 0;
		}
		//bufferList.clear();
/*
		if(bufferList.size() > MAX_MEMBER){
		}*/

		SDL_Delay(10);
	}
	for(std::map<int, HPLClient*>::iterator it = clientMap.begin();
		it != clientMap.end(); it ++){
			SDLNet_TCP_Close(it->second->socket);
	}
	
	return 0;
}

int main(int argc, char *argv[])
{
	IPaddress myAddress;

	int i;

    /* Initialize SDL */
    if ( SDL_Init(0) < 0 ) {
        fprintf(stderr, "Couldn't initialize SDL: %s\n",SDL_GetError());
        exit(1);
	}

	/* Initialize the network */
	if ( SDLNet_Init() < 0 ) {
		fprintf(stderr, "Couldn't initialize net: %s\n",
						SDLNet_GetError());
		SDL_Quit();
		exit(1);
	}
	staticData = new GStaticData();


	//myAddress.port = staticData->getSetting()->net.port;

	if(SDLNet_ResolveHost(&myAddress,
		NULL,//staticData->getSetting()->net.myAddress.c_str(), 
		(Uint16)staticData->getSetting()->net.port
		) == -1){
			fprintf(stderr, "SDLNet_ResolveHost(%s %d): %s\n", "NULL",
				staticData->getSetting()->net.port, SDLNet_GetError());
		exit(EXIT_FAILURE);
	}else{
		HPLError::msg("message", MB_OK, 
			"my address = %s:%d\n", 
			staticData->getSetting()->net.myAddress.c_str(),
					(Uint16)myAddress.port);
	}

	//myAddress.port = staticData->getSetting()->net.port;
	// Open socket
	/*
	serverSocket = SDLNet_UDP_Open(PORT);
	if(!serverSocket){
		fprintf(stderr, "SDLNet_UDP_Open: %s\n", SDLNet_GetError());

		exit(1);
	}

	serverPacket = SDLNet_AllocPacket(512);
	if(!serverPacket){
		fprintf(stderr, "SDLNet_AllocPacket: %s\n", SDLNet_GetError());
		exit(1);
	}*/
	if(!(socketDescriptor = SDLNet_TCP_Open(&myAddress))){
		fprintf(stderr, "SDLNet_TCP_Open: %s\n", SDLNet_GetError());
		exit(1);
	}


	///////////
	// V[쐬
	staticData->setupWindow();


	/* Loop, waiting for network events */



	SDL_Thread* thread;

	thread = SDL_CreateThread(threadProc, NULL);

	
	while(staticData->isRunning()) {

		///
		// wait a packet
		/*if(SDLNet_UDP_Recv(serverSocket, serverPacket)){
			//printf("UDP Packet incoming\n");
			//printf("\tChan:    %d\n", serverPacket->channel);
			std::string dat((char *)serverPacket->data);
			printf("Data Get\n\tData:    %s\n", dat.c_str());
			//printf("\tLen:     %d\n", serverPacket->len);
			//printf("\tMaxlen:  %d\n", serverPacket->maxlen);
			//printf("\tStatus:  %d\n", serverPacket->status);
			std::string str = HPLString::chrToStr("  Address: %d.%d.%d.%d:%d", 
			(serverPacket->address.host)&0xFF, (serverPacket->address.host>>8)&0xFF,
				(serverPacket->address.host>>16)&0xFF, (serverPacket->address.host>>24)&0xFF,
						(int)serverPacket->address.port);
			logger.push_back(str);

			if (strcmp((char *)serverPacket->data, "quit") == 0){
				printf("quit");
				delClient(serverPacket->address.host);
				//isRunning = false;
			}

			//std::vector<std::string> items = HPLString::split(std::string(serverPacket->data).c_str(),

			//int id = atoi(items[0].c_str());

			int id = serverPacket->address.host;
			if(isContains(id)){
				/////
				// AhX`FbN
				//HPLClient* client = getClient(serverPacket->address.host);
				printf("Already registered\n");
				clientMap[id]->timeOutCounter = 0;
			}else {
				addClient(id, serverPacket->address);
			}

			staticData->setSendString(
				clientMap[id]->player,
				std::string((const char*)serverPacket->data));

			printf("\n");


			sendAll();
		}*/

		/////////////
		// O\
		staticData->clearScreen(0,10,0);
		HPLSDLKanjiManager* sdlkanji = staticData->getSDLKanjiManager();

		//////
		// ꍇŌ̂݃Rs[
		std::vector<std::string> newLogger;

		const int MAX_LINE = 20;
		int start = logger.size() - MAX_LINE;
		if(start < 0){
			start = 0;
		}
		for(int i = start; i < logger.size(); i ++){
			newLogger.push_back(logger[i]);
		}
		logger = newLogger;


		const float LEFT = 0;
		const float TOP = 0;
		int fontID = 0;
		int r = 255, g = 255, b = 255;
		const float INTERVAL_Y = 20;
		for(i = 0; i < logger.size(); i ++){
			if(logger[i].length() == 0){
				continue;
			}
			float left = LEFT;
			float top = TOP + INTERVAL_Y * i;
			sdlkanji->drawString(staticData->getGraphics()->getScreen(),
				left, top, fontID, r,g,b,
				logger[i].c_str());
				
		}

		// event
		staticData->doEvent();

		
		// common
		staticData->doCommonLoopProcess();
	}
	int a;
	scanf("%d",&a);
	cleanup(0);

	/* Not reached, but fixes compiler warnings */
	return 0;
}

