#include "GEnemyManager.h"

#include "../game/UGStaticData.h"

bool GEnemyManager::checkHitToPlayer(GEnemy* enemy, UGPlayer* player){


	//////
	// ʂȗR΁AڐG𖳎iGȂǁj
	if(player->isInvinsible() || player->getState()->getState() == StateType::DISAPPEAR){
		return false;
	}



	HPLRect enemyHitArea = enemy->getHitArea();

	HPLRect playerHitArea = player->getHitArea();

	float dx = enemy->getCenter().getX() - player->getCenter().getX();
	float dy = enemy->getCenter().getY() - player->getCenter().getY();

	if(enemyHitArea.isShare(playerHitArea)){

		////
		// 
		if(enemy->isHoldEnemy() == false){
			float SPD = 8;
			HPLVector v(-HPLMath::getSgn<float>(enemyHitArea.getX() - playerHitArea.getX()) * SPD, -4);
			player->setVelocityAngle(v);
		}


		bool isInv = true;
		int nextState = StateType::DAMAGE;

		if(enemy->getType() == EnemyType::Heavy){
			nextState = StateType::DAMAGE_B;

		}else if(enemy->getType() == EnemyType::Body){
			nextState = StateType::DAMAGE_A;

		}else if(enemy->getType() == EnemyType::Ramia){

			enemy->changeState(StateType::ATTACK);

		}else if(enemy->getType() == EnemyType::Kikai){

			enemy->changeState(StateType::ATTACK);

		}else if(enemy->getType() == EnemyType::Shokushu){

			enemy->changeState(StateType::ATTACK);

		}else if(enemy->getType() == EnemyType::NakedNormal){
			nextState = StateType::DAMAGE_C;
		}

		////
		// z[h
		if(enemy->isHoldEnemy()){
			enemy->setHolding(true);
			player->setHeld(true);
			nextState = StateType::DISAPPEAR;

			player->setCenter(enemy->getCenter());
		}
		//////
		// vC[̓_[W󂯂
		player->damage(enemy->getPower(), (HPLShootingObject*)enemy,
			isInv, nextState);

		return true;
	}

	return false;
}

