#include "GEnemyManager.h"

#include "../game/GStaticData.h"

GEnemyManager::GEnemyManager(){
	std::vector<std::string> lines = HPLFile::loadStringLinesFromFile("data/image/Enemy/EnemyPower.dat");

	for(int i = 0; i < lines.size(); i ++){
		if(HPLFile::isCommentLine(&lines[i])){
			continue;
		}
		powerList.push_back(atof(lines[i].c_str()));
	}
	HPLError::assertIt(powerList.size() >= EnemyType::MAX_NUMBER_OF_ENEMY_TYPE,
		"G̐ڐG̍U͂w肳Ă܂B[ݒ̎:%d < G̎:%d]",
		powerList.size(), EnemyType::MAX_NUMBER_OF_ENEMY_TYPE);

}

GEnemyManager::~GEnemyManager(){
	clear();
}


void GEnemyManager::process(bool isMove){

	HPLRect merginedGameRange = staticData->getMerginedGameRange();

	adds.clear();
	for(std::list<GEnemy*>::iterator it = getList()->begin();
		it != getList()->end();){

			GEnemy* enemy = *it;

			// ʊO̓G͍sȂ
			if(merginedGameRange.isShare(enemy->getHitArea()) == false){
				it ++;
				continue;
			}

			
			if(isMove){
				/*enemy->collision(
					staticData->getBlockManager()->getBlockMatrix(),
					staticData->getBlockManager()->getBlockMap()
					);
				*/
				if(enemy->isAlive()){
					algorithm(enemy);

					////////////
					// Gƒe̓蔻
					//checkHitToShot(enemy);

					///////
					// vC[Ƃ̓蔻iނUj
//					checkHitToPlayer(enemy, staticData->getObjectManager()->getPlayer());
//					checkHitToPlayer(enemy, staticData->getObjectManager()->getPlayer()->aibo);

				}
			}

			if(enemy->isAlive()){

				enemy->draw(staticData->getImageManager());

				it ++;

			}else{
				it = getList()->erase(it);
				delete enemy;
			}
	}

	for(std::list<GEnemy*>::iterator it = adds.begin();
		it != adds.end();
		it ++){
			getList()->push_back(*it);
	}

}


GEnemy* GEnemyManager::create(int t, HPLVector center){
	GEnemy* en = new GEnemy(t);
	en->setCenter(center);
	en->setPower(powerList[t]);

	getList()->push_back(en);
	
	return en;
}

void GEnemyManager::algorithm(GEnemy* enemy){
	int t = enemy->getType();

	int st = enemy->getState()->getState();

	HPLSequence* seq = enemy->getSprite()->getPair(enemy->getSequenceID())->left;
	HPLSequenceState seqState = seq->getState();

	float dx = enemy->getTarget()->getCenter().getX() - enemy->getCenter().getX();
	float dy = enemy->getTarget()->getCenter().getY() - enemy->getCenter().getY();
	HPLVector delta(dx,dy);
	HPLVector aim = delta;
	aim.normalize();

	HPLVector targetCenter = enemy->getTarget()->getCenter();

	float RESIST = staticData->getSetting()->resist;
	
	if(t == EnemyType::Kikai ||
		t == EnemyType::Ramia){
			if(st == StateType::ATTACK){
				if(seqState.isFinishAnimation){
					enemy->changeState(StateType::ATTACK_2);
				}


			}
			if(st == StateType::ATTACK ||
				st == StateType::ATTACK_2){
				///////
				// SE
				int loop = 1;

				std::vector<int> kuchaList;
				kuchaList.push_back(GEnum::SE::Kucha4);
				kuchaList.push_back(GEnum::SE::Kucha5a);
				kuchaList.push_back(GEnum::SE::Kucha5b);

				int ch = 0;
				if(enemy->getSequence()->getFrameIndex() % 3 == 0 &&
					enemy->getSequence()->getStepCounter() == 0){
					staticData->getMixerManager()->playSE(
						kuchaList[HPLMath::nextInt(0,kuchaList.size())],
						0, loop);
				}

				std::vector<int> ahiList;
				ahiList.push_back(GEnum::SE::Voice1);
				ahiList.push_back(GEnum::SE::Voice2);
				ch = 1;
				if(HPLMath::nextDouble(0.f, 100.f) < 1.5f){
					staticData->getMixerManager()->playSE(
						ahiList[HPLMath::nextInt(0,ahiList.size())],
						ch, loop);
				}

			}
	}
}
