// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2004, 2005 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: BrandList.cs,v 1.9 2007-12-27 08:34:39 panacoran Exp $

using System;
using System.Collections;

namespace Protra.Lib.Db
{
	/// <summary>
	/// BrandListe[ũR[h\ƓɖXg̑񋟂B
	/// </summary>
	public class BrandList: IRecord
	{
		private int id;
		private string name;

		/// <summary>
		/// ̃RXgN^
		/// </summary>
		public BrandList() {}

		/// <summary>
		/// RXgN^
		/// </summary>
		public BrandList(int id, string name)
		{
			this.id = id;
			this.name = name;
		}

		/// <summary>
		/// XgID擾B
		/// </summary>
		public int Id
		{
			get { return id; }
		}

		/// <summary>
		/// O擾邢͕ύXB
		/// </summary>
		public string Name
		{
			get { return name; }
			set { 
				BrandListTable.ChangeBrandListName(id, value);
				name = value;
			}
		}

		/// <summary>
		/// Xg擾B
		/// </summary>
		public Brand[] Brands
		{
			get {
				return BrandList_BrandTable.GetBrands(id);
			}
		}

		/// <summary>
		/// XgɒǉB
		/// </summary>
		/// <param name="brandId">BrandId</param>
		public void Add(int brandId)
		{
			BrandList_BrandTable.Add(id, brandId);
		}

		/// <summary>
		/// Xg폜B
		/// </summary>
		public void Clear()
		{
			BrandList_BrandTable.Delete(id);
		}

		/// <summary>
		/// Xĝ̂폜B
		/// </summary>
		public void Delete()
		{
			BrandList_BrandTable.Delete(id);
			BrandListTable.Delete(id);
		}

		/// <summary>
		/// f[^x[X̃R[hIuWFNgɕϊB
		/// </summary>
		/// <param name="values">lCeBu`̒l̔z</param>
		/// <returns>ϊBrandListIuWFNgԂB</returns>
		public Object ToObject(Object[] values)
		{
			return new BrandList((int)values[0], // @Id
								 (string)values[1]); // @Name
		}

		/// <summary>
		/// CX^X𕶎\ɕϊB
		/// </summary>
		/// <returns>\</returns>
		public override string ToString()
		{
			return string.Format(
				"BrandList[Id={0}, Name={1}]", id, name);
		}
	}

	/// <summary>
	/// BrandList_Brande[ũR[h\B
	/// </summary>
	public class BrandList_Brand: IRecord
	{
		private int brandListId;
		private int brandId;

		/// <summary>
		/// ̃RXgN^
		/// </summary>
		public BrandList_Brand() {}

		/// <summary>
		/// RXgN^
		/// </summary>
		public BrandList_Brand(int brandListId, int brandId)
		{
			this.brandListId = brandListId;
			this.brandId = brandId;
		}

		/// <summary>
		/// XgID擾B
		/// </summary>
		public int BrandListId
		{
			get { return brandListId; }
		}

		/// <summary>
		/// ID擾B
		/// </summary>
		public int BrandId
		{
			get { return brandId; }
		}

		/// <summary>
		/// f[^x[X̃R[hIuWFNgɕϊB
		/// </summary>
		/// <param name="values">lCeBu`̒l̔z</param>
		/// <returns>ϊBrandListIuWFNgԂB</returns>
		public Object ToObject(Object[] values)
		{
			return new BrandList_Brand((int)values[0], // @BrandListId
									   (int)values[1]); // @BrandId
		}

		/// <summary>
		/// CX^X𕶎\ɕϊB
		/// </summary>
		/// <returns>\</returns>
		public override string ToString()
		{
			return string.Format(
				"BrandList_Brand[BrandListId={0}, BrandId={1}]",
				brandListId, brandId);
		}
	}

	/// <summary>
	/// BrandListe[u𑀍삷B
	/// </summary>
	public class BrandListTable
	{
		private static Connection conn;
		private static Connection Conn
		{
			get 
			{
				if (conn != null)
					return conn;
				conn = new Connection("protra");
				return conn;
			}
		}

		/// <summary>
		/// w肳ꂽXgID̃R[h擾B
		/// </summary>
		/// <param name="id">XgID</param>
		/// <returns>BrandListIuWFNgԂBR[h݂ȂꍇɂnullԂB</returns>
		public static BrandList GetRecord(int id) 
		{
			string sql = string.Format("SELECT * FROM BrandList WHERE @Id={0}", id);
			ArrayList result = Conn.Query(sql, new BrandList());
			return result.Count == 0 ? null : (BrandList)result[0];
		}

		/// <summary>
		/// ׂẴR[h擾B
		/// </summary>
		/// <returns>BrandListIuWFNg̔zԂB</returns>
		public static BrandList[] GetAllRecords()
		{
			string sql = "SELECT * FROM BrandList ORDER BY @Id";
			ArrayList result = Conn.Query(sql, new BrandList());
			return (BrandList[])result.ToArray(typeof(BrandList));
		}

		/// <summary>
		/// R[hǉB
		/// </summary>
		/// <param name="name">O</param>
		/// <returns>ǉꂽR[hԂ</returns>
		public static BrandList Add(string name)
		{
			string sql = string.Format("INSERT INTO BrandList(@Name) VALUES('{0}')", name);
			Conn.Execute(sql);
			BrandList[] all = GetAllRecords();
			return all[all.Length - 1];
		}

		/// <summary>
		/// XgύXB
		/// </summary>
		/// <param name="id">XgID</param>
		/// <param name="name">VO</param>
		public static void ChangeBrandListName(int id, string name)
		{
			string sql = string.Format(
				"UPDATE BrandList SET @Name='{0}' WHERE @Id={1}", name, id);
			Conn.Execute(sql);
		}

		/// <summary>
		/// w肳ꂽXgID̃f[^폜B
		/// </summary>
		public static void Delete(int id)
		{
			string sql = string.Format("DELETE FROM BrandList WHERE @Id={0}", id);
			Conn.Execute(sql);
		}

		/// <summary>
		/// Sf[^폜B
		/// </summary>
		public static void Delete()
		{
			string sql = "DELETE FROM BrandList";
			Conn.Execute(sql);
		}
	}

	/// <summary>
	/// BrandList_Brande[u𑀍삷B
	/// </summary>
	public class BrandList_BrandTable
	{
		private static Connection conn;
		private static Connection Conn
		{
			get 
			{
				if (conn != null)
					return conn;
				conn = new Connection("protra");
				return conn;
			}
		}

		/// <summary>
		/// w肳ꂽXgIDƑΉtꂽIDBrande[ũR[h擾B
		/// </summary>
		/// <param name="brandListId">XgID</param>
		/// <returns>BrandIuWFNg̔zԂB</returns>
		public static Brand[] GetBrands(int brandListId) 
		{
			string sql = string.Format(
				"SELECT @Id, @Code, @MarketId, @Name " +
				"FROM BrandList_Brand, Brand " +
				"WHERE @BrandListId={0} AND @BrandId=@Id " +
				"ORDER BY @Code, @MarketId", brandListId);
			ArrayList result = Conn.Query(sql, new Brand());
			return (Brand[])result.ToArray(typeof(Brand));
		}

		/// <summary>
		/// R[hǉB
		/// </summary>
		/// <param name="brandListId">XgID</param>
		/// <param name="brandId">ID</param>
		public static BrandList_Brand Add(int brandListId, int brandId)
		{
			string sql = string.Format(
				"INSERT INTO BrandList_Brand(@BrandListId, @BrandId) " +
				"VALUES({0}, '{1}')", brandListId, brandId);
			Conn.Execute(sql);
			BrandList_Brand record =
				new BrandList_Brand(brandListId, brandId);
			return record;
		}

		/// <summary>
		/// w肳ꂽXgID̃R[h폜B
		/// </summary>
		/// <param name="brandListId">XgId</param>
		public static void Delete(int brandListId)
		{
			string sql = string.Format(
				"DELETE FROM BrandList_Brand WHERE @BrandListId={0}",
				brandListId);
			Conn.Execute(sql);
		}

		/// <summary>
		/// Sf[^폜B
		/// </summary>
		public static void Delete()
		{
			string sql = "DELETE FROM BrandList_Brand";
			Conn.Execute(sql);
		}
	}
}
