﻿// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2008, 2010 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: Resource.cs 444 2013-03-11 04:41:16Z panacoran $

using System.Collections.Generic;

namespace Protra.Lib.Lang
{
    /// <summary>
    /// プログラムを実行するのに必要なリソースを保持するクラス。
    /// </summary>
    public class Resource
    {
        private readonly Stack<Value[]> stack = new Stack<Value[]>();
        private readonly Dictionary<FunctionType, FunctionDefinitionNode> ft = new Dictionary<FunctionType, FunctionDefinitionNode>();
        private Dictionary<string, Value> gvt = new Dictionary<string, Value>();

        /// <summary>
        /// スタックフレームを取得する。
        /// </summary>
        public Stack<Value[]> Stack
        {
            get { return stack; }
        }

        /// <summary>
        /// 関数のテーブルを取得する。
        /// </summary>
        public Dictionary<FunctionType, FunctionDefinitionNode> FunctionTable
        {
            get { return ft; }
        }

        /// <summary>
        /// グローバル変数のテーブルを取得または設定する。
        /// </summary>
        public Dictionary<string, Value> GlobalVariableTable
        {
            get { return gvt; }
            set { gvt = value; }
        }

        /// <summary>
        /// 組み込み関数の実装を取得または設定する。
        /// </summary>
        public Builtins.BasicBuiltins Builtins { get; set; }
    }
}
