﻿using System;
using System.Runtime.InteropServices;
using System.Diagnostics;

namespace Protra.Lib
{
    /// <summary>
    /// Win32APIを実行するクラス
    /// </summary>
    public class Win32API
    {
        [DllImport("user32.dll")]
        private static extern bool SetForegroundWindow(IntPtr hWnd);

        [DllImport("user32.dll")]
        private static extern bool ShowWindowAsync(IntPtr hWnd, int nCmdShow);

        [DllImport("user32.dll")]
        private static extern bool IsIconic(IntPtr hWnd);

        /// <summary>
        /// 同じアプリケーションがすでに起動しているか調べる。起動していたら最前面に表示する。
        /// </summary>
        /// <returns>起動していたらtrue</returns>
        public static bool ProcessAlreadyExists()
        {
            var cur = Process.GetCurrentProcess();
            var all = Process.GetProcessesByName(cur.ProcessName);
            foreach (var p in all)
            {
                if (cur.Id == p.Id)
                    continue;
                if (p.MainModule.FileName != cur.MainModule.FileName)
                    continue;
                if (IsIconic(p.MainWindowHandle))
                    ShowWindowAsync(p.MainWindowHandle, 9); // SW_RESTORE
                else
                    SetForegroundWindow(p.MainWindowHandle);
                return true;
            }
            return false;
        }
    }
}
