// Copyright (C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2008 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: VariableNode.cs 263 2010-01-16 13:12:35Z panacoran $

using System;
using System.Collections.Generic;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// ϐ̃m[h\NXB
	/// </summary>
	public class VariableNode : Node
	{
        /// <summary>
        /// X^bNt[̃CfbNXB
        /// </summary>
        int index;

		/// <summary>
		/// \͂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.ParseException">
		/// \͒ɃG[ƂthrowB
		/// </exception>
        /// <return>
        /// ͂ʂ̃m[hB
        /// </return>
		public override Node Parse()
		{
			Token = Scanner.Token;
            Scanner.Scan();
            if (Token.Type == TokenType.LocalVariable)
            {
                Dictionary<string, int> lvt = LvtStack.Peek();
                if (lvt.ContainsKey(Token.Value))
                    index = lvt[Token.Value];
                else
                    throw new ParseException("undefined local variable '" + Token.Value + "'", Token);
            }
            return this;
		}

		/// <summary>
		/// vOsB
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrowB
		/// </exception>
		/// <param name="resource">\[X</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>s</returns>
		public override Value Execute(Resource resource, int at)
		{
            if (Token.Type == TokenType.GlobalVariable)
            {
                try
                {
                    return resource.GlobalVariableTable[Token.Value];
                }
                catch (KeyNotFoundException)
                {
                    return null;
                }
            }
			else
                return resource.Stack.Peek()[index];
		}

		/// <summary>
		/// sB
		/// </summary>
		/// <param name="resource">\[X</param>
        /// <param name="val">l</param>
		/// <returns>s</returns>
		public Value Assign(Resource resource, Value val)
		{
            if (Token.Type == TokenType.GlobalVariable)
                resource.GlobalVariableTable[Token.Value] = val;
			else
                resource.Stack.Peek()[index] = val;
            return val;
		}
	}
}
