// Copyright (C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: Context.cs,v 1.5 2008-02-28 16:19:51 panacoran Exp $

using System;
using System.Collections;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// vO̕\NXłB
	/// ContextToken؂ôɎgp܂B
	/// </summary>
	public class Context : IEnumerable, IEnumerator
	{
		/// <summary>
		/// ReLXgg[Nɕ邽߂ɎgpZp[^
		/// </summary>
		private string[] separators = {
			",", ";", "(", ")", "{", "}", "[", "]",
			"+", "-", "*", "/", "%", "&&", "||",
			"<=", ">=", "<", ">", "==", "!=", "=", "!",
			"if ", "else ", "elsif ", "while ", "def ",
			"if\t", "else\t", "elsif\t", "while\t", "def\t" };
		/// <summary>
		/// ReLXgg[Nɕ邽߂ɎgpZp[^
		/// </summary>
		private static char[] separatorChars = {
			' ', '\t', ',', ';', '(', ')', '{', '}', '[', ']',
			'+', '-', '*', '/', '%', '&', '|', '<', '>', '=' };

		/// <summary>
		/// Cȗ݂fBNg̃pX
		/// </summary>
		private string libPath = "";
		/// <summary>
		/// t@Cƃt@C̒gƂȂstring[]ΉnbV
		/// </summary>
		private Hashtable hash = new Hashtable();
		/// <summary>
		/// RXgN^ɓnꂽt@C
		/// </summary>
		private string rootFile;
		/// <summary>
		/// ݓǂݍłt@C
		/// </summary>
		private string file;
		/// <summary>
		/// ݓǂݍłs
		/// </summary>
		private int line;
		/// <summary>
		/// ݓǂݍłʒu
		/// </summary>
		private int pos;
		/// <summary>
		/// ݂̃g[N̕
		/// </summary>
		private string currentToken;
		/// <summary>
		/// #include ǂݍݎɌ݈ʒuvbVX^bN
		/// </summary>
		private Stack stack = new Stack();
		/// <summary>
		/// R[h
		/// </summary>
		private Encoding encoding = Encoding.GetEncoding("Shift_JIS");

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.ParseException">
		/// t@CJȂꍇthrow܂B
		/// </exception>
		/// <param name="file">vOt@C̃pX</param>
		public Context(string file)
		{
			StreamReader sr;
			try
			{
				sr = new StreamReader(file, encoding);
			}
			catch(IOException)
			{
				throw new ParseException("can't open file --- " + file, null);
			}

			ArrayList array = new ArrayList();
			string s;
			while((s = sr.ReadLine()) != null)
				array.Add(s);
			sr.Close();

			string[] tmp = (string[])array.ToArray(typeof(string));
			hash.Add(file, tmp);

			this.rootFile = this.file = file;
		}

		/// <summary>
		/// ݈ʒuX^bNɃvbV܂B
		/// </summary>
		private void Push()
		{
			stack.Push(new ContextToken(currentToken, file, line, pos));
		}

		/// <summary>
		/// X^bNߋ̈ʒuoA܂B
		/// </summary>
		/// <returns>X^bNȂfalseɂȂ܂B</returns>
		private bool Pop()
		{
			if(stack.Count == 0)
				return false;
			Reset((ContextToken)stack.Pop());
			return true;
		}

		/// <summary>
		/// ContextToken񋓂IEnumerator擾܂B
		/// </summary>
		/// <returns>ContextToken񋓂IEnumeratorłB</returns>
		public IEnumerator GetEnumerator()
		{
			return this;
		}

		/// <summary>
		/// J[\1i߂܂B
		/// </summary>
		/// <returns>I[܂ŒBĂfalseɂȂ܂B</returns>
		public bool MoveNext()
		{
			while(true)
			{
				if(line >= ((string[])hash[file]).Length)
				if(! Pop())
					break;
				
				string[] lines =(string[])hash[file];
				string s;

				if(pos == 0)
				{
					// sǂݔ΂
					Regex regex = new Regex(@"^[\t ]*$|^[\t ]*//.*$");
					if(regex.IsMatch(lines[line]))
					{
						line++;
						while(line < lines.Length && regex.IsMatch(lines[line]))
							line++;
						if(line >= lines.Length)
							continue;
					}

					// #include sł邩`FbN
					regex = new Regex(@"^[\t ]*#include[\t ]+<(.*)>");
					Match m = regex.Match(lines[line]);
					if(m.Success)
					{
						string includeFile = m.Groups[1].Value.Replace('/', Path.DirectorySeparatorChar);
						includeFile = libPath + includeFile + ".pt";
						if(! hash.Contains(includeFile))
						{
							try
							{
								StreamReader sr = new StreamReader(includeFile, encoding);
								ArrayList array = new ArrayList();
								while((s = sr.ReadLine()) != null)
									array.Add(s);
								sr.Close();

								string[] tmp = (string[])array.ToArray(typeof(string));
								hash.Add(includeFile, tmp);
							}
							catch(IOException)
							{
								throw new ParseException
									("can't open include file --- " + includeFile, (ContextToken)this.Current);
							}
						}

						line++;
						if(line < lines.Length)
							Push();
						file = includeFile;
						line = pos = 0;
						continue;
					}
				}

				// g[N؂o
				s = lines[line];
				if(! s.EndsWith(";"))
					s += ";";
				while(pos < s.Length && (s[pos] == '\t' || s[pos] == ' '))
					pos++;
				string sub = s.Substring(pos, s.Length - pos);
				if(sub.StartsWith("//")) // Rg
				{
					line++;
					pos = 0;
					currentToken = ";";
					return true;
				}
				// Zp[^ƈvΐ؂o
				foreach(string sep in separators)
					if(sub.StartsWith(sep))
					{
						currentToken = sep.Replace('\t', ' ');
						pos += sep.Length;
						if(pos >= s.Length)
						{
							line++; pos = 0;
						}
						return true;
					}
				if(sub[0] == '"') // 
				{
					for(int i = pos + 1; i < s.Length; i++)
						if(s[i] == '"')
						{
							i++;
							currentToken = s.Substring(pos, i - pos);
							pos = i;
							return true;
						}
					throw new ParseException("string is not closed", (ContextToken)this.Current);
				}
				else if(sub[0] == '_') // ̍sւ̌p
				{
					line++;
					pos = 0;
				}
				else // ʏ̃g[N
				{
					for(int i = pos + 1; i < s.Length; i++)
						for(int j = 0; j < separatorChars.Length; j++)
							if(s[i] == separatorChars[j])
							{
								currentToken = s.Substring(pos, i - pos);
								pos = i;
								return true;
							}
				}
			}

			currentToken = null;
			return false;
		}

		/// <summary>
		/// J[\擪ɃZbg܂B
		/// </summary>
		public void Reset()
		{
			currentToken = null;
			file = rootFile;
			line = pos = 0;
		}

		/// <summary>
		/// J[\wʒu܂Ŗ߂܂B
		/// </summary>
		/// <param name="ct">J[\ʒuLContextToken</param>
		public void Reset(ContextToken ct)
		{
			currentToken = ct.ToString();
			file = ct.FileName;
			line = ct.Line;
			pos = ct.Position;
		}

		/// <summary>
		/// ݂ContextToken擾܂B
		/// </summary>
		public object Current
		{
			get { return new ContextToken(currentToken, file, line, pos); }
		}

		/// <summary>
		/// Cȗ݂fBNg̃pX擾܂͐ݒ肵܂B
		/// </summary>
		public string LibraryPath
		{
			get { return libPath; }
			set
			{
				if(value[value.Length - 1] != Path.DirectorySeparatorChar)
					value += Path.DirectorySeparatorChar;
				libPath = value;
			}
		}
	}
}
