// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2004, 2005, 2008 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: Option.cs 283 2010-03-05 22:15:12Z panacoran $

using System;
using System.Drawing;
using Protra.Lib;
using Protra.Lib.Dialogs;
using Protra.Lib.Update;

namespace Protra
{
	/// <summary>
	/// IvV\NXłB
	/// </summary>
	public class Option
	{
		/// <summary>
		/// vLVT[ogp܂H
		/// </summary>
		public bool UseProxy;
		/// <summary>
		/// vLṼAhX
		/// </summary>
		public string ProxyAddress = "";
		/// <summary>
		/// vLṼ|[g
		/// </summary>
		public int ProxyPort = -1;
		/// <summary>
		/// f[^\[X
		/// </summary>
		public PriceDataSource PriceDataSource = PriceDataSource.KabukaJoho;
		/// <summary>
		/// `[ǧ
		/// </summary>
		public int ChartNum = 3;
		/// <summary>
		/// `[g̔wiF
		/// </summary>
		public Color ChartBackColor = Color.FromKnownColor(KnownColor.Control);
		/// <summary>
		/// `[g̑OiF
		/// </summary>
		public Color ChartForeColor = Color.FromKnownColor(KnownColor.ControlText);
		/// <summary>
		/// f[^̂ĂȂT`悷邩
		/// </summary>
		public bool DrawLastWeek;
		/// <summary>
		/// ƏTňقȂ`[ggp邩
		/// </summary>
		public bool UseDifferentChart;

		private ConfigFile configFile = new ConfigFile("ptopt");

		/// <summary>
		/// RXgN^
		/// </summary>
		public Option()
		{
			Load();
		}

		/// <summary>
		/// IvVǂݍ݂܂B
		/// </summary>
		public void Load()
		{
			try
			{
				configFile.Read();
			}
			catch
			{
				return;
			}
			try
			{
				UseProxy = bool.Parse(configFile["UseProxy"]);
				ProxyAddress = configFile["ProxyAddress"];
				ProxyPort = int.Parse(configFile["ProxyPort"]);
				try
				{
					PriceDataSource = (PriceDataSource)Enum.Parse(typeof(PriceDataSource), configFile["PriceDataSource"]);
				}
				catch (ArgumentException) {}
				ChartNum = int.Parse(configFile["ChartNum"]);
				ChartBackColor = Color.FromArgb(int.Parse(configFile["ChartBackColor"]));
				ChartForeColor = Color.FromArgb(int.Parse(configFile["ChartForeColor"]));
				DrawLastWeek = bool.Parse(configFile["DrawLastWeek"]);
				UseDifferentChart = bool.Parse(configFile["UseDifferentChart"]);
			}
			catch {
                using (var dialog = new ApplicationError())
                {
                    dialog.ErrorMessage = "ݒt@CĂ܂:\n" + configFile.Filename;
                    dialog.ShowDialog();
                }
            }
		}

		/// <summary>
		/// IvV݂܂B
		/// </summary>
		public void Save()
		{
			configFile["UseProxy"] = UseProxy.ToString();
			configFile["ProxyAddress"] = ProxyAddress.ToString();
			configFile["ProxyPort"] = ProxyPort.ToString();
			configFile["PriceDataSource"] = PriceDataSource.ToString();
			configFile["ChartNum"] = ChartNum.ToString();
			configFile["ChartBackColor"] = ChartBackColor.ToArgb().ToString();
			configFile["ChartForeColor"] = ChartForeColor.ToArgb().ToString();
			configFile["DrawLastWeek"] = DrawLastWeek.ToString();
			configFile["UseDifferentChart"] = UseDifferentChart.ToString();
			configFile.Write();
		}		
	}
}
