// Copyright (C) 2008 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: MathBuiltins.cs,v 1.1 2008-03-26 19:49:42 panacoran Exp $

using System;

namespace Protra.Lib.Lang
{
    /// <summary>
    /// w֌W̑gݍ݊֐sNXB
    /// </summary>
    public class MathBuiltins : Builtins
    {
        /// <summary>
        /// gݍ݊֐sB
        /// </summary>
        /// <param name="name">O</param>
        /// <param name="args"></param>
        /// <param name="at">atp[^</param>
        /// <returns></returns>
        public override Value Invoke(string name, Value[] args, int at)
        {
            if (args.Length == 1)
            {
                double d = (double)(args[0].Cast(Value.Type.Float).InnerValue);
                switch (name)
                {
                case "Exp":
                    return new Value(Math.Exp(d));
                case "Log":
                    return new Value(Math.Log(d));
                case "Sqrt":
                    return new Value(Math.Sqrt(d));
                case "Sin":
                    return new Value(Math.Sin(d));
                case "Cos":
                    return new Value(Math.Cos(d));
                case "Tan":
                    return new Value(Math.Tan(d));
                case "Asin":
                    return new Value(Math.Asin(d));
                case "Acos":
                    return new Value(Math.Acos(d));
                case "Atan":
                    return new Value(Math.Atan(d));
                default:
                    return base.Invoke(name, args, at);
                }
            }
            else if (args.Length == 2 && name == "Pow")
            {
                double x = (double)(args[0].Cast(Value.Type.Float).InnerValue);
                double y = (double)(args[1].Cast(Value.Type.Float).InnerValue);
                return new Value(Math.Pow(x, y));
            }
            return base.Invoke(name, args, at);
        }
    }
}
